CREATE TABLE IF NOT EXISTS `plugin_quickbooks_settings` (
    `name` VARCHAR(255) NOT NULL COLLATE 'utf8_unicode_ci',
    `value` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
    PRIMARY KEY (`name`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_quickbooks_error_logs` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `created_at` TIMESTAMP NULL,
    `dev_mode` ENUM('0', '1') DEFAULT '0',
    `cart_id` int(10) unsigned DEFAULT NULL,
    `error_type` ENUM('customer', 'invoice', 'payment', 'force_payment') DEFAULT 'customer',
    `error_details` TEXT DEFAULT NULL,
    PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_quickbooks_transaction_logs` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `created_at` TIMESTAMP NULL,
    `dev_mode` ENUM('0', '1') DEFAULT '0',
    `cart_id` int(10) unsigned DEFAULT NULL,
    `customer_id` INT(10) UNSIGNED DEFAULT NULL,
    `invoice_id` INT(10) UNSIGNED DEFAULT NULL,
    `payment_id` INT(10) UNSIGNED DEFAULT NULL,
    `is_partial` ENUM('0', '1') DEFAULT '0',
    `is_first_partial_payment` ENUM('0', '1') DEFAULT '0',
    `first_partial_purchased_on` timestamp NULL,
    `is_second_partial_payment` ENUM('0', '1') DEFAULT '0',
    `second_partial_purchased_on` timestamp NULL,
    `multiple_payments` ENUM('0', '1') DEFAULT '0',
    `status` VARCHAR(255) DEFAULT '' COLLATE 'utf8_unicode_ci',
    `details` TEXT DEFAULT NULL,
    PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_quickbooks_multiple_payments` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `transaction_log_id` int(10) UNSIGNED NOT NULL,
    `cart_id` int(10) unsigned DEFAULT NULL,
    `payment_id` INT(10) UNSIGNED DEFAULT NULL,
    `total` decimal(10,2) NOT NULL DEFAULT '0.00',
    `created_at` timestamp NULL,
    `comment` TEXT DEFAULT NULL,
    `notes` TEXT DEFAULT NULL,
    PRIMARY KEY(`id`),
    FOREIGN KEY (`transaction_log_id`) REFERENCES `plugin_quickbooks_transaction_logs` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT IGNORE INTO `email_triggers` (`enabled`, `trigger_name`, `observer`) VALUES
('1', 'quickbooks_sendnotification_refresh_token_expires_at', 'Tools_QuickbooksMailWatchdog');

INSERT IGNORE INTO `observers_queue` (`observable`, `observer`)
SELECT CONCAT('Models_Model_CartSession'), CONCAT('Tools_QuickbooksExpiredTokenWatchdog') FROM observers_queue WHERE
    NOT EXISTS (SELECT `observable`, `observer` FROM `observers_queue`
    WHERE `observable` = 'Models_Model_CartSession' AND `observer` = 'Tools_QuickbooksExpiredTokenWatchdog')
    AND EXISTS (SELECT name FROM `plugin` where `name` = 'quickbooks') LIMIT 1;

INSERT IGNORE INTO `observers_queue` (`observable`, `observer`)
SELECT CONCAT('Models_Model_CartSession'), CONCAT('Tools_QuickbooksCreateInvoiceWatchdog') FROM observers_queue WHERE
    NOT EXISTS (SELECT `observable`, `observer` FROM `observers_queue`
    WHERE `observable` = 'Models_Model_CartSession' AND `observer` = 'Tools_QuickbooksCreateInvoiceWatchdog')
    AND EXISTS (SELECT name FROM `plugin` where `name` = 'quickbooks') LIMIT 1;

INSERT IGNORE INTO `plugin_quickbooks_settings` (`name`, `value`) VALUES
('createInvoiceForCart', '1'),
('createInvoiceForQuote', '1');

UPDATE `plugin` SET `version` = '2.2.1' WHERE `name` = 'quickbooks';
