-- 23/03/2023
-- version: 2.2.0
ALTER TABLE `plugin_quickbooks_transaction_logs` ADD COLUMN `multiple_payments` ENUM('0', '1') DEFAULT '0' AFTER `is_partial`;
ALTER TABLE `plugin_quickbooks_error_logs` MODIFY COLUMN `error_type` ENUM ('customer', 'invoice', 'payment', 'force_payment') DEFAULT 'customer';

CREATE TABLE IF NOT EXISTS `plugin_quickbooks_multiple_payments` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `transaction_log_id` int(10) UNSIGNED NOT NULL,
    `cart_id` int(10) unsigned DEFAULT NULL,
    `total` decimal(10,2) NOT NULL DEFAULT '0.00',
    `created_at` timestamp NULL,
    `comment` TEXT DEFAULT NULL,
    PRIMARY KEY(`id`),
    FOREIGN KEY (`transaction_log_id`) REFERENCES `plugin_quickbooks_transaction_logs` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT IGNORE INTO `plugin_quickbooks_settings` (`name`, `value`) VALUES
('createInvoiceForCart', '1'),
('createInvoiceForQuote', '1');


-- These alters are always the latest and updated version of the database
UPDATE `plugin` SET `version`='2.2.1' WHERE `name`='quickbooks';
SELECT version FROM `plugin` WHERE `name` = 'quickbooks';
