import { createApp } from 'vue';

//if you have web history mode
import { createRouter, createMemoryHistory } from 'vue-router';

//if you have localization block start
import { createI18n } from 'vue-i18n';
import messages from './localization';
//if you have localization block ends

import App from './components/app/index.vue';
import {store} from './config/store/';
import "regenerator-runtime/runtime";
import routes from './config/routing/routes';



const userWebApp =  createApp(App);

const router = createRouter({
    history: createMemoryHistory(window.location.pathname),
    routes
})

//if you have localization block start
const i18n = createI18n({
    locale: 'en', // set default locale
    messages,
})
userWebApp.use(i18n);
//if you have localization block ends

userWebApp.use(store);
userWebApp.use(router);
userWebApp.mount('#posgraph-screen-block');
