import merge from 'lodash/merge';
import unescape from 'lodash/unescape';
import moment from 'moment';
import lodash from 'lodash';

let defaultState = {
    filterDateFrom:'',
    filterDateTo:'',
    filterSalesPersonId:-1,
    filterIncludeShipping:1,
    filterIncludeTaxes:0,
    changedDate:'',
    additionalInfo: [],
    orderSalesGraphData:[],
    orderSalesLocationGraphData:[],
};

let state = {};
merge(state, defaultState);

const actions = {

};

const mutations = {
    setFilterDateFrom : (state, payload) => {
        state.filterDateFrom = payload;
    },
    setFilterDateTo : (state, payload) => {
        state.filterDateTo = payload;
    },
    setFilterSalesPersonId : (state, payload) => {
        state.filterSalesPersonId = payload;
    },
    setFilterIncludeTaxes : (state, payload) => {
        state.filterIncludeTaxes = payload;
    },
    setFilterIncludeShipping : (state, payload) => {
        state.filterIncludeShipping = payload;
    },
    setChangedDate: (state, payload) => {
        state.changedDate = payload;
    },
    setAdditionalInfo : (state, payload) => {
        state.additionalInfo = payload;
    },
    setState: (state, payload) => {
        lodash.mergeWith(state, payload, (objValue, srcValue) => {
            if (lodash.isArray(objValue) ) {
                return srcValue;
            }
        });
    }
};

const getters = {
    getFilterDateFrom : (state) => {
        return state.filterDateFrom
    },
    getFilterDateTo : (state) => {
        return state.filterDateTo
    },
    getFilterSalesPersonId : (state) => {
        return state.filterSalesPersonId
    },
    getFilterIncludeTaxes : (state) => {
        return state.filterIncludeTaxes
    },
    getFilterIncludeShipping : (state) => {
        return state.filterIncludeShipping
    },
    getChangedDate: (state) => {
        return state.changedDate
    },
    getAdditionalInfo : (state) => {
        return state.additionalInfo
    },
    getOrderSalesGraphData: (state) => {
        return state.orderSalesGraphData
    },
    getOrderSalesLocationGraphData: (state) => {
        return state.orderSalesLocationGraphData
    },
    formatDateForGraphs : (state) => {
        return (date) => {
            return moment(date).format('DD-MMM-YYYY');
        }
    },
    processWidth : (state) => {
        return (percent, element) => {
            if (typeof window.device !== 'undefined') {
                if (window.device.tablet() || window.device.mobile()) {
                    if (window.device.landscape()) {
                        if (window.device.mobile()) {
                            percent = 90;
                        } else {
                            percent = 45;
                        }
                    } else {
                        percent = 90;
                    }

                }
            }
            if (typeof element !== 'undefined') {
                return (($(element).width() * percent) / 100);
            } else {
                return (($(document).width() * percent) / 100);
            }
        }
    },
};
export default {
    state,
    actions,
    getters,
    mutations
};
