import D3Funnel from 'd3-funnel';
import c3 from 'c3';
import * as d3 from "d3";

export const getGraphData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner(payload.elName, 'total-pipeline-by-sales-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/dashboard/ordersalesgraph/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'graphType':payload.graphType,
                'filterDateFrom':payload.filterDateFrom,
                'filterDateTo':payload.filterDateTo,
                'filterSalesPersonId':payload.filterSalesPersonId,
                'filterIncludeTaxes':payload.filterIncludeTaxes,
                'filterIncludeShipping':payload.filterIncludeShipping,
            }
        }).done(async  function(response){
            hideSpinner('.total-pipeline-by-sales-spinner');
            if (response.status !== 'error') {
                if (typeof response.storageName !== 'undefined') {
                    let storageName = response.storageName;
                    commit('setState', {[storageName]: []});
                    commit('setState', {[storageName]: response.graphs});
                }
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const drawBarGraph = ({state, getters}, payload) => {
    let barWidth = getters.processWidth(payload.percentWidth),
        yAxisTick =  {
            centered: true,
            outer: false,
            multiline: true
        },
        showLegend = false,
        groups = [],
        order = null,
        //colorPattern = [],
        labels = [],
        title = '',
        tooltip = true,
        compare = false,
        roughData = {},
        self = this,
        customParamsData = payload.customParamsData;

    if (typeof customParamsData !== 'undefined') {
        if(typeof customParamsData.showLegend !== 'undefined'){
            showLegend = true;
        }

        if (typeof customParamsData.customYAxisFormat !== 'undefined') {
            if (customParamsData.customYAxisFormat.type === 'currency') {
                yAxisTick.format = function(d) { return customParamsData.customYAxisFormat.sign + d3.format(",")(d); }
            }

            if (customParamsData.customYAxisFormat.type === 'onlyInteger') {
                yAxisTick.format = d3.format("d")
            }
        }

        if (typeof customParamsData.groups !== 'undefined') {
            groups = customParamsData.groups;
        }

        // if (typeof customParamsData.colorPattern !== 'undefined') {
        //     colorPattern = customParamsData.colorPattern;
        // }

        if (typeof customParamsData.title !== 'undefined') {
            title = customParamsData.title;
        }

        if (typeof customParamsData.tooltip !== 'undefined') {
            if (customParamsData.tooltip.compare !== 'undefined' && customParamsData.tooltip.compare === true) {
                compare = true;
            }

            if (customParamsData.tooltip.roughData !== 'undefined') {
                roughData = customParamsData.tooltip.roughData;
            }

            tooltip = {
                format: {
                },
                contents: function (d, defaultTitleFormat, defaultValueFormat, color) {
                    let $$ = this, config = $$.config,
                        titleFormat = config.tooltip_format_title || defaultTitleFormat,
                        nameFormat = config.tooltip_format_name || function (name) { return name; },
                        valueFormat = config.tooltip_format_value || defaultValueFormat,
                        text, i, title, value, name, bgcolor,
                        dataParams = {},
                        usedParams = {},
                        textItemRow = '';

                    for (i = 0; i < d.length; i++) {
                        if (! (d[i] && (d[i].value || d[i].value === 0))) { continue; }
                        name = nameFormat(d[i].name);
                        value = valueFormat(d[i].value, d[i].ratio, d[i].id, d[i].index);
                        bgcolor = $$.levelColor ? $$.levelColor(d[i].value) : color(d[i].id);
                        title = titleFormat ? titleFormat(d[i].x) : d[i].x;
                        dataParams[name] = {'value' : value, 'bgcolor' : bgcolor, 'line': d[i].id};

                        if (!_.isEmpty(roughData)) {
                            let roughDataItem = _.find(roughData, function(item) {
                                if (name.match(/\*/) !== null && compare === true) {
                                    return (item.full_name == title && item.type == 'previous' && item.description == name.substring(1));
                                } else {
                                    return (item.full_name == title && item.type == 'current' && item.description == name);
                                }
                            });

                            dataParams[name].amount = value;
                            dataParams[name].count = roughDataItem.count;
                        } else {
                            dataParams[name].amount = '';
                            dataParams[name].count = '';
                        }
                    }

                    for (const key in dataParams) {
                        if (!text) {
                            text = "<table class='" + $$.CLASS.tooltip + "'>" + "<tr><th style='text-align: center'>" + title + "</th><th style='text-align: center'>"+customParamsData.tooltip.filterFromDate+"</th>";
                            if (compare === true) {
                                text += "<th style='text-align: center'>"+customParamsData.tooltip.filterToDate+"</th></tr>";
                            }
                        }

                        if ((typeof usedParams[key] !== 'undefined' || typeof usedParams[key.substring(1)] !== 'undefined') && compare === true) {
                            continue;
                        }

                        text += "<tr class='" + $$.CLASS.tooltipName + "-" + key + "'>";

                        if (key.match(/\*/) !== null) {
                            text += "<td class='name'><span style='background-color:" + dataParams[key]['bgcolor'] + "'></span>" + key.substring(1)+"</td>";
                        } else {
                            text += "<td class='name'><span style='background-color:" + dataParams[key]['bgcolor'] + "'></span>" + key+"</td>";
                        }

                        if (typeof dataParams[key]['count'] !== 'undefined' && dataParams[key]['count'] !== '') {
                            textItemRow =  dataParams[key]['value'] + ' ('+dataParams[key]['count']+')';
                        } else {
                            textItemRow = dataParams[key]['value'];
                        }
                        text += "<td  style='text-align:center;' class='value'>" + textItemRow + "</td>";
                        text += "</tr>";

                        usedParams[key] = true;
                    }
                    return text + "</table>";
                }
            }
        }
    }

    let chart = c3.generate({
        bindto: payload.elId,
        padding: {
            left: 120
        },
        size: {
            width: barWidth,
            height: barWidth/2.5
        },
        onresize: function(){
            if (typeof window.device !== 'undefined') {
                if (window.device.tablet() || window.device.mobile()) {
                    let koef = 1.1;
                    if (window.device.mobile()) {
                        if (!window.device.landscape()) {
                            koef = 1.6;
                        }
                    }
                    chart.resize({
                        width: getters.processWidth()/koef,
                        height: getters.processWidth() / 2.5
                    });
                }
            } else {
                chart.resize({
                    width: barWidth,
                    height: barWidth / 2.5
                });
            }
        },
        data: {
            x: 'x',
            columns:payload.chartData,
            type: 'bar',
            groups:groups,
            order: order,
            labels: labels,
            onclick: function () {
                if (typeof customParamsData  !== 'undefined' &&  typeof customParamsData.axesAdditionalInfo !== 'undefined') {
                    let id = arguments[0]['id'],
                        axeXValue = arguments[0]['x'],
                        filterFromDate = customParamsData.filterStartDate,
                        filterToDate = customParamsData.filterEndDate,
                        salesPersonId = customParamsData.axesAdditionalInfo[axeXValue+1],
                        filterType = customParamsData.filterType,
                        filterOrderStatus = 'completed,shipped,delivered';

                    if (typeof filterType !== 'undefined' && filterType !== '') {
                        let filterFinalUrl = $('#website_url').val() + 'dashboard/orders/?filter=1&filter_from_date='+filterFromDate+'&filter_to_date='+filterToDate+'&filter_by_sales_id=' + salesPersonId + '&filter_status=' + filterOrderStatus;
                        window.open(filterFinalUrl, '_blank');
                    }
                }
            }
        },
        // color: {
        //     pattern: colorPattern
        // },
        color: {
            pattern: []
        },
        axis: {
            rotated: true,
            x: {
                type: 'category',
                show: true,
                tick: {
                    centered: true,
                    multiline:true,
                    width: 150

                }
            },
            y:{
                show: true,
                tick: yAxisTick
            }
        },
        grid: {
            x: {
                show: true
            }
        },
        title: {
            text: title,
            position: 'top-center'
        },
        legend: {
            show: showLegend,
            position: 'bottom'
        },
        tooltip: tooltip

    });

    $(payload.elId).data('c3-chart', chart);
};

export const drawBarLocationGraph = ({state, getters}, payload) => {
    let barWidth = getters.processWidth(payload.percentWidth),
        showLegend = false,
        title = '',
        tooltip = true,
        self = this,
        customParamsData = payload.customParamsData,
        yAxisTick =  {
            centered: true,
            //count: 10
        },
        roughData = {};

    if (typeof customParamsData !== 'undefined') {
        if(typeof customParamsData.showLegend !== 'undefined'){
            showLegend = true;
        }

        if (typeof customParamsData.title !== 'undefined') {
            title = customParamsData.title;
        }

        if (typeof customParamsData.customYAxisFormat !== 'undefined') {
            if (customParamsData.customYAxisFormat.type === 'currency') {
                yAxisTick.format = function(value) {
                    return customParamsData.customYAxisFormat.sign + d3.format(",")(value); }
            }

            if (customParamsData.customYAxisFormat.type === 'onlyInteger') {
                yAxisTick.format = d3.format("d")
            }
        }

        if (customParamsData.roughData !== 'undefined') {
            roughData = customParamsData.roughData;
        }

        tooltip = {
            format: {},
            contents: function (d, defaultTitleFormat, defaultValueFormat, color) {
                var $$ = this, config = $$.config,
                    titleFormat = config.tooltip_format_title || defaultTitleFormat,
                    nameFormat = config.tooltip_format_name || function (name) { return name; },
                    valueFormat = config.tooltip_format_value || defaultValueFormat,
                    text, i, title, value, name, bgcolor,
                    dataParams = {},
                    usedParams = {},
                    textItemRow = '';

                for (i = 0; i < d.length; i++) {
                    if (! (d[i] && (d[i].value || d[i].value === 0))) { continue; }
                    name = nameFormat(d[i].name);
                    value = valueFormat(d[i].value, d[i].ratio, d[i].id, d[i].index);
                    bgcolor = $$.levelColor ? $$.levelColor(d[i].value) : color(d[i].id);
                    title = titleFormat ? titleFormat(d[i].x) : d[i].x;
                    dataParams[name] = {'value' : value, 'bgcolor' : bgcolor, 'line': d[i].id};

                    if (!_.isEmpty(roughData)) {
                        var roughDataItem = _.find(roughData, function(item) {
                            return (item.full_name == title);
                        });

                        dataParams[name].amount = value;
                        dataParams[name].count = roughDataItem.count;
                    } else {
                        dataParams[name].amount = '';
                        dataParams[name].count = '';
                    }
                }

                for (i in dataParams) {
                    if (!text) {
                        text = "<table class='" + $$.CLASS.tooltip + "'>" + "<tr><th colspan='2' style='text-align: center'>" + title + "</th>";
                    }

                    if ((typeof usedParams[i] !== 'undefined' || typeof usedParams[i.substring(1)] !== 'undefined')) {
                        continue;
                    }

                    text += "<tr class='" + $$.CLASS.tooltipName + "'>";

                    if (i.match(/\*/) !== null) {
                        text += "<td class='name'><span style='background-color:" + dataParams[i]['bgcolor'] + "'></span>" + i.substring(1)+"</td>";
                    } else {
                        text += "<td class='name'><span style='background-color:" + dataParams[i]['bgcolor'] + "'></span>" + i+"</td>";
                    }

                    if (typeof dataParams[i]['count'] !== 'undefined' && dataParams[i]['count'] !== '') {
                        textItemRow =  dataParams[i]['value'] + ' ('+dataParams[i]['count']+')';
                    } else {
                        textItemRow = dataParams[i]['value'];
                    }

                    text += "<td  style='text-align:center;' class='value'>" + textItemRow + "</td>";
                    text += "</tr>";

                    usedParams[i] = true;
                }

                return text + "</table>";
            }
        }
    }

    let chart = c3.generate({
        bindto: payload.elId,
        padding: {
            left: 120,
            top: 10
        },
        size: {
            width: barWidth,
            height: barWidth/2.5
        },
        onresize: function(){
            if (typeof window.device !== 'undefined') {
                if (window.device.tablet() || window.device.mobile()) {
                    let koef = 1.1;
                    if (window.device.mobile()) {
                        if (!window.device.landscape()) {
                            koef = 1.6;
                        }
                    }
                    chart.resize({
                        width: getters.processWidth()/koef,
                        height: getters.processWidth() / 2.5
                    });
                }
            } else {
                chart.resize({
                    width: barWidth,
                    height: barWidth / 2.5
                });
            }
        },
        data: {
            columns:payload.chartData,
            // columns:[
            //     ['05-June-2024 to 06-Jan-2025', 6, 8, 16]
            // ],
            type: 'bar',
            onclick: function () {
                if (typeof customParamsData  !== 'undefined' &&  typeof customParamsData.axesAdditionalInfo !== 'undefined') {
                    let id = arguments[0]['id'],
                        filterFromDate = customParamsData.filterStartDate,
                        filterToDate = customParamsData.filterEndDate,
                        salesPersonId = customParamsData.filterSalesPersonId,
                        filterType = customParamsData.filterType,
                        locationIds = customParamsData.locationIds,
                        filterOrderStatus = 'completed,shipped,delivered',
                        locationId = locationIds[arguments[0]['x']];

                    if (typeof filterType !== 'undefined' && filterType !== '') {
                        let filterFinalUrl = $('#website_url').val() + 'dashboard/orders/?filter=1&filter_from_date='+filterFromDate+'&filter_to_date='+filterToDate+'&filter_by_sales_id=' + salesPersonId + '&filter_status=' + filterOrderStatus+ '&filter_by_location_id=' + locationId;
                        window.open(filterFinalUrl, '_blank');
                    }
                }
            }
        },
        axis: {
            x: {
                type: 'category',
                show: true,
                tick: {
                    centered: true,
                    width: 150

                },
                //categories: ['Boyd J Ball', 'Fisher/Shafer NONMEM Workshop', 'Unif Inc'],
                categories: customParamsData.axesAdditionalInfo.categories,
            },
            y: {
                min: 0,
                padding: {
                    top: 0,
                    bottom: 0
                },
                tick: yAxisTick
            }
        },
        grid: {
            x: {
                show: true
            }
        },
        title: {
            text: title,
            position: 'top-center'
        },
        legend: {
            show: showLegend,
            position: 'bottom'
        },
        tooltip: tooltip
    });

    $(payload.elId).data('c3-chart', chart);
};

export const destroyGraph = ({state, getters}, payload) => {
    let chart = c3.generate({
        bindto: payload.elId,
        padding: {},
        data: {
            columns: [
            ],
        },
    });

    chart.destroy();
};

