import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';

export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            graphType: 'orderSalesGraph',
            graphDataExists: false,
            graphDataNotExists: false,
            elName:'#sales-report-graph-block'
        }
    },
    components: {
    },
    computed: {
        ...mapGetters({
            filterDateFrom: 'getFilterDateFrom',
            filterDateTo: 'getFilterDateTo',
            filterSalesPersonId: 'getFilterSalesPersonId',
            filterIncludeTaxes: 'getFilterIncludeTaxes',
            filterIncludeShipping: 'getFilterIncludeShipping',
            changedDate: 'getChangedDate',
            additionalInfo:'getAdditionalInfo',
            formatDateForGraphs:'formatDateForGraphs',
            orderSalesGraphData:'getOrderSalesGraphData'
        })
    },
    watch: {
        changedDate () {
            this.drawGraph();
        }
    },
    methods: {
        async drawGraph() {
            const result = await this.$store.dispatch('getGraphData', {'router':this.$router, 'filterSalesPersonId':this.filterSalesPersonId, 'filterIncludeTaxes':this.filterIncludeTaxes, 'filterIncludeShipping':this.filterIncludeShipping, 'graphType':this.graphType, 'filterDateFrom':this.filterDateFrom, 'filterDateTo':this.filterDateTo, 'elName':this.elName});
            this.$store.dispatch('destroyGraph', {
                'elId': '#sales-report'
            });

            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                let orderSalesGraphData = this.orderSalesGraphData,
                    chartData = [];

                if (typeof orderSalesGraphData[this.graphType].axes !== 'undefined') {
                    chartData = [
                        orderSalesGraphData[this.graphType].axes
                    ];

                    let locationsGroupFrom = orderSalesGraphData[this.graphType].locationsGroupFrom,
                        groups = [],
                        onlyData = [],
                        compare = false;

                    groups.push(locationsGroupFrom);

                    _.each(orderSalesGraphData[this.graphType].data, function(salesData, sale){
                        let cleanLegendId = '';
                        if (!_.isArray(salesData)) {
                            let dataArr = [];
                            _.each(salesData, function(elem, key){
                                dataArr[key] = elem;
                            });
                            chartData.push(dataArr);
                        } else {
                            chartData.push(salesData);
                        }

                        if (salesData[0].match(/\*/) !== null) {
                            cleanLegendId = salesData[0].substring(1);
                        } else {
                            cleanLegendId = salesData[0];
                        }
                        if (_.indexOf(onlyData, cleanLegendId) == '-1') {
                            onlyData.push(cleanLegendId);
                        }
                    });

                    this.graphDataExists = true;
                    this.graphDataNotExists = false;

                    this.$store.dispatch('drawBarGraph', {
                        'elId': '#sales-report',
                        'chartData': chartData,
                        'percentWidth': 75,
                        'customParamsData': {
                            'axesAdditionalInfo': orderSalesGraphData[this.graphType].axesAdditionalInfo,
                            'groups':groups,
                            //'colorPattern':orderSalesGraphData[this.graphType].colorPattern,
                            //'title':this.$t('message.salesreport'),
                            'customYAxisFormat': {
                                type: 'currency',
                                sign: orderSalesGraphData[this.graphType].currencySymbol
                            },
                            'tooltip': {
                                filterFromDate: orderSalesGraphData[this.graphType].filterFromDate,
                                filterToDate: orderSalesGraphData[this.graphType].filterToDate,
                                roughData: orderSalesGraphData[this.graphType].roughData,
                                compare: compare
                            },
                            'filterStartDate':this.formatDateForGraphs(orderSalesGraphData[this.graphType].filterStartDate),
                            'filterEndDate':this.formatDateForGraphs(orderSalesGraphData[this.graphType].filterEndDate),
                            'filterSalesPersonId':this.filterSalesPersonId,
                            'filterType':'order_sales_type',
                            'showLegend': true
                        },
                        'router': this.$router
                    });

                } else {
                    this.graphDataNotExists = true;
                }

                this.loadedScreen = true;
            }

        }
    },
    async created(){

    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    },
    async mounted()  {
        this.graphDataExists = true;
        this.drawGraph();
    }
}
