import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';

export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            graphType: 'orderSalesLocationGraph',
            graphDataExists: false,
            graphDataNotExists: false,
            elName:'#sales-location-report-graph-block'
        }
    },
    components: {
    },
    computed: {
        ...mapGetters({
            filterDateFrom: 'getFilterDateFrom',
            filterDateTo: 'getFilterDateTo',
            filterSalesPersonId: 'getFilterSalesPersonId',
            filterIncludeTaxes: 'getFilterIncludeTaxes',
            filterIncludeShipping: 'getFilterIncludeShipping',
            changedDate: 'getChangedDate',
            additionalInfo:'getAdditionalInfo',
            formatDateForGraphs:'formatDateForGraphs',
            orderSalesLocationGraphData:'getOrderSalesLocationGraphData'
        })
    },
    watch: {
        changedDate () {
            this.drawGraph();
        }
    },
    methods: {
        async drawGraph() {
            const result = await this.$store.dispatch('getGraphData', {'router':this.$router, 'filterSalesPersonId':this.filterSalesPersonId, 'filterIncludeTaxes':this.filterIncludeTaxes, 'filterIncludeShipping':this.filterIncludeShipping, 'graphType':this.graphType, 'filterDateFrom':this.filterDateFrom, 'filterDateTo':this.filterDateTo, 'elName':this.elName});
            this.$store.dispatch('destroyGraph', {
                'elId': '#sales-location-report'
            });

            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                let orderSalesLocationGraphData = this.orderSalesLocationGraphData,
                    chartData = [];

                if (typeof orderSalesLocationGraphData[this.graphType].data !== 'undefined') {
                    chartData = [
                        orderSalesLocationGraphData[this.graphType].data
                    ];

                    this.graphDataExists = true;
                    this.graphDataNotExists = false;

                    this.$store.dispatch('drawBarLocationGraph', {
                        'elId': '#sales-location-report',
                        'chartData': chartData,
                        'percentWidth': 75,
                        'customParamsData': {
                            'axesAdditionalInfo': orderSalesLocationGraphData[this.graphType].axesAdditionalInfo,
                            //'title':this.$t('message.salesreport'),
                            'customYAxisFormat': {
                                type: 'currency',
                                sign: orderSalesLocationGraphData[this.graphType].currencySymbol
                            },
                            'filterStartDate':this.formatDateForGraphs(orderSalesLocationGraphData[this.graphType].filterStartDate),
                            'filterEndDate':this.formatDateForGraphs(orderSalesLocationGraphData[this.graphType].filterEndDate),
                            'filterSalesPersonId':this.filterSalesPersonId,
                            'locationIds': orderSalesLocationGraphData[this.graphType].locationIds,
                            'roughData': orderSalesLocationGraphData[this.graphType].roughData,
                            'filterType':'order_sales_type',
                        },
                        'router': this.$router
                    });

                } else {
                    this.graphDataNotExists = true;
                }

                this.loadedScreen = true;
            }

        }
    },
    async created(){

    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    },
    async mounted()  {
        this.graphDataExists = true;
        this.drawGraph();
    }
}
