import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import salesreport from '../../salesreport';
import saleslocationreport from '../../saleslocationreport';
import moment from 'moment';
export default {
    data () {
        return {
            loadedScreen: false,
            filterDateFrom:'',
            filterDateTo:'',
            filterSalesPersonId: -1,
            filterIncludeTaxes: 0,
            filterIncludeShipping: 1,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
        }
    },
    components: {
        salesreport:salesreport,
        saleslocationreport:saleslocationreport,
    },
    computed: {
        ...mapGetters({
            additionalInfo:'getAdditionalInfo',
        }),
    },
    methods: {
        async showReports(){
            let dateFrom = $('#datepickerFrom').val();
            let dateTo = $("#datepickerTo").val();
            let salesPersonId = $('#sales-person').val();

            if($('#enableTaxesGraf').is(':checked')){
                this.filterIncludeTaxes = 1;
            } else {
                this.filterIncludeTaxes = 0;
            }

            if(!$('#enableShippingForGraf').is(':checked')){
                this.filterIncludeShipping = 0;
            } else{
                this.filterIncludeShipping = 1;
            }

            this.filterDateFrom = dateFrom;
            this.filterDateTo = dateTo;

            if(_.isEmpty(salesPersonId)) {
                salesPersonId = -1;
            }

            this.filterSalesPersonId = salesPersonId;
            this.filterDateFrom = moment(this.filterDateFrom).format('YYYY-MM-DD HH:mm:ss');
            this.filterDateTo = moment(this.filterDateTo).format('YYYY-MM-DD HH:mm:ss');

            this.$store.commit('setFilterDateFrom', this.filterDateFrom);
            this.$store.commit('setFilterDateTo', this.filterDateTo);
            this.$store.commit('setFilterSalesPersonId', this.filterSalesPersonId);
            this.$store.commit('setFilterIncludeTaxes', this.filterIncludeTaxes);
            this.$store.commit('setFilterIncludeShipping', this.filterIncludeShipping);
            this.$store.commit('setChangedDate', (Date.now() % 1000) / 1000);
        },
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        let dateFrom = $('#datepickerFrom').val();
        let dateTo = $("#datepickerTo").val();
        if(typeof dateFrom !== 'undefined' && dateFrom != '' && typeof dateTo !== 'undefined' && dateTo != '') {
            this.showReports();
        }

        this.loadedScreen = true;
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    },
    async mounted()  {
        $('#redrawSales').on('click', (e) => {
            this.showReports();
        });
    }
}
