<?php

class Toasterstats_Tools_PosReportsTools
{


    public static function prepareSalesReportDataAggregated($ownersData, $useAmountAsValue = false)
    {
        $ownersDataResult = array();
        if (!empty($ownersData)) {
            $ownersDataResult['axes'] = array();
            $ownersDataResult['axesAdditionalInfo'] = array();
            $ownersDataResult['data'] = array();
            $usedOwnerNames = array();
            $ownersNamesArray = array();
            $ordersData = array();
            $ordersDataResultFrom = array();
            $ordersDataResultTo = array();
            $allNames = array();
            array_push($ownersDataResult['axes'], 'x');
            array_push($ownersDataResult['axesAdditionalInfo'], 'x');

            $excludeOwnerIds = array();

            foreach ($ownersData as $key => $ownerData) {
                $currentOwnerName = $ownerData['full_name'];
                $addName = false;
                $ordersData[$ownerData['locationId']]['locationName'] = $ownerData['description'];
                if (!array_key_exists($ownerData['full_name'], $usedOwnerNames)) {
                    $usedOwnerNames[$currentOwnerName]['id'] = $ownerData['id'];
                    $usedOwnerNames[$currentOwnerName]['count'] = 0;
                    $addName = true;
                } elseif($usedOwnerNames[$currentOwnerName]['id'] != $ownerData['id'] && !in_array($ownerData['id'], $excludeOwnerIds)) {
                    $usedOwnerNames[$currentOwnerName]['count'] = $usedOwnerNames[$currentOwnerName]['count'] + 1;
                    $currentOwnerName = $currentOwnerName . '_' . $usedOwnerNames[$currentOwnerName]['count'];
                    $addName = true;
                }

                if (!array_key_exists($ownerData['id'], $allNames)) {
                    $allNames[$ownerData['id']] = $currentOwnerName;
                }

                if ($addName === true) {
                    array_push($ownersDataResult['axes'], $currentOwnerName);
                    array_push($ownersDataResult['axesAdditionalInfo'],  $ownerData['id']);
                    $ownersNamesArray[$ownerData['id']]['id'] = $ownerData['id'];
                    $ownersNamesArray[$ownerData['id']]['position'] = count($ownersDataResult['axes']) - 1;
                }

                array_push($excludeOwnerIds, $ownerData['id']);
            }

            foreach ($ordersData as $locationId => $locationName) {
                array_push($ordersDataResultFrom, $locationName['locationName']);
                $ordersData[$locationId]['position'] = count($ordersDataResultFrom);

            }

            $ordersDataGrouped = array();

            foreach ($ownersData as $key => $ownerData) {
                $locationName = $ownerData['description'];
                $ordersDataGrouped[$ownerData['locationId'].'_'.$ownerData['type']][0] = $locationName;
                $position = $ownersNamesArray[$ownerData['id']]['position'];
                if ($useAmountAsValue === true) {
                    $ordersDataGrouped[$ownerData['locationId'] . '_' . $ownerData['type']][$position] = $ownerData['amount'];
                } else {
                    $ordersDataGrouped[$ownerData['locationId'] . '_' . $ownerData['type']][$position] = $ownerData['count'];
                }
            }

            foreach ($ordersDataGrouped as $key => $ordersDataGroupedSingleItem) {
                $quantity = count($ownersNamesArray) + 1;
                for($i = 0; $i < $quantity; $i++)
                {
                    if(!isset($ordersDataGrouped[$key][$i]))
                    {
                        $ordersDataGrouped[$key][$i] = null;
                    }
                }

            }

            foreach ($ordersDataGrouped as $key => $ordersDataGroupedSingleItem) {
                ksort($ordersDataGroupedSingleItem);
                $ordersDataGrouped[$key] = $ordersDataGroupedSingleItem;
            }

            $ownersDataResult['data'] = $ordersDataGrouped;
            $ownersDataResult['locationsGroupFrom'] = $ordersDataResultFrom;
            $ownersDataResult['locationsGroupTo'] = $ordersDataResultTo;

        }

        return $ownersDataResult;

    }

    public static function prepareSalesReportLocationDataAggregated($ownersData, $useAmountAsValue = false, $dateFilterPeriodLabel = '')
    {
        $ownersDataResult = array();
        if (!empty($ownersData) && !empty($dateFilterPeriodLabel)) {
            $ownersDataResult['data'] = array($dateFilterPeriodLabel);
            $ownersDataResult['axesAdditionalInfo'] = array();
            $ownersDataResult['locationIds'] = array();

            foreach ($ownersData as $key => $ownerData) {
                if ($useAmountAsValue === true) {
                    array_push($ownersDataResult['data'], $ownerData['amount']);
                } else {
                    array_push($ownersDataResult['data'], $ownerData['count']);
                }

                $ownersDataResult['axesAdditionalInfo']['categories'][] = $ownerData['full_name'];
                $ownersDataResult['locationIds'][] = $ownerData['locationId'];

            }
        }

        return $ownersDataResult;

    }
}
