<?php

class MagicSpaces_Ispluginexists_Ispluginexists extends Tools_MagicSpaces_Abstract
{
    protected $_parseBefore = true;

    /**
     * Is plugin exists Magic Space
     * {ispluginexists[:pluginname1,pluginname2,...]}
     * {/ispluginexists}
     * @return string
     */
    protected function _run()
    {
        $allowedPlugins = explode(',', filter_var($this->_params[0], FILTER_SANITIZE_STRING));

        if(!empty($allowedPlugins)) {
            $pluginMapper = Application_Model_Mappers_PluginMapper::getInstance();

            foreach ($allowedPlugins as $allowedPlugin) {
                $pluginMapper = $pluginMapper->findByName(strtolower($allowedPlugin));
                if ($pluginMapper instanceof Application_Model_Models_Plugin) {
                    $pluginStatus = $pluginMapper->getStatus();
                    if ($pluginStatus === 'enabled') {
                        return $this->_spaceContent;
                    }
                }
            }
        }

        return '';
    }
}
