<?php

class Api_Dashboard_Ordersalesgraph extends Api_Service_Abstract
{


    /**
     * Toasterstats secure token
     */
    const TOASTERSTATS_SECURE_TOKEN = 'ToasterstatsToken';


    /**
     * System response helper
     *
     * @var null
     */
    protected $_responseHelper = null;

    /**
     * @var array Access Control List
     */
    protected $_accessList = array(
        Tools_Security_Acl::ROLE_SUPERADMIN => array(
            'allow' => array('get', 'post', 'put', 'delete')
        ),
        Tools_Security_Acl::ROLE_ADMIN => array(
            'allow' => array('get', 'post', 'put', 'delete')
        ),
        Shopping::ROLE_SALESPERSON => array(
            'allow' => array('get', 'post', 'put', 'delete')
        )
    );


    public function init()
    {
        parent::init();
        $this->_responseHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('response');
    }


    /**
     * Welcome screen
     *
     * Resource:
     * : /api/dashboard/ordersalesgraph/
     *
     * HttpMethod:
     * : GET
     *
     * @return JSON
     */
    public function getAction()
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $graphType = $this->_request->getParam('graphType');
        $reportsFilterStartDateOrigin =  filter_var($this->_request->getParam('filterDateFrom'), FILTER_SANITIZE_STRING);
        $reportsFilterEndDateOrigin =  filter_var($this->_request->getParam('filterDateTo'), FILTER_SANITIZE_STRING);
        $reportsFilterSalesPersonId =  filter_var($this->_request->getParam('filterSalesPersonId'), FILTER_SANITIZE_NUMBER_INT);
        $reportsFilterIncludeTaxes =  filter_var($this->_request->getParam('filterIncludeTaxes'), FILTER_SANITIZE_NUMBER_INT);
        $reportsFilterIncludeShipping =  filter_var($this->_request->getParam('filterIncludeShipping'), FILTER_SANITIZE_NUMBER_INT);

        $storageName = '';

        if (empty($reportsFilterStartDateOrigin)) {
            $reportsFilterStartDateOrigin = date('Y-m-d', strtotime('-19 day')). ' 00:00:01';
        } else {
            $reportsFilterStartDateOrigin = date('Y-m-d', strtotime($reportsFilterStartDateOrigin)). ' 00:00:01';
        }

        if (empty($reportsFilterEndDateOrigin)) {
            $reportsFilterEndDateOrigin = date('Y-m-d', strtotime('now')).' 23:59:59';
        } else {
            $reportsFilterEndDateOrigin = date('Y-m-d', strtotime($reportsFilterEndDateOrigin)).' 23:59:59';
        }

        if (empty($reportsFilterSalesPersonId) || $reportsFilterSalesPersonId == '-1') {
            $reportsFilterSalesPersonId = '';
        }

        $salesReportsFilterStartDateOriginForLabel = $reportsFilterStartDateOrigin;
        if (empty($salesReportsFilterStartDateOriginForLabel)) {
            $salesReportsFilterStartDateOriginForLabel = Tools_System_Tools::convertDateFromTimezone('now');
        }

        $salesReportsFilterEndDateOriginForLabel = $reportsFilterEndDateOrigin;
        if (empty($salesReportsFilterEndDateOriginForLabel)) {
            $salesReportsFilterEndDateOriginForLabel = Tools_System_Tools::convertDateFromTimezone('now');
        }

        $salesReportsCompareFilterStartDateOriginForLabel = '';
        if (empty($salesReportsCompareFilterStartDateOriginForLabel)) {
            $salesReportsCompareFilterStartDateOriginForLabel = Tools_System_Tools::convertDateFromTimezone('now');
        }

        $salesReportsCompareFilterEndDateOriginForLabel = '';
        if (empty($salesReportsCompareFilterEndDateOriginForLabel)) {
            $salesReportsCompareFilterEndDateOriginForLabel = Tools_System_Tools::convertDateFromTimezone('now');
        }

        $labelTo = $translator->translate('to');

        $salesReportsFilterDateOriginForLabel = date('d-M-Y',
                strtotime($salesReportsFilterStartDateOriginForLabel)) . ' '.$labelTo .' '. date('d-M-Y',
                strtotime($salesReportsFilterEndDateOriginForLabel));
        $salesReportsFilterDateCompareForLabel = date('d-M-Y',
                strtotime($salesReportsCompareFilterStartDateOriginForLabel)) . ' '.$labelTo .' ' . date('d-M-Y',
                strtotime($salesReportsCompareFilterEndDateOriginForLabel));

        $currency = Zend_Registry::get('Zend_Currency');
        $currencySymbol = preg_replace('~[\w]~', '', $currency->getSymbol());

        if ($graphType === 'orderSalesGraph') {
            $storageName = 'orderSalesGraphData';

            $tosterStatsDbTable = new Toasterstats_Models_Dbtables_ToasterstatsDbtable();

            $ordersSalesReport = $tosterStatsDbTable->getOrderSalesReport($reportsFilterStartDateOrigin, $reportsFilterEndDateOrigin, $reportsFilterSalesPersonId, $reportsFilterIncludeTaxes, $reportsFilterIncludeShipping);
            $ordersSalesReportResult = Toasterstats_Tools_PosReportsTools::prepareSalesReportDataAggregated($ordersSalesReport, true);

            if (!empty($ordersSalesReportResult)) {
                $ordersSalesReportResult['filterFromDate'] = $salesReportsFilterDateOriginForLabel;
                $ordersSalesReportResult['filterToDate'] = $salesReportsFilterDateCompareForLabel;
                $ordersSalesReportResult['filterStartDate'] = $reportsFilterStartDateOrigin;
                $ordersSalesReportResult['filterEndDate'] = $reportsFilterEndDateOrigin;

                $ordersSalesReportResult['currencySymbol'] = $currencySymbol;
                $ordersSalesReportResult['roughData'] = $ordersSalesReport;
            }

            $data['graphs']['orderSalesGraph'] = $ordersSalesReportResult;

        } else if ($graphType === 'orderSalesLocationGraph') {
            $storageName = 'orderSalesLocationGraphData';

            $tosterStatsDbTable = new Toasterstats_Models_Dbtables_ToasterstatsDbtable();

            $ordersSalesReport = $tosterStatsDbTable->getOrderSalesLocationReport($reportsFilterStartDateOrigin, $reportsFilterEndDateOrigin, $reportsFilterSalesPersonId, $reportsFilterIncludeTaxes, $reportsFilterIncludeShipping);
            $ordersSalesReportResult = Toasterstats_Tools_PosReportsTools::prepareSalesReportLocationDataAggregated($ordersSalesReport, true, $salesReportsFilterDateOriginForLabel);

            if (!empty($ordersSalesReportResult)) {
                $ordersSalesReportResult['filterFromDate'] = $salesReportsFilterDateOriginForLabel;
                $ordersSalesReportResult['filterToDate'] = $salesReportsFilterDateCompareForLabel;
                $ordersSalesReportResult['filterStartDate'] = $reportsFilterStartDateOrigin;
                $ordersSalesReportResult['filterEndDate'] = $reportsFilterEndDateOrigin;

                $ordersSalesReportResult['currencySymbol'] = $currencySymbol;
                $ordersSalesReportResult['roughData'] = $ordersSalesReport;
            }

            $data['graphs']['orderSalesLocationGraph'] = $ordersSalesReportResult;
        }

        $data['storageName'] = $storageName;

        return $data;
    }

    /**
     *
     * Resource:
     *
     * HttpMethod:
     * : POST
     *
     * @return JSON
     */
    public function postAction()
    {

    }

    /**
     *
     * Resource:
     *
     * HttpMethod:
     * : PUT
     *
     * ## Parameters:
     * id (source integer)
     *
     * @return JSON
     */
    public function putAction()
    {

    }

    /**
     *
     * Resource:
     *
     * HttpMethod:
     * : DELETE
     *
     * ## Parameters:
     * id (source integer)
     *
     * @return JSON
     */
    public function deleteAction()
    {


    }

}
