import merge from 'lodash/merge';
import unescape from 'lodash/unescape';
import moment from 'moment';
import lodash from 'lodash';

let defaultState = {
    configDataInfo: [],
    additionalInfo: [],
    currencyInfo :[],
    stripeSecretKey:''
};

let state = {};
merge(state, defaultState);

const actions = {

};

const mutations = {
    setConfigDataInfo : (state, payload) => {
        state.configDataInfo = payload;
    },
    setAdditionalInfo : (state, payload) => {
        state.additionalInfo = payload;
    },
    setCurrencyInfo : (state, payload) => {
        state.currencyInfo = payload;
    },
    setStripeSecretKey : (state, payload) => {
        state.stripeSecretKey = payload;
    },
    setState: (state, payload) => {
        lodash.mergeWith(state, payload, (objValue, srcValue) => {
            if (lodash.isArray(objValue) ) {
                return srcValue;
            }
        });
    }
};

const getters = {
    getConfigDataInfo : (state) => {
        return state.configDataInfo
    },
    getAdditionalInfo : (state) => {
        return state.additionalInfo
    },
    getCurrencyInfo : (state) => {
        return state.currencyInfo
    },
    getStripeSecretKey : (state) => {
        return state.stripeSecretKey
    },
    formatDate : (state) => {
        return (date) => {
            let finalDate =  moment(date).format('DD MMM YYYY hh:mm a');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    formatOnlyDate: (state) => {
        return (date) => {
            let finalDate = moment(date).format('DD MMM YYYY');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    formatTimeOnly: (state) => {
        return (date) => {
            let finalDate = moment(date).format('hh:mm');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    formatTimeFull: (state) => {
        return (date) => {
            let finalDate = moment(date).format('hh:mm A');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    sortByColumn : (state) => {
        return (data, columnName, reverse) => {
            if (typeof reverse !== 'undefined') {
                return _.orderBy(data, columnName).reverse();
            }

            return _.orderBy(data, columnName);
        }
    },
    truncateText : (state) => {
        return (text, limit) => {
            if (text.length > limit) {
                text = text.substring(0, (limit - 3)) + '...';
            }

            return text;
        }
    },
    cleanText : (state) => {
        return (text, replaceTo) => {
            let replaceToSymbol = '';

            if (typeof replaceTo !== 'undefined') {
                replaceToSymbol = replaceTo;
            }

            text = text.replace(/(<([^>]+)>)/gi, replaceToSymbol);

            return text;
        }
    },
    toCurrency : (state) => {
        return (value, decimals) => {
            let result = parseFloat(value),
                minDecimals = 2;

            if (typeof decimals !== 'undefined') {
                minDecimals = decimals;
            }

            if (isNaN(result)) {
                return '';
            }

            if (state.currencyInfo && typeof state.currencyInfo.locale !== 'undefined') {
                result = result.toLocaleString(state.currencyInfo.locale, { style: 'currency', currency: state.currencyInfo.currency, minimumFractionDigits: minDecimals, maximumFractionDigits: minDecimals });
            }

            return result;
        }
    },
    unescapeValue: (state) => {
        return (value) => {
            return unescape(value);
        }
    },
    creditCardYears:(state) => {
        return (value) => {
           const year = new Date().getFullYear();
           return Array.from({length: 10}, (value, index) => year + index);

        }
    }
};
export default {
    state,
    actions,
    getters,
    mutations
};
