export const getGeneralConfigData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#quote-payment-form', 'quote-payment-form-spinner system-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/stripepayment/quotepayment/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'id': payload.id
            }
        }).done(async  function(response){
            hideSpinner('.quote-payment-form-spinner');
            if (response.status !== 'error') {
                commit('setConfigDataInfo', response.data);
                commit('setAdditionalInfo', response.additionalInfo);
                commit('setStripeSecretKey', response.stripeSecretKey);
                commit('setCurrencyInfo', response.currencyInfo);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const sendPaymentData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#quote-payment-form', 'quote-payment-form-spinner system-spinner');
        $.ajax({
            'url': $('#website_url').val() + 'api/stripepayment/quotepayment/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' : $('#stripepay-quote-payment-screen-token').val(),
                'paymentFirstName': payload.paymentFirstName,
                'paymentLastName': payload.paymentLastName,
                'stripePaymentMethod': payload.stripePaymentMethod,
                'quotePageId': payload.quotePageId,
            }
        }).done(async function (response) {
            hideSpinner('.quote-payment-form-spinner');
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function(response){
            hideSpinner('.quote-payment-form-spinner');
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};
