import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import moment from 'moment';
export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#stripepay-quote-system-language').val(),
            paymentFirstName:'',
            paymentLastName:'',
            paymentAgreement: false,
            totalPrice:0,
            stripeObject:null,
            stripeCardObject:null,
            stripeClientPaymentSecret:null,
            stripePaymentMethod:'',
            showPaymentBlock:false,
            paymentBlockAlreadyInited:false,
            formProcessing: false,
            quotePageId:$('#stripepay-quote-page-id').val(),
            amountToPay:$('#stripepay-quote-page-pay-amount').val(),
        }
    },
    components: {

    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            stripeSecretKey: 'getStripeSecretKey',
            toCurrency:'toCurrency',
            truncateText: 'truncateText',
            sortByColumn: 'sortByColumn',
        }),
    },
    methods: {
        async initPaymentGateway()
        {
            if (typeof this.additionalInfo.stripePublishKey !== 'undefined' && this.additionalInfo.stripePublishKey !== '') {
                if(this.additionalInfo.accountId !== '') {
                    this.stripeObject = window.Stripe(this.additionalInfo.stripePublishKey, {stripeAccount: this.additionalInfo.accountId});
                } else {
                    this.stripeObject = window.Stripe(this.additionalInfo.stripePublishKey);
                }
                // Create an instance of Elements.
                let elements = this.stripeObject.elements();
                let stripeCardStyle = {
                    base: {
                        fontSize: '16px',
                        color: "#32325d",
                        borderWidth: "1px",
                    }
                };

                this.stripeCardObject = elements.create('card', {style: stripeCardStyle});
                this.stripeCardObject.mount('#quote-stripe-payment-block');
            }
        },
        async processForm()
        {
            if (this.formProcessing === true) {
                return false;
            }

            this.formProcessing = true;

            // if (this.paymentAgreement === false) {
            //     showMessage(this.$t('message.pleaseSpecifyAgreement'), true, 2000);
            //     this.formProcessing = false;
            //     return false;
            // }

            if (this.paymentFirstName === '') {
                showMessage(this.$t('message.pleaseSpecifyPaymentFirstName'), true, 2000);
                this.formProcessing = false;
                return false;
            }

            if (this.paymentLastName === '') {
                showMessage(this.$t('message.pleaseSpecifyPaymentLastName'), true, 2000);
                this.formProcessing = false;
                return false;
            }

            let stripeCardObject = this.stripeCardObject;
            let stripeSecretKey = this.stripeSecretKey;
            let cardHolderName = this.paymentFirstName + ' '+this.paymentLastName;
            let self = this;

            this.stripeObject.confirmCardSetup(
                stripeSecretKey,
                {
                    payment_method: {
                        card: stripeCardObject,
                        billing_details: {name: cardHolderName}
                    }
                }
            ).then(function (result) {
                if (result.error) {
                    console.log(result);
                    if (result.error.code === "setup_intent_unexpected_state") {
                        showMessage(result.error.message, true, 5000);
                        self.formProcessing = false;
                        self.stripeCardObject.destroy();
                        self.loadData();
                        self.initPaymentGateway();
                    } else {
                        // Display error.message in your UI.
                        showMessage(result.error.message, true, 5000);
                        self.stripePaymentMethod = '';
                        self.formProcessing = false;
                    }

                } else {
                    self.stripePaymentMethod = result.setupIntent.payment_method;
                    self.sendFormData();
                }
            });
        },
        async sendFormData()
        {

            const result = await this.$store.dispatch('sendPaymentData', {
                'paymentFirstName': this.paymentFirstName,
                'paymentLastName': this.paymentLastName,
                'stripePaymentMethod': this.stripePaymentMethod,
                'quotePageId':this.quotePageId
            });

            if (result.error == '1') {
                showMessage(result.message, true, 2000);
                this.formProcessing = false;
                return false;
            } else {
                showMessage(result.message, false, 2000);
                this.loadData();
            }

            this.formProcessing = false;
            if (typeof result.redirectUrl !== 'undefined') {
                setTimeout(() => window.location = result.redirectUrl, 2000);
            }
        },
        async loadData()
        {
            const result = await this.$store.dispatch('getGeneralConfigData', {'router':this.$router});
            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.initPaymentGateway();
                this.loadedScreen = true;
            }
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.loadData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
