CREATE TABLE IF NOT EXISTS `plugin_stripepay_config` (
	`name` VARCHAR(255) NOT NULL COLLATE 'utf8_unicode_ci',
	`value` VARCHAR(255) NOT NULL COLLATE 'utf8_unicode_ci',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_stripepay_transactions` (
`id` INT NOT NULL AUTO_INCREMENT,
`live_mode` VARCHAR(10) DEFAULT NULL,
`payment_type` VARCHAR(30) DEFAULT NULL,
`charge_id` VARCHAR(200) DEFAULT NULL,
`checkout_session_id` VARCHAR(200) DEFAULT NULL,
`stripe_customer_id` VARCHAR(200) DEFAULT NULL,
`payment_intent` VARCHAR(200) DEFAULT NULL,
`status` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
`amount` DECIMAL(10, 4) DEFAULT NULL,
`card_type` VARCHAR(50) DEFAULT NULL,
`exp_month` VARCHAR(50) DEFAULT NULL,
`exp_year` VARCHAR(50) DEFAULT NULL,
`card_fingerprint` VARCHAR(50) DEFAULT NULL,
`card_mask` VARCHAR(4) DEFAULT NULL,
`token` VARCHAR(200) DEFAULT NULL,
`total_tax` DECIMAL(10, 4) COLLATE utf8_unicode_ci DEFAULT NULL,
`cart_id` int(10) unsigned NOT NULL,
`order_shipping_address` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
`order_billing_address` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
`order_date_full` TIMESTAMP NULL,
`order_amount` INT(10) DEFAULT NULL,
`currency` VARCHAR(4) COLLATE utf8_unicode_ci DEFAULT NULL,
`transaction_type` CHAR(128) DEFAULT NULL,
`transaction_id` CHAR(255) DEFAULT NULL,
`receipt_url` VARCHAR(255) DEFAULT NULL,
`payment_method` CHAR(64) DEFAULT NULL,
`intent_client_secret` VARCHAR(255) DEFAULT NULL,
`first_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
`last_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
`email` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
`email_sent` ENUM('0','1') DEFAULT '0',
`customer_email_sent` ENUM('0','1') DEFAULT '0',
`refund_id` VARCHAR(255) DEFAULT NULL,
`refund_amount` DECIMAL(10, 4) DEFAULT NULL,
`refund_last_date` TIMESTAMP NULL,
`reason` VARCHAR(255) NULL,
PRIMARY KEY (`id`)
) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_unicode_ci;

INSERT IGNORE INTO `email_triggers` (`enabled`, `trigger_name`, `observer`) VALUES
('1', 'stripepay_recurringpayment', 'Tools_StripepayMailWatchdog'),
('1', 'stripepay_recurringcanceled', 'Tools_StripepayMailWatchdog'),
('1', 'stripepay_recurringsuspended', 'Tools_StripepayMailWatchdog'),
('1', 'stripepay_recurringfailed', 'Tools_StripepayMailWatchdog'),
('1', 'stripepay_recurringreactivated', 'Tools_StripepayMailWatchdog');

INSERT IGNORE INTO `config` (`name`, `value`) VALUES ('stripepayOAuth', '0');

UPDATE `plugin` SET `version`='1.0.3' WHERE `name`='stripepay';
