<?php

/**
 * Class Tools_StripepayMailWatchdog
 */
class Tools_StripepayMailWatchdog implements Interfaces_Observer
{
    /**
     * Subscription canceled
     */
    const TRIGGER_SUBSCRIPTION_RECURRING_CANCELED = 'stripepay_recurringcanceled';

    /**
     * Subscription suspended
     */
    const TRIGGER_SUBSCRIPTION_RECURRING_SUSPENDED = 'stripepay_recurringsuspended';

    /**
     * Subscription failed
     */
    const TRIGGER_SUBSCRIPTION_RECURRING_FAILED = 'stripepay_recurringfailed';

    /**
     * Subscription reactivated
     */
    const TRIGGER_SUBSCRIPTION_RECURRING_REACTIVATED = 'stripepay_recurringreactivated';

    /**
     * Recurring payment received
     */
    const TRIGGER_SUBSCRIPTION_RECURRING_PAYMENT = 'stripepay_recurringpayment';

    /**
     * @var array
     */
    private $_options;

    /**
     * @var Tools_Mail_Mailer instance of mailer
     */
    private $_mailer;

    /**
     * @var Helpers_Action_Config
     */
    private $_configHelper;

    /**
     * @var Helpers_Action_Website
     */
    private $_websiteHelper;

    /**
     * @var instance of watched object
     */
    private $_object;

    private $_template;

    /**
     * @var Tools_Content_EntityParser
     */
    private $_entityParser;

    public function __construct($options = array())
    {
        $this->_configHelper = Zend_Controller_Action_HelperBroker::getExistingHelper('config');
        $this->_websiteHelper = Zend_Controller_Action_HelperBroker::getExistingHelper('website');
        $this->_options = $options;
        $this->_initMailer();
        $this->_entityParser = new Tools_Content_EntityParser();
    }

    public function notify($object)
    {
        if (!$object) {
            return false;
        }

        $this->_object = $object;

        if (isset($this->_options['template']) && !empty($this->_options['template'])) {
            $this->_template = $this->_preparseEmailTemplate();
        } else {
            throw new Exceptions_SeotoasterException('Missing template for action email trigger');
        }

        $this->_mailer->setMailFromLabel('')
            ->setSubject($this->_options['subject']);

        if (!empty($this->_options['from'])) {
            $this->_mailer->setMailFrom($this->_options['from']);
        } else {
            $this->_mailer->setMailFrom($this->_configHelper->getConfig('adminEmail'));
        }

        if (isset($this->_options['trigger'])) {
            $methodName = str_replace('stripepay_', '', $this->_options['trigger']);
            $methodName = '_send' . ucfirst(strtolower(preg_replace('/\s*/', '', $methodName))) . 'Mail';
            if (method_exists($this, $methodName)) {
                $this->$methodName($object);
            }
        }
    }

    private function _initMailer()
    {
        $config = $this->_configHelper->getConfig();
        $this->_mailer = new Tools_Mail_Mailer();

        if ((bool)$config['useSmtp']) {
            $smtpConfig = array(
                'host' => $config['smtpHost'],
                'username' => $config['smtpLogin'],
                'password' => $config['smtpPassword']
            );
            if ((bool)$config['smtpSsl']) {
                $smtpConfig['ssl'] = $config['smtpSsl'];
            }
            if (!empty($config['smtpPort'])) {
                $smtpConfig['port'] = $config['smtpPort'];
            }
            $this->_mailer->setSmtpConfig($smtpConfig);
            $this->_mailer->setTransport(Tools_Mail_Mailer::MAIL_TYPE_SMTP);
        } else {
            $this->_mailer->setTransport(Tools_Mail_Mailer::MAIL_TYPE_MAIL);
        }
    }

    private function _sendRecurringpaymentMail()
    {
        $userEmail = $this->_options['userEmail'];
        $fullName = $this->_options['fullName'];
        $systemConfig = $this->_configHelper->getConfig();
        $userMapper = Application_Model_Mappers_UserMapper::getInstance();
        $adminBccArray = array();
        $adminEmail = isset($systemConfig['adminEmail']) ? $systemConfig['adminEmail'] : 'admin@localhost';
        switch ($this->_options['recipient']) {
            case Tools_Security_Acl::ROLE_ADMIN:
                $this->_mailer->setMailToLabel('Admin')
                    ->setMailTo($adminEmail);
                $where = $userMapper->getDbTable()->getAdapter()->quoteInto("role_id = ?",
                    Tools_Security_Acl::ROLE_ADMIN);
                $adminUsers = $userMapper->fetchAll($where);
                if (!empty($adminUsers)) {
                    foreach ($adminUsers as $admin) {
                        array_push($adminBccArray, $admin->getEmail());
                    }
                    if (!empty($adminBccArray)) {
                        $this->_mailer->setMailBcc($adminBccArray);
                    }
                }
                break;
            default:
                $this->_mailer->setMailToLabel($fullName)->setMailTo($userEmail);
                break;
        }
        $this->_entityParser->objectToDictionary($this->_object, 'profile');
        $customer = Models_Mapper_CustomerMapper::getInstance()->find($this->_options['userId']);
        $this->_entityParser->objectToDictionary($customer, 'customer');
        if (isset($this->_options['attachmentPath']) && isset($this->_options['attachmentName'])) {
            $attachment = new Zend_Mime_Part(file_get_contents($this->_options['attachmentPath']));
            $attachment->type = 'application/pdf';
            $attachment->disposition = Zend_Mime::DISPOSITION_ATTACHMENT;
            $attachment->encoding = Zend_Mime::ENCODING_BASE64;
            $attachment->filename = $this->_options['attachmentName'];
            $this->_mailer->addAttachment($attachment);
        }

        return $this->_send();
    }

    private function _sendRecurringfailedMail()
    {
        $userEmail = $this->_options['userEmail'];
        $fullName = $this->_options['fullName'];
        $systemConfig = $this->_configHelper->getConfig();
        $userMapper = Application_Model_Mappers_UserMapper::getInstance();
        $adminBccArray = array();
        $adminEmail = isset($systemConfig['adminEmail']) ? $systemConfig['adminEmail'] : 'admin@localhost';
        switch ($this->_options['recipient']) {
            case Tools_Security_Acl::ROLE_ADMIN:
                $this->_mailer->setMailToLabel('Admin')
                    ->setMailTo($adminEmail);
                $where = $userMapper->getDbTable()->getAdapter()->quoteInto("role_id = ?",
                    Tools_Security_Acl::ROLE_ADMIN);
                $adminUsers = $userMapper->fetchAll($where);
                if (!empty($adminUsers)) {
                    foreach ($adminUsers as $admin) {
                        array_push($adminBccArray, $admin->getEmail());
                    }
                    if (!empty($adminBccArray)) {
                        $this->_mailer->setMailBcc($adminBccArray);
                    }
                }
                break;
            default:
                $this->_mailer->setMailToLabel($fullName)->setMailTo($userEmail);
                break;
        }
        $additionalLexems['user:email'] = $userEmail;
        $additionalLexems['user:fullName'] = $fullName;
        $this->_entityParser->objectToDictionary($this->_object, 'profile');
        $this->_entityParser->addToDictionary($additionalLexems);
        $customer = Models_Mapper_CustomerMapper::getInstance()->find($this->_options['userId']);
        $this->_entityParser->objectToDictionary($customer, 'customer');

        return $this->_send();
    }

    private function _sendRecurringreactivatedMail()
    {
        $userEmail = $this->_options['userEmail'];
        $fullName = $this->_options['fullName'];
        $systemConfig = $this->_configHelper->getConfig();
        $userMapper = Application_Model_Mappers_UserMapper::getInstance();
        $adminBccArray = array();
        $adminEmail = isset($systemConfig['adminEmail']) ? $systemConfig['adminEmail'] : 'admin@localhost';
        switch ($this->_options['recipient']) {
            case Tools_Security_Acl::ROLE_ADMIN:
                $this->_mailer->setMailToLabel('Admin')
                    ->setMailTo($adminEmail);
                $where = $userMapper->getDbTable()->getAdapter()->quoteInto("role_id = ?",
                    Tools_Security_Acl::ROLE_ADMIN);
                $adminUsers = $userMapper->fetchAll($where);
                if (!empty($adminUsers)) {
                    foreach ($adminUsers as $admin) {
                        array_push($adminBccArray, $admin->getEmail());
                    }
                    if (!empty($adminBccArray)) {
                        $this->_mailer->setMailBcc($adminBccArray);
                    }
                }
                break;
            default:
                $this->_mailer->setMailToLabel($fullName)->setMailTo($userEmail);
                break;
        }
        $additionalLexems['user:email'] = $userEmail;
        $additionalLexems['user:fullName'] = $fullName;
        $this->_entityParser->objectToDictionary($this->_object, 'profile');
        $this->_entityParser->addToDictionary($additionalLexems);
        $customer = Models_Mapper_CustomerMapper::getInstance()->find($this->_options['userId']);
        $this->_entityParser->objectToDictionary($customer, 'customer');

        return $this->_send();
    }

    private function _sendRecurringsuspendedMail()
    {
        $userEmail = $this->_options['userEmail'];
        $fullName = $this->_options['fullName'];
        $systemConfig = $this->_configHelper->getConfig();
        $userMapper = Application_Model_Mappers_UserMapper::getInstance();
        $adminBccArray = array();
        $adminEmail = isset($systemConfig['adminEmail']) ? $systemConfig['adminEmail'] : 'admin@localhost';
        switch ($this->_options['recipient']) {
            case Tools_Security_Acl::ROLE_ADMIN:
                $this->_mailer->setMailToLabel('Admin')
                    ->setMailTo($adminEmail);
                $where = $userMapper->getDbTable()->getAdapter()->quoteInto("role_id = ?",
                    Tools_Security_Acl::ROLE_ADMIN);
                $adminUsers = $userMapper->fetchAll($where);
                if (!empty($adminUsers)) {
                    foreach ($adminUsers as $admin) {
                        array_push($adminBccArray, $admin->getEmail());
                    }
                    if (!empty($adminBccArray)) {
                        $this->_mailer->setMailBcc($adminBccArray);
                    }
                }
                break;
            default:
                $this->_mailer->setMailToLabel($fullName)->setMailTo($userEmail);
                break;
        }

        $additionalLexems['user:email'] = $userEmail;
        $additionalLexems['user:fullName'] = $fullName;
        $this->_entityParser->objectToDictionary($this->_object, 'profile');
        $this->_entityParser->addToDictionary($additionalLexems);
        $customer = Models_Mapper_CustomerMapper::getInstance()->find($this->_options['userId']);
        $this->_entityParser->objectToDictionary($customer, 'customer');

        return $this->_send();
    }

    private function _sendRecurringcanceledMail()
    {
        $userEmail = $this->_options['userEmail'];
        $fullName = $this->_options['fullName'];
        $systemConfig = $this->_configHelper->getConfig();
        $userMapper = Application_Model_Mappers_UserMapper::getInstance();
        $adminBccArray = array();
        $adminEmail = isset($systemConfig['adminEmail']) ? $systemConfig['adminEmail'] : 'admin@localhost';
        switch ($this->_options['recipient']) {
            case Tools_Security_Acl::ROLE_ADMIN:
                $this->_mailer->setMailToLabel('Admin')
                    ->setMailTo($adminEmail);
                $where = $userMapper->getDbTable()->getAdapter()->quoteInto("role_id = ?",
                    Tools_Security_Acl::ROLE_ADMIN);
                $adminUsers = $userMapper->fetchAll($where);
                if (!empty($adminUsers)) {
                    foreach ($adminUsers as $admin) {
                        array_push($adminBccArray, $admin->getEmail());
                    }
                    if (!empty($adminBccArray)) {
                        $this->_mailer->setMailBcc($adminBccArray);
                    }
                }
                break;
            default:
                $this->_mailer->setMailToLabel($fullName)->setMailTo($userEmail);
                break;
        }

        $additionalLexems['user:email'] = $userEmail;
        $additionalLexems['user:fullName'] = $fullName;
        $this->_entityParser->objectToDictionary($this->_object, 'profile');
        $this->_entityParser->addToDictionary($additionalLexems);
        $customer = Models_Mapper_CustomerMapper::getInstance()->find($this->_options['userId']);
        $this->_entityParser->objectToDictionary($customer, 'customer');

        return $this->_send();
    }

    protected function _send()
    {
        if (!$this->_mailer->getMailFrom() || !$this->_mailer->getMailTo()) {
            throw new Exceptions_SeotoasterException('Missing required "from" and "to" fields');
        }
        $this->_mailer->setBody($this->_entityParser->parse($this->_template));

        return ($this->_mailer->send() !== false);
    }

    private function _preparseEmailTemplate()
    {
        $tmplName = $this->_options['template'];
        $tmplMessage = $this->_options['message'];
        $mailTemplate = Application_Model_Mappers_TemplateMapper::getInstance()->find($tmplName);

        if (!empty($mailTemplate)) {
            $this->_entityParser->setDictionary(
                array(
                    'emailmessage' => !empty($tmplMessage) ? $tmplMessage : ''
                )
            );
            //pushing message template to email template and cleaning dictionary
            $mailTemplate = $this->_entityParser->parse($mailTemplate->getContent());
            $this->_entityParser->setDictionary(array());

            $mailTemplate = $this->_entityParser->parse($mailTemplate);

            $themeData = Zend_Registry::get('theme');
            $extConfig = Zend_Registry::get('extConfig');
            $parserOptions = array(
                'websiteUrl' => $this->_websiteHelper->getUrl(),
                'websitePath' => $this->_websiteHelper->getPath(),
                'currentTheme' => $extConfig['currentTheme'],
                'themePath' => $themeData['path'],
            );
            $parser = new Tools_Content_Parser($mailTemplate, array(), $parserOptions);

            return $parser->parseSimple();
        }

        return false;
    }


}