<?php

use Stripe\SetupIntent;
use Stripe\Customer;
use Stripe\PaymentMethod;
use Stripe\Refund;


class Tools_StripeOAuthTools
{

    public static function checkStripepayConfigOAuth()
    {
        $configData = Application_Model_Mappers_ConfigMapper::getInstance()->getConfig();

        $stripepayOAuth = 0;
        if(!empty($configData['stripepayOAuth'])) {
            $stripepayOAuth = $configData['stripepayOAuth'];
        }

        return $stripepayOAuth;
    }

    public static function connectionStatusMojo()
    {
        //return array
//        $stripepayConnectionStatus = array (
//        'done' => true,//false
//        'status' => 'connected',
//        'oauthLink' => 'https://connect.stripe.com/oauth/authorize?scope=read_writ…',
//        'stripe_publishable_key' => 'pk_live_***',
//        'stripe_client_id' => 'acct_***',
//        'mode' => 'test'//production
//)
        $stripepayConnectionStatus = Apps::apiCall('POST', 'stripeService', 'getConnectionStatus', array());

        if(!empty($stripepayConnectionStatus['done'])) {
            return $stripepayConnectionStatus;
        }

        return null;
    }

    public static function setTestModeMojo(array $dataRequest = array()) {
        //array('testMode' => 1)
        $stripepayTestMode = Apps::apiCall('POST', 'stripeService', 'setTestMode', array('requestData' => $dataRequest));

        if(!empty($stripepayTestMode['done'])) {
            return $stripepayTestMode;
        }

        return null;
    }

    public static function createSetupIntentMojo()
    {
        //return SetupIntent Obj
        $responceIntent = Apps::apiCall('POST', 'stripeService', 'createSetupIntent', array());

        if (!empty($responceIntent['error'])) {
            return null;
        }

        return array('intent' => $responceIntent);
    }

    public static function createPaymentIntentMojo(array $dataRequest = array())
    {
        //return Obj
        $responceIntent = Apps::apiCall('POST', 'stripeService', 'createPaymentIntent', array('requestData' => json_encode($dataRequest)));

        if (!empty($responceIntent['error'])) {
            return null;
        }

        return $responceIntent;
    }

    public static function createStripeSessionMojo($paymentMethodTypes = array(), $shippingOptions = array(), $lineItems = array(), $customerEmail = '', $successUrl = '', $cancelUrl = '', $metadata = array())
    {
        //return Obj
        $responceStripeSession = Apps::apiCall('POST', 'stripeService', 'createStripeSession', array('requestData' => array(
            'payment_method_types' => $paymentMethodTypes,
            'shipping_options' => $shippingOptions,
            'mode' => 'payment',
            'line_items' => $lineItems,
            'customer_email' => $customerEmail,
            'success_url' => $successUrl,
            'cancel_url' => $cancelUrl,
            'metadata' => $metadata,
        )));

        if (!empty($responceStripeSession['error'])) {
            return null;
        }

        return $responceStripeSession;
    }

    public static function retrievePaymentIntentMojo($intentId)
    {
        //return Obj
        $responceIntent = Apps::apiCall('POST', 'stripeService', 'retrievePaymentIntent', array('requestData' => array(
            'intent_id' => $intentId
        )));

        if (!empty($responceIntent['error'])) {
            return null;
        }

        return $responceIntent;
    }

    public static function retrievePaymentMethodMojo($paymentMethodId)
    {
        //return Obj
        $responcePaymentMethod = Apps::apiCall('POST', 'stripeService', 'retrievePaymentMethod', array('requestData' => array(
            'payment_method' => $paymentMethodId
        )));

        if (!empty($responcePaymentMethod['error'])) {
            return null;
        }

        return $responcePaymentMethod;
    }

    public static function createCustomerMojo($paymentMethodId)
    {
        //return Customer Obj
        $responceCustomer = Apps::apiCall('POST', 'stripeService', 'createCustomer', array('requestData' => array(
            'payment_method' => $paymentMethodId
        )));

        if (!empty($responceCustomer['error'])) {
            return null;
        }

        return array('customer' => $responceCustomer);
    }

    public static function allPaymentMethodMojo($customer, $type)
    {
        //return PaymentMethod Obj
        $responcePaymentMethod = Apps::apiCall('POST', 'stripeService', 'allPaymentMethod', array('requestData' => array(
            'customer' => $customer,
            'type' => $type
        )));

        if (!empty($responcePaymentMethod['error'])) {
            return null;
        }

        return array('paymentMethod' => $responcePaymentMethod);
    }

    public static function createRefundMojo($requestData)
    {
        //return Refund Obj
        $refundResponce = Apps::apiCall('POST', 'stripeService', 'createRefund', array('requestData' => $requestData));

        if (!empty($refundResponce['error'])) {
            return null;
        }

        return $refundResponce;
    }


    public static function deauthorizeAccountMojo()
    {
        $deauthorizeResponce = Apps::apiCall('POST', 'stripeService', 'deauthorize', array());

        if (!empty($deauthorizeResponce['error'])) {
            return null;
        }

        return $deauthorizeResponce;
    }

    public static function getStripeTerminalTokenMojo()
    {
        //https://docs.stripe.com/api/terminal/connection_tokens/create
        $terminalTokenResponce = Apps::apiCall('POST', 'stripeService', 'getTerminalToken', array());

        if (!empty($terminalTokenResponce['error'])) {
            return null;
        }

        return $terminalTokenResponce;
    }

    public static function getStripeTerminalLocationMojo($requestData)
    {
//       https://docs.stripe.com/api/terminal/locations/retrieve
//        array (
//            'location_id' => 'tml_GOxz8AdbezLCsk'//terminalId
//        )

        $getTerminalLocationResponce = Apps::apiCall('POST', 'stripeService', 'getTerminalLocation', array('requestData' => $requestData));

        if (!empty($getTerminalLocationResponce['error'])) {
            return null;
        }

        return $getTerminalLocationResponce;
    }

    public static function createStripeTerminalLocationMojo($requestData)
    {
        //https://docs.stripe.com/api/terminal/locations/create
//        array (
//            'display_name' => 'Boyd J Ball',
//            'address' => array (
//                    'line1' => '1696 19th Ave1',
//                    'city' => 'San Francisco',
//                    'postal_code' => '94122',
//                    'country' => 'US',
//                    'state' => 'CA',
//            ),
//        )

        $createTerminalLocationResponce = Apps::apiCall('POST', 'stripeService', 'createTerminalLocation', array('requestData' => $requestData));

        if (!empty($createTerminalLocationResponce['error'])) {
            return null;
        }

        return $createTerminalLocationResponce;
    }


    public static function updateStripeTerminalLocationMojo($requestData)
    {

        //https://docs.stripe.com/api/terminal/locations/update

//        array (
//           'terminalId' => 'tml_Fru9TAlsysudlc',//location_id
//           'location' => array (
//                'display_name' => 'Boyd J Ball',
//                'address' => array (
//                        'line1' => '1696 19th Ave1',
//                        'city' => 'San Francisco',
//                        'postal_code' => '94122',
//                        'country' => 'US',
//                        'state' => 'CA',
//                ),
//            )
//        )

        $updateTerminalLocationResponce = Apps::apiCall('POST', 'stripeService', 'updateTerminalLocation', array('requestData' => $requestData));

        if (!empty($updateTerminalLocationResponce['error'])) {
            return null;
        }

        return $updateTerminalLocationResponce;
    }


}
