<?php

class Stripepay_Models_Mappers_StripepayTransactionMapper extends Application_Model_Mappers_Abstract
{
    protected $_dbTable = 'Stripepay_Models_Dbtables_StripepayTransactionDbtable';

    protected $_model = 'Stripepay_Models_Models_StripepayTransactionModel';

    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'live_mode' => $model->getLiveMode(),
            'payment_type' => $model->getPaymentType(),
            'charge_id' => $model->getChargeId(),
            'checkout_session_id' => $model->getCheckoutSessionId(),
            'stripe_customer_id' => $model->getStripeCustomerId(),
            'payment_intent' => $model->getPaymentIntent(),
            'status' => $model->getStatus(),
            'amount' => $model->getAmount(),
            'card_type' => $model->getCardType(),
            'exp_month' => $model->getExpMonth(),
            'exp_year' => $model->getExpYear(),
            'card_fingerprint' => $model->getCardFingerprint(),
            'card_mask' => $model->getCardMask(),
            'token' => $model->getToken(),
            'total_tax' => $model->getTotalTax(),
            'cart_id' => $model->getCartId(),
            'order_shipping_address' => $model->getOrderShippingAddress(),
            'order_billing_address' => $model->getOrderBillingAddress(),
            'order_date_full' => $model->getOrderDateFull(),
            'order_amount' => $model->getOrderAmount(),
            'currency' => $model->getCurrency(),
            'transaction_type' => $model->getTransactionType(),
            'receipt_url' => $model->getReceiptUrl(),
            'payment_method' => $model->getPaymentMethod(),
            'intent_client_secret' => $model->getIntentClientSecret(),
            'first_name' => $model->getFirstName(),
            'last_name' => $model->getLastName(),
            'email' => $model->getEmail(),
            'email_sent' => $model->getEmailSent(),
            'customer_email_sent' => $model->getCustomerEmailSent(),
            'refund_id' => $model->getRefundId(),
            'refund_amount' => $model->getRefundAmount(),
            'refund_last_date' => $model->getRefundLastDate(),
            'reason' => $model->getReason(),
        );

        $id = $model->getId();
        if ($id) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            $this->getDbTable()->update($data, $where);
        } else {
            $id = $this->getDbTable()->insert($data);
            $model->setId($id);
        }
        return $model;
    }

    /**
     * @param $token
     * @return null
     */
    public function getByTokenId($token)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('token = ?', $token);

        return $this->_findWhere($where);
    }

    public function findByCheckoutSessionId($checkoutSessionId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('checkout_session_id = ?', $checkoutSessionId);
        $transaction = $this->fetchAll($where);
        if (!empty($transaction) && $transaction[0] instanceof $this->_model) {
            return $this->find($transaction[0]->getId());
        }
        return false;
    }

    public function selectTransactionsByCartId($cartId, $getObj = false)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto("cart_id=?", $cartId);

        if($getObj) {
            return $this->_findWhere($where);
        } else {
            return $this->fetchAll($where);
        }
    }

    public function findByCartId($cartId, $paymentType = false, $status = array())
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('cart_id = ?', $cartId);
        if ($paymentType) {
            $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto('payment_type= ?', $paymentType);
        }
        if (!empty($status)) {
            $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto('status IN (?)', $status);
        }

        return $this->fetchAll($where);
    }

    public function findById($id)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
        return $this->_findWhere($where);
    }

}
