<?php

/**
 * Class Stripepay_Models_Mappers_StripepayConfigMapper
 */
class Stripepay_Models_Mappers_StripepayConfigMapper extends Application_Model_Mappers_Abstract {

    protected $_dbTable = 'Stripepay_Models_Dbtables_StripepayConfigDbtable';

    protected $_model   = 'Stripepay_Models_Models_StripepayConfigModel';

    public function save($config)
    {
        if (!is_array($config) || empty ($config)) {
            throw new Exceptions_SeotoasterPluginException('Given parameter should be non empty array');
        }

        array_walk($config, function ($value, $key, $dbTable) {
            $dbTable->updateParam($key, $value);
        }, $this->getDbTable());

    }

    /**
     * Get all config params
     *
     * @return mixed
     * @throws Exception
     */
    public function getConfigParams()
    {
        return $this->getDbTable()->selectConfig();
    }

    /**
     * Get by param name
     *
     * @param string $name param name
     * @return null
     * @throws Exception
     */
    public function getConfigParam($name)
    {
        if (!$name) {
            return null;
        }

        $row = $this->getDbTable()->find($name);
        if ($row = $row->current()) {
            return $row->value;
        }

        return null;
    }

}

