#!/usr/bin/env php
<?php
/**
 * The script for a cron recurring payments
 */
if (PHP_SAPI !== 'cli') {
    die('direct access is not allowed');
}

define('TOASTER_ROOT', realpath(__DIR__ . '/../..'));

if (!TOASTER_ROOT) {
    die('Can\'t get proper toaster location');
}

require_once TOASTER_ROOT . '/system/coreinfo.php';

$ini = CORE . 'application/configs/' . SITE_NAME . '.ini';

if (!is_file($ini)) {
    die('Can not find application ini file');
}

set_include_path(
    implode(
        PATH_SEPARATOR,
        array(
            realpath(CORE . 'library'),
            realpath(CORE . 'application/app'),
            get_include_path(),
        )
    )
);

require_once('Zend/Loader/Autoloader.php');
$autoloader = Zend_Loader_Autoloader::getInstance();
$autoloader->registerNamespace(
    array(
        'Widgets_',
        'Helpers_',
        'Tools_'
    )
);

Zend_Controller_Action_HelperBroker::addHelper(new Helpers_Action_Website());

$config = new Zend_Config_Ini($ini);
$dbConfig = $config->database->database->toArray();
Zend_Registry::set('website', $config->website->website->toArray());
Zend_Registry::set('database', $dbConfig);
Zend_Registry::set('theme', $config->theme->theme->toArray());
Zend_Registry::set('news', $config->news->news->toArray());
Zend_Registry::set('misc', $config->misc->misc->toArray());

if ($dbConfig['adapter'] === 'pdo_mysql') {
    $dbConfig['params']['driver_options'] = array(
        PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES UTF8;'
    );
}

$db = Zend_Db::factory($dbConfig['adapter'], $dbConfig['params']);

if ($dbConfig['adapter'] === 'mysqli') {
    $db->query('SET NAMES UTF8');
    $db->query('SET CHARACTER SET utf8');
}

Zend_Db_Table::setDefaultAdapter($db);

try {
    $db->getConnection();
    $select = $db->select()
        ->from(array('srp' => 'shopping_recurring_payment'), null)
        ->columns(
            array('id' => 'cart_id')
        )
        ->where("srp.gateway_type = ?", 'stripepay')
        ->where("srp.recurring_status IN (?)", array('new', 'active', 'pending'))
        ->where("srp.next_payment_date <= ?", date('Y-m-d'));
    $url = "https://" . $config->website->website->url;
    $carts = $db->fetchAll($select);
    foreach ($carts as $cart) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url . "plugin/stripepay/run/recurrentPay/cartId/" . $cart['id']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);

        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // this results 0 every time
        $response = curl_exec($ch);

        if ($response === false) {
            $response = curl_error($ch);
            echo stripslashes($response);
        } else {
            $response = json_decode($response, true);
            if ($response['error'] === 0) {
                echo " Done!\n";
            } else {
                echo " Error\n";
            }
        }
        curl_close($ch);
    }
} catch (Exception $e) {
    die($e->getMessage());
}
exit(0);