export const getCashRegistersSavedData = ({commit, state, dispatch}, payload) => {
    showLoader();

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/seosambapos/run/getCashRegistersSavedData/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'secureToken': $('#cash-registers-config-token').val(),
            }
        }).done(async  function(response){
            hideLoader();
            if (response.responseText.status !== 'error') {
                commit('setCashRegistersData', response.responseText.cashRegisters);
                resolve(response.responseText);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const updateCashRegisterLabel = ({commit, state, dispatch}, payload) => {
    showLoader();

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/seosambapos/run/updateCashRegisterLabel/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'id': payload.id,
                'cashRegisterLabel': payload.cashRegisterLabel,
                'secureToken': $('#cash-registers-config-token').val(),
            }
        }).done(function(response){
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const deleteCashRegister = ({commit, state, dispatch}, payload) => {
    showLoader();

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/seosambapos/run/deleteCashRegister/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'id': payload.id,
                'secureToken': $('#cash-registers-config-token').val(),
            }
        }).done(function(response){
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const saveCashRegistersConfigData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'plugin/seosambapos/run/saveCashRegistersConfigData/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' : $('#cash-registers-config-token').val(),
                'cashRegisterId': payload.cashRegisterId,
                'cashRegisterLabel': payload.cashRegisterLabel,

            }
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}