import localeMapping from '../../../localizationLanguages';
import {saveCashRegistersConfigData} from "../../../config/store/actions";

export default {
    data() {
        return {
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#system-language-cash-registers').val(),
            showCashRegistersBlock: false,
            newCashRegisterId: '',
            newCashRegisterLabel: '',
        }
    },
    components: {},
    computed: {
        cashRegistersData: function() {
            return this.$store.getters.getCashRegistersData;
        }
    },
    methods: {
        async saveCashRegistersConfigData(e) {
            let cashRegisterId = this.newCashRegisterId,
                cashRegisterLabel = this.newCashRegisterLabel;

            cashRegisterId = cashRegisterId.replace(/[^0-9]/g, '');
            cashRegisterLabel = cashRegisterLabel.replace(/[^a-zA-Z0-9'-_ ]/g, '');

            if(cashRegisterId.length < 1) {
                showMessage(this.$t('message.notEmptyCashRegisterId'), true, 2000);
                return false;
            }

            if(cashRegisterLabel.length < 1) {
                showMessage(this.$t('message.notEmptyCashRegisterLabel'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('saveCashRegistersConfigData', {'cashRegisterId': cashRegisterId, 'cashRegisterLabel': cashRegisterLabel});
            if(result.responseText.status === 'error') {
                if(result.responseText.message != '') {
                    showMessage(result.responseText.message, true, 3000);
                } else {
                    showMessage('Please re-login', true, 3000);
                }
            } else {
                showMessage(result.responseText.message, false, 3000);

                this.newCashRegisterId = '';
                this.newCashRegisterLabel = '';

                const resultData = await this.$store.dispatch('getCashRegistersSavedData', {'router':this.$router});
                if(resultData.status === 'error') {
                    this.showCashRegistersBlock = false;
                    if(resultData.message != '') {
                        showMessage(resultData.message, true, 3000);
                    } else {
                        showMessage('Please re-login', true, 3000);
                    }
                } else {
                    this.showCashRegistersBlock = true;
                }
            }
        },
        async updateCashRegisterLabel(id, oldName, event) {
            event.preventDefault();
            let cashRegisterLabel = event.target.value;
            cashRegisterLabel = cashRegisterLabel.replace(/[^a-zA-Z0-9'-_ ]/g, '');

            if(cashRegisterLabel.length < 1) {
                showMessage(this.$t('message.notEmptyCashRegisterLabel'), true, 2000);
                event.target.value = oldName;
                return false;
            } else {
                const result = await this.$store.dispatch('updateCashRegisterLabel', {'id': id, 'cashRegisterLabel': cashRegisterLabel});

                if (result.responseText.status === 'error') {
                    event.target.value = oldName;
                    showMessage(result.responseText.message, true, 2000);
                    return false;
                } else {
                    event.target.value = cashRegisterLabel;
                    showMessage(result.responseText.message, false, 2000);
                    return true;
                }
            }
        },
        async deleteCashRegisterItem(id) {
            showConfirm(this.$t('message.areYouShureDelete'), async () => {
                const result = await this.$store.dispatch('deleteCashRegister', {'id': id});
                if (result.responseText.status === 'error') {
                    showMessage(result.responseText.message, true, 2000);
                    return false;
                } else {
                    showMessage(result.responseText.message, false, 2000);
                    const resultData = await this.$store.dispatch('getCashRegistersSavedData', {'router':this.$router});
                    if(resultData.status === 'error') {
                        this.showCashRegistersBlock = false;
                        if(resultData.message != '') {
                            showMessage(resultData.message, true, 3000);
                        } else {
                            showMessage('Please re-login', true, 3000);
                        }
                    } else {
                        this.showCashRegistersBlock = true;
                    }
                }
            });
        }

    },
    async created() {
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        const result = await this.$store.dispatch('getCashRegistersSavedData', {'router':this.$router});
        console.log('getCashRegistersSavedData', result)
        if(result.status === 'error') {
            if(result.message != '') {
                showMessage(result.message, true, 3000);
            } else {
                showMessage('Please re-login', true, 3000);
            }
        } else {
            this.showCashRegistersBlock = true;
        }

    },
    async updated() {

    },
    async mounted() {
    },
}
