export const configurationData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'plugin/seosambapos/run/configData/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'getConfig': 1,
                'secureToken': $('#general-config-token').val()
             }
        }).done(async function(response){
            if (response.responseText.status !== 'error') {
                commit('setDefaultCustomersDropdown', response.responseText.defaultCustomers);
                commit('setDefaultSalespersonsDropdown', response.responseText.defaultSalespersons);
                commit('setTemplateList', response.responseText.templateList);
                resolve(response.responseText);
            } else {
                resolve(response.responseText);
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const setDefaultCustomer = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'plugin/seosambapos/run/configData/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'defaultCustomerId': payload.defaultCustomerId,
                'defaultCustomerLabel': payload.defaultCustomerLabel,
                'secureToken': $('#general-config-token').val()
            }
        }).done(async function(response){
            if (response.responseText.status !== 'error') {
                resolve(response.responseText);
            } else {
                resolve(response.responseText);
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const setReceiptTemplate = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'plugin/seosambapos/run/configData/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'receiptTemplate': payload.receiptTemplate,
                'secureToken': $('#general-config-token').val()
            }
        }).done(async function(response){
            if (response.responseText.status !== 'error') {
                resolve(response.responseText);
            } else {
                resolve(response.responseText);
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const setDefaultSalesperson = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'plugin/seosambapos/run/configData/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'defaultSalespersonId': payload.defaultSalespersonId,
                'defaultSalespersonLabel': payload.defaultSalespersonLabel,
                'secureToken': $('#general-config-token').val()
            }
        }).done(async function(response){
            if (response.responseText.status !== 'error') {
                resolve(response.responseText);
            } else {
                resolve(response.responseText);
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}