import localeMapping from '../../../localizationLanguages';

export default {
    data() {
        return {
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#system-language-general-config').val(),
            defaultCustomer: [],
            cronPathClearReservedCardsContent: '',
            cronPathUnsetActiveSessionAllSales: '',
            receiptTemplate: 0,
            defaultSalesperson: [],
        }
    },
    components: {},
    computed: {
        defaultCustomersDropdown: function() {
            return this.$store.getters.getDefaultCustomersDropdown;
        },
        templateList: function() {
            return this.$store.getters.getTemplateList;
        },
        defaultSalespersonsDropdown: function() {
            return this.$store.getters.getDefaultSalespersonsDropdown;
        },
    },
    methods: {
        async setDefaultCustomer(e) {
            let defaultCustomer = e.id;
            let defaultCustomerLabel = e.label;

            const result = await this.$store.dispatch('setDefaultCustomer', {'defaultCustomerId': defaultCustomer, 'defaultCustomerLabel': defaultCustomerLabel});
            console.log('setDefaultCustomer', result);
            if(result.status === 'error') {
                if(result.message != '') {
                    showMessage(result.message, true, 3000);
                } else {
                    showMessage('Please re-login', true, 3000);
                }
            } else {
                if(result.generalConfig.defaultCustomerId != '' && typeof result.generalConfig.defaultCustomerId !== 'undefined') {
                    this.defaultCustomer = [{'id': result.generalConfig.defaultCustomerId, 'label': result.generalConfig.defaultCustomerLabel}];
                } else {
                    this.defaultCustomer = [];
                }
            }
        },
        async setDefaultSalesperson(e) {
            let defaultSalesperson = e.id;
            let defaultSalespersonLabel = e.label;

            const result = await this.$store.dispatch('setDefaultSalesperson', {'defaultSalespersonId': defaultSalesperson, 'defaultSalespersonLabel': defaultSalespersonLabel});
            console.log('setDefaultSalesperson', result);
            if(result.status === 'error') {
                if(result.message != '') {
                    showMessage(result.message, true, 3000);
                } else {
                    showMessage('Please re-login', true, 3000);
                }
            } else {
                if(result.generalConfig.defaultSalespersonId != '' && typeof result.generalConfig.defaultSalespersonId !== 'undefined') {
                    this.defaultSalesperson = [{'id': result.generalConfig.defaultSalespersonId, 'label': result.generalConfig.defaultSalespersonLabel}];
                } else {
                    this.defaultSalesperson = [];
                }
            }
        },
        async setReceiptTemplate(e) {
            let template = e;

            const result = await this.$store.dispatch('setReceiptTemplate', {'receiptTemplate': template});
            console.log('setReceiptTemplate', result);
            if(result.status === 'error') {
                if(result.message != '') {
                    showMessage(result.message, true, 3000);
                } else {
                    showMessage('Please re-login', true, 3000);
                }
            } else {
                if(typeof result.generalConfig.receiptTemplate !== 'undefined') {
                    this.receiptTemplate = result.generalConfig.receiptTemplate;
                } else {
                    this.receiptTemplate = 0;
                }
            }
        },
        async imapCopyPathInfo(event, type){
            event.preventDefault();
            let cronPath = this.cronPathClearReservedCardsContent;

            if(type == 'unsetActiveSession') {
                cronPath = this.cronPathUnsetActiveSessionAllSales;
            }

            if (document.queryCommandSupported("copy")) {
                let copyFromEl = $('<textarea/>');
                copyFromEl.text(cronPath);
                $('body').append(copyFromEl);
                copyFromEl.select();
                document.execCommand('copy', true);
                copyFromEl.remove();
                showMessage(this.$t('message.copiedToClipboard'), false, 2000);
            }

            return true;
        },

    },
    async created() {
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        const result = await this.$store.dispatch('configurationData', {'router':this.$router});

        if(result.status === 'error') {
            if(result.message != '') {
                showMessage(result.message, true, 3000);
            } else {
                showMessage('Please re-login', true, 3000);
            }
        } else {
            if(result.generalConfig.defaultCustomerId != '' && typeof result.generalConfig.defaultCustomerId !== 'undefined') {
                this.defaultCustomer = [{'id': result.generalConfig.defaultCustomerId, 'label': result.generalConfig.defaultCustomerLabel}];
            } else {
                this.defaultCustomer = [];
            }

            if(result.generalConfig.defaultSalespersonId != '' && typeof result.generalConfig.defaultSalespersonId !== 'undefined') {
                this.defaultSalesperson = [{'id': result.generalConfig.defaultSalespersonId, 'label': result.generalConfig.defaultSalespersonLabel}];
            } else {
                this.defaultSalesperson = [];
            }

            if(typeof result.generalConfig.receiptTemplate !== 'undefined') {
                this.receiptTemplate = result.generalConfig.receiptTemplate;
            } else {
                this.receiptTemplate = 0;
            }

            this.cronPathClearReservedCardsContent = result.cronPathClearReservedCardsContent;
            this.cronPathUnsetActiveSessionAllSales = result.cronPathUnsetActiveSessionAllSales;
        }
    },
    async updated() {

    },
    async mounted() {
    },
}
