export const getConfigSavedData = ({commit, state, dispatch}, payload) => {
    showLoader();

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/seosambapos/run/defaultProductConfigData/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'secureToken': $('#general-config-token').val()
            }
        }).done(async  function(response){
            hideLoader();
            if (response.responseText.status !== 'error') {
                commit('setConfigDataInfo', response.responseText.configData);
                commit('setBrands', response.responseText.brands);
                commit('setDefaultTaxes', response.responseText.defaultTaxes);
                commit('setTemplateList', response.responseText.templateList);
                commit('setProductList', response.responseText.productList);
                commit('setProductCondition', response.responseText.defaultCondition);
                resolve(response.responseText);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const saveConfigData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'plugin/seosambapos/run/defaultProductConfigData/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' : $('#general-config-token').val(),
                'defaultBrandId': payload.defaultBrandId,
                'defaultTaxId': payload.defaultTaxId,
                'defaultTemplate': payload.defaultTemplate,
                'defaultProduct': payload.defaultProduct,
                'defaultCondition': payload.defaultCondition,
            }
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}