import localeMapping from '../../../localizationLanguages';

export default {
    data() {
        return {
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#system-language-general-config').val(),
            defaultBrandId: 0,
            defaultTaxId: 0,
            defaultTemplate: 0,
            defaultProduct: [],
            defaultCondition: 0,
        }
    },
    components: {},
    computed: {
        configDataInfo: function() {
            return this.$store.getters.getConfigDataInfo;
        },
        brands: function() {
            return this.$store.getters.getBrands;
        },
        defaultTaxes: function() {
            return this.$store.getters.getDefaultTaxes;
        },
        templateList: function() {
            return this.$store.getters.getTemplateList;
        },
        productList: function() {
            return this.$store.getters.getProductList;
        },
        productCondition: function() {
            return this.$store.getters.getProductCondition;
        }
    },
    methods: {
        async renderGrid()
        {
            const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});

            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                if(typeof result.configData.defaultBrandId !== 'undefined' && result.configData.defaultBrandId != '') {
                    this.defaultBrandId = result.configData.defaultBrandId;
                } else {
                    this.defaultBrandId = 0;
                }

                if(typeof result.configData.defaultTaxId !== 'undefined' && result.configData.defaultTaxId != '') {
                    this.defaultTaxId = result.configData.defaultTaxId;
                } else {
                    this.defaultTaxId = 0;
                }

                if(typeof result.configData.defaultTemplate !== 'undefined' && result.configData.defaultTemplate != '') {
                    this.defaultTemplate = result.configData.defaultTemplate;
                } else {
                    this.defaultTemplate = 0;
                }

                if(typeof result.configData.defaultCondition !== 'undefined' && result.configData.defaultCondition != '') {
                    this.defaultCondition = result.configData.defaultCondition;
                } else {
                    this.defaultCondition = 0;
                }

                if(typeof result.configData.defaultProductId !== 'undefined' && result.configData.defaultProductId != '') {
                    this.defaultProduct = [{'id': result.configData.defaultProductId, 'label': result.configData.defaultProductLabel}];
                } else {
                    this.defaultProduct = [];
                }

            }
        },
        async setDefaultProduct(e) {
            let defaultProduct = e.id;
            let defaultProductLabel = e.label;

            this.defaultProduct = [{'id': defaultProduct, 'label': defaultProductLabel}];
        },
        async saveConfig(){
            if (this.defaultBrandId === 0) {
                showMessage(this.$t('message.pleaseSelectDefaultBrand'), true, 2000);
                return false;
            }

            if (this.defaultTemplate === 0) {
                showMessage(this.$t('message.pleaseSelectDefaultTemplate'), true, 2000);
                return false;
            }

            if (this.defaultCondition === 0) {
                showMessage(this.$t('message.pleaseSelectDefaultCondition'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('saveConfigData', {'defaultBrandId':this.defaultBrandId, 'defaultTaxId':this.defaultTaxId, 'defaultTemplate':this.defaultTemplate, 'defaultProduct':this.defaultProduct, 'defaultCondition':this.defaultCondition});

            if (result.error == '1') {
                showMessage(result.responseText.message, true, 2000);
                return false;
            } else {
                showMessage(result.responseText.message, false, 2000);
            }
        },

    },
    async created() {
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.renderGrid();
    },
    async updated() {

    },
    async mounted() {
    },
}
