CREATE TABLE IF NOT EXISTS `plugin_seosambapos_settings` (
    `name` VARCHAR(255) NOT NULL COLLATE 'utf8_unicode_ci',
    `value` VARCHAR(255) NOT NULL COLLATE 'utf8_unicode_ci',
    PRIMARY KEY (`name`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_seosambapos_default_product_settings` (
    `name` VARCHAR(255) NOT NULL COLLATE 'utf8_unicode_ci',
    `value` VARCHAR(255) NOT NULL COLLATE 'utf8_unicode_ci',
    PRIMARY KEY (`name`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_seosambapos_active_session` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `user_id` INT(10) UNSIGNED NOT NULL COMMENT 'posUserId',
    `location_id` INT(10) UNSIGNED NOT NULL,
    `cash_register_id` INT(10) UNSIGNED NOT NULL,
    PRIMARY KEY(`id`),
    FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_seosambapos_logged_user_log` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `user_id` INT(10) UNSIGNED NOT NULL COMMENT 'posUserId',
    `status` ENUM('login', 'logout') DEFAULT 'login',
    `location_id` INT(10) UNSIGNED DEFAULT NULL,
    `cash_register_id` INT(10) UNSIGNED DEFAULT NULL,
    `date_created` TIMESTAMP NOT NULL COMMENT 'Logged in/Logged out date',
    PRIMARY KEY(`id`),
    INDEX (`user_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_seosambapos_action_log` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `type` VARCHAR(64) COLLATE utf8_unicode_ci NOT NULL,
    `user_id` INT(10) UNSIGNED NOT NULL COMMENT 'posUserId',
    `created_at` TIMESTAMP NULL,
    `additional_content` MEDIUMTEXT DEFAULT NULL,
    PRIMARY KEY (`id`),
    INDEX `user_id` (`user_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_seosambapos_terminal_locations` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `pickup_location_id` INT(10) UNSIGNED NOT NULL,
    `location_address_hash` VARCHAR(35) COLLATE utf8_unicode_ci NOT NULL,
    `terminal_id` VARCHAR(64) COLLATE utf8_unicode_ci NOT NULL,
    PRIMARY KEY (`id`),
    FOREIGN KEY (`pickup_location_id`) REFERENCES `shopping_pickup_location` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT IGNORE INTO `email_triggers` (`enabled`, `trigger_name`, `observer`) VALUES
('1', 'seosambapos_emailreceipt', 'Tools_SeosambaposMailWatchdog'),
('1', 'seosambapos_sendreviewlink', 'Tools_SeosambaposMailWatchdog');

INSERT IGNORE INTO `email_triggers_actions` (`service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject`)
SELECT CONCAT('email'),	CONCAT('seosambapos_emailreceipt'),	NULL,	CONCAT('customer'),	CONCAT('Hi there {customer:fullname}! <br/><br/>Thank you for purchasing with us.<br/><br/>Your order includes<br/><br/>{$seosambapos:seosambaposreport:mailreport}'),	CONCAT('no-reply@{$website:domain}'),	CONCAT('Email Receipt') FROM email_triggers_actions
WHERE NOT EXISTS (SELECT `service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject` FROM `email_triggers_actions` WHERE `trigger` = 'seosambapos_emailreceipt') LIMIT 1;

INSERT IGNORE INTO `email_triggers_actions` (`service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject`)
SELECT CONCAT('email'),	CONCAT('seosambapos_sendreviewlink'),	NULL,	CONCAT('customer'),	CONCAT('Hi there {customer:fullname}! <br/><br/>Thank you for purchasing with us.<br/><br/>Please send us a review by the following link(s):<br/>{seosambapos:reviewlink}'),	CONCAT('no-reply@{$website:domain}'),	CONCAT('Review Link') FROM email_triggers_actions
WHERE NOT EXISTS (SELECT `service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject` FROM `email_triggers_actions` WHERE `trigger` = 'seosambapos_sendreviewlink') LIMIT 1;

INSERT IGNORE INTO `email_triggers_actions` (`id`, `service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject`)
SELECT NULL, CONCAT('sms'), CONCAT('seosambapos_sendreviewlink'), NULL, CONCAT('customer') , CONCAT('Hi there {customer:fullname}!
Thank you for purchasing with us.
Please send us a review by the following link(s):
{seosambapos:reviewlink}'), NULL,  NULL
FROM email_triggers_actions WHERE
    NOT EXISTS (SELECT `id`, `service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject` FROM `email_triggers_actions`
                WHERE `service` = 'sms' AND `recipient` = 'customer' AND `trigger` = 'seosambapos_sendreviewlink')
                              AND EXISTS (SELECT name FROM `plugin` where `name` = 'shopping') LIMIT 1;

CREATE TABLE IF NOT EXISTS `plugin_seosambapos_cash_registers_config` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `cash_register_id` INT(10) UNSIGNED NOT NULL,
    `cash_register_label` VARCHAR(255) NOT NULL COLLATE 'utf8_unicode_ci',
    PRIMARY KEY(`id`),
    UNIQUE (`cash_register_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_seosambapos_default_customer_address` (
    `customer_id` INT(10) UNSIGNED NOT NULL,
    `customer_address_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
    PRIMARY KEY(`customer_id`),
    FOREIGN KEY(`customer_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
    UNIQUE (`customer_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_seosambapos_purchases_data` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `cart_id` INT(10) UNSIGNED NOT NULL,
    `location_id` INT(10) UNSIGNED DEFAULT NULL,
    `status` ENUM('waiting', 'completed', 'error') DEFAULT 'waiting',
    `type` ENUM('web', 'app') DEFAULT 'web',
    `gateway` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
    `receipt` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
    PRIMARY KEY(`id`),
    FOREIGN KEY(`cart_id`) REFERENCES `shopping_cart_session` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
    UNIQUE (`cart_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `observers_queue` (`observable`, `observer`) VALUES
    ('Models_Model_CartSession', 'Tools_SeosambaposPurchaseWatchdog');

CREATE TABLE IF NOT EXISTS `plugin_seosambapos_reduce_product_locations_inventory_log` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `type` ENUM('web', 'app') DEFAULT 'web',
    `cart_id` INT(10) UNSIGNED NOT NULL,
    `location_id` INT(10) UNSIGNED DEFAULT NULL,
    `created_at` TIMESTAMP NULL,
    `additional_content` MEDIUMTEXT DEFAULT NULL,
    PRIMARY KEY(`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_seosambapos_reserved_carts` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `cart_id` INT(10) UNSIGNED NOT NULL,
    `location_id` INT(10) UNSIGNED NOT NULL,
    `cashier_id` INT(10) UNSIGNED NOT NULL,
    PRIMARY KEY(`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_seosambapos_transactions` (
    `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
    `payment_type` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
    `cart_id` int(10) unsigned NOT NULL,
    `status` VARCHAR(255) NULL,
    `amount` int(10) unsigned NOT NULL DEFAULT '0',
    `charge_id` VARCHAR(200) DEFAULT NULL,
    `transaction_id` VARCHAR(200) DEFAULT NULL,
    `date` TIMESTAMP NULL,
    `reason` VARCHAR(255) NULL,
    PRIMARY KEY (`id`)
    ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET='utf8' COLLATE='utf8_unicode_ci';

INSERT IGNORE INTO `template_type` (`id`, `title`) VALUES
('typepos', 'POS');

INSERT IGNORE INTO `template` (`name`, `content`, `type`) VALUES
    ('receipt',	'<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">\n<html>\n    <head>\n     <title>{$plugin:widcard:BizOrgName:notag}</title>\n  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">\n\n  <style type="text/css">\n   *{\n       margin  : 0;\n     padding : 0;\n   }\n   body{\n       background : #ffffff;\n       font       : 14px Arial, sans-serif;\n       color      : #000000;\n   }\n   a{ text-decoration : none; }\n   h1{\n       float : left;\n       width : 60%;\n   }\n   img.logo{\n       max-width  : 100%;\n       max-height : 100px;\n       border     : none;\n   }\n   img.pickup-location-map{\n       max-width  : 100%;\n       max-height : none;\n       border     : none;\n   }\n   #address{\n       float      : left;\n       width      : 40%;\n       text-align : right;\n       color      : #333333;\n   }\n   #address h3{\n       font-size     : 18px;\n       font-weight   : bold;\n       margin-bottom : 0;\n   }\n   #address p{\n       margin    : 0;\n       font-size : 12px;\n   }\n   .post-purchase{\n       overflow : hidden;\n       clear    : both;\n   }\n   .post-purchase h3.post-purchase-report-customer-order-id{\n       border-bottom : 1px dashed #CCCCCC;\n       color         : #222;\n       font-size     : 18px;\n       font-weight   : bold;\n       margin        : 0;\n       padding       : 0;\n   }\n   .post-purchase .createdOrderDate{\n       padding   : 0;\n       margin    : 0;\n       font-size : 12px;\n   }\n   .post-purchase .post-purchase-report-shipping,\n   .post-purchase .post-purchase-report-billing{\n       float    : left;\n       width    : 50%;\n       margin   : 0 0 20px;\n       overflow : hidden;\n   }\n   .post-purchase .post-purchase-report-shipping h4,\n   .post-purchase .post-purchase-report-billing h4{\n       margin-top    : 20px;\n       font-size     : 15px;;\n       margin-bottom : 5px;\n   }\n   /*===== Table checkout cart =====*/\n   table.cart-content{\n       overflow        : hidden;\n       border          : none;\n       margin-bottom   : 10px;\n       width           : 100%;\n       border-collapse : collapse;\n   }\n   table.cart-content td, table.cart-content th{\n       text-align : center;\n       padding    : 5px 10px;\n   }\n   table.cart-content th{\n       background    : #eee;\n       border-bottom : 2px solid #000;\n   }\n  table.cart-content td{\n       border-bottom : 1px solid #ddd;\n   }\n   table.cart-content th.product-info, table.cart-content td.product-info{\n       text-align : left;\n   }\n   img{\n       max-width      : 95px;\n       max-height     : 95px;\n       vertical-align : middle;\n   }\n   table.cart-content td span.post-purchase-report-product-name{\n       font-size   : 16px;\n       font-weight : bold;\n   }\n   table.cart-content td.product-info span{ display : block; }\n   /*summary  */\n   .post-purchase-report-summary{\n       float : right;\n       width : 25%;\n   }\n   .post-purchase-report-summary .summary-title{\n       border-bottom  : 1px solid #151515;\n       padding        : 5px 7px;\n       font-size      : 14px;\n      margin-bottom  : 5px;\n       background     : #eee;\n       font-weight    : bold;\n       text-transform : uppercase;\n   }\n   .post-purchase .post-purchase-report-summary span{\n       display : block;\n       width   : 100%;\n   }\n   .post-purchase .post-purchase-report-summary div{\n       margin    : 10px 0;\n       font-size : 12px;\n   }\n   .post-purchase .post-purchase-report-summary div.post-purchase-row{\n       padding : 2px 7px;\n   }\n   .post-purchase .post-purchase-report-summary div.cart-total{\n       padding-top : 5px;\n       font-weight : bold;\n       border      : none;\n   }\n   .footer{\n       border-top : 1px solid #000;\n       margin-top : 20px;\n       padding    : 10px 0;\n       text-align : center;\n       font-size  : 12px;\n   }\n  </style>\n\n</head>\n<body>\n<div>\n    <h1>\n        <img src="{$website:url}media/logo/original/corporatelogo-black.jpg" alt="{$plugin:widcard:BizOrgName:notag}" class="logo" width="218" height="137" border="0" />\n    </h1>\n    <div id="address">\n        <h3>{$plugin:widcard:BizOrgName:notag}</h3>\n        <!--<p>Sarl Azur Tex</p>-->\n        <p>{$plugin:widcard:BizAddress1:notag}</p>\n        <p>{$plugin:widcard:BizCity:notag}, {$plugin:widcard:BizState:notag} {$plugin:widcard:BizZip:notag}</p>\n        <p><strong>Email:</strong> {$plugin:widcard:BizEmail:notag}</p>\n    </div>\n\n    <!-- Content box -->\n    <main id="content">\n        <!--{ $store:postpurchasereport::mpn:Code}-->\n\n        {postpurchasecode}\n        <div class="post-purchase">\n            <h2>Invoice # {$postpurchase:id}</h2>\n            <h3 class="post-purchase-report-customer-order-id">Order number # {$postpurchase:id}</h3>\n            <p>{$postpurchase:Created}</p>\n            <p class="createdOrderDate">{$postpurchase:createdAt}</p>\n            <div class="post-purchase-report-billing">\n                <h4 class="title">Billing Address:</h4>\n\n                <div class="post-purchase-report-billing-address">\n                    <span>{$postpurchase:billing:firstname}</span>\n                    <span>{$postpurchase:billing:lastname}</span>\n                    <br>\n                    <span class="street-address">{$postpurchase:billing:address1} {$postpurchase:billing:address2}</span>\n                    <br>\n                    <span class="locality">{$postpurchase:billing:city},</span>\n                    <span class="region">{$postpurchase:billing:state},</span>\n                    <span class="postal-code">{$postpurchase:billing:zip}</span>\n                    <br>\n                    <span>{$postpurchase:billing:country}</span>\n                    <br>\n                    <span>Phone: {$postpurchase:billing:phone}</span>\n                    <br>\n                    <span>Email: {$postpurchase:billing:email}</span>\n                    <br>\n                    <br>\n                    <span>Shipping Method : {$postpurchase:shippingType}</span>\n                </div>\n            </div>\n\n            <div class="post-purchase-report-shipping">\n                <h4 class="title">Shipping Address			:</h4>\n\n                <div class="post-purchase-report-shipping-address">\n                    <span>{$postpurchase:shipping:firstname}</span>\n                    <span>{$postpurchase:shipping:lastname}</span>\n                    <br>\n                    <span class="street-address">{$postpurchase:shipping:address1} {$postpurchase:shipping:address2}</span>\n                    <br>\n                    <span class="locality">{$postpurchase:shipping:city},</span>\n                    <span class="region">{$postpurchase:shipping:state},</span>\n                    <span class="postal-code">{$postpurchase:shipping:zip}</span>\n                    <br>\n                    <span>{$postpurchase:shipping:country}</span>\n                    <br>\n                    <span>Phone: {$postpurchase:shipping:phone}</span>\n                    <br>\n                    <span>Mobile: {$postpurchase:shipping:mobile}</span>\n                    <br>\n                </div>\n            </div>\n            <div style="clear:both"></div>\n            <table border="0" cellpadding="0" cellspacing="0" width="100%" class="post-purchase-report cart-content">\n                <thead>\n                    <tr>\n                        <th colspan="2" align="left" class="product-info">Product</th>\n                        <th class="product-unit-price">Price</th>\n                        <th class="product-tax">Tax</th>\n                        <th class="product-qty">Qty</th>\n                        <th class="product-total">Total</th>\n                    </tr>\n                </thead>\n                <tbody>\n                {postpurchasecartcontent:email}\n                    <tr>\n                        <td class="product-img">\n                            {$postpurchase:cartitem:photo:product}\n                        </td>\n                        <td class="product-info">\n                            <span class="post-purchase-report-product-name">{$postpurchase:cartitem:name}</span>\n                            <br>\n                            <p style="color:#cd092f;">{$postpurchase:cartitem:options:email}</p>\n\n                        </td>\n                        <td class="product-unit-price">{$postpurchase:cartitem:price}</td>\n                        <td class="product-tax">{$postpurchase:cartitem:tax}</td>\n                        <td class="product-qty">{$postpurchase:cartitem:qty}</td>\n                        <td class="product-total">{$postpurchase:cartitem:total:withouttax}</td>\n                    </tr>\n                {/postpurchasecartcontent}\n                </tbody>\n            </table>\n\n            <div class="post-purchase-report-summary">\n                <h3 class="summary-title">Summary</h3>\n\n                <div class="post-purchase-row cart-subtotal" style="border-bottom: 1px solid #151515; padding: 5px 7px;">\n                    <span>Sub-Total:</span>\n                    <span id="subtotal-val">{$postpurchase:subTotal}</span>\n                </div>\n                <div class="post-purchase-row" style="border-bottom: 1px solid #151515; padding: 5px 7px;">\n                    <span>Discount:</span>\n                    <span id="discount-val">{$postpurchase:discount}</span>\n                </div>\n                <div class="post-purchase-row cart-shipping" style="border-bottom: 1px solid #151515; padding: 5px 7px;">\n                    <span>Shipping:</span>\n                    <span>{$postpurchase:shippingPrice}</span>\n                </div>\n                <div class="post-purchase-row cart-total-tax" style="border-bottom: 1px solid #151515; padding: 5px 7px;">\n                    <span>VAT:</span>\n                    <span>{$postpurchase:totalTax}</span>\n                </div>\n                <div class="post-purchase-row cart-total" style="border-bottom: 1px solid #151515; padding: 5px 7px;">\n                    <span>Total:</span>\n                    <span>{$postpurchase:total}</span>\n                </div>\n            </div>\n        </div>\n        {/postpurchasecode}\n    </main>\n\n</div>\n\n</body>\n</html>',	'typepos');

UPDATE `plugin` SET `tags`='pos,posmobile,ecommerce' WHERE `name` = 'seosambapos';
UPDATE `plugin` SET `version` = '2.2.1' WHERE `name` = 'seosambapos';