<?php

class Widgets_Seosambapos_Seosambapos extends Widgets_Abstract {

    protected $_cacheable      = false;


    protected function _load() {
        $this->_request = Zend_Controller_Front::getInstance()->getRequest();
        $this->_productMapper = Models_Mapper_ProductMapper::getInstance();

        $currentController = $this->_request->getParam('controller');
        if (!preg_match('~backend_~', $currentController)) {
            $layout = Zend_Layout::getMvcInstance();
            $layout->getView()->inlineScript()->appendFile($this->_websiteHelper->getUrl() . 'plugins/shopping/web/js/notifyme.min.js');
        }

        $methodName = Tools_Plugins_Abstract::OPTION_MAKER_PREFIX.ucfirst(strtolower($this->_options[0]));
        if (method_exists($this, $methodName)) {
            return $this->$methodName();
        }
    }

    protected function _init() {
        parent::_init();
        if (empty($this->_options)) {
            throw new Exceptions_SeotoasterWidgetException('No options provided');
        }
        $this->_view = new Zend_View();
        $this->_view->websiteUrl = Zend_Controller_Action_HelperBroker::getExistingHelper('website')->getUrl();
        $this->_view->setScriptPath(realpath(__DIR__.DIRECTORY_SEPARATOR.'views'));
        $this->_websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $this->_redirector = new Zend_Controller_Action_Helper_Redirector();
        $this->_sessionHelper = Zend_Controller_Action_HelperBroker::getExistingHelper('session');
    }

    /**
     * @return string|void
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Controller_Action_Exception
     * @throws Zend_Db_Table_Exception
     */
    protected function _makeOptionSeosambaposReport() {

        $sessionHelper = Zend_Controller_Action_HelperBroker::getExistingHelper('session');
        if (isset($sessionHelper->seosambaposCartSessionKey)){
            $cartId = intval($sessionHelper->seosambaposCartSessionKey);
            $cartSession = Models_Mapper_CartSessionMapper::getInstance()->find($cartId, true);
            if(isset($this->_options[1]) && $this->_options[1] == 'mailreport'){
                $this->_view->mailReport = 1;
            }else{
                unset($sessionHelper->seosambaposCartSessionKey);
            }
            if(isset($this->_options[2]) && $this->_options[2] != ''){
                $additionalTableRows = explode(',', $this->_options[2]);
                $this->_view->additionalTableRows = $additionalTableRows;
            }

            if(isset($this->_options[2]) && $this->_options[2] != '' && isset($this->_options[3]) && $this->_options[3] != ''){
                $renamedTableRows = explode(',', $this->_options[3]);
                $this->_view->renamedTableRows = $renamedTableRows;
            }

            if ($cartSession instanceof Models_Model_CartSession){
                $cartContent = $cartSession->getCartContent();
                $productMapper = Models_Mapper_ProductMapper::getInstance();
                $shoppingConfig = Models_Mapper_ShoppingConfig::getInstance()->getConfigParams();
                $this->_view->shoppingConfig = $shoppingConfig;

                if(!empty($shoppingConfig['quoteDraggableProducts'])) {
                    $quoteEnabled = Tools_Plugins_Tools::findPluginByName('quote');
                    if($quoteEnabled->getStatus() == Application_Model_Models_Plugin::ENABLED) {
                        $quote = Quote_Models_Mapper_QuoteMapper::getInstance()->findByCartId($cartId);

                        if ($quote instanceof Quote_Models_Model_Quote) {
                            $quoteId = $quote->getId();

                            $quoteDraggableMapper = Quote_Models_Mapper_QuoteDraggableMapper::getInstance();

                            $quoteDraggableModel = $quoteDraggableMapper->findByQuoteId($quoteId);

                            if($quoteDraggableModel instanceof Quote_Models_Model_QuoteDraggableModel) {
                                $dragOrder = $quoteDraggableModel->getData();

                                if(!empty($dragOrder)) {
                                    $dragOrder = explode(',', $dragOrder);

                                    $prepareContentSids = array();
                                    foreach ($cartContent as $key => $content) {
                                        $product = $productMapper->find($content['product_id']);
                                        $options = ($content['options']) ? $content['options'] : Quote_Tools_Tools::getProductDefaultOptions($product);
                                        $prodSid = Quote_Tools_Tools::generateStorageKey($product, $options);
                                        $prepareContentSids[$prodSid] = $content;
                                    }

                                    $sortedCartContent = array();
                                    foreach ($dragOrder as $productSid) {
                                        if(!empty($prepareContentSids[$productSid])) {
                                            $sortedCartContent[$productSid] = $prepareContentSids[$productSid];
                                        }
                                    }
                                    $preparedCartContent = array_merge($sortedCartContent, $prepareContentSids);

                                    $cartContent = array();

                                    foreach ($preparedCartContent as $cContent) {
                                        $cartContent[] = $cContent;
                                    }
                                }
                            }
                        }
                    }
                }

                foreach ($cartContent as $key => $product){
                    $productObject = $productMapper->find($product['product_id']);
                    if($productObject !== null){
                        $cartContent[$key]['mpn']        = $productObject->getMpn();
                        $cartContent[$key]['photo']      = $productObject->getPhoto();
                        $cartContent[$key]['productUrl'] = $productObject->getPage()->getUrl();
                        $cartContent[$key]['taxRate']    = Tools_Tax_Tax::calculateProductTax($productObject, null, true);
                        $cartContent[$key]['isEnabled']  = $productObject->getEnabled();
                    }
                }

                $defaultPickup = true;
                $pickupLocationConfigMapper = Store_Mapper_PickupLocationConfigMapper::getInstance();
                $pickupLocationData = $pickupLocationConfigMapper->getCartPickupLocationByCartId($cartId);
                if (!empty($pickupLocationData)) {
                    $defaultPickup = false;
                    $this->_view->pickupLocationData = $pickupLocationData;
                }
                $this->_view->defaultPickup = $defaultPickup;

                $this->_view->showPriceIncTax = $shoppingConfig['showPriceIncTax'];
                $this->_view->weightSign = $shoppingConfig['weightUnit'];
                $this->_view->cartContent = $cartContent;
                $this->_view->cart = $cartSession;
                return $this->_view->render('seosambapos-report.phtml');
            }
            return;
        }
        $errmsg = 'seosambapos:seosambaposreport missing cart id';
        return Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_CONTENT) ? '<b>'.$errmsg.'</b>' : '<!-- '.$errmsg.' -->' ;
    }

}
