<?php
class Tools_StripeTools
{

    /**
     * Get Stripe terminal token
     *
     * @return void
     */
    public static function getStripeTerminalToken()
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $secret = array('error' => '1', 'message' => $translator->translate('Stripe not configured.'));

        $stripepayOAuth = Tools_StripeOAuthTools::checkStripepayConfigOAuth();

        $stripeClientId = '';
        if(empty($stripepayOAuth)) {
            $stripeConfigMapper = Stripepay_Models_Mappers_StripepayConfigMapper::getInstance();
            $stripeSettings = $stripeConfigMapper->getConfigParams();

            $secret = array('error' => '1', 'message' => $translator->translate('Stripe not configured.'));
            if(!empty($stripeSettings)) {
                $secretKey = $stripeSettings['privateKey'];

                if(!empty($stripeSettings['useSandBox'])) {
                    $secretKey = $stripeSettings['privateKeyTest'];
                }

                if(!empty($secretKey)) {
                    //Client
                    $stripeClient = new \Stripe\StripeClient($secretKey);
                    //Terminal
                    $connectionToken = $stripeClient->terminal->connectionTokens->create([]);

                    if(!empty($connectionToken)) {
                        $secret = $connectionToken->secret;
                    }
                }
            }
        } else {
            $connectionTokenResponceError = true;

            $connectionTokenResponce = Tools_StripeOAuthTools::getStripeTerminalTokenMojo();

            if(!empty($connectionTokenResponce)) {
                $connectionTokenResponceData = json_decode($connectionTokenResponce, true);
                if(!empty($connectionTokenResponceData)) {
                    $connectionTokenResponceData = (object) $connectionTokenResponceData;

                    if(!empty($connectionTokenResponceData)) {
                        $secret = $connectionTokenResponceData->secret;
                        $connectionTokenResponceError = false;
                    }
                }
            }

            $stripepayConnectionStatus = Tools_StripeOAuthTools::connectionStatusMojo();

            if(!empty($stripepayConnectionStatus)) {
                if(!empty($stripepayConnectionStatus['stripe_client_id'])) {
                    $stripeClientId = $stripepayConnectionStatus['stripe_client_id'];
                }
            }

            if($connectionTokenResponceError) {
                return array('error' => '1', 'message' => $translator->translate('You can not continue working with API. Can not get terminal connection token!'));
            }

            if(empty($stripeClientId)) {
                return array('error' => '1', 'message' => $translator->translate('You can not continue working with API. Can not get stripe_account_id!'));
            }
        }

        return array(
            'secret' => $secret,
            'stripe_account_id' => $stripeClientId,
        );
    }

    public static function createStripeTerminalLocation($data) {
        $translator = Zend_Registry::get('Zend_Translate');
        $terminalLocationData = array();

        $state = '';
        if(!empty($data['state'])) {
            $state = $data['state'];
        }

        //Terminal
        $location = array();
        $location['display_name'] = $data['name'];
        $location['address'] = array(
            'line1' => $data['address1'],
            //'line2' => $data['address2'],
            'city' => $data['city'],
            'postal_code' => $data['zip'],
            'country' => $data['countryAbbr'],
        );

        if(!empty($state)) {
            $location['address']['state'] = $state;
        }

        try{
            $stripepayOAuth = Tools_StripeOAuthTools::checkStripepayConfigOAuth();

            if(empty($stripepayOAuth)) {
                $stripeConfigMapper = Stripepay_Models_Mappers_StripepayConfigMapper::getInstance();
                $stripeSettings = $stripeConfigMapper->getConfigParams();

                if(!empty($stripeSettings)) {
                    $secretKey = $stripeSettings['privateKey'];

                    if(!empty($stripeSettings['useSandBox'])) {
                        $secretKey = $stripeSettings['privateKeyTest'];
                    }

                    if(!empty($secretKey)) {
                        //Client
                        $stripeClient = new \Stripe\StripeClient($secretKey);

                        try{
                            $terminalLocationData = $stripeClient->terminal->locations->create($location);
                            if(!empty($terminalLocationData)) {
                                $terminalLocationData = array('id' => $terminalLocationData->id, 'error' => '0', 'message' => $translator->translate('Success'));
                            }
                        }catch (Exception $e) {
                            $terminalLocationData = array('id' => '', 'error' => '1', 'message' => $e->getMessage());
                        }
                    }
                }
            } else {
                $responceTerminalLocation = Tools_StripeOAuthTools::createStripeTerminalLocationMojo($location);

                $terminalLocationData = array('id' => '', 'error' => '1', 'message' => 'can not create terminal location');

                if(!empty($responceTerminalLocation)) {
                    $responceTerminalLocationData = json_decode($responceTerminalLocation, true);
                    if(!empty($responceTerminalLocationData)) {
                        $responceTerminalLocationData = (object) $responceTerminalLocationData;

                        if(!empty($responceTerminalLocationData)) {
                            $terminalLocationData = array('id' => $responceTerminalLocationData->id, 'error' => '0', 'message' => $translator->translate('Success'));
                        }
                    }
                }
            }
        }catch (Exception $e) {
            $terminalLocationData = array('id' => '', 'error' => '1', 'message' => $e->getMessage());
        }

        return $terminalLocationData;
    }

    public static function updateStripeTerminalLocation($terminalId, $data) {
        $translator = Zend_Registry::get('Zend_Translate');

        $terminalLocationData = array();
        if(!empty($terminalId)) {
            $state = '';
            if(!empty($data['state'])) {
                $state = $data['state'];
            }

            //Terminal
            $location = array();
            $location['display_name'] = $data['name'];
            $location['address'] = array(
                'line1' => $data['address1'],
                //'line2' => $data['address2'],
                'city' => $data['city'],
                'postal_code' => $data['zip'],
                'country' => $data['countryAbbr'],
            );

            if(!empty($state)) {
                $location['address']['state'] = $state;
            }

            $stripepayOAuth = Tools_StripeOAuthTools::checkStripepayConfigOAuth();

            if(empty($stripepayOAuth)) {
                $stripeConfigMapper = Stripepay_Models_Mappers_StripepayConfigMapper::getInstance();
                $stripeSettings = $stripeConfigMapper->getConfigParams();

                if(!empty($stripeSettings)) {
                    $secretKey = $stripeSettings['privateKey'];

                    if(!empty($stripeSettings['useSandBox'])) {
                        $secretKey = $stripeSettings['privateKeyTest'];
                    }

                    if(!empty($secretKey)) {
                        //Client
                        $stripeClient = new \Stripe\StripeClient($secretKey);

                        try{
                            $savedTerminalLocation = $stripeClient->terminal->locations->retrieve($terminalId, []);
                            if(!empty($savedTerminalLocation)) {
                                $terminalLocationData = array('id' => $savedTerminalLocation->id, 'error' => '0', 'message' => $translator->translate('Success'));
                            }
                        }catch (Exception $e) {
                            $terminalLocationData = array('id' => '', 'error' => '1', 'message' => $e->getMessage());
                        }

                        if(empty($terminalLocationData['error'])) {
                            try{
                                $terminalLocationData = $stripeClient->terminal->locations->update($terminalLocationData['id'], $location);

                                if(!empty($terminalLocationData)) {
                                    $terminalLocationData = array('id' => $terminalLocationData->id, 'error' => '0', 'message' => $translator->translate('Success'));
                                }
                            }catch (Exception $e) {
                                $terminalLocationData = array('id' => '', 'error' => '1', 'message' => $e->getMessage());
                            }
                        }
                    }
                }
            } else {
                $requestData = array(
                    'terminalId' => $terminalId,
                    'location' => $location,
                );

                //retreive location
                $terminalLocationMojoDataId = '';
                $terminalLocationMojo = Tools_StripeOAuthTools::getStripeTerminalLocationMojo(array('location_id' => $terminalId));

                if(!empty($terminalLocationMojo)) {
                    $terminalLocationMojoData = json_decode($terminalLocationMojo, true);
                    if(!empty($terminalLocationMojoData)) {
                        $terminalLocationMojoData = (object) $terminalLocationMojoData;

                        if(!empty($terminalLocationMojoData)) {
                            $terminalLocationMojoDataId = $terminalLocationMojoData->id;
                        }
                    }
                }

                if(!empty($terminalLocationMojoDataId) && $terminalId == $terminalLocationMojoDataId) {
                    $responceTerminalLocation = Tools_StripeOAuthTools::updateStripeTerminalLocationMojo($requestData);
                } else {
                    $seosambaposTerminalLocationsMapper = Seosambapos_Models_Mappers_SeosambaposTerminalLocationsMapper::getInstance();
                    $seosambaposTerminalLocationsMapper->deleteByTerminalId($terminalId);

                    $responceTerminalLocation = Tools_StripeOAuthTools::createStripeTerminalLocationMojo($location);
                }

                $terminalLocationData = array('id' => '', 'error' => '1', 'message' => 'can not update terminal location');

                if(!empty($responceTerminalLocation)) {
                    $responceTerminalLocationData = json_decode($responceTerminalLocation, true);
                    if(!empty($responceTerminalLocationData)) {
                        $responceTerminalLocationData = (object) $responceTerminalLocationData;

                        if(!empty($responceTerminalLocationData)) {
                            $terminalLocationData = array('id' => $responceTerminalLocationData->id, 'error' => '0', 'message' => $translator->translate('Success'));
                        }
                    }
                }
            }
        }

        return $terminalLocationData;
    }

}