<?php

class Tools_ShippingTools
{


    /**
     * Return shipping rates data
     *
     * @param $data
     * @return array
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     */
    public static function getShippingPriceValues($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['cartId'])) {
            return array('error' => '1', 'message' => $translator->translate('cartId is empty.'));
        }

        if(empty($data['serviceName'])) {
            return array('error' => '1', 'message' => $translator->translate('service is empty.'));
        }

        $shippingConfigMapper = Models_Mapper_ShippingConfigMapper::getInstance();
        $seosambaposActiveSessionMapper = Seosambapos_Models_Mappers_SeosambaposActiveSessionMapper::getInstance();
        $pickupLocationMapper = Store_Mapper_PickupLocationMapper::getInstance();
        $productMapper = Models_Mapper_ProductMapper::getInstance();

        $pluginExistsAndEnabled = false;
        $pluginMapper = Application_Model_Mappers_PluginMapper::getInstance()->findByName($data['serviceName']);
        if ($pluginMapper instanceof Application_Model_Models_Plugin) {
            $pluginStatus = $pluginMapper->getStatus();
            if ($pluginStatus === 'enabled') {
                $pluginExistsAndEnabled = true;
            }
        }

        if($pluginExistsAndEnabled) {
            $shipPlugin = $shippingConfigMapper->find($data['serviceName']);

            if(empty($shipPlugin)) {
                return array('error' => '1', 'message' => $translator->translate('Plugin does not configured.'));
            }

            if(!empty($shipPlugin['enabled'])) {
                $seosambaposActiveSession = $seosambaposActiveSessionMapper->findSession($data['posUserId']);

                $locationData = array();
                if(!empty($seosambaposActiveSession)) {
                    $locationId = $seosambaposActiveSession['location_id'];

                    if(!empty($locationId)) {
                        $storeInfo = Tools_SeosambaPosTools::getStoreInfo();

                        if(!empty($storeInfo)) {
                            $locationData['currency'] = $storeInfo['currency'];
                            $locationData['weightUnit'] = $storeInfo['weightUnit'];
                            $locationData['lengthUnit'] = $storeInfo['lengthUnit'];
                        }

                        $existedLocation = $pickupLocationMapper->find($locationId);

                        if($existedLocation instanceof Store_Model_PickupLocation) {
                            $locationData['address1'] = $existedLocation->getAddress1();
                            $locationData['address2'] = $existedLocation->getAddress2();

                            $countryListNames = Tools_Geo::countryListNames();
                            $country = array_search($existedLocation->getCountry(), $countryListNames);

                            $locationData['country'] = $country;
                            $locationData['city'] = $existedLocation->getCity();
                            $locationData['state'] = $existedLocation->getState();
                            $locationData['zip'] = $existedLocation->getZip();
                        }
                    }
                }

                if(!empty($locationData)) {
                    $cartStorage = Tools_ShoppingCart::getInstance();
                    $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();

                    $isAlreadyPaid = Tools_CartTools::verifyIfAlreadyPaid($data['cartId']);
                    if ($isAlreadyPaid === true) {
                        $cartStorage->clean();
                        //@ todo clear cart into reserved cart table
                        $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
                        $seosambaposReservedCartsMapper->removeReservedCartByCartId($data['cartId']);
                        return array('error' => '1', 'message' => $translator->translate('This cart is already paid.'));
                    }

                    $cartStorage->restoreCartSession($data['cartId']);

                    $cart = $cartSessionMapper->find($data['cartId']);
                    if($cart instanceof Models_Model_CartSession) {
                        $cartStorage->setShippingAddressKey($cart->getShippingAddressId());
                        $cartStorage->setBillingAddressKey($cart->getBillingAddressId());
                        $cartContent = $cart->getCartContent();

                        $preparedCartContent = array();
                        foreach ($cartContent as $key => $productContent) {
                            $product = $productMapper->findByProductId($productContent['product_id']);

                            if(!empty($product)) {
                                $productContent['weight'] = $product['weight'];
                                $productContent['prodLength'] = $product['prod_length'];
                                $productContent['prodDepth'] = $product['prod_depth'];
                                $productContent['prodWidth'] = $product['prod_width'];
                            }

                            $preparedCartContent[$key] = $productContent;
                        }

                        $cartStorage->setContent($preparedCartContent);
                        $cartStorage->calculate(false);
                    }

                    try {
                        $serviceLabelMapper = Models_Mapper_ShoppingShippingServiceLabelMapper::getInstance();
                        $shippingPlugin = Tools_Factory_PluginFactory::createPlugin($data['serviceName']);

                        $shippingPlugin->_shoppingConfig = $locationData;

                        $result = $shippingPlugin->calculateAction(true);

                        $errorMsg = array('error' => '1', 'message' => $translator->translate('Can not get shipping price for '. $data['serviceName']));
                        if(!empty($result)) {
                            if(isset($result['error']) || !empty($result['message'])) {
                                if(!empty($result['message'])) {
                                    $errorMsg = array('error' => '0', 'message' => str_replace('<br>', '\n', $result['message']));
                                } elseif (!empty($result['error']) && empty($result['message'])) {
                                    $errorMsg = array('error' => '0', 'message' => str_replace('<br>', '\n', $result['error']));
                                }

                                return $errorMsg;
                            }

                            $shippingService = $data['serviceName'];
                            $class = get_class($shippingPlugin);

                            $deliveryService = '';
                            if (defined($class.'::SHIPPING_SERVICE_NAME')) {
                                $deliveryService = $serviceLabelMapper->findByName($shippingPlugin::SHIPPING_SERVICE_NAME);
                            }

                            if(empty($deliveryService) && defined($class.'::ADDITIONAL_DESC')) {
                                $deliveryService = $shippingPlugin::ADDITIONAL_DESC;
                            }

                            if($data['serviceName'] == 'flatrateshipping' || $data['serviceName'] == 'flatrateship') {
                                $currencySign = '';
                                if(!empty($storeInfo['currencySign'])) {
                                    $currencySign = $storeInfo['currencySign'];
                                }

                                $descr = '';
                                if(!empty($result['descr'])) {
                                    $descr = $result['descr'];
                                }

                                $tmpResult[] = array(
                                    'type' => !empty($deliveryService) ? $deliveryService.' - '.strip_tags($result['type']): strip_tags($result['type']),
                                    'price' => $currencySign.$result['price'],
                                    'descr' => strip_tags($descr),
                                    'serviceName' => $shippingService,
                                    'priceToCart' => preg_replace('/[^0-9.]/', '', $result['price']),
                                    'typeToCart' => !empty($deliveryService) ? str_replace($deliveryService . ' - ', '', strip_tags($result['type'])) : strip_tags($result['type']),
                                );

                                $result = $tmpResult;
                            } else {
                                foreach ($result as $key => $rate) {
                                    $descr = '';
                                    if(!empty($rate['descr'])) {
                                        $descr = $rate['descr'];
                                    }

                                    $result[$key]['type'] = strip_tags($rate['type']);
                                    $result[$key]['descr'] = strip_tags($descr);
                                    $result[$key]['serviceName'] = $shippingService;
                                    $result[$key]['priceToCart'] = preg_replace('/[^0-9.]/', '', $rate['price']);

                                    $result[$key]['typeToCart'] = strip_tags($rate['type']);
                                    if(!empty($deliveryService)) {
                                        $result[$key]['typeToCart'] = str_replace($deliveryService . ' - ', '', strip_tags($rate['type']));
                                    }
                                }
                            }

                            return $result;
                        }

                        return $errorMsg;

                    } catch (Exception $e) {
                        return array('error' => '1', 'message' => strtoupper($data['serviceName']) . ' Error: ' . $e->getMessage());
                    }
                }
            }

            return array('error' => '1', 'message' => $translator->translate('Plugin disabled in shipping config.'));
        } else {
            return array('error' => '1', 'message' => $translator->translate('Plugin does not exist or disabled.'));
        }
    }

    /**
     * Get enabled shipping services list
     *
     * @return array
     */
    public static function getShippingServices()
    {
        $shippingServicesData = array();

        $shippingServices = Models_Mapper_ShippingConfigMapper::getInstance()->fetchByStatus(Models_Mapper_ShippingConfigMapper::STATUS_ENABLED);
        if (!empty($shippingServices)) {
            $shippingServices = array_map(function ($shipper) {
                return !in_array($shipper['name'], array(Shopping::SHIPPING_TRACKING_URL, Shopping::SHIPPING_MARKUP, Shopping::SHIPPING_PICKUP, Shopping::SHIPPING_FREESHIPPING, Shopping::ORDER_CONFIG, Shopping::SHIPPING_RESTRICTION_ZONES)) ? array(
                    'name'  => $shipper['name'],
                    'title' => isset($shipper['config']) && isset($shipper['config']['title']) ? $shipper['config']['title'] : '',
                    'restrictedType' => isset($shipper['config']) && isset($shipper['config']['restrictedType']) ? $shipper['config']['restrictedType'] : '',
                    'restrictZones' => isset($shipper['config']) && isset($shipper['config']['restrictZones']) ? $shipper['config']['restrictZones'] : '',
                ) : null;
            }, $shippingServices);

            $shippingServicesData = array_values(array_filter($shippingServices));
        }

        return $shippingServicesData;
    }

    /**
     * Preepare address locality
     *
     * @param $shippingAddress
     * @return string
     */
    public static function prepareLocality($shippingAddress)
    {
        $city = '';
        $state = '';
        $zip = '';
        $country = '';

        if(!empty($shippingAddress['city'])) {
            $city = $shippingAddress['city'] .', ';
        }

        if(!empty($shippingAddress['state'])) {
            $stateData = Tools_Geo::getStateByParam($shippingAddress['state']);

            if(!empty($stateData)) {
                $state = $stateData .', ';
            }
        }

        if(!empty($shippingAddress['zip'])) {
            $zip = $shippingAddress['zip'] .', ';
        }

        if(!empty($shippingAddress['country'])) {
            $country = $shippingAddress['country'];
        }

        $locality = $city . $state . $zip . $country;
        return rtrim($locality, ", ");
    }

}

