<?php

class Tools_SeosambaposPurchaseWatchdog implements Interfaces_Observer
{

    /**
     * Logs only orders with status completed!
     *
     * @param $cartSessionModel
     * @return string
     */
    public function notify($cartSessionModel)
    {
        if ($cartSessionModel instanceof Models_Model_CartSession) {
            $userMapper = Application_Model_Mappers_UserMapper::getInstance();
            $cartId = $cartSessionModel->getId();
            $cartStatus = $cartSessionModel->getStatus();
            $gateway = $cartSessionModel->getGateway();
            $currentLoggedUserId = $cartSessionModel->getUserId();
            $userModel = $userMapper->find($currentLoggedUserId);
            $purchasedOn = $cartSessionModel->getPurchasedOn();
            $locationId = $cartSessionModel->getLocationId();

            if ($userModel instanceof Application_Model_Models_User && $cartStatus === Models_Model_CartSession::CART_STATUS_COMPLETED && !empty($locationId)) {
                $type = Seosambapos_Models_Models_SeosambaposPurchasesDataModel::PURCHASE_TYPE_APP;

                $seosambaposPurchasesDataMapper = Seosambapos_Models_Mappers_SeosambaposPurchasesDataMapper::getInstance();

                $ifPurchaseDone = $seosambaposPurchasesDataMapper->findByCartId($cartId);

                $purchaseDataId = '';
                $allowReduceLocationInventory = false;
                if(empty($ifPurchaseDone)) {
                    $allowReduceLocationInventory = true;
                } elseif ($ifPurchaseDone['status'] == Seosambapos_Models_Models_SeosambaposPurchasesDataModel::PURCHASE_STATUS_WAITING) {
                    $purchaseDataId = $ifPurchaseDone['id'];
                    $allowReduceLocationInventory = true;
                }

                if(!$allowReduceLocationInventory) {
                    return false;
                }

                $cartContent = $cartSessionModel->getCartContent();

                if(!empty($cartContent)) {
                    $this->_reduceAppLocationInventory($cartContent, $cartId);

                    $lId = null;
                    if(!empty($locationId)) {
                        $lId = $locationId;
                    }

                    if(!empty($purchaseDataId)) {
                        $seosambaposPurchasesDataModel = $seosambaposPurchasesDataMapper->find($purchaseDataId);

                        if($seosambaposPurchasesDataModel instanceof Seosambapos_Models_Models_SeosambaposPurchasesDataModel) {
                            $seosambaposPurchasesDataModel->setStatus(Seosambapos_Models_Models_SeosambaposPurchasesDataModel::PURCHASE_STATUS_COMPLETED);
                            $seosambaposPurchasesDataModel->setType($type);
                            $seosambaposPurchasesDataModel->setGateway($gateway);
                            $seosambaposPurchasesDataModel->setReceipt('');

                            $seosambaposPurchasesDataMapper->save($seosambaposPurchasesDataModel);
                        }
                    } else {
                        $seosambaposPurchasesDataModel = new Seosambapos_Models_Models_SeosambaposPurchasesDataModel();
                        $seosambaposPurchasesDataModel->setCartId($cartId);

                        $seosambaposPurchasesDataModel->setLocationId($lId);
                        $seosambaposPurchasesDataModel->setStatus(Seosambapos_Models_Models_SeosambaposPurchasesDataModel::PURCHASE_STATUS_COMPLETED);
                        $seosambaposPurchasesDataModel->setType($type);
                        $seosambaposPurchasesDataModel->setGateway($gateway);
                        $seosambaposPurchasesDataModel->setReceipt('');

                        $seosambaposPurchasesDataMapper->save($seosambaposPurchasesDataModel);
                    }

                    // log reduce product location inventory action
                    $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
                    $data['purchasedOn'] = $purchasedOn;
                    $data['cartContent'] = $cartContent;
                    $additionalContent = json_encode($data);

                    $seosambaposReduceProductLocationsInventoryLogMapper = Seosambapos_Models_Mappers_SeosambaposReduceProductLocationsInventoryLogMapper::getInstance();
                    $seosambaposReduceProductLocationsInventoryLogModel = new Seosambapos_Models_Models_SeosambaposReduceProductLocationsInventoryLogModel();

                    $seosambaposReduceProductLocationsInventoryLogModel->setType($type);
                    $seosambaposReduceProductLocationsInventoryLogModel->setCartId($cartId);
                    $seosambaposReduceProductLocationsInventoryLogModel->setLocationId($lId);
                    $seosambaposReduceProductLocationsInventoryLogModel->setCreatedAt($createdAt);
                    $seosambaposReduceProductLocationsInventoryLogModel->setAdditionalContent($additionalContent);

                    $seosambaposReduceProductLocationsInventoryLogMapper->save($seosambaposReduceProductLocationsInventoryLogModel);

                    //@ todo clear cart into reserved cart table
                    $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
                    $seosambaposReservedCartsMapper->removeReservedCartByCartId($cartId);
                }

                if (!Zend_Registry::isRegistered('extConfig')) {
                    $configTable   = new Application_Model_DbTable_Config();
                    Zend_Registry::set('extConfig', $configTable->selectConfig());
                }

                Tools_PaymentGateway::productLocationInventoryNotification($cartId);
            }
        }
    }

    /**
     * Reducing location products inventory via APP purchase
     *
     * @param $cartContent
     * @param $locationId
     * @return void
     * @throws Exceptions_SeotoasterException
     */
    private function _reduceAppLocationInventory($cartContent, $cartId)
    {
        $cartLocationInventoryMapper = Models_Mapper_CartLocationInventoryMapper::getInstance();
        $productLocationsMapper = Models_Mapper_ProductLocationsMapper::getInstance();

        foreach ($cartContent as $cKey => $cContent) {
            $productId = $cContent['product_id'];

            $cartLocationInventories = $cartLocationInventoryMapper->findByCartProductId($cartId, $productId);

            if(!empty($cartLocationInventories)) {
                foreach ($cartLocationInventories as $cartLocationInventory) {
                    $locationId = $cartLocationInventory['location_id'];
                    $productLocation = $productLocationsMapper->findLocationByProductIdAndLocationId($productId, $locationId);

                    if(!empty($productLocation)) {
                        $currentLocation = $productLocationsMapper->find($productLocation['id']);

                        if($currentLocation instanceof Models_Model_ProductLocationsModel) {
                            $inventory = $currentLocation->getInventory() - $cartLocationInventory['location_inventory'];

                            if($inventory < 0) {
                                $inventory = 0;
                            }

                            $currentLocation->setInventory($inventory);

                            $productLocationsMapper->save($currentLocation);
                        }
                    }
                }
            }
        }

    }
}

