<?php

class Tools_SeosambaposMailWatchdog implements Interfaces_Observer
{

    const TRIGGER_SEOSAMBAPOS_EMAILRECEIPT = 'seosambapos_emailreceipt';

    const TRIGGER_SEOSAMBAPOS_SENDREVIEWLINK = 'seosambapos_sendreviewlink';

    private $_options       = array();

    private $_configHelper  = null;

    private $_mailer        = null;

    private $_entityParser  = null;

    private $_websiteHelper = null;

    /**
     * @var instance of watched object
     */
    private $_object;

    /**
     * Template html
     *
     * @var string
     */
    private $_template;

    public function __construct($options = array()) {
        $this->_configHelper = Zend_Controller_Action_HelperBroker::getExistingHelper('config');
        if(empty($this->_configHelper->getConfig())) {
            $this->_configHelper = Application_Model_Mappers_ConfigMapper::getInstance();
        }
        $this->_websiteHelper = Zend_Controller_Action_HelperBroker::getExistingHelper('website');
        $this->_options = $options;
        $this->_initMailer();
        $this->_entityParser = new Tools_Content_EntityParser();
    }

    public function notify($object) {
        if (!$object){
            return false;
        }

        $this->_object = $object;

        if (isset($this->_options['template']) && !empty($this->_options['template'])) {
            $this->_template = $this->_preparseEmailTemplate();
        } else {
            return false;
        }

        if (isset($this->_options['trigger'])){
            $methodName = str_replace('seosambapos_', '', $this->_options['trigger']);
            $methodName = '_send' . ucfirst(strtolower(preg_replace('/\s*/', '', $methodName))) . 'Mail';
            if (method_exists($this, $methodName)) {
                $this->$methodName();
            }
        }
    }

    /**
     * @return bool
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Exception
     *
     * Sender method for the 'seosambapos_emailreceipt' trigger
     *
     */
    private function _sendEmailreceiptMail(){
        $customer = Models_Mapper_CustomerMapper::getInstance()->find($this->_object->getUserId());
        $userMapper = Application_Model_Mappers_UserMapper::getInstance();
        $systemConfig = $this->_configHelper->getConfig();
        $adminEmail = isset($systemConfig['adminEmail'])?$systemConfig['adminEmail']:'admin@localhost';
        $this->_mailer->setSubject($this->_parseLexemsAndContent($this->_options['subject']));
        switch ($this->_options['recipient']) {
            case Tools_Security_Acl::ROLE_SUPERADMIN:
            case Tools_Security_Acl::ROLE_ADMIN:
            case Tools_StoreMailWatchdog::RECIPIENT_CUSTOMER:
            $this->_mailer->setMailTo($this->_options['email']);
                break;
            default:
                error_log('Unsupported recipient '.$this->_options['recipient'].' given');
                return false;
                break;
        }

        //$this->_entityParser->objectToDictionary($customer);

        $wicEmail = $this->_configHelper->getConfig('wicEmail');
        $this->_entityParser->addToDictionary(array('widcard:BizEmail' => !empty($wicEmail) ? $wicEmail : $this->_configHelper->getConfig('adminEmail')));
        $this->_mailer->setMailFrom($this->_parseLexemsAndContent($this->_options['from']));

        $reviewLinks = '';
        if(!empty($this->_options['links']) && is_array($this->_options['links'])) {
            $links = $this->_options['links'];
            foreach ($links as $link) {
                $reviewLinks .= ' ' . '<a href="' . $link . '" target="_blank" title="' . $link . '">' . $link . '</a></br>';
            }

            $reviewLinks = trim($reviewLinks, " \r\n");
        }

        $userFullName = $customer->getFullName();

        $this->_entityParser->addToDictionary(array(
                'seosambapos:reviewlink' => $reviewLinks,
                'customer:fullname' => !empty($userFullName) ? $userFullName : '',
            ));

        if(!empty($this->_options['orderData'])) {
//            $this->_entityParser->addToDictionary(array(
//                'seosambapos:barcode' => $this->_options['orderData']['barcode'],
//            ));
        }

       return $this->_send();
    }

    /**
     * @return bool
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Exception
     *
     * Sender method for the 'seosambapos_sendreviewlink' trigger
     *
     */
    private function _sendSendreviewlinkMail(){
        $userEmail = $this->_options['recipient'];
        if(!empty($userEmail)) {
            $customer = Models_Mapper_CustomerMapper::getInstance()->findByEmail($userEmail);
        } else {
            $customer = Models_Mapper_CustomerMapper::getInstance()->find($this->_object->getUserId());
        }

        $userMapper = Application_Model_Mappers_UserMapper::getInstance();
        $systemConfig = $this->_configHelper->getConfig();
        $adminEmail = isset($systemConfig['adminEmail'])?$systemConfig['adminEmail']:'admin@localhost';
        $this->_mailer->setSubject($this->_parseLexemsAndContent($this->_options['subject']));

        switch ($this->_options['recipientRole']) {
            case Tools_Security_Acl::ROLE_SUPERADMIN:
                $su = $userMapper->getDbTable()->fetchAll(array('role_id = ?'=>Tools_Security_Acl::ROLE_SUPERADMIN));
                if ($su->count()){
                    foreach($su as $user){
                        $this->_mailer->setMailTo($user['email']);
                    }
                } else {
                    return false;
                }
                break;
            case Tools_Security_Acl::ROLE_ADMIN:
                $this->_mailer->setMailToLabel('Admin')
                    ->setMailTo($adminEmail);
                $where = $userMapper->getDbTable()->getAdapter()->quoteInto("role_id = ?", Tools_Security_Acl::ROLE_ADMIN);
                $adminUsers = $userMapper->fetchAll($where);
                if(!empty($adminUsers)){
                    $adminBccArray = array();
                    foreach($adminUsers as $admin){
                        array_push($adminBccArray, $admin->getEmail());
                    }
                    if(!empty($adminBccArray)){
                        $this->_mailer->setMailBcc($adminBccArray);
                    }
                }
                break;
            case Tools_StoreMailWatchdog::RECIPIENT_CUSTOMER:
                if ($customer && $customer->getEmail()){
                    $this->_mailer->setMailToLabel($customer->getFullName())
                        ->setMailTo($customer->getEmail());
                } else {
                    $this->_mailer->setMailToLabel('customer')->setMailTo($userEmail);
                }
                break;
            default:
                error_log('Unsupported recipient '.$this->_options['recipient'].' given');
                return false;
                break;
        }

        if($customer) {
            $this->_entityParser->objectToDictionary($customer);
        }

        $wicEmail = $this->_configHelper->getConfig('wicEmail');
        $this->_entityParser->addToDictionary(array('widcard:BizEmail' => !empty($wicEmail) ? $wicEmail : $this->_configHelper->getConfig('adminEmail')));
        $this->_mailer->setMailFrom($this->_parseLexemsAndContent($this->_options['from']));

        return $this->_send();
    }

    private function _initMailer(){
        $config = $this->_configHelper->getConfig();
        $this->_mailer = new Tools_Mail_Mailer();

        if ((bool)$config['useSmtp']){
            $smtpConfig = array(
                'host'      => $config['smtpHost'],
                'username'  => $config['smtpLogin'],
                'password'  => $config['smtpPassword']
            );
            if ((bool)$config['smtpSsl']){
                $smtpConfig['ssl'] = $config['smtpSsl'];
            }
            if (!empty($config['smtpPort'])){
                $smtpConfig['port'] = $config['smtpPort'];
            }
            $this->_mailer->setSmtpConfig($smtpConfig);
            $this->_mailer->setTransport(Tools_Mail_Mailer::MAIL_TYPE_SMTP);
        } else {
            $this->_mailer->setTransport(Tools_Mail_Mailer::MAIL_TYPE_MAIL);
        }
    }

    /**
     * Send email
     *
     * @return bool
     * @throws Exceptions_SeotoasterException
     */
    protected function _send()
    {
        if (!$this->_mailer->getMailFrom() || !$this->_mailer->getMailTo()) {
            throw new Exceptions_SeotoasterException('Missing required "from" and "to" fields');
        }
        $this->_mailer->setBody($this->_entityParser->parse($this->_template));

        return ($this->_mailer->send() !== false);
    }

    /**
     * Parse lexems and content
     *
     * @param string $content any content
     * @param object $observableModel
     * @return null|string
     * @throws Zend_Exception
     */
    private function _parseLexemsAndContent($content, $observableModel = null)
    {
        $content = $this->_entityParser->parse($content);
        $themeData = Zend_Registry::get('theme');
        $extConfig = Zend_Registry::get('extConfig');
        $parserOptions = array(
            'websiteUrl' => $this->_websiteHelper->getUrl(),
            'websitePath' => $this->_websiteHelper->getPath(),
            'currentTheme' => $extConfig['currentTheme'],
            'themePath' => $themeData['path'],
            'observableModel' => $this->_object
        );

        if (!empty($observableModel)) {
            $parserOptions['observableModel'] = $observableModel;
        }

        $parser = new Tools_Content_Parser($content, array(), $parserOptions);

        $content = $parser->parse();

        return $content;
    }

    /**
     * Parse email template data
     *
     * @return bool|null
     * @throws Zend_Exception
     */
    private function _preparseEmailTemplate()
    {
        $tmplName = $this->_options['template'];
        $tmplMessage = $this->_options['message'];
        $mailTemplate = Application_Model_Mappers_TemplateMapper::getInstance()->find($tmplName);

        if (!empty($mailTemplate)) {
            if (!empty($this->_options['defaultMessageTemplate'])) {
                $emailContent = $mailTemplate->getContent();
                $emailContent = preg_replace('~{defaultemailcontent}(.*){\/defaultemailcontent}~uiUs', addcslashes($this->_options['message'], '$'), $emailContent);
                $mailTemplate->setContent($emailContent);
            }
            $this->_entityParser->setDictionary(
                array(
                    'emailmessage' => !empty($tmplMessage) ? $tmplMessage : ''
                )
            );
            //pushing message template to email template and cleaning dictionary
            $mailTemplate = $this->_entityParser->parse($mailTemplate->getContent());
            $this->_entityParser->setDictionary(array());

            $mailTemplate = $this->_entityParser->parse($mailTemplate);

            $themeData = Zend_Registry::get('theme');
            $extConfig = Zend_Registry::get('extConfig');
            $parserOptions = array(
                'websiteUrl' => $this->_websiteHelper->getUrl(),
                'websitePath' => $this->_websiteHelper->getPath(),
                'currentTheme' => $extConfig['currentTheme'],
                'themePath' => $themeData['path'],
                'observableModel' => $this->_object
            );

            $pageMapper = Application_Model_Mappers_PageMapper::getInstance();
            $where = $pageMapper->getDbTable()->getAdapter()->quoteInto('template_id = ?', $tmplName);
            $templatePageSystem = $pageMapper->fetchAll($where, array(), 1);
            $templatePageNotSystem = $pageMapper->fetchAll($where, array());
            if (!empty($templatePageSystem) || !empty($templatePageNotSystem)) {
                if (!empty($templatePageSystem)) {
                    $templatePageModel = array_pop($templatePageSystem);
                } else {
                    $templatePageModel = array_pop($templatePageNotSystem);
                }

                $templatePageUrl = $templatePageModel->getUrl();
                $templatePageModelWithContainers = $pageMapper->findByUrl($templatePageUrl);
                if ($templatePageModelWithContainers instanceof Application_Model_Models_Page) {
                    $parser = new Tools_Content_Parser($mailTemplate, $templatePageModelWithContainers->toArray(),
                        $parserOptions);
                } else {
                    $parser = new Tools_Content_Parser($mailTemplate, array(), $parserOptions);
                }

            } else {
                $parser = new Tools_Content_Parser($mailTemplate, array(), $parserOptions);
            }

            $emailTemplateMessage = $parser->parseSimple();

            if (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_CONTENT)) {
                return Tools_SeosambaPosTools::stripEditLinks($emailTemplateMessage);
            }

            return $emailTemplateMessage;

        }

        return false;
    }

}
