<?php


class Tools_SeosambaPosTools
{

    const USER_ACTIVE_SESSION = 'active';
    const USER_INACTIVE_SESSION = 'inactive';

    /**
     * Set user login session
     *
     * @param $data
     * @return array|string[]
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Exception
     */
    public static function setSession($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');
        if(!empty($data['posUserId']) && !empty($data['cashRegisterId']) && !empty($data['locationId'])) {
            $seosambaposActiveSessionMapper = Seosambapos_Models_Mappers_SeosambaposActiveSessionMapper::getInstance();
            $seosambaposLoggedUserLogMapper = Seosambapos_Models_Mappers_SeosambaposLoggedUserLogMapper::getInstance();

            $activeSessionData = $seosambaposActiveSessionMapper->findSessionByLocationIdAndCashRegisterId($data['locationId'], $data['cashRegisterId']);

            if(!empty($activeSessionData) && $data['posUserId'] != $activeSessionData['user_id']){
                return array('error' => '1', 'message' => $translator->translate('Session with posUserId-'. $activeSessionData['user_id'] .' is already connected with status-active to the same location and terminal.'));
            }

            $seosambaposActiveSessionModel = $seosambaposActiveSessionMapper->findSessionObj($data['posUserId']);

            $skipLog = false;
            if(!$seosambaposActiveSessionModel instanceof Seosambapos_Models_Models_SeosambaposActiveSessionModel) {
                $seosambaposActiveSessionModel = new Seosambapos_Models_Models_SeosambaposActiveSessionModel();
                $seosambaposActiveSessionModel->setUserId($data['posUserId']);
            } else {
                if($seosambaposActiveSessionModel->getLocationId() != $data['locationId'] || $seosambaposActiveSessionModel->getCashRegisterId() != $data['cashRegisterId']) {
                    $seosambaposLoggedUserLogModel = new Seosambapos_Models_Models_SeosambaposLoggedUserLogModel();
                    $seosambaposLoggedUserLogModel->setUserId($data['posUserId']);
                    $seosambaposLoggedUserLogModel->setStatus(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_LOGOUT);
                    $seosambaposLoggedUserLogModel->setLocationId($seosambaposActiveSessionModel->getLocationId());
                    $seosambaposLoggedUserLogModel->setCashRegisterId($seosambaposActiveSessionModel->getCashRegisterId());
                    $seosambaposLoggedUserLogModel->setDateCreated(Tools_System_Tools::convertDateFromTimezone('now'));

                    $seosambaposLoggedUserLogMapper->save($seosambaposLoggedUserLogModel);
                } else {
                    $skipLog = true;
                }
            }

            $seosambaposActiveSessionModel->setCashRegisterId($data['cashRegisterId']);
            $seosambaposActiveSessionModel->setLocationId($data['locationId']);

            $seosambaposActiveSessionMapper->save($seosambaposActiveSessionModel);

            if(!$skipLog) {
                $seosambaposLoggedUserLogModel = new Seosambapos_Models_Models_SeosambaposLoggedUserLogModel();
                $seosambaposLoggedUserLogModel->setUserId($data['posUserId']);
                $seosambaposLoggedUserLogModel->setStatus(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_LOGIN);
                $seosambaposLoggedUserLogModel->setLocationId($data['locationId']);
                $seosambaposLoggedUserLogModel->setCashRegisterId($data['cashRegisterId']);
                $seosambaposLoggedUserLogModel->setDateCreated(Tools_System_Tools::convertDateFromTimezone('now'));

                $seosambaposLoggedUserLogMapper->save($seosambaposLoggedUserLogModel);
            }

            return array('message' => $translator->translate('The session registered successfully.'));

        } else {
            return array('error' => '1', 'message' => $translator->translate('posUserId or cashRegisterId or locationId not provided.'));
        }
    }

    /**
     * Set user login session
     *
     * @param $data
     * @return array|string[]
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Exception
     */
    public static function unsetSession($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');
        if(!empty($data['posUserId'])) {
            $seosambaposActiveSessionMapper = Seosambapos_Models_Mappers_SeosambaposActiveSessionMapper::getInstance();
            $seosambaposLoggedUserLogMapper = Seosambapos_Models_Mappers_SeosambaposLoggedUserLogMapper::getInstance();

            $seosambaposActiveSession = $seosambaposActiveSessionMapper->findSession($data['posUserId']);

            if(!empty($seosambaposActiveSession)) {
                $locationId = $seosambaposActiveSession['location_id'];
                $cashRegisterId = $seosambaposActiveSession['cash_register_id'];

                $seosambaposActiveSessionMapper->delete($seosambaposActiveSession['id']);

                $seosambaposLoggedUserLogModel = new Seosambapos_Models_Models_SeosambaposLoggedUserLogModel();
                $seosambaposLoggedUserLogModel->setUserId($data['posUserId']);
                $seosambaposLoggedUserLogModel->setStatus(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_LOGOUT);
                $seosambaposLoggedUserLogModel->setLocationId($locationId);
                $seosambaposLoggedUserLogModel->setCashRegisterId($cashRegisterId);
                $seosambaposLoggedUserLogModel->setDateCreated(Tools_System_Tools::convertDateFromTimezone('now'));

                $seosambaposLoggedUserLogMapper->save($seosambaposLoggedUserLogModel);
            }

            return array('message' => $translator->translate('The session deleted successfully.'));

        } else {
            return array('error' => '1', 'message' => $translator->translate('posUserId not provided.'));
        }
    }

    public static function sessionStatus($data, $external = false)
    {
        $translator = Zend_Registry::get('Zend_Translate');
        if(!empty($data['posUserId'])) {
            $seosambaposActiveSessionMapper = Seosambapos_Models_Mappers_SeosambaposActiveSessionMapper::getInstance();
            $seosambaposActiveSession = $seosambaposActiveSessionMapper->findSession($data['posUserId']);

            if(!empty($seosambaposActiveSession)) {
                $data = array(
                    'isActive' => true,
                    'location' => array(),
                    'cashRegister' => array()
                );

                if($external) {
                    $data = array(
                        'isActive' => true,
                        'location' => array(),
                        'cashRegisterId' => null
                    );
                }

                $pickupLocationMapper = Store_Mapper_PickupLocationMapper::getInstance();

                $locationId = $seosambaposActiveSession['location_id'];
                $cashRegisterId = $seosambaposActiveSession['cash_register_id'];

                if(!empty($locationId) && !empty($cashRegisterId)) {
                    $existedLocation = $pickupLocationMapper->find($locationId);

                    if($existedLocation instanceof Store_Model_PickupLocation) {
                        $location = Tools_LocationsTools::getLocations($locationId);
                        $data['location'] = $location;

                        if($external) {
                            $data['location'] = array_shift($location);
                        }
                    }

                    $cashRegisterList = Tools_LocationsTools::getCashRegisterList(true);
                    $cashRegisterIds = $existedLocation->getCashRegisterId();
                    if(!empty($cashRegisterIds)) {
                        $cashRegisterIds = explode(',', $cashRegisterIds);

                        if($external) {
                            if(in_array($cashRegisterId, $cashRegisterIds)) {
                                $data['cashRegisterId'] = $cashRegisterId;
                            }
                        } else {
                            if(in_array($cashRegisterId, $cashRegisterIds)) {
                                $data['cashRegister']['id'] = $cashRegisterId;
                                $data['cashRegister']['label'] = $cashRegisterList[$cashRegisterId];
                            }
                        }
                    }
                }

                return $data;
            }

          return array(
                'isActive' => false,
                'location' => null,
                'cashRegisterId' => null
            );

        } else {
            return array('error' => '1', 'message' => $translator->translate('User not found.'));
        }
    }

    /**
     * Save action logs
     *
     * @param $type
     * @param $posUserId
     * @param $createdAt
     * @param $additionalContent
     * @return mixed
     * @throws Exceptions_SeotoasterException
     */
    public static function logAction($type, $posUserId, $createdAt, $additionalContent)
    {
        if(!empty($posUserId)) {
            $seosambaposActionLogMapper = Seosambapos_Models_Mappers_SeosambaposActionLogMapper::getInstance();
            $seosambaposActionLog = new Seosambapos_Models_Models_SeosambaposActionLogModel();
            $seosambaposActionLog->setType($type);
            $seosambaposActionLog->setUserId($posUserId);
            $seosambaposActionLog->setCreatedAt($createdAt);
            $seosambaposActionLog->setAdditionalContent($additionalContent);

            return $seosambaposActionLogMapper->save($seosambaposActionLog);
        }
    }

    /**
     * Check if user and cash_register_id location in system exists
     *
     * @param $posUserId
     * @param $cashRegisterId
     * @return array|string[]
     * @throws Zend_Exception
     */
    public static function checkExistUserAndCashRegister($posUserId, $cashRegisterId = '', $locationId = '', $setSession = false)
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $isActiveSession = false;
        $userValidate = false;
        $locationValidate = false;
        $cashRegisterIdValidate = false;
        if(!empty($posUserId)) {
            $userMapper = Application_Model_Mappers_UserMapper::getInstance();
            $seosambaposActiveSessionMapper = Seosambapos_Models_Mappers_SeosambaposActiveSessionMapper::getInstance();
            $seosambaposActiveSession = $seosambaposActiveSessionMapper->findSession($posUserId);

            if(!empty($seosambaposActiveSession)) {
                $isActiveSession = true;
            }

            $existedCustomer = $userMapper->find($posUserId);

            if($existedCustomer instanceof Application_Model_Models_User) {
                if($posUserId == $existedCustomer->getId()) {
                    $userValidate = true;
                }
            }

            if(empty($cashRegisterId) && empty($locationId)) {
                if($isActiveSession) {
                    $cashRegisterId = $seosambaposActiveSession['cash_register_id'];
                    $locationId = $seosambaposActiveSession['location_id'];
                }
            }
        }

        if(!empty($cashRegisterId) && !empty($locationId)) {
            $locations = Tools_LocationsTools::getLocations($locationId);

            if(!empty($locations)) {
                 foreach ($locations as $location) {
                     if($locationId == $location['id']) {
                         $locationValidate = true;

                         if(!empty($location['cashRegisters'])) {
                             foreach ($location['cashRegisters'] as $cashRegister) {
                                 if($cashRegisterId == $cashRegister['id']) {
                                     $cashRegisterIdValidate = true;
                                 }
                             }
                         }
                     }
                 }
            }
        }

        if(!$isActiveSession && !$setSession) {
            return array('error' => '1', 'typeError' => 'session', 'message' => $translator->translate('Your session has expired. Please choose your store location.'));
        }

        if(!$userValidate) {
            return array('error' => '1', 'message' => $translator->translate('You can not continue working with API. The requested user is not found!'));
        }

        if(!$cashRegisterIdValidate) {
            return array('error' => '1', 'message' => $translator->translate('You can not continue working with API. The requested cash register ID is not found!'));
        }

        if(!$locationValidate) {
            return array('error' => '1', 'message' => $translator->translate('You can not continue working with API. The requested location ID is not found!'));
        }

        return array('error' => '0', 'message' => '');
    }

//    /**
//     * Check if session active
//     *
//     * @param $posUserId
//     * @return string[]
//     * @throws Zend_Exception
//     */
//    public static function checkActiveSession($posUserId)
//    {
//        $translator = Zend_Registry::get('Zend_Translate');
//
//        $seosambaposActiveSessionMapper = Seosambapos_Models_Mappers_SeosambaposActiveSessionMapper::getInstance();
//        $seosambaposActiveSession = $seosambaposActiveSessionMapper->findSession($posUserId);
//
//        if(!empty($seosambaposActiveSession)) {
//            return array();
//        }
//
//        return array('error' => '1', 'message' => $translator->translate('This session with posUserId-') . $posUserId . $translator->translate(' is inactive.'));
//    }

    /**
     * Return Shopping confid data
     *
     * @return array
     * @throws Zend_Exception
     */
    public static function getStoreInfo() {
       $shoppingConfig = Models_Mapper_ShoppingConfig::getInstance()->getConfigParams();
       $brandMapper = Models_Mapper_Brand::getInstance();

       $shoppingConfigData = array();

       $publishKey = 'not configured';
       $stripeClientId = '';

        $stripepayOAuth = Tools_StripeOAuthTools::checkStripepayConfigOAuth();

        if(empty($stripepayOAuth)) {
            $stripeConfigMapper = Stripepay_Models_Mappers_StripepayConfigMapper::getInstance();
            $stripeSettings = $stripeConfigMapper->getConfigParams();

            if(!empty($stripeSettings)) {
               if(!empty($stripeSettings['publishableKey'])) {
                   $publishKey = $stripeSettings['publishableKey'];
                   if(!empty($stripeSettings['useSandBox'])) {
                       $publishKey = $stripeSettings['publishableKeyTest'];
                   }
               }
            }
        } else {
            $stripepayConnectionStatus = Tools_StripeOAuthTools::connectionStatusMojo();

            if(!empty($stripepayConnectionStatus)) {
                if(!empty($stripepayConnectionStatus['stripe_publishable_key'])) {
                    $publishKey = $stripepayConnectionStatus['stripe_publishable_key'];
                }

                if(!empty($stripepayConnectionStatus['stripe_client_id'])) {
                    $stripeClientId = $stripepayConnectionStatus['stripe_client_id'];
                }
            }
        }

       $shoppingConfigData['pk'] = $publishKey;
       $shoppingConfigData['stripe_account_id'] = $stripeClientId;

       $shoppingConfigData['shippingServices'] = Tools_ShippingTools::getShippingServices();

       //@todo deprecated. remove on next release
       $shoppingConfigData['defaultTaxList'] = Tools_ProductTools::getDefaultTaxList();

       if(!empty($shoppingConfig)) {
           $shoppingConfigData['currency'] = $shoppingConfig['currency'];

           $locale = Cart::DEFAULT_LOCALE;
           if(!empty($shoppingConfig['currencyCountry'])) {
               $locale = Zend_Locale::getLocaleToTerritory($shoppingConfig['currencyCountry']);
           }
           $currency = Zend_Registry::isRegistered('Zend_Currency') ? Zend_Registry::get('Zend_Currency') : new Zend_Currency($locale);
           $correctCurrency = isset($shoppingConfig['currency']) ? $shoppingConfig['currency'] : Cart::DEFAULT_CURRENCY_NAME;
           $shoppingConfigData['currencySign'] = $currency->getSymbol($correctCurrency, Cart::DEFAULT_LOCALE);

           $shoppingConfigData['weightUnit'] = $shoppingConfig['weightUnit'];
           $shoppingConfigData['lengthUnit'] = $shoppingConfig['lengthUnit'];
           $shoppingConfigData['country'] = $shoppingConfig['country'];
           $shoppingConfigData['wordCountAiShortDescription'] = $shoppingConfig['wordCountAiShortDescription'];
           $shoppingConfigData['wordCountAiFullDescription'] = $shoppingConfig['wordCountAiFullDescription'];
       }

       $countryCodeList = Tools_System_Tools::getFullCountryPhoneCodesList(false);
       $shoppingConfigData['mobileCountryCodes'] = $countryCodeList;

       $shoppingConfigData['brands'] = array();
       $brands = $brandMapper->getAllBrands();

       if(!empty($brands)) {
           foreach ($brands as $key => $brand) {
               $shoppingConfigData['brands'][] = $brand;
           }
       }

        $shoppingConfigData['tags'] = array();
        $tagsData = Models_Mapper_Tag::getInstance()->fetchAll();

        if(!empty($tagsData)) {
            foreach ($tagsData as $tag) {
                $shoppingConfigData['tags'][] = $tag->getName();
            }
        }

        $shoppingConfigData['conditions'] = array(
            'New',
            'Refurbished',
            'Used',
        );

        $shoppingConfigData['successfulPurchaseExists'] = Tools_CartTools::ifSuccessfulPurchaseExists();//true/false

       return $shoppingConfigData;
    }

    /**
     * Cut out edit links from contents.
     */
    public static function stripEditLinks($string) {
        if (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_CONTENT)) {
            return preg_replace('/<a class=\"tpopup generator-links\".*>.*<\/a>/', '', $string);
        }
        return $string;
    }


    public static function sendReviewLink($data) {
        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['cartId'])) {
            return array('error' => '1', 'message' => $translator->translate('cartId is empty.'));
        }

        if(empty($data['links'])) {
            return array('error' => '1', 'message' => $translator->translate('Nothing to send.'));
        }

        if(empty($data['recipient'])) {
            return array('error' => '1', 'message' => $translator->translate('Recipient is empty.'));
        }

        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
        $cartSession = $cartSessionMapper->find($data['cartId']);

        if($cartSession instanceof Models_Model_CartSession) {
            $isAlreadyPaid = Tools_CartTools::verifyIfAlreadyPaid($data['cartId']);
            if ($isAlreadyPaid === true) {
                //$seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();
                //$defaultCustomerId = $seosambaposSettingsMapper->getConfigParam('defaultCustomerId');
                $userId = $cartSession->getUserId();


//                if($userId == $defaultCustomerId) {
//                    return array('error' => '1', 'message' => $translator->translate('You can not send review link to default customer.'));
//                }

                $userModel = Application_Model_Mappers_UserMapper::getInstance()->find($userId);
                $data['userFullName'] = $userModel->getFullName();

                if (!Zend_Registry::isRegistered('extConfig')) {
                    $configTable   = new Application_Model_DbTable_Config();
                    Zend_Registry::set('extConfig', $configTable->selectConfig());
                }


                if($data['isEmail'] == false) {
                    $smsPhoneNumber = Apps_Tools_Twilio::normalizePhoneNumberToE164($data['recipient']);
                    if (!empty($smsPhoneNumber)) {
                        $activeActionEmailTriggers = self::getDefaultActionEmailInfo(Tools_SeosambaposMailWatchdog::TRIGGER_SEOSAMBAPOS_SENDREVIEWLINK, 'sms');

                        if(!empty($activeActionEmailTriggers)) {
                            $messageContent = $activeActionEmailTriggers['message'];

                            if(!empty($messageContent)) {
                                $messageContent = self::addDictionaryFields($messageContent, $data, $websiteHelper->getUrl(), '<a>');
                            }

                            $subscriber['subscriber']['user'] = array(
                                'phone' => array($smsPhoneNumber),
                                'message' => $messageContent,
                                'owner_type' => Apps::SMS_OWNER_TYPE_USER,
                                'sms_from_type' => 'info',
                                'custom_params' => array(),
                            );

                            $response = Apps::apiCall('POST', 'apps', array('twilioSms'), $subscriber);

                            if($response['twilioSms']['done']) {
                                return array('error' => '0', 'message' => $translator->translate('The review link(s) has been sent'));
                            }
                        } else {
                            return array('error' => '1', 'message' => $translator->translate('Review Link sms trigger not found in system'));
                        }

                        return array('error' => '1', 'message' => $translator->translate('Can\'t send SMS'));
                    }

                    return array('error' => '1', 'message' => $translator->translate('Not valid phone number'));
                }


                if($data['isEmail'] == true) {
                    $emailIsValid = Tools_System_Tools::isEmailValid(trim($data['recipient']));
                    if (!$emailIsValid) {
                        return array('error' => '1', 'message' => $translator->translate('Not valid email'));
                    }

                    $activeActionEmailTriggers = self::getDefaultActionEmailInfo(Tools_SeosambaposMailWatchdog::TRIGGER_SEOSAMBAPOS_SENDREVIEWLINK);

                    if(!empty($activeActionEmailTriggers)) {
                        $messageContent = $activeActionEmailTriggers['message'];

                        if(!empty($messageContent)) {
                            $messageContent = self::addDictionaryFields($messageContent, $data, $websiteHelper->getUrl(), '<a></br>', true);
                        }

                        $cartSession->registerObserver(new Tools_Mail_Watchdog(array(
                            'trigger' => Tools_SeosambaposMailWatchdog::TRIGGER_SEOSAMBAPOS_SENDREVIEWLINK,
                            'message' => $messageContent,
                            'recipient' => $data['recipient'],
                            'observableModel' => $cartSession,
                            'recipientRole' => Shopping::ROLE_CUSTOMER
                        )));

                        $cartSession->notifyObservers();
                    } else {
                        return array('error' => '1', 'message' => $translator->translate('Review Link email trigger not found in system'));
                    }
                }

                // log action
                $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
                $additionalContent = json_encode($data);
                Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_ORDER_REVIEW_LINK,
                    $data['posUserId'], $createdAt, $additionalContent);

                return array('error' => '0', 'message' => $translator->translate('The review link(s) has been sent'));
            } else {
                return array('error' => '1', 'message' => $translator->translate('The cart has not been paid yet.'));
            }
        }

        return array('error' => '1', 'message' => $translator->translate('Cart not found!'));

    }

    public static function addDictionaryFields($messageContent, $data, $websiteUrl, $excludeTags = '', $isEmail = false)
    {
        $reviewLinks = '';
        if(!empty($data['links']) && is_array($data['links'])) {
            $links = $data['links'];

            foreach ($links as $link) {
                if($isEmail) {
                    $reviewLinks .= ' ' . '<a href="' . $link . '" target="_blank" title="' . $link . '">' . $link . '</a></br>';
                } else {
                    $reviewLinks .= $link . chr(13).chr(10);
                }
            }

            $reviewLinks = trim($reviewLinks, " \r\n");
        }

        $dictionary = array(
            'seosambapos:reviewlink' => $reviewLinks,
            'customer:fullname' => !empty($data['userFullName']) ? $data['userFullName'] : '',
        );

        $entityParser = new Tools_Content_EntityParser();

        $entityParser->addToDictionary($dictionary);

        if (!empty($excludeTags)) {
            return $entityParser->parse(strip_tags($messageContent, $excludeTags));
        }

        return $entityParser->parse(strip_tags($messageContent));
    }

    public static function getDefaultActionEmailInfo($triggerName, $service = 'email')
    {
        $triggerActionsDbTable = new Application_Model_DbTable_TriggersActions();
        $where = $triggerActionsDbTable->getAdapter()->quoteInto('`trigger` = ?', $triggerName);
        $where .= ' AND ' . $triggerActionsDbTable->getAdapter()->quoteInto('`service` = ?', $service);
        $selectActiveActionEmailTriggers = $triggerActionsDbTable->select()->setIntegrityCheck(false)->from('email_triggers_actions',
            array('trigger', 'id', 'subject', 'template', 'message'))
            ->where($where)->limit(1);

        return $triggerActionsDbTable->getAdapter()->fetchRow($selectActiveActionEmailTriggers);
    }

    public static function getPosUserId($data)
    {
        $userMapper = Application_Model_Mappers_UserMapper::getInstance();
        $posUserId = $data['posUserId'];
        if(empty($posUserId)) {
            $posUserEmail = $data['posUserEmail'];

            if(!empty($posUserEmail)) {
                $existedSalesperson = $userMapper->findByEmail($posUserEmail);

                if($existedSalesperson instanceof Application_Model_Models_User) {
                    if($existedSalesperson->getRoleId() == Tools_Security_Acl::ROLE_SUPERADMIN || $existedSalesperson->getRoleId() == Tools_Security_Acl::ROLE_ADMIN || $existedSalesperson->getRoleId() == Shopping::ROLE_SALESPERSON) {
                        $posUserId = $existedSalesperson->getId();
                    }
                }
            }

            if(empty($posUserId)) {
                $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();
                $defaultSalespersonId = $seosambaposSettingsMapper->getConfigParam('defaultSalespersonId');

                if(!empty($defaultSalespersonId)) {
                    $posUserId = $defaultSalespersonId;
                }
            }
        }

        return $posUserId;
    }

}