<?php

class Tools_ProductTools
{

    public static $_acceptedFileTypesArray = array(
        'png',
        'gif',
        'jpg',
        'jpeg',
        'webp',
    );

    const DEFAULT_MEDIA_FOLDER = 'products';

    public static function getProductsFilePath($imageName, $mediaFolder = self::DEFAULT_MEDIA_FOLDER, $subFolder = 'original')
    {
        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');

        $dir = $websiteHelper->getPath() . 'media' . DIRECTORY_SEPARATOR . $mediaFolder;
        if (!is_dir($dir)) {
            Tools_Filesystem_Tools::mkdir($dir);
        }

        $dir = $websiteHelper->getPath() . 'media' . DIRECTORY_SEPARATOR . $mediaFolder . DIRECTORY_SEPARATOR . $subFolder;
        if (!is_dir($dir)) {
            Tools_Filesystem_Tools::mkdir($dir);
        }

        return $websiteHelper->getPath() . 'media' . DIRECTORY_SEPARATOR . $mediaFolder .
            DIRECTORY_SEPARATOR . $subFolder . DIRECTORY_SEPARATOR . $imageName;

    }

    /**
     * Preparing tags
     *
     * @param string $tagNames (FirstTag,SecondTag)
     * @return array tags (array(0 => array(id, name)))
     *
     */
    private static function _prepareTag($tagNames) {
        $tagsDbTable = new Models_DbTable_Tag();
        $tags = array_map('trim',array_unique(array_filter(explode(',', $tagNames))));
        $tags = self::_parseDublicateTags($tags);
        $tagsResult = array();
        if (!empty($tags)) {
            foreach ($tags as $tagName) {
                $where = $tagsDbTable->getAdapter()->quoteInto('name = ?', $tagName);
                $tagExist = $tagsDbTable->getAdapter()->fetchAll(
                    $tagsDbTable->select()->from('shopping_tags')->where($where)
                );
                if (!empty($tagExist)) {
                    $tagsResult[] = array('id' => $tagExist[0]['id'], 'name' => $tagName);
                } else {
                    $tagId = $tagsDbTable->insert(array('name' => $tagName));
                    $tagsResult[] = array('id' => $tagId, 'name' => $tagName);
                }
            }
        }

        return $tagsResult;
    }

    /*
     * Find dublicate tag in array
     * @return array
     */
    private static function _parseDublicateTags(array $tags){
        $workTags = array_unique(array_map('strtolower',$tags));

        return array_intersect_key($tags,$workTags);
    }

    /**
     * Get default product from seosambapos Default product config
     *
     * @return void
     */
    public static function getDefaultProduct()
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $seosambaposDefaultproductSettingMapper = Seosambapos_Models_Mappers_SeosambaposDefaultproductSettingMapper::getInstance();
        $productMapper = Models_Mapper_ProductMapper::getInstance();
        $websiteHelper = Zend_Controller_Action_HelperBroker::getExistingHelper('website');
        $websiteUrl = $websiteHelper->getUrl();
        $brandMapper = Models_Mapper_Brand::getInstance();
        $currency = Zend_Registry::get('Zend_Currency');

        $seosambaposDefaultproductSetting = $seosambaposDefaultproductSettingMapper->getConfigParams();

        if(!empty($seosambaposDefaultproductSetting['defaultProductId'])) {
            $defaultProduct = $productMapper->find($seosambaposDefaultproductSetting['defaultProductId']);

            $productInfo = array();
            if($defaultProduct instanceof Models_Model_Product) {
                $productInfo['id'] = (string) $defaultProduct->getId();
                $productInfo['name'] = '';//$defaultProduct->getName();
                $productInfo['sku'] = '';//$defaultProduct->getSku();
                $productInfo['shortDescription'] = '';//$defaultProduct->getShortDescription();
                $productInfo['mpn'] = '';//$defaultProduct->getMpn();
                $productInfo['gtin'] = '';//$defaultProduct->getGtin();

                $condition = $defaultProduct->getCondition();
                if(isset($seosambaposDefaultproductSetting['defaultCondition'])) {
                    $condition = $seosambaposDefaultproductSetting['defaultCondition'];
                }

                $productInfo['condition'] = $condition;
                $productInfo['imageUrl'] = self::prepareProductImage($defaultProduct->getPhoto(), 'small');
                $productInfo['weight'] = (float)$defaultProduct->getWeight();
                //product tax
                $taxClass = $defaultProduct->getTaxClass();
                if(isset($seosambaposDefaultproductSetting['defaultTaxId'])) {
                    $taxClass = $seosambaposDefaultproductSetting['defaultTaxId'];
                }

                $productInfo['taxClass'] = $taxClass;
                //@todo add get tax list by zone?
                $taxConfigData = self::getDefaultTaxList($taxClass);
                $productInfo['tax']['id'] = $taxConfigData['id'];
                $productInfo['tax']['label'] = $taxConfigData['label'];
                $productInfo['tax']['tax_value'] = (float)$taxConfigData['tax_value'];

                $inventory = $defaultProduct->getInventory();
                if(!is_null($inventory)) {
                    $inventory = (int)$inventory;
                }
                $productInfo['inventory'] = $inventory;

                $productInfo['locationId'] = '';
                $productInfo['locationInventories'] = array();
                $productInfo['dimensions']['width'] = (is_null($defaultProduct->getProdWidth()) ? 0.00 : (float)$defaultProduct->getProdWidth());
                $productInfo['dimensions']['length'] = (is_null($defaultProduct->getProdLength()) ? 0.00 : (float)$defaultProduct->getProdLength());
                $productInfo['dimensions']['depth'] = (is_null($defaultProduct->getProdDepth()) ? 0.00 : (float)$defaultProduct->getProdDepth());

                $brand = $defaultProduct->getBrand();
                if(!empty($seosambaposDefaultproductSetting['defaultBrandId'])) {
                    $brandObj = $brandMapper->find($seosambaposDefaultproductSetting['defaultBrandId']);

                    if($brandObj instanceof Models_Model_Brand) {
                        $brand = $brandObj->getName();
                    }
                }

                $productInfo['brand'] = $brand;
                //$productInfo['tags'] = $defaultProduct->getTags();

                if ($defaultProduct->getCurrentPrice() !== null && $defaultProduct->getExtraProperties()) {
                    $defaultProduct->setCurrentPrice(null);
                }

                $itemDefaultOptionsArray = array();
                $prodOptions = $defaultProduct->getDefaultOptions();

                if(!empty($prodOptions)) {
                    foreach($prodOptions as $option){
                        if(is_array($option['selection'])) {
                            foreach ($option['selection'] as $item) {
                                if($item['isDefault'] == 1){
                                    $itemDefaultOptionsArray[$option['id']] = $item['id'];
                                }
                            }
                        }
                    }

//                    $productInfo['defaultOptions'] = $prodOptions;
                }

                $price = number_format(Tools_ShoppingCart::getInstance()->calculateProductPrice($defaultProduct, $itemDefaultOptionsArray), 2, '.', '');
                $productInfo['price'] = (float)$price;
                $productInfo['nonTaxablePrice'] = (float)$defaultProduct->getPrice();
                //$productInfo['priceWithCurrency'] = $currency->toCurrency($price);
                $productInfo['additionalImages'] = array();

                return $productInfo;
            } else {
                return array('error' => '1', 'message' => $translator->translate('Default product was deleted, please reassign the product in config.'));
            }
        }

        return array('error' => '1', 'message' => $translator->translate('Default product not assigned in the config'));
    }

    /**
     * Get product list
     *
     * @return void
     */
    public static function getProductList($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $posUserId = Tools_SeosambaPosTools::getPosUserId($data);
        $locationId = filter_var($data['locationId'], FILTER_SANITIZE_NUMBER_INT);
        if(!empty($locationId)) {
            $productMapper = Models_Mapper_ProductMapper::getInstance();
            $productLocationsMapper = Models_Mapper_ProductLocationsMapper::getInstance();

            if (empty($data) || empty($data['limit'])) {
                return array('error' => '1', 'message' => $translator->translate('Missing query limit'));
            }

            $limit = $data['limit'];
            $offset = null;
            if ($data['offset']) {
                $offset = $data['offset'];
            }

            $order = null;
            if(!empty($data['order'])) {
                $orderType = 'DESC';
                if(!empty($data['orderType']) && ($data['orderType'] == 'DESC' || $data['orderType'] == 'ASC')) {
                    $orderType = $data['orderType'];
                }

                if($data['order'] == 'name') {
                    $order = 'sp.name ' . $orderType;
                } elseif ($data['order'] == 'price') {
                    $order = 'sp.price ' . $orderType;
                }
            }

            $productDbTable = new Models_DbTable_Product();

            //includeOutOfStock
            $includeOutOfStock = 0;
            if($data['includeOutOfStock'] == 'true') {
                $includeOutOfStock = 1;
            }

            $where = '';
            if(!$includeOutOfStock) {
                $where = $productDbTable->getAdapter()->quoteInto('sp.enabled = ?', '1');
            }
            //$where .= ' AND ' . $productDbTable->getAdapter()->quoteInto('sp.inventory <> ?', '0');

            if (!empty($data['searchParam'])) {
                if(!empty($where)) {
                    $where .= ' AND ';
                }

                $where .= ' (' . $productDbTable->getAdapter()->quoteInto('sp.name LIKE ?', '%' .$data['searchParam']. '%');
                $where .= ' OR ' . $productDbTable->getAdapter()->quoteInto('sp.sku LIKE ?', '%' .$data['searchParam']. '%');
                $where .= ' OR ' . $productDbTable->getAdapter()->quoteInto('sp.gtin LIKE ?', '%' .$data['searchParam']. '%');
                $where .= ' OR ' . $productDbTable->getAdapter()->quoteInto('sp.mpn LIKE ?', '%' .$data['searchParam']. '%');
                $where .= ')';
            }

            //$searchByLocationId = false;
            $locationId = filter_var($data['locationId'], FILTER_SANITIZE_NUMBER_INT);
            $searchByLocationId = true;
            if(!empty($where)) {
                $where .= ' AND ';
            }
            $where .= $productDbTable->getAdapter()->quoteInto('spl.id = ?', $locationId);

            $searchByTags = false;
            $tagIds = array();
            if(!empty($data['productTags'])) {
                $tagIds = explode(',', $data['productTags']);
            }

            $tagIds = filter_var_array($tagIds, FILTER_SANITIZE_STRING);
            if(!empty($tagIds)) {
                $searchByTags = true;
                if(!empty($where)) {
                    $where .= ' AND ';
                }
                $where .= $productDbTable->getAdapter()->quoteInto('t.id in (?)', $tagIds);
            }

            if(!$includeOutOfStock) {
                if(!empty($where)) {
                    $where .= ' AND ';
                }
                $where .= $productDbTable->getAdapter()->quoteInto('pspl.inventory > ?', '0');
            } else {
                if(!empty($where)) {
                    $where .= ' AND ';
                }
                $where .= $productDbTable->getAdapter()->quoteInto('pspl.inventory >= ?', '0');
            }

            $where .= ' AND ' . $productDbTable->getAdapter()->quoteInto('pspl.is_quick_product = ?', '0');


            $productsDataInfo = $productLocationsMapper->fetchAllData($where, $order, $limit, $offset, false, false, '', $searchByLocationId, $searchByTags);

            if (empty($productsDataInfo) || empty($productsDataInfo['data'])) {
                return array(
                    'totalRecords' => (int) $productsDataInfo['totalRecords'],
                    'products' => array(),
                    'offset' => (int) $productsDataInfo['offset'],
                    'limit' => (int) $productsDataInfo['limit'],
                );
            }

            $productInfo = array();

            $currency = Zend_Registry::get('Zend_Currency');
            $websiteHelper = Zend_Controller_Action_HelperBroker::getExistingHelper('website');
            $websiteUrl = $websiteHelper->getUrl();
            $shoppingConfig = Models_Mapper_ShoppingConfig::getInstance()->getConfigParams();

            foreach ($productsDataInfo['data'] as $key => $product) {
                $productInfo[$key]['id'] = $product['id'];
                $productInfo[$key]['name'] = $product['name'];
                $productInfo[$key]['sku'] = $product['sku'];
                $productInfo[$key]['shortDescription'] = $product['short_description'];
                $productInfo[$key]['mpn'] = $product['mpn'];
                $productInfo[$key]['gtin'] = $product['gtin'];
                $productInfo[$key]['condition'] = $product['condition'];
                $productInfo[$key]['imageUrl'] = self::prepareProductImage($product['photo'], 'small');
                $productInfo[$key]['weight'] = (float)$product['weight'];
                $productInfo[$key]['taxClass'] = $product['tax_class'];
                //product tax
                //@todo add get tax list by zone?
                $taxConfigData = self::getDefaultTaxList($product['tax_class']);
                $productInfo[$key]['tax']['id'] = $taxConfigData['id'];
                $productInfo[$key]['tax']['label'] = $taxConfigData['label'];
                $productInfo[$key]['tax']['tax_value'] = (float)$taxConfigData['tax_value'];

                $inventory = $product['inventory'];
                if(!is_null($inventory)) {
                    $inventory = (int)$inventory;
                }
                $productInfo[$key]['inventory'] = $inventory;

                $locationInventories = array();
                $productLocations = $productLocationsMapper->findLocationsByProductId($product['id']);

                $productInfo[$key]['locationId'] = '';

                if(!empty($productLocations)) {
                    foreach ($productLocations as $pKey => $pLocation){
                        if($pLocation['location_id'] == $locationId) {
                            $productInfo[$key]['locationId'] = $pLocation['location_id'];
                        }
                        $locationInventories[$pKey]['locationId'] = $pLocation['location_id'];
                        $locationInventories[$pKey]['locationName'] = $pLocation['name'];
                        $locationInventories[$pKey]['locationAddress'] = (!empty($pLocation['address1'])) ? $pLocation['address1'] : $pLocation['address2'];
                        $locationInventories[$pKey]['inventory'] = (int)$pLocation['inventory'];
                    }
                }

                $productInfo[$key]['locationInventories'] = $locationInventories;
                $productInfo[$key]['dimensions']['width'] = (is_null($product['prod_width']) ? 0.00 : (float)$product['prod_width']);
                $productInfo[$key]['dimensions']['length'] = (is_null($product['prod_length']) ? 0.00 : (float)$product['prod_length']);
                $productInfo[$key]['dimensions']['depth'] = (is_null($product['prod_depth']) ? 0.00 : (float)$product['prod_depth']);

                $productInfo[$key]['brand'] = $product['brandName'];

                $productModel = $productMapper->find($product['id']);

                $productTags = $productModel->getTags();

                $tags = array();
                if(!empty($productTags)) {
                    foreach ($productTags as $productTag) {
                        $tags[] = $productTag['name'];
                    }
                }
                $productInfo[$key]['tags'] = $tags;

                if ($productModel->getCurrentPrice() !== null && $productModel->getExtraProperties()) {
                    $productModel->setCurrentPrice(null);
                }

                $itemDefaultOptionsArray = array();
                $prodOptions = $productModel->getDefaultOptions();

                if(!empty($prodOptions)) {
                    foreach($prodOptions as $option){
                        if(is_array($option['selection'])) {
                            foreach ($option['selection'] as $item) {
                                if($item['isDefault'] == 1){
                                    $itemDefaultOptionsArray[$option['id']] = $item['id'];
                                }
                            }
                        }
                    }

                    //$productInfo[$key]['defaultOptions'] = $prodOptions;
                }

                $price = number_format(Tools_ShoppingCart::getInstance()->calculateProductPrice($productModel, $itemDefaultOptionsArray), 2, '.', '');
                $price = self::calculateProductPriceByZone($posUserId, $productModel, $price);

                $productInfo[$key]['price'] = (float)$price;
                $productInfo[$key]['nonTaxablePrice'] = (float)$productModel->getPrice();
                //$productInfo[$key]['priceWithCurrency'] = $currency->toCurrency($price);
                $productInfo[$key]['additionalImages'] = self::getProductAdditionalPictures(array('productId' => $productModel->getId()));
            }

            $productsDataInfo['products'] = $productInfo;
            unset($productsDataInfo['data']);
            $productsDataInfo['totalRecords'] = (int) $productsDataInfo['totalRecords'];
            $productsDataInfo['limit'] = (int) $productsDataInfo['limit'];
            if(is_null($productsDataInfo['ofset'])) {
                $productsDataInfo['offset'] = 0;
            }


            return $productsDataInfo;
        }

        return array('error' => '1', 'message' => $translator->translate('Missing locationId'));
    }

    /**
     * Add product
     *
     * @return void
     */
    public static function addProduct($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $websiteUrl = $websiteHelper->getUrl();
        $currency = Zend_Registry::get('Zend_Currency');

        $productMapper = Models_Mapper_ProductMapper::getInstance();
        $brandMapper = Models_Mapper_Brand::getInstance();
        $templateMapper = Application_Model_Mappers_TemplateMapper::getInstance();
        $seosambaposDefaultproductSettingMapper = Seosambapos_Models_Mappers_SeosambaposDefaultproductSettingMapper::getInstance();
        $seosambaposDefaultproductSetting = $seosambaposDefaultproductSettingMapper->getConfigParams();
        $seosambaposActiveSessionMapper = Seosambapos_Models_Mappers_SeosambaposActiveSessionMapper::getInstance();
        $productLocationsMapper = Models_Mapper_ProductLocationsMapper::getInstance();

        $sku = filter_var(trim($data['product']['sku']), FILTER_SANITIZE_STRING);

        if(empty($sku)) {
            $uniqueHash = (string) time();
            $sku = $uniqueHash;
        }

        $existedProduct = $productMapper->findBySku($sku);

        if($existedProduct instanceof Models_Model_Product) {
            return array('error' => '1', 'message' => $translator->translate('You already have a product with this SKU'));
        }

        $brandName = filter_var(trim($data['product']['brand']), FILTER_SANITIZE_STRING);
        $brandName = preg_replace("/[^a-zA-Z0-9\-_\s]/", '', $brandName);
        $brand = '';
        if(!empty($brandName)) {
            $brand = $brandName;
        }

        if(empty($brand) && !empty($seosambaposDefaultproductSetting['defaultBrandId'])) {
            $brandObj = $brandMapper->find($seosambaposDefaultproductSetting['defaultBrandId']);

            if($brandObj instanceof Models_Model_Brand) {
                $brand = $brandObj->getName();
            }
        }

        if(empty($brand)) {
            return array('error' => '1', 'message' => $translator->translate('Default brand not assigned in the config or not set in request'));
        }

        $mpn = filter_var(trim($data['product']['mpn']), FILTER_SANITIZE_STRING);
        $productName = filter_var(trim($data['product']['name']), FILTER_SANITIZE_STRING);

        if(empty($productName)) {
            return array('error' => '1', 'message' => $translator->translate('Product name is empty'));
        }

        $weight = $data['product']['weight'];

        $price = $data['product']['nonTaxablePrice'];
        if(empty($price)) {
            return array('error' => '1', 'message' => $translator->translate('Product price is empty'));
        }

        $taxClass = filter_var($data['product']['taxClass'], FILTER_SANITIZE_NUMBER_INT);
        $taxC = '';

        if(is_numeric($taxClass)) {
            $taxC = $taxClass;
            if($taxClass > 3) {
                $taxC = '0';
            }
        }

        if($taxC == '' && !empty($seosambaposDefaultproductSetting['defaultTaxId'])) {
            $taxC = $seosambaposDefaultproductSetting['defaultTaxId'];
        }

        if(empty($taxC)) {
            $taxC = '0';
        }

        $tagNames = $data['product']['tags'];
        $tags = array();
        if(!empty($tagNames)) {
            $preparedTags = $tagNames;
            if(is_array($tagNames)) {
                $preparedTags = implode(',', $tagNames);
            }

            $tags = self::_prepareTag($preparedTags);
        }

        $inventory = filter_var($data['product']['inventory'], FILTER_SANITIZE_NUMBER_INT);
        if(empty($inventory)) {
            $inventory = 1;
        }
        $shortDescription = $data['product']['shortDescription'];

//        if(empty($shortDescription)) {
//            return array('error' => '1', 'message' => $translator->translate('Product shortDescription is empty'));
//        }

        $dimensionW = 0;
        $dimensionWidth = preg_replace("/[^0-9.]/", '', $data['product']['dimensions']['width']);
        if(!empty($dimensionWidth)) {
            $dimensionW = $dimensionWidth;
        }

        $dimensionL = 0;
        $dimensionLength = preg_replace("/[^0-9.]/", '', $data['product']['dimensions']['length']);
        if(!empty($dimensionLength)) {
            $dimensionL = $dimensionLength;
        }

        $dimensionD = 0;
        $dimensionDepth = preg_replace("/[^0-9.]/", '', $data['product']['dimensions']['depth']);
        if(!empty($dimensionDepth)) {
            $dimensionD = $dimensionDepth;
        }

        $gtin = $data['product']['gtin'];

        $condition = '';
        $conditionName = '';
        if(!empty($data['product']['condition'])) {
            $conditionName = $data['product']['condition'];
        }

        if(!empty($conditionName)) {
            $condition = $conditionName;
        }

        if(empty($condition) && !empty($seosambaposDefaultproductSetting['defaultCondition'])) {
            $condition = $seosambaposDefaultproductSetting['defaultCondition'];
        }

        $image = $websiteUrl.Tools_Page_Tools::PLACEHOLDER_NOIMAGE;
        if(!empty($data['product']['image']) && is_array($data['product']['image'])) {
            $imageExtension = '';
            if(!empty($data['product']['image']['name'])) {
                $imageExtension = pathinfo($data['product']['image']['name'], PATHINFO_EXTENSION);
            }
//            $pattern = '/data:image\/(.+);base64,(.*)/';
//            preg_match($pattern, $data['image'], $matches);
//            $imageExtension = $matches[1];

            if(in_array($imageExtension, self::$_acceptedFileTypesArray, true)) {
                $encodedImageData = $data['product']['image']['data'];
                $decodedImageData = base64_decode($encodedImageData);

                $mediaFolder = self::DEFAULT_MEDIA_FOLDER;
                if(!empty($data['product']['photoFolder'])) {
                    $mediaFolder = $data['product']['photoFolder'];
                }

                $imageName = strtolower(preg_replace("/[^a-zA-Z0-9\-_\s]/", '', $sku)) . time() . '.' . $imageExtension;
                $savePath = self::getProductsFilePath($imageName, $mediaFolder, 'original');

                if(file_exists($savePath)){
                    unlink($savePath);
                }

                $fp = fopen($savePath,'x');
                fwrite($fp, $decodedImageData);
                fclose($fp);
                if (file_exists($savePath)) {
                    $image = $mediaFolder . DIRECTORY_SEPARATOR . $imageName;

                    $localPath = $websiteHelper->getPath() . 'media' . DIRECTORY_SEPARATOR . self::DEFAULT_MEDIA_FOLDER . DIRECTORY_SEPARATOR;
                    $originalDir = $localPath . 'original' . DIRECTORY_SEPARATOR;

                    //$productDirs = array('large', 'medium', 'product', 'small');

                    $configTable   = new Application_Model_DbTable_Config();
                    $dbConfig = $configTable->selectConfig();
                    $iniConfig = Zend_Registry::get('misc');

                    $productDirs = array(
                        'small'	 => intval($dbConfig['imgSmall']),
                        'medium' => intval($dbConfig['imgMedium']),
                        'large'	 => intval($dbConfig['imgLarge']),
                        'product' => intval($iniConfig['imgProduct'])
                    );

                    foreach ($productDirs as $type => $size) {
                        $savePath = self::getProductsFilePath($imageName, $mediaFolder, $type);

                        if(file_exists($savePath)){
                            unlink($savePath);
                        }

                        $result = Tools_Image_Tools::resizeByParameters(
                            $originalDir . $imageName,
                            $size,
                            'auto',
                            true,
                            $localPath . $type . DIRECTORY_SEPARATOR
                        );

//                        $fp = fopen($savePath,'x');
//                        fwrite($fp, $decodedImageData);
//                        fclose($fp);
                    }
                }
            }
        } elseif(!empty($data['product']['imageUrl'])){
            $image = str_replace('/small/', '/product/', $data['product']['imageUrl']);
        }

        $templateName = filter_var(trim($data['product']['template']), FILTER_SANITIZE_STRING);
        $template = '';
        if(!empty($templateName)) {
            $existedTemplate = $templateMapper->find($templateName);

            if($existedTemplate instanceof Application_Model_Models_Template) {
                $template = $templateName;
            }
        }

        if(empty($template) && !empty($seosambaposDefaultproductSetting['defaultTemplate'])) {
            $existedTemplate = $templateMapper->find($seosambaposDefaultproductSetting['defaultTemplate']);

            if(!empty($existedTemplate)) {
                $template = $seosambaposDefaultproductSetting['defaultTemplate'];
            }
        }

        if(empty($template)) {
            return array('error' => '1', 'message' => $translator->translate('Default template not assigned in the config or not set in request or not found in system'));
        }

        $productModel = new Models_Model_Product();
        $productModel->setSku($sku);
        $productModel->setMpn($mpn);
        $productModel->setBrand($brand);
        $productModel->setName($productName);
        $productModel->setPrice($price);
        $productModel->setWeight($weight);
        $productModel->setTaxClass($taxC);
        $productModel->setTags($tags);
        $productModel->setInventory($inventory);
        $productModel->setShortDescription($shortDescription);
        $productModel->setFullDescription('');
        $productModel->setProdWidth($dimensionW);
        $productModel->setProdLength($dimensionL);
        $productModel->setProdDepth($dimensionD);
        $productModel->setGtin($gtin);
        $productModel->setCondition($condition);
        $productModel->setPhoto($image);
        $productModel->setPageTemplate($template);

        if(!empty($data['product']['defaultOptions'])) {
            $optionsInLibrary = self::getLibraryOptionsList(array('withoutSelections' => true));

            if(!empty($optionsInLibrary)) {
                foreach ($data['product']['defaultOptions'] as $key => $option) {
                    if(!array_key_exists($option['parentId'], $optionsInLibrary)) {
                        unset($data['product']['defaultOptions'][$key]);
                    }
                }

                $productModel->setDefaultOptions($data['product']['defaultOptions']);
            }
        }
        $productModel->setEnabled(1);

       $product = $productMapper->save($productModel);

       if($product instanceof Models_Model_Product) {
           if(!empty($data['posUserId'])) {
               $seosambaposActiveSession = $seosambaposActiveSessionMapper->findSession($data['posUserId']);

               if(!empty($seosambaposActiveSession)) {
                   $locationId = $seosambaposActiveSession['location_id'];
                   $existedProductLocation = $productLocationsMapper->findLocationByProductIdAndLocationId($product->getId(), $locationId);
                   if(empty($existedProductLocation)) {
                       $productLocationsModel = new Models_Model_ProductLocationsModel();
                       $productLocationsModel->setProductId($product->getId());
                       $productLocationsModel->setLocationId($locationId);
                       $productLocationsModel->setInventory($inventory);
                       $productLocationsModel->setIsDefaultLocation(1);
                       $productLocationsModel->setIsQuickProduct(0);

                       $productLocationsMapper->save($productLocationsModel);
                   }
               }
           }

           $productInfo = array();

           $productInfo['id'] = (string) $product->getId();
           $productInfo['name'] = $product->getName();
           $productInfo['sku'] = $product->getSku();
           $productInfo['shortDescription'] = $product->getShortDescription();
           $productInfo['mpn'] = $product->getMpn();
           $productInfo['gtin'] = $product->getGtin();
           $productInfo['condition'] = $product->getCondition();
           $productInfo['imageUrl'] = self::prepareProductImage($product->getPhoto(), 'small');
           $productInfo['weight'] = (float)$product->getWeight();
           $productInfo['taxClass'] = $product->getTaxClass();
           //product tax
           //@todo add get tax list by zone?
           $taxConfigData = self::getDefaultTaxList($product->getTaxClass());
           $productInfo['tax']['id'] = $taxConfigData['id'];
           $productInfo['tax']['label'] = $taxConfigData['label'];
           $productInfo['tax']['tax_value'] = (float)$taxConfigData['tax_value'];

           $inventory = $product->getInventory();
           if(!is_null($inventory)) {
               $inventory = (int)$inventory;
           }
           $productInfo['inventory'] = $inventory;

           $locationInventories = array();
           $productLocations = $productLocationsMapper->findLocationsByProductId($product->getId());

           $productInfo['locationId'] = '';

           if(!empty($productLocations)) {
               foreach ($productLocations as $pKey => $pLocation){
                   if(!empty($locationId) && $locationId == $pLocation['location_id']) {
                       $productInfo['locationId'] = $pLocation['location_id'];
                   }
                   $locationInventories[$pKey]['locationId'] = $pLocation['location_id'];
                   $locationInventories[$pKey]['locationName'] = $pLocation['name'];
                   $locationInventories[$pKey]['locationAddress'] = (!empty($pLocation['address1'])) ? $pLocation['address1'] : $pLocation['address2'];
                   $locationInventories[$pKey]['inventory'] = (int)$pLocation['inventory'];
               }
           }

           $productInfo['locationInventories'] = $locationInventories;
           $productInfo['dimensions']['width'] = (is_null($product->getProdWidth()) ? 0.00 : (float)$product->getProdWidth());
           $productInfo['dimensions']['length'] = (is_null($product->getProdLength()) ? 0.00 : (float)$product->getProdLength());
           $productInfo['dimensions']['depth'] = (is_null($product->getProdDepth()) ? 0.00 : (float)$product->getProdDepth());

           $productInfo['brand'] = $product->getBrand();
           $productTags = $product->getTags();

           $tags = array();
           if(!empty($productTags)) {
               foreach ($productTags as $productTag) {
                   $tags[] = $productTag['name'];
               }
           }
           $productInfo['tags'] = $tags;

           if ($product->getCurrentPrice() !== null && $product->getExtraProperties()) {
               $product->setCurrentPrice(null);
           }

           $itemDefaultOptionsArray = array();
           $prodOptions = $product->getDefaultOptions();

           if(!empty($prodOptions)) {
               foreach($prodOptions as $option){
                   if(is_array($option['selection'])) {
                       foreach ($option['selection'] as $item) {
                           if($item['isDefault'] == 1){
                               $itemDefaultOptionsArray[$option['id']] = $item['id'];
                           }
                       }
                   }
               }

               //$productInfo['defaultOptions'] = $prodOptions;
           }

           $price = number_format(Tools_ShoppingCart::getInstance()->calculateProductPrice($product, $itemDefaultOptionsArray), 2, '.', '');
           $price = self::calculateProductPriceByZone($data['posUserId'], $productModel, $price);

           $productInfo['price'] = (float)$price;
           $productInfo['nonTaxablePrice'] = (float)$product->getPrice();
           //$productInfo['priceWithCurrency'] = $currency->toCurrency($price);

           $productInfo['additionalImages'] = array();
           $additionalImagesError = false;
           $additionalImagesErrorMsg = '';
           if(!empty($data['product']['additionalImages'])) {
               $additionalImages = Tools_ProductTools::addProductAdditionalPictures(array('productId' => $product->getId(), 'additionalImages' => $data['product']['additionalImages']));

               if(!empty($additionalImages)) {
                   if(empty($additionalImages['error'])) {
                       if(!empty($additionalImages['errorMsg'])) {
                           $additionalImagesError = true;
                           $additionalImagesErrorMsg = $additionalImages['errorMsg'];
                           unset($additionalImages['errorMsg']);
                       }
                       $productInfo['additionalImages'] = $additionalImages;
                   } else {
                       $additionalImagesError = true;
                       $additionalImagesErrorMsg = $additionalImages['message'];
                   }
               }
           }

           if($additionalImagesError) {
               Tools_ProductTools::deleteProduct(array('productId' => $product->getId(), 'forceDelete' => 1, 'posUserId' => $data['posUserId']));
               return array('error' => '1', 'message' => $additionalImagesErrorMsg);
           }

           $data['product']['imageUrl'] = $productInfo['imageUrl'];
           // log action
           $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
           //unset image and additionalImages in log
           $data['product']['image'] = array();
           $data['product']['additionalImages'] = array();

           $additionalContent = json_encode($data);
           Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_ADD_PRODUCT,
               $data['posUserId'], $createdAt, $additionalContent);

           return $productInfo;
       } else {
           return array('error' => '1', 'message' => $translator->translate('Can not create a product. Something went wrong!'));
       }

    }


    /**
     * Update product
     * Required: productId or sku
     *
     * @param $data
     * @return array
     * @throws Zend_Controller_Action_Exception
     * @throws Zend_Exception
     */
    public static function updateProduct($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $websiteUrl = $websiteHelper->getUrl();
        $currency = Zend_Registry::get('Zend_Currency');

        if (empty($data)) {
            return array('error' => '1', 'message' => $translator->translate('Missing query mandatory field(s)'));
        }

        $productMapper = Models_Mapper_ProductMapper::getInstance();
        $templateMapper = Application_Model_Mappers_TemplateMapper::getInstance();
        $seosambaposDefaultproductSettingMapper = Seosambapos_Models_Mappers_SeosambaposDefaultproductSettingMapper::getInstance();
        $seosambaposDefaultproductSetting = $seosambaposDefaultproductSettingMapper->getConfigParams();
        $seosambaposActiveSessionMapper = Seosambapos_Models_Mappers_SeosambaposActiveSessionMapper::getInstance();
        $productLocationsMapper = Models_Mapper_ProductLocationsMapper::getInstance();

        $productId = filter_var(trim($data['product']['id']), FILTER_SANITIZE_NUMBER_INT);
        $sku = filter_var(trim($data['product']['sku']), FILTER_SANITIZE_STRING);

        if(!empty($productId)) {
            $existedProduct = $productMapper->find($productId);

            if(!$existedProduct instanceof Models_Model_Product) {
                return array('error' => '1', 'message' => $translator->translate('Product is not exist. Missing query mandatory productId'));
            }
        } else {
            return array('error' => '1', 'message' => $translator->translate('Product is not exist. Missing query mandatory productId'));
        }

        if(!empty($sku)){
            $existedProductSku = $productMapper->findBySku($sku);

            if($existedProductSku instanceof Models_Model_Product) {
                if($existedProduct->getId() != $existedProductSku->getId()) {
                    return array('error' => '1', 'message' => $translator->translate('SKU already exists for other product'));
                }
            }

            $existedProduct->setSku($sku);
        }

        $brandName = filter_var(trim($data['product']['brand']), FILTER_SANITIZE_STRING);
        $brandName = preg_replace("/[^a-zA-Z0-9\-_\s]/", '', $brandName);
        $brand = '';

        if(!empty($brandName)) {
            $brand = $brandName;
        }

        if(!empty($brand)) {
            $existedProduct->setBrand($brand);
        }

        $mpn = filter_var(trim($data['product']['mpn']), FILTER_SANITIZE_STRING);
        $existedProduct->setMpn($mpn);

        $productName = filter_var(trim($data['product']['name']), FILTER_SANITIZE_STRING);
        if(!empty($productName)) {
            $existedProduct->setName($productName);
        } else {
            return array('error' => '1', 'message' => $translator->translate('product name is empty.'));
        }

        $weight = $data['product']['weight'];

        if(isset($weight)) {
            $existedProduct->setWeight($weight);
        }

        $price = $data['product']['nonTaxablePrice'];
        if(!empty($price)) {
            $existedProduct->setPrice($price);
        }

        $taxClass = filter_var($data['product']['taxClass'], FILTER_SANITIZE_NUMBER_INT);
        $taxC = '';
        if(is_numeric($taxClass)) {
            $taxC = $taxClass;
            if($taxClass > 3) {
                $taxC = '0';
            }
        }

        if($taxC != '') {
            $existedProduct->setTaxClass($taxC);
        }

        $tagNames = $data['product']['tags'];
        $tags = array();
        if(!empty($tagNames)) {
            $preparedTags = $tagNames;
            if(is_array($tagNames)) {
                $preparedTags = implode(',', $tagNames);
            }

            $tags = self::_prepareTag($preparedTags);
        }
        $existedProduct->setTags($tags);

        $requestedInventory = filter_var($data['product']['inventory'], FILTER_SANITIZE_NUMBER_INT);

        if($requestedInventory == '') {
            $requestedInventory = 0;
        }

        if(!empty($data['posUserId'])) {
            $seosambaposActiveSession = $seosambaposActiveSessionMapper->findSession($data['posUserId']);
            $locationId = $seosambaposActiveSession['location_id'];
            $productGlobalInventory = $existedProduct->getInventory();

            if(!empty($seosambaposActiveSession)) {
                $existedProductLocation = $productLocationsMapper->findLocationByProductIdAndLocationId($existedProduct->getId(), $locationId);

                if(isset($requestedInventory)) {
                    $requestedInventory = (int)$requestedInventory;
                }

                if(empty($existedProductLocation)) {
                    $productLocationsModel = new Models_Model_ProductLocationsModel();
                    $productLocationsModel->setProductId($existedProduct->getId());
                    $productLocationsModel->setLocationId($locationId);
                    $productLocationsModel->setInventory($requestedInventory);
                    $productLocationsModel->setIsDefaultLocation(0);
                    $productLocationsModel->setIsQuickProduct(0);

                    $productLocationsMapper->save($productLocationsModel);

                    if(!is_null($productGlobalInventory)) {
                        $productGlobalInventory += $requestedInventory;
                        $existedProduct->setInventory($productGlobalInventory);
                    }
                } elseif (!empty($existedProductLocation) && isset($requestedInventory) && $existedProductLocation['inventory'] != $requestedInventory) {

                    $productLocationsModel = $productLocationsMapper->find($existedProductLocation['id']);
                    $locationInventory = $productLocationsModel->getInventory();
                    $productLocationsModel->setInventory($requestedInventory);

                    $productLocationsMapper->save($productLocationsModel);

                    $allProductLocations = $productLocationsMapper->findLocationsByProductId($existedProduct->getId());

                    //Update global inventory
                    if(count($allProductLocations) > 1) {
                        $allLocationInventory = 0;
                        foreach ($allProductLocations as $productLocation) {
                            $allLocationInventory += $productLocation['inventory'];
                        }

                        if($allLocationInventory > $productGlobalInventory) {
                            $productGlobalInventory = $allLocationInventory;
                        } elseif ($locationInventory > $requestedInventory) {
                            $productGlobalInventory -= $locationInventory - $requestedInventory;

                            if($productGlobalInventory < 0) {
                                $productGlobalInventory = 0;
                            }
                        }
                    } else {
                        if($requestedInventory > $productGlobalInventory) {
                            $productGlobalInventory = $requestedInventory;
                        } elseif ($locationInventory > $requestedInventory) {
                            $productGlobalInventory -= $locationInventory - $requestedInventory;

                            if($productGlobalInventory < 0) {
                                $productGlobalInventory = 0;
                            }
                        }
                    }

                    $existedProduct->setInventory($productGlobalInventory);
                }

                //enable product if disableOutOfStock param is enabled in global shopping config
                $disableOutOfStock = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('disableOutOfStock');
                if(!empty($productGlobalInventory) && !empty($disableOutOfStock)) {
                    $existedProduct->setEnabled(1);
                }
            }
        }

        $shortDescription = $data['product']['shortDescription'];
        $existedProduct->setShortDescription($shortDescription);

        $fullDescription = $data['product']['fullDescription'];
        $existedProduct->setFullDescription($fullDescription);

        $dimensionWidth = preg_replace("/[^0-9.]/", '', $data['product']['dimensions']['width']);
        if(!empty($dimensionWidth)) {
            $existedProduct->setProdWidth($dimensionWidth);
        } else {
            $existedProduct->setProdWidth(0);
        }

        $dimensionLength = preg_replace("/[^0-9.]/", '', $data['product']['dimensions']['length']);
        if(!empty($dimensionLength)) {
            $existedProduct->setProdLength($dimensionLength);
        } else {
            $existedProduct->setProdLength(0);
        }

        $dimensionDepth = preg_replace("/[^0-9.]/", '', $data['product']['dimensions']['depth']);
        if(!empty($dimensionDepth)) {
            $existedProduct->setProdDepth($dimensionDepth);
        } else {
            $existedProduct->setProdDepth(0);
        }

        $gtin = $data['product']['gtin'];
        $existedProduct->setGtin($gtin);

        $condition = $data['product']['condition'];

        if(!empty($condition)) {
            $existedProduct->setCondition($condition);
        } else {
            $existedProduct->setCondition('new');
        }

        $additionalImagesError = false;
        $additionalImagesErrorMsg = '';
        $additionalImagesData = array();
        if(!empty($data['product']['deletedImagesIds'])) {
            $deleteAdditionalImagesError = Tools_ProductTools::deleteProductAdditionalPictures(array('productId' => $productId, 'deletedImagesIds' => $data['product']['deletedImagesIds']));
            if(!empty($deleteAdditionalImagesError)) {
                $additionalImagesError = true;
                $additionalImagesErrorMsg = $deleteAdditionalImagesError . '\n';
            }
        }

        $productInfo['additionalImages'] = array();
        if(!empty($data['product']['additionalImages'])) {
            $additionalImages = Tools_ProductTools::addProductAdditionalPictures(array('productId' => $productId, 'additionalImages' => $data['product']['additionalImages']));

            if(!empty($additionalImages)) {
                if(empty($additionalImages['error'])) {
                    if(!empty($additionalImages['errorMsg'])) {
                        $additionalImagesError = true;
                        $additionalImagesErrorMsg .= $additionalImages['errorMsg'];
                        unset($additionalImages['errorMsg']);
                    }
                    $additionalImagesData = $additionalImages;
                } else {
                    $additionalImagesError = true;
                    $additionalImagesErrorMsg .= $additionalImages['message'];
                }
            }
        } else {
            $additionalImagesData = self::getProductAdditionalPictures(array('productId' => $productId));
        }

        if($additionalImagesError) {
            return array('error' => '1', 'message' => $additionalImagesErrorMsg);
        }

        $image = '';
        if(!empty($data['product']['image']['data'])) {
            $imageExtension = '';
            if(!empty($data['product']['image']['name'])) {
                $imageExtension = pathinfo($data['product']['image']['name'], PATHINFO_EXTENSION);
            }

//            $pattern = '/data:image\/(.+);base64,(.*)/';
//            preg_match($pattern, $data['image'], $matches);
//            $imageExtension = $matches[1];

            if(in_array($imageExtension, self::$_acceptedFileTypesArray, true)) {
                $encodedImageData = $data['product']['image']['data'];
                $decodedImageData = base64_decode($encodedImageData);

                $mediaFolder = self::DEFAULT_MEDIA_FOLDER;
                if(!empty($data['product']['photoFolder'])) {
                    $mediaFolder = $data['product']['photoFolder'];
                }

                $imageName = strtolower(preg_replace("/[^a-zA-Z0-9\-_\s]/", '', $sku)) . time() . '.' . $imageExtension;
                $savePath = self::getProductsFilePath($imageName, $mediaFolder, 'original');

                if(file_exists($savePath)){
                    unlink($savePath);
                }

                $fp = fopen($savePath,'x');
                fwrite($fp, $decodedImageData);
                fclose($fp);
                if (file_exists($savePath)) {
                    $image = $mediaFolder . DIRECTORY_SEPARATOR . $imageName;

                    $localPath = $websiteHelper->getPath() . 'media' . DIRECTORY_SEPARATOR . self::DEFAULT_MEDIA_FOLDER . DIRECTORY_SEPARATOR;
                    $originalDir = $localPath . 'original' . DIRECTORY_SEPARATOR;

                    //$productDirs = array('large', 'medium', 'product', 'small');

                    $configTable   = new Application_Model_DbTable_Config();
                    $dbConfig = $configTable->selectConfig();
                    $iniConfig = Zend_Registry::get('misc');

                    $productDirs = array(
                        'small'	 => intval($dbConfig['imgSmall']),
                        'medium' => intval($dbConfig['imgMedium']),
                        'large'	 => intval($dbConfig['imgLarge']),
                        'product' => intval($iniConfig['imgProduct'])
                    );

                    foreach ($productDirs as $type => $size) {
                        $savePath = self::getProductsFilePath($imageName, $mediaFolder, $type);

                        if(file_exists($savePath)){
                            unlink($savePath);
                        }

                        $result = Tools_Image_Tools::resizeByParameters(
                            $originalDir . $imageName,
                            $size,
                            'auto',
                            true,
                            $localPath . $type . DIRECTORY_SEPARATOR
                        );

//                        $fp = fopen($savePath,'x');
//                        fwrite($fp, $decodedImageData);
//                        fclose($fp);
                    }
                }
            }
        }

        if(!empty($image)) {
            $existedProduct->setPhoto($image);
        }

//        $templateName = filter_var(trim($data['product']['template']), FILTER_SANITIZE_STRING);
//        $template = '';
//        if(!empty($templateName)) {
//            $existedTemplate = $templateMapper->find($templateName);
//
//            if($existedTemplate instanceof Application_Model_Models_Template) {
//                $template = $templateName;
//            }
//        }
//
//        if(!empty($template)) {
//            $existedProduct->setPageTemplate($template);
//        }

//        if(!empty($data['product']['defaultOptions'])) {
//            $optionsInLibrary = self::getLibraryOptionsList(array('withoutSelections' => true));
//
//            if(!empty($optionsInLibrary)) {
//                foreach ($data['product']['defaultOptions'] as $key => $option) {
//                    if(!array_key_exists($option['parentId'], $optionsInLibrary)) {
//                        unset($data['product']['defaultOptions'][$key]);
//                    }
//                }
//
//                $existedProduct->setDefaultOptions($data['product']['defaultOptions']);
//            }
//        }

        $product = $productMapper->save($existedProduct);

        if($product instanceof Models_Model_Product) {
            $productInfo = array();

            $productInfo['id'] = (string) $product->getId();
            $productInfo['name'] = $product->getName();
            $productInfo['sku'] = $product->getSku();
            $productInfo['shortDescription'] = $product->getShortDescription();
            $productInfo['mpn'] = $product->getMpn();
            $productInfo['gtin'] = $product->getGtin();
            $productInfo['condition'] = $product->getCondition();
            $productInfo['imageUrl'] = self::prepareProductImage($product->getPhoto(), 'small');
            $productInfo['weight'] = (float)$product->getWeight();
            $productInfo['taxClass'] = $product->getTaxClass();
            //@todo add get tax list by zone?
            $taxConfigData = self::getDefaultTaxList($product->getTaxClass());
            $productInfo['tax']['id'] = $taxConfigData['id'];
            $productInfo['tax']['label'] = $taxConfigData['label'];
            $productInfo['tax']['tax_value'] = (float)$taxConfigData['tax_value'];

            $inventory = $product->getInventory();
            if(!is_null($inventory)) {
                $inventory = (int)$inventory;
            }
            $productInfo['inventory'] = $inventory;

            $locationInventories = array();
            $productLocations = $productLocationsMapper->findLocationsByProductId($product->getId());

            $productInfo['locationId'] = '';

            if(!empty($productLocations)) {
                foreach ($productLocations as $pKey => $pLocation){
                    if(!empty($locationId) && $locationId == $pLocation['location_id']) {
                        $productInfo['locationId'] = $pLocation['location_id'];
                    }
                    $locationInventories[$pKey]['locationId'] = $pLocation['location_id'];
                    $locationInventories[$pKey]['locationName'] = $pLocation['name'];
                    $locationInventories[$pKey]['locationAddress'] = (!empty($pLocation['address1'])) ? $pLocation['address1'] : $pLocation['address2'];
                    $locationInventories[$pKey]['inventory'] = (int)$pLocation['inventory'];
                }
            }

            $productInfo['locationInventories'] = $locationInventories;
            $productInfo['dimensions']['width'] = (is_null($product->getProdWidth()) ? 0.00 : (float)$product->getProdWidth());
            $productInfo['dimensions']['length'] = (is_null($product->getProdLength()) ? 0.00 : (float)$product->getProdLength());
            $productInfo['dimensions']['depth'] = (is_null($product->getProdDepth()) ? 0.00 : (float)$product->getProdDepth());

            $productInfo['brand'] = $product->getBrand();

            $productTags = $product->getTags();

            $tags = array();
            if(!empty($productTags)) {
                foreach ($productTags as $productTag) {
                    $tags[] = $productTag['name'];
                }
            }
            $productInfo['tags'] = $tags;

            if ($product->getCurrentPrice() !== null && $product->getExtraProperties()) {
                $product->setCurrentPrice(null);
            }

            $itemDefaultOptionsArray = array();
            $prodOptions = $product->getDefaultOptions();

            if(!empty($prodOptions)) {
                foreach($prodOptions as $option){
                    if(is_array($option['selection'])) {
                        foreach ($option['selection'] as $item) {
                            if($item['isDefault'] == 1){
                                $itemDefaultOptionsArray[$option['id']] = $item['id'];
                            }
                        }
                    }
                }

                //$productInfo['defaultOptions'] = $prodOptions;
            }

            $price = number_format(Tools_ShoppingCart::getInstance()->calculateProductPrice($product, $itemDefaultOptionsArray), 2, '.', '');
            $price = self::calculateProductPriceByZone($data['posUserId'], $product, $price);

            $productInfo['price'] = (float)$price;
            $productInfo['nonTaxablePrice'] = (float)$product->getPrice();
            //$productInfo['priceWithCurrency'] = $currency->toCurrency($price);
            $productInfo['additionalImages'] = $additionalImagesData;

            $data['product']['imageUrl'] = $productInfo['imageUrl'];
            // log action
            $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
            //unset image and additionalImages in log
            $data['product']['image'] = array();
            $data['product']['additionalImages'] = array();

            $additionalContent = json_encode($data);
            Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_UPDATE_PRODUCT,
                $data['posUserId'], $createdAt, $additionalContent);

            return $productInfo;
        } else {
            return array('error' => '1', 'message' => $translator->translate('Can not update a product. Something went wrong!'));
        }

    }

    /**
     * return shopping taxes list
     *
     * @param $taxClass
     * @return array|mixed
     * @throws Zend_Exception
     */
    public static function getDefaultTaxList($taxClass = '', $zoneId = 0)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if ($zoneId) {
            $defaultTaxes = Models_Mapper_Tax::getInstance()->findByZoneId($zoneId);
        } else {
            $defaultTaxes = Models_Mapper_Tax::getInstance()->getDefaultRule();
        }

        //$taxes = array('error' => '1', 'message' => $translator->translate('No taxes found in the system'));
        $taxes = array(
            'id' => '',
            'label' => '',
            'tax_value' => 0
        );
        if(!empty($defaultTaxes)) {
            $taxes = array(
                '0' => array('id' => '0', 'label' => $translator->translate('Non taxable')),
                '1' => array('id' => '1', 'label' => $translator->translate('Default')),
                '2' => array('id' => '2', 'label' => $translator->translate('Alternative')),
                '3' => array('id' => '3', 'label' => $translator->translate('Alternative 2'))
            );

            $taxes[0]['tax_value'] = (float)'0';
            $taxes[1]['tax_value'] = (($defaultTaxes->getRate1() === '0.00') ? (float)'0' : (float)$defaultTaxes->getRate1());
            $taxes[2]['tax_value'] = (($defaultTaxes->getRate2() === '0.00') ? (float)'0' : (float)$defaultTaxes->getRate2());
            $taxes[3]['tax_value'] = (($defaultTaxes->getRate3() === '0.00') ? (float)'0' : (float)$defaultTaxes->getRate3());

            if(array_key_exists($taxClass, $taxes)) {
                return $taxes[$taxClass];
            }
        }

        return $taxes;
    }

    /**
     * Return library options
     *
     * @array $data
     * @return array
     */
    public static function getLibraryOptionsList($data)
    {
        $options = Models_Mapper_OptionMapper::getInstance()->fetchAll(array('parentId = ?' => 0), null, false);

        $optionsData = array();
        if(!empty($options)) {
            foreach ($options as $key => $option) {
                if($data['withoutSelections']) {
                    $optionsData[$key]['id'] = $option['id'];
                    $optionsData[$key]['title'] = $option['title'];
                    $optionsData[$key]['type'] = $option['type'];
                } else {
                    $optionsData[$key] = $option;
                }
            }
        }

        return $optionsData;
    }

    public static function getLibraryOptionById($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if (empty($data['libraryOptionId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing libraryOptionId param'));
        }

        $options = Models_Mapper_OptionMapper::getInstance()->find($data['libraryOptionId'], true);

        $optionsData = array();
        if(!empty($options)) {
            $optionsData = $options;
        }

        return $optionsData;
    }

    /**
     * return new Dropdown or Radio default option selection
     *
     * @return array
     */
    public static function getOptionDropdownRadioNewSelection()
    {
        return array(
            'title' => '',
            'priceSign' => '+',
            'priceType' => 'percent',
            'priceValue' => '0.0000',//null
            'weightSign' => '+',
            'weightValue' => '0.0000',//null
            'isDefault' => '0',
        );
    }

    /**
     * Check if product be able to add to checkout
     *
     * @param $data
     * @return array|string[]
     * @throws Zend_Exception
     */
    public static function isProductAvailable($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        $productMapper = Models_Mapper_ProductMapper::getInstance();
        $shoppingConfig = Models_Mapper_ShoppingConfig::getInstance()->getConfigParams();

        if(!empty($data)) {
            foreach ($data as $key => $param) {
                if (empty($param['produuctId'])) {
                    return array('error' => '1', 'message' => $translator->translate('Missing produuctId param'));
                }

                $addProductQty = isset($param['qty']) ? abs(intval($param['qty'])) : 1;
                $product = $productMapper->find($param['produuctId']);

                if($product instanceof Models_Model_Product) {
                    $inStockCount = $product->getInventory();
                    $productDisabled = $product->getEnabled();
                    $productNegativeStock = $product->getNegativeStock();

                    if (!$productDisabled) {
                        return array('error' => '1', 'productId' => $param['produuctId'], 'productSku' => $product->getSku(), 'message' => $translator->translate('This product is not available. Product disabled.'));
                    }

                    if(!empty($shoppingConfig['minimumOrder'])) {
                        $minimumOrder = $product->getMinimumOrder();

                        if($addProductQty < $minimumOrder) {
                            return array(
                                'error' => '1',
                                'productId' => $param['produuctId'],
                                'productSku' => $product->getSku(),
                                'message' => $translator->translate('You can add minimum') . ' ' . $minimumOrder . ' ' . $translator->translate('products')
                            );
                        }

                        if($inStockCount !== null && $addProductQty > $inStockCount) {
                            if(empty($productNegativeStock)) {
                                return array(
                                    'error' => '1',
                                    'productId' => $param['produuctId'],
                                    'productSku' => $product->getSku(),
                                    'message' => $translator->translate('You can\'t buy this product. Products left less than minimum quantity.')
                                );
                            }
                        }
                    }

                    $errMessageOutOfStock = $translator->translate('The requested product is out of stock');
                    $errMessageLimitQty = $translator->translate('The requested quantity is not available');

                    if (!is_null($inStockCount)) {
                        $inStockCount = intval($inStockCount);
                        $inCartCount = 0;

                        if(empty($productNegativeStock)) {
                            if ($inStockCount <= 0) {
                                return array(
                                    'error' => '1',
                                    'productId' => $param['produuctId'],
                                    'productSku' => $product->getSku(),
                                    'stock' => $inStockCount,
                                    'message' => $errMessageOutOfStock
                                );
                            }
                            if ($inStockCount - ($addProductQty + $inCartCount) < 0) {
                                return array(
                                    'error' => '1',
                                    'productId' => $param['produuctId'],
                                    'productSku' => $product->getSku(),
                                    'stock' => $inStockCount,
                                    'message' => $errMessageLimitQty
                                );
                            }
                        }
                    }
                } else {
                    return array('error' => '1', 'productId' => $param['produuctId'], 'message' => $translator->translate('Product not found'));
                }
            }
        }

        return array('error' => '1', 'message' => $translator->translate('Empty params in request'));
    }

    /**
     * Add coupon to cart
     *
     * @param $data
     * @return array|string[]
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     */
    public static function addCouponToCart($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['cartId'])) {
            return array('error' => '1', 'message' => $translator->translate('cartId not provided'));
        }

        if (empty($data['code'])) {
            return array('error' => '1', 'message' => $translator->translate('Coupon name is empty'));
        }

        $cartStorage = Tools_ShoppingCart::getInstance();

        $isAlreadyPaid = Tools_CartTools::verifyIfAlreadyPaid($data['cartId']);
        if ($isAlreadyPaid === true) {
            $cartStorage->clean();
            //@ todo clear cart into reserved cart table
            $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
            $seosambaposReservedCartsMapper->removeReservedCartByCartId($data['cartId']);
            return array('error' => '1', 'message' => $translator->translate('This cart is already paid.'));
        }

        $сouponMapper = Store_Mapper_CouponMapper::getInstance();

        $code = array_unique(explode(' ', $data['code']));
        $coupons = $сouponMapper->findByCode($code);

        $defaultErrorMessage = $translator->translate("Sorry, some coupon codes you provided are invalid or cannot be combined with the ones you've already captured in.");
        $configMapper = Models_Mapper_ShoppingConfig::getInstance();
        $currency = Zend_Registry::get('Zend_Currency');

        if (!empty($coupons)) {
            $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
            $cart = $cartSessionMapper->find($data['cartId']);
            $cartStorage->restoreCartSession($data['cartId']);
            $cartStorage->setCustomerId($cart->getUserId());
            $cartStorage->setShippingAddressKey($cart->getShippingAddressId());
            $cartStorage->setBillingAddressKey($cart->getBillingAddressId());

            if($cartStorage instanceof Tools_ShoppingCart) {
                $cartStorage = Tools_CartTools::getAppliedCouponsInCart($cartStorage, $data['cartId']);

                $service = array('price' => 0);

                $ss = $cart->getShippingService();
                $sp = $cart->getShippingPrice();
                if(!empty($ss) && !empty($sp)) {
                    $service['service'] = $cart->getShippingService();
                    $service['type'] = $cart->getShippingType();
                    $service['price'] = $cart->getShippingPrice();
                }

                $cartStorage->setShippingData($service)->calculate(true);
                $cartStorageData = $cartStorage->saveCartSession();

                $msgCoupons = array();
                $status = Tools_CouponTools::applyCoupons($coupons);
                if (!empty($status)) {
                    if(in_array(Tools_CouponTools::STATUS_FAIL_ONE_TIME_USED, $status)) {
                        $defaultErrorMessage = $translator->translate('Sorry, some coupon codes you provided had already been used.');
                    }

                    $hasErrors = count(array_filter($status, function ($status) {
                        return $status !== true;
                    }));
                    if ($hasErrors) {
                        return array('error' => '1', 'message' => $defaultErrorMessage);
                    }
                }

                $discount = $cartStorage->getDiscount();

                if ($discount) {
                    if($configMapper->getConfigParam('showPriceIncTax')){
                        $discount += $cartStorage->getDiscountTax();
                    }
                    $msgPartOne = $translator->translate('Congratulations, you save');
                    $msgPartTwo = $translator->translate('on this order.');
                    $msgCoupons = array('message' => "$msgPartOne " . $currency->toCurrency($discount) . " $msgPartTwo");
                }

                //processing freeshipping coupons
                if (Tools_CouponTools::processCoupons($cartStorage->getCoupons(), Store_Model_Coupon::COUPON_TYPE_FREESHIPPING)) {
                    $msgCoupons = array('message' => $translator->translate('Congratulations, your order is now available for free shipping.'));
                }

                // log action
//                $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
//                $additionalContent = json_encode($data);
//                Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_ADD_COUPON_TO_CART,
//                    $data['posUserId'], $createdAt, $additionalContent);

                $coupons = $cartStorage->getCoupons();
                if (!empty($coupons)) {
                    $appliedCoupons = array();
                    foreach ($coupons as $coupon) {
                        $appliedCoupons[] = $coupon->getCode();
                    }
                    $msgCoupons['couponCodes'] = implode(',', $appliedCoupons);
                }

                $cart = $cartSessionMapper->find($data['cartId']);

                $productsInCart = Tools_CartTools::getProductsInCart($cart);

                $shippingType = $cart->getShippingType();
                $shippingService = $cart->getShippingService();

                $shippingAddressId = $cart->getShippingAddressId();
                $shippingAddress = array();

                if(!empty($shippingAddressId)) {
                    $shippingAddress = $cartStorage->getAddressById($shippingAddressId);

                    if(!empty($shippingAddress)) {
                        $customerId =  $cart->getUserId();
                        $shippingAddress = Tools_CartTools::getCartShippingAddress($shippingAddress, $customerId);
                    }
                }

                return array(
                    'cartId'          => $data['cartId'],
                    'products'        => !empty($productsInCart) ? $productsInCart : array(),
                    'subTotal'        => round($cartStorageData->getSubTotal(), 2),
                    'discount'        => round($cartStorageData->getDiscount(), 2),
                    'discountTax'     => round($cartStorageData->getDiscountTax(), 2),
                    'shippingPrice'   => is_null($cart->getShippingPrice()) ? 0.00 : round($cart->getShippingPrice(), 2),
                    'shippingType'    => !empty($shippingType) ? $cart->getShippingType() : '',
                    'shippingService' => !empty($shippingService) ? $cart->getShippingService() : '',
                    'shippingAddress' => !empty($shippingAddress) ? $shippingAddress : null,
                    'totalTax'        => round($cartStorageData->getTotalTax(), 2),
                    'total'           => round($cartStorageData->getTotal(), 2),
                    'shippingTax'     => round($cartStorageData->getShippingTax(), 2),
                    'subTotalTax'     => round($cartStorageData->getSubTotalTax(), 2),
                    'couponCodes'     => !empty($msgCoupons['couponCodes']) ? $msgCoupons['couponCodes'] : '',
                    'message'         => !empty($msgCoupons['message']) ? $msgCoupons['message'] : '',
                );
            }

            return array(
                'cartId'          => '0',
                'products'        => array(),
                'subTotal'        => 0.00,
                'discount'        => 0.00,
                'discountTax'     => 0.00,
                'shippingPrice'   => 0.00,
                'shippingType'    => '',
                'shippingService' => '',
                'shippingAddress' => null,
                'totalTax'        => 0.00,
                'total'           => 0.00,
                'shippingTax'     => 0.00,
                'subTotalTax'     => 0.00,
                'couponCodes'     => '',
            );
        } else {
            return array('error' => '1', 'message' => $defaultErrorMessage);
        }
    }

    /**
     * Return product brands list
     *
     * @return array
     * @throws Zend_Exception
     */
    public static function getProductBrandsList()
    {
        $translator = Zend_Registry::get('Zend_Translate');

        $productBrands = Models_Mapper_Brand::getInstance()->getAllBrands();

        if(!empty($productBrands)) {
            return $productBrands;
        }

        return array('error' => '1', 'message' => $translator->translate('Product brands not found in store.'));
    }

    /**
     * Send email receipt
     *
     * @param $data
     * @return array
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     */
    public static function emailReceipt($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if(!empty($data['cartId'])) {
            if (!Zend_Registry::isRegistered('extConfig')) {
                $configTable   = new Application_Model_DbTable_Config();
                Zend_Registry::set('extConfig', $configTable->selectConfig());
            }

            //$seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();
            //$defaultCustomerId = $seosambaposSettingsMapper->getConfigParam('defaultCustomerId');
            $cartSession = Models_Mapper_CartSessionMapper::getInstance()->find($data['cartId']);

            if($cartSession instanceof Models_Model_CartSession) {
                $sessionHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('session');

                $sessionHelper->seosambaposCartSessionKey = $data['cartId'];

                $userId = $cartSession->getUserId();
                $cartStatus = $cartSession->getStatus();
                $cartContent = $cartSession->getCartContent();

                if(empty($data['email'])) {
                    return array('error' => '1', 'message' => $translator->translate('Please provide an email.'));
                }

                $emailIsValid = Tools_System_Tools::isEmailValid(trim($data['email']));
                if (!$emailIsValid) {
                    return array('error' => '1', 'message' => $translator->translate('Not valid email'));
                }

//                if($userId == $defaultCustomerId) {
//                    return array('error' => '1', 'message' => $translator->translate('You can not send emailReceipt to default customer.'));
//                }

                if(!empty($userId) && $cartStatus == Models_Model_CartSession::CART_STATUS_COMPLETED) {
                    $notifiedProductsMapper = Store_Mapper_NotifiedProductsMapper::getInstance();

                    if(!empty($cartContent)) {
                        $productMapper = Models_Mapper_ProductMapper::getInstance();

                        foreach ($cartContent as $cContent) {
                            $productId = $cContent['product_id'];

                            $product = $productMapper->find($productId);
                            $productNegativeStock = $product->getNegativeStock();

                            if(($product->getInventory() == '0' || $product->getInventory() < '0') && empty($productNegativeStock)) {
                                $currentNotifiedProduct = $notifiedProductsMapper->findByUserIdProductId($userId, $productId);

                                if($currentNotifiedProduct instanceof Store_Model_NotifiedProductsModel && $currentNotifiedProduct->getSendNotification() == '1') {
                                    $notifiedProductsMapper->delete($currentNotifiedProduct);
                                }

                                $where = $notifiedProductsMapper->getDbTable()->getAdapter()->quoteInto("product_id = ?", $productId);
                                $allOtherNotifiedProducts = $notifiedProductsMapper->fetchAll($where);

                                if(!empty($allOtherNotifiedProducts)) {
                                    foreach ($allOtherNotifiedProducts as $notifiedProduct) {
                                        if($notifiedProduct->getSendNotification() == '1') {
                                            $notifiedProduct->setSendNotification('0');

                                            $notifiedProductsMapper->save($notifiedProduct);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }


                if ($cartSession->getStatus() !== Models_Model_CartSession::CART_STATUS_PARTIAL) {
                    $orderData = $cartSession->toArray();

                    $links = array();

                    if(!empty($data['links'])) {
                        $links = $data['links'];
                    }

                    $cartSession->registerObserver(new Tools_Mail_Watchdog(array(
                        'trigger' => Tools_SeosambaposMailWatchdog::TRIGGER_SEOSAMBAPOS_EMAILRECEIPT,
                        'observableModel' => $cartSession,
                        'orderData' => $orderData,
                        'links' => $links,
                        'email' => $data['email'],
                        'recipient' => Shopping::ROLE_CUSTOMER
                    )));

                    $cartSession->notifyObservers();

                    unset($sessionHelper->seosambaposCartSessionKey);

                    // log action
                    $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
                    $additionalContent = json_encode($orderData);
                    Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_ORDER_EMAIL_RECEIPT,
                        $data['posUserId'], $createdAt, $additionalContent);

                    return array('message' => $translator->translate('An email has been sent'));
                }
            }
        }

        return array('error' => '1', 'message' => $translator->translate('cartId not found in store.'));
    }

    /**
     * Change customer ID for cart with status "new" and with default customer
     *
     * @param $data
     * @return array
     * @throws Exceptions_SeotoasterException
     * @throws Exceptions_SeotoasterPluginException
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     */
    public static function changeCartCustomerId($data) {
        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['customerId'])) {
            return array('error' => '1', 'message' => $translator->translate('customerId not provided'));
        }

        if(empty($data['cartId'])) {
            return array('error' => '1', 'message' => $translator->translate('cartId not provided'));
        }

        $userMapper = Application_Model_Mappers_UserMapper::getInstance();
        $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();
        $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
        $сouponMapper = Store_Mapper_CouponMapper::getInstance();
        $defaultCustomerId = $seosambaposSettingsMapper->getConfigParam('defaultCustomerId');

//        if(!empty($defaultCustomerId) && $data['customerId'] == $defaultCustomerId) {
//            return array('error' => '1', 'message' => $translator->translate('You can not set default customer'));
//        }

        $userModel = $userMapper->find($data['customerId']);

        if ($userModel instanceof Application_Model_Models_User) {
            $userRole = $userModel->getRoleId();
            if($userRole != Shopping::ROLE_CUSTOMER && $userRole != Tools_Security_Acl::ROLE_MEMBER) {
                return array('error' => '1', 'message' => $translator->translate('customerId does not belong to the customer role'));
            }
        } else {
            return array('error' => '1', 'message' => $translator->translate('customer not found'));
        }

        $cartSession = $cartSessionMapper->find($data['cartId']);

        if($cartSession instanceof Models_Model_CartSession) {
            $cartStorage = Tools_ShoppingCart::getInstance();
            $cartStorage->restoreCartSession($data['cartId']);
            $cartStorage->setCustomerId($cartSession->getUserId());
            $shippingAddress = $cartSession->getShippingAddressId();
            $billingAddress = $cartSession->getBillingAddressId();
            $shippingPrice = $cartSession->getShippingPrice();
            $cartStorage->setShippingAddressKey($shippingAddress);
            $cartStorage->setBillingAddressKey($billingAddress);

            $isAlreadyPaid = Tools_CartTools::verifyIfAlreadyPaid($data['cartId']);
            if ($isAlreadyPaid === true) {
                $cartStorage->clean();
                //@ todo clear cart into reserved cart table
                $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
                $seosambaposReservedCartsMapper->removeReservedCartByCartId($data['cartId']);
                return array('error' => '1', 'message' => $translator->translate('This cart is already paid.'));
            }

            $userId = $cartSession->getUserId();
            $cartStatus = $cartSession->getStatus();

            $allowChangeCustomer = false;
            if($userId == $defaultCustomerId || $userId == $data['customerId']) {
                $allowChangeCustomer = true;
            } elseif ($userId != $data['customerId']) {
                $allowChangeCustomer = true;

                if(!empty($shippingAddress)) {
                    $cartStorage->setShippingAddressKey('');
                    $cartSession->setShippingAddressId('');
                }

                if(!empty($billingAddress)) {
                    $cartStorage->setBillingAddressKey('');
                    $cartSession->setBillingAddressId('');
                }

                if(!empty($shippingPrice)) {
                    $cartSession->setShippingService('');
                    $cartSession->setShippingType('');
                    $cartSession->setShippingPrice(0);
                }
            }

            if($cartStatus == Models_Model_CartSession::CART_STATUS_NEW && $allowChangeCustomer) {
                $cartSession->setUserId($data['customerId']);
                $cartStorage->setCustomerId($data['customerId']);

                $cartSessionMapper->save($cartSession);

                //@ todo clear cart into reserved cart table
                $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
                $seosambaposReservedCartsMapper->removeReservedCartByCartId($data['cartId']);

                // log action
                $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
                $additionalContent = json_encode($data);
                Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_ORDER_CUSTOMER_CHANGE,
                    $data['posUserId'], $createdAt, $additionalContent);

                $cartStorage = Tools_CartTools::getAppliedCouponsInCart($cartStorage, $data['cartId']);

                $service = array('price' => 0);
                $ss = $cartSession->getShippingService();
                $sp = $cartSession->getShippingPrice();
                if(!empty($ss) && !empty($sp)) {
                    $service['service'] = $cartSession->getShippingService();
                    $service['type'] = $cartSession->getShippingType();
                    $service['price'] = $cartSession->getShippingPrice();
                }

                $cartStorage->setShippingData($service);

                $cartStorage->calculate(true);
                $cartStorageData = $cartStorage->saveCartSession();

                $msgCoupons = array();
                $coupons = $сouponMapper->findSalesCouponsByCartId($data['cartId']);
                if(!empty($coupons)) {
                    $appliedCoupons = array();
                    foreach ($coupons as $coupon) {
                        $appliedCoupons[] = $coupon['coupon_code'];
                    }
                    $msgCoupons['couponCodes'] = implode(',', $appliedCoupons);
                }

                $cart = $cartSessionMapper->find($data['cartId']);

                $productsInCart = Tools_CartTools::getProductsInCart($cart);

                $shippingType = $cart->getShippingType();
                $shippingService = $cart->getShippingService();

                $shippingAddressId = $cart->getShippingAddressId();
                $shippingAddress = array();

                if(!empty($shippingAddressId)) {
                    $shippingAddress = $cartStorage->getAddressById($shippingAddressId);

                    if(!empty($shippingAddress)) {
                        $customerId =  $cart->getUserId();
                        $shippingAddress = Tools_CartTools::getCartShippingAddress($shippingAddress, $customerId);
                    }
                }

                if($cartStorageData instanceof Tools_ShoppingCart) {
                    return array(
                        'cartId'          => $data['cartId'],
                        'products'        => !empty($productsInCart) ? $productsInCart : array(),
                        'subTotal'        => round($cartStorageData->getSubTotal(), 2),
                        'discount'        => round($cartStorageData->getDiscount(), 2),
                        'discountTax'     => round($cartStorageData->getDiscountTax(), 2),
                        'shippingPrice'   => is_null($cart->getShippingPrice()) ? 0.00 : round($cart->getShippingPrice(), 2),
                        'shippingType'    => !empty($shippingType) ? $cart->getShippingType() : '',
                        'shippingService' => !empty($shippingService) ? $cart->getShippingService() : '',
                        'shippingAddress' => !empty($shippingAddress) ? $shippingAddress : null,
                        'totalTax'        => round($cartStorageData->getTotalTax(), 2),
                        'total'           => round($cartStorageData->getTotal(), 2),
                        'shippingTax'     => round($cartStorageData->getShippingTax(), 2),
                        'subTotalTax'     => round($cartStorageData->getSubTotalTax(), 2),
                        'couponCodes'     => !empty($msgCoupons['couponCodes']) ? $msgCoupons['couponCodes'] : '',
                    );
                }

                return array(
                    'cartId'          => '0',
                    'products'        => array(),
                    'subTotal'        => 0.00,
                    'discount'        => 0.00,
                    'discountTax'     => 0.00,
                    'shippingPrice'   => 0.00,
                    'shippingType'    => '',
                    'shippingService' => '',
                    'shippingAddress' => null,
                    'totalTax'        => 0.00,
                    'total'           => 0.00,
                    'shippingTax'     => 0.00,
                    'subTotalTax'     => 0.00,
                    'couponCodes'     => '',
                );
            } else {
                return array('error' => '1', 'message' => $translator->translate('Only for cart with the status "new" and with default customer, you can change customerId'));
            }
        }

        return array('error' => '1', 'message' => $translator->translate('Can not change customer for this card'));
    }

    /**
     * Prepare default product options to add to the cart
     *
     * @param Models_Model_Product $product
     * @return array|void
     */
    public static function getDefaultProductOptions(Models_Model_Product $product) {
        $productOptions = $product->getDefaultOptions();
        if (!is_array($productOptions) || empty($productOptions)) {
            return array();
        }
        foreach ($productOptions as $key => $option) {
            if (isset($option['selection']) && is_array($option['selection']) && !empty($option['selection'])) {
                $selections = $option['selection'];
                foreach ($selections as $selectionData) {
                    if (!$selectionData['isDefault']) {
                        continue;
                    }
                    return array(
                        $selectionData['option_id'] => $selectionData['id']
                    );
                }
            } else {
                return array();
            }
        }
    }

    /**
     * Genarate unique storage key
     *
     * @param $item
     * @param $options
     * @return false|string
     */
    public static function generateStorageKey($item, $options = array()) {
        return substr(md5($item->getName() . $item->getSku() . http_build_query($options)), 0, 10);
    }

    public static function prepareFreebies($productFreebiesSettings) {
        $translator = Zend_Registry::get('Zend_Translate');
        $productMapper = Models_Mapper_ProductMapper::getInstance();
        $shoppingConfig = Models_Mapper_ShoppingConfig::getInstance()->getConfigParams();

        $freebiesQuantity = array();
        foreach($productFreebiesSettings as $freebies){
            $freebiesProduct = $productMapper->find($freebies['freebies_id']);
            if($freebiesProduct instanceof Models_Model_Product){
                $inStockCount = $freebiesProduct->getInventory();
                if(!is_null($inStockCount)) {
                    $inStockCount = intval($inStockCount);
                    if ($inStockCount <= 0 || $inStockCount < $freebies['freebies_quantity']) {
                        $errMessageOutOfStock = $translator->translate('The requested product is out of stock');
                        return array('error' => '1', 'message' => $errMessageOutOfStock);
                    }
                }
                $freebiesProducts[$freebiesProduct->getId()] = $freebiesProduct;
                $freebiesQuantity[$freebiesProduct->getId()] = $freebies['freebies_quantity'];
            }
        }
        return array('freebiesProducts' => $freebiesProducts, 'freebiesQuantity' => $freebiesQuantity);
    }

    /**
     * Get product tags by location ID
     *
     * @param $data
     * @return array
     * @throws Zend_Exception
     */
    public static function getProductTagsByLocation($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['locationId'])) {
            return array('error' => '1', 'message' => $translator->translate('locationId not provided'));
        }

        $productLocationsMapper = Models_Mapper_ProductLocationsMapper::getInstance();

        $productIds = $productLocationsMapper->findProductsByLocationId($data['locationId']);

        $tagsInfo[] = array('id' => '', 'name' => '');
        if(!empty($productIds)) {
            $tags = $productLocationsMapper->findTagsByProductId($productIds);

            if(!empty($tags)) {
                $tagsInfo = $tags;
            }
        }

        return $tagsInfo;

        //return array('error' => '1', 'message' => $translator->translate('Products not found for this location'));
    }

    /**
     * Generate successful purchase receipt
     *
     * @param $data
     * @return array|string[]
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     * @throws \Mpdf\MpdfException
     */
    public static function generateReceipt($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $sessionHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');

        if(!empty($data['cartId'])) {
            $cartId = $data['cartId'];

            $isAlreadyPaid = Tools_CartTools::verifyIfAlreadyPaid($cartId);
            if ($isAlreadyPaid === false) {
                return array('error' => '1', 'message' => $translator->translate('This cart is not paid yet.'));
            }

            $seosambaposPurchasesDataMapper = Seosambapos_Models_Mappers_SeosambaposPurchasesDataMapper::getInstance();
            $ifPurchaseDone = $seosambaposPurchasesDataMapper->findByCartId($cartId);

            if(!empty($ifPurchaseDone) && !empty($ifPurchaseDone['receipt'])) {
                return array(
                    'error' => '0',
                    'receipt' => $websiteHelper->getUrl() . 'plugins' . DIRECTORY_SEPARATOR . 'seosambapos' . DIRECTORY_SEPARATOR . 'receipts' . DIRECTORY_SEPARATOR . $ifPurchaseDone['receipt'],
                    'fileName' => $ifPurchaseDone['receipt'],
                    'folder' => $websiteHelper->getPath() . 'plugins' . DIRECTORY_SEPARATOR . 'seosambapos' . DIRECTORY_SEPARATOR . 'receipts' . DIRECTORY_SEPARATOR
                );
            }

            if (!Zend_Registry::isRegistered('extConfig')) {
                $configTable   = new Application_Model_DbTable_Config();
                Zend_Registry::set('extConfig', $configTable->selectConfig());
            }

            $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();

            $receiptTemplate = $seosambaposSettingsMapper->getConfigParam('receiptTemplate');

            if(empty($receiptTemplate)) {
                return array('error' => '1', 'message' => $translator->translate('receiptTemplate is not provided in config.'));
            }

            $templateList = Application_Model_Mappers_TemplateMapper::getInstance()->findByType(Seosambapos::RECEIPT_TEMPLATE_TYPE);

            $templateContent = '';
            if(!empty($templateList)) {
                $existedTemplate = false;
                foreach ($templateList as $template) {
                    if($template->getName() == $receiptTemplate) {
                        $existedTemplate = true;
                        $templateContent = $template->getContent();
                    }
                }

                if(!$existedTemplate) {
                    return array('error' => '1', 'message' => $translator->translate('Template: ') . $receiptTemplate . $translator->translate(' is not found in system. Please create template.'));
                }
            } else {
                return array('error' => '1', 'message' => $translator->translate('receiptTemplate is not provided in config.'));
            }

            $cartSession = Models_Mapper_CartSessionMapper::getInstance()->find($cartId);

            if($cartSession instanceof Models_Model_CartSession) {
                $sessionHelper->storeCartSessionKey = $cartId;
                $sessionHelper->storeCartSessionConversionKey = $cartId;

                $customerDbTable = new Quote_Models_DbTable_ShoppingCustomerAddress();
                $whereBilling = $customerDbTable->getAdapter()->quoteInto(
                    'id = ?',
                    $cartSession->getBillingAddressId()
                );
                $whereShipping = $customerDbTable->getAdapter()->quoteInto(
                    'id = ?',
                    $cartSession->getShippingAddressId()
                );
                $customerShipping = $customerDbTable->getAdapter()->fetchAll(
                    $customerDbTable->select()->from('shopping_customer_address')->where($whereShipping)
                );
                $customerBilling = $customerDbTable->getAdapter()->fetchAll(
                    $customerDbTable->select()->from('shopping_customer_address')->where($whereBilling)
                );
                if (!empty($customerShipping)) {
                    $customerShipping[0]['country'] = self::_prepareCountry($customerShipping[0]['country']);
                    $sessionHelper->customerShippingInvoice = $customerShipping;
                }
                if (!empty($customerBilling)) {
                    $customerBilling[0]['country'] = self::_prepareCountry($customerBilling[0]['country']);
                    $sessionHelper->customerBillingInvoice = $customerBilling;
                }

                $themeData = Zend_Registry::get('theme');
                $pageMapper = Application_Model_Mappers_PageMapper::getInstance();
                $parserOptions = array(
                    'websiteUrl' => $websiteHelper->getUrl(),
                    'websitePath' => $websiteHelper->getPath(),
                    'currentTheme' => $websiteHelper->getConfig('currentTheme'),
                    'themePath' => $themeData['path'],
                );
                $page = $pageMapper->findByUrl('index.html');
                $page = $page->toArray();
                $parser = new Tools_Content_Parser($templateContent, $page, $parserOptions);
                $content = $parser->parse();
                Tools_ShoppingCart::getInstance()->clean();

                $pdfTmpPath = $websiteHelper->getPath() . 'plugins' . DIRECTORY_SEPARATOR . 'seosambapos' . DIRECTORY_SEPARATOR . 'receipts' . DIRECTORY_SEPARATOR;
                require_once($websiteHelper->getPath() . 'plugins' . DIRECTORY_SEPARATOR . 'seosambapos' . DIRECTORY_SEPARATOR.'system/mpdflibrary/vendor/autoload.php');

                $pdfFile = new \Mpdf\Mpdf([
                    'mode' => 'utf-8',
                    'format' => 'A4',
                    'tempDir' => $pdfTmpPath
                ]);
                $pdfFile->WriteHTML($content);

                $pdfFileName = 'Receipt_' . md5($cartId . microtime()) . '.pdf';
                $pdfFilePath = $websiteHelper->getUrl() . 'plugins' . DIRECTORY_SEPARATOR . 'seosambapos' . DIRECTORY_SEPARATOR . 'receipts' . DIRECTORY_SEPARATOR . $pdfFileName;

                $pdfFile->Output($pdfTmpPath . $pdfFileName, 'F');

                unset($sessionHelper->storeCartSessionKey);
                unset($sessionHelper->storeCartSessionConversionKey);
                unset($sessionHelper->customerShippingInvoice);
                unset($sessionHelper->customerBillingInvoice);

                if(!empty($ifPurchaseDone) && $ifPurchaseDone['status'] == Seosambapos_Models_Models_SeosambaposPurchasesDataModel::PURCHASE_STATUS_COMPLETED) {
                    $ifPurchaseDone['receipt'] = $pdfFileName;
                    $seosambaposPurchasesDataModel = new Seosambapos_Models_Models_SeosambaposPurchasesDataModel();

                    $seosambaposPurchasesDataModel->setOptions($ifPurchaseDone);
                    Seosambapos_Models_Mappers_SeosambaposPurchasesDataMapper::getInstance()->save($seosambaposPurchasesDataModel);
                }

                return array(
                    'error' => '0',
                    'receipt' => $pdfFilePath,
                    'fileName' => $pdfFileName,
                    'folder' => $pdfTmpPath
                );
            }
        }

        return array('error' => '1', 'message' => $translator->translate('cartId not found in store.'));
    }

    /**
     * Return country full name
     *
     * @param string $country country code
     * @return mixed
     */
    private static function _prepareCountry($country)
    {
        if (!empty($country)) {
            $countries = Tools_Geo::getCountries(true);
            $country = $countries[$country];
        }
        return $country;
    }


    /**
     * @param $photoSrc
     * @param $newSize
     * @return mixed|string
     */
    public static function prepareProductImage($photoSrc, $newSize = 'product')
    {
        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $websiteUrl = (Zend_Controller_Action_HelperBroker::getStaticHelper('config')->getConfig(
            'mediaServers'
        ) ? Tools_Content_Tools::applyMediaServers($websiteHelper->getUrl()) : $websiteHelper->getUrl());
        if (preg_match('~^https?://.*~', $photoSrc)) {
            $tmp = parse_url($photoSrc);
            $path = explode('/', trim($tmp['path'], '/'));
            if (is_array($path)) {
                $imgName = array_pop($path);
                $guessSize = array_pop($path);
                if (in_array($guessSize, array('small', 'medium', 'large', 'original', 'product')) && $guessSize !== $newSize) {
                    $guessSize = $newSize;
                }
                return $tmp['scheme'] . '://' . implode(
                        '/',
                        array(
                            $tmp['host'],
                            implode('/', $path),
                            $guessSize,
                            $imgName
                        )
                    );
            }
            return $photoSrc;
        } else {
            $photoSrc = str_replace('/', '/' . $newSize . '/', $photoSrc);
            return $websiteUrl . $websiteHelper->getMedia() . $photoSrc;
        }
    }

    /**
     * @param $posUserId
     * @param $productModel
     * @param $price
     * @return float|int
     * @throws Exception
     */
    public static function calculateProductPriceByZone($posUserId, $productModel, $price)
    {
        $shoppingConfig = Models_Mapper_ShoppingConfig::getInstance()->getConfigParams();
        $seosambaposActiveSessionMapper = Seosambapos_Models_Mappers_SeosambaposActiveSessionMapper::getInstance();
        $seosambaposActiveSession = $seosambaposActiveSessionMapper->findSession($posUserId);

        if(!empty($seosambaposActiveSession)) {
            $locId = $seosambaposActiveSession['location_id'];

            if(!empty($locId)) {
                $pickupLocation = Tools_Misc::getLocationsData($locId);

                $destinationAddress = array();
                if(!empty($pickupLocation)) {
                    $destinationAddress['address1'] = $pickupLocation['address1'];
                    $destinationAddress['address2'] = $pickupLocation['address2'];
                    $destinationAddress['zip'] = $pickupLocation['zip'];
                    $destinationAddress['country'] = $pickupLocation['country'];

                    $state = Tools_Geo::getStateByCode($pickupLocation['state']);
                    if(!is_null($state) && !empty($state)) {
                        $destinationAddress['state'] = $state['id'];
                    }

                    $destinationAddress['city'] = $pickupLocation['city'];

                    if(isset($shoppingConfig['showPriceIncTax']) && $shoppingConfig['showPriceIncTax'] === '1'){
                        $origProductTax = Tools_Tax_Tax::calculateProductTax($productModel);
                        $locationProductTax = Tools_Tax_Tax::calculateProductTax($productModel, $destinationAddress);
                        if(!empty($origProductTax)) {
                            $price += $locationProductTax - $origProductTax;
                        } else {
                            $price += $locationProductTax;
                        }
                    }
                }
            }
        }

        return $price;
    }

    /**
     * @param $data
     * @return array|void
     * @throws Zend_Exception
     */
    public static function addProductAdditionalPictures($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');

        $productId = filter_var(trim($data['productId']), FILTER_SANITIZE_NUMBER_INT);
        $productMapper = Models_Mapper_ProductMapper::getInstance();
        $productImagesMapper = Productimages_Mapper_ProductImagesMapper::getInstance();

        if(!empty($productId)) {
            $existedProduct = $productMapper->find($productId);
            if($existedProduct instanceof Models_Model_Product) {
                if(!empty($data['additionalImages']) && is_array($data['additionalImages'])) {
                    $folder = $productId;
                    $imageFolder = trim(preg_replace('~[^\w]+|[\s\-]+~ui', '-', filter_var($folder, FILTER_SANITIZE_STRING)), '-');
                    $clearPathToDirectory = Productimages_Tools_Filesystem::getSavePath($imageFolder);
                    $pathToDirectory = Productimages_Tools_Filesystem::getSavePath($imageFolder, Productimages_Tools_Filesystem::IMG_ORIGINAL);
                    if (!$pathToDirectory) {
                        return array('error' => '1', 'message' => $translator->translate('Directory doesn\'t exist'));
                    }

                    $processErrors = array();
                    foreach ($data['additionalImages'] as $image) {
                        if(empty($image['data'])) {
                            continue;
                        }
                        $imageExtension = '';
                        if(!empty($image['name'])) {
                            $imageExtension = pathinfo($image['name'], PATHINFO_EXTENSION);
                        }

                        $fileName = pathinfo($image['name'], PATHINFO_FILENAME);
                        $imageName = strtolower(preg_replace("/[^a-zA-Z0-9\-_\s]/", '', $fileName)) . '.' . $imageExtension;

                        if(in_array($imageExtension, self::$_acceptedFileTypesArray, true)) {
                            $productImagesModel = $productImagesMapper->findByFileName($productId, $imageName);
                            if ($productImagesModel instanceof Productimages_Model_ProductImagesModel) {
                                $processErrors[] = $translator->translate('Image with such name') . ' ' . $imageName . ' ' . $translator->translate('already exists');
                                continue;
                            }

                            $encodedImageData = $image['data'];
                            $decodedImageData = base64_decode($encodedImageData);

                            $fp = fopen($pathToDirectory . DIRECTORY_SEPARATOR . $imageName,'x');
                            fwrite($fp, $decodedImageData);
                            fclose($fp);

                            $status = Tools_Image_Tools::batchResize($pathToDirectory . DIRECTORY_SEPARATOR. $imageName, $clearPathToDirectory. DIRECTORY_SEPARATOR);

                            $thumbnailsDirectory = Productimages_Tools_Filesystem::getSavePath($imageFolder. DIRECTORY_SEPARATOR, Productimages_Tools_Filesystem::IMG_THUMBNAILS);
                            $cropDirectory = Productimages_Tools_Filesystem::getSavePath($imageFolder. DIRECTORY_SEPARATOR, Productimages_Tools_Filesystem::IMG_CROP);

                            $useCrop = true;
                            $thumbSize = Productimages_Tools_Filesystem::DEFAULT_THUMB_SIZE;

                            Tools_Image_Tools::resizeByParameters(
                                $pathToDirectory . DIRECTORY_SEPARATOR . $imageName,
                                $thumbSize,
                                'auto',
                                !($useCrop),
                                $thumbnailsDirectory,
                                $useCrop
                            );

                            Tools_Image_Tools::resizeByParameters(
                                $pathToDirectory . DIRECTORY_SEPARATOR . $imageName,
                                $thumbSize,
                                'auto',
                                !($useCrop),
                                $cropDirectory,
                                $useCrop
                            );

                            $productImagesModel = new Productimages_Model_ProductImagesModel();
                            $productImagesModel->setFileName($imageName);
                            $productImagesModel->setOrderNumber(0);
                            $productImagesModel->setProductId($productId);
                            $productImagesMapper->save($productImagesModel);

                        } else {
                            $processErrors[] = $translator->translate('Image'). ' ' . $image['name'] . ' have ' . $translator->translate('prohibited image extension');
                        }
                    }

                    if(!empty($processErrors)) {
                        $errorText = '';
                        foreach ($processErrors as $error) {
                            $errorText .= $error .'\n';
                        }

                        $data = self::getProductAdditionalPictures($data);
                        $data['errorMsg'] = $errorText;

                        return $data;
                    }

                    return self::getProductAdditionalPictures($data);
                }
            }
        }
        return array();
    }

    /**
     * @param $data
     * @return array
     * @throws Zend_Exception
     */
    public static function getProductAdditionalPictures($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $websiteUrl = $websiteHelper->getUrl();
        $productId = filter_var(trim($data['productId']), FILTER_SANITIZE_NUMBER_INT);

        $resultData = array();

        if(!empty($productId)) {
            $productImagesMapper = Productimages_Mapper_ProductImagesMapper::getInstance();
            $where = $productImagesMapper->getDbTable()->getAdapter()->quoteInto('ppf.product_id = ?', $productId);
            $data = $productImagesMapper->fetchAll($where);

            if(!empty($data['data'])) {
                foreach ($data['data'] as $key => $imageData) {
                    $imageUrl = $websiteUrl.'plugins/productimages/web/images/product-images/'.$imageData['product_id'].'/thumbnails/'.$imageData['file_name'];
                    $resultData[$key]['id'] = $imageData['id'];
                    //$resultData[$key]['productId'] = $imageData['product_id'];
                    $resultData[$key]['imageUrl'] = $imageUrl;
                    //$resultData[$key]['fileName'] = $imageData['file_name'];
                    //$resultData[$key]['orderNumber'] = $imageData['order_number'];
                }
            }
        }

        return $resultData;
    }

    /**
     * @param $data
     * @return array
     * @throws Zend_Exception
     */
    public static function deleteProductAdditionalPictures($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if(!empty($data['deletedImagesIds'])) {
            $productImagesMapper = Productimages_Mapper_ProductImagesMapper::getInstance();

            $errorMsg = array();
            foreach ($data['deletedImagesIds'] as $imageId) {
                $productImagesModel = $productImagesMapper->find($imageId);

                if ($productImagesModel instanceof Productimages_Model_ProductImagesModel) {
                    $productImageName = $productImagesModel->getFileName();
                    $productId = $productImagesModel->getProductId();
                    $folderPath = Productimages_Tools_Filesystem::getSavePath($productId. DIRECTORY_SEPARATOR);

                    if($data['productId'] != $productId) {
                        return array('error' => '1', 'message' => $translator->translate('prooductId does not belong to this product.'));
                    }

                    try {
                        // removing image from filesystem
                        if (($result = Productimages_Tools_Filesystem::removeImageFromFilesystem($productImageName, $productId)) !== true) {
                            $errorMsg[] = $translator->translate('Can not delete'). ' ' . $productImageName . '\n';
                        }

                        $productImagesMapper->delete($imageId);
                        //cleaning up the file system if needed
                        $folderContent = Tools_Filesystem_Tools::scanDirectory($folderPath, false, true);
                        if (empty($folderContent)) {
                            try {
                                Tools_Filesystem_Tools::deleteDir($folderPath);
                            } catch (Exception $e) {
                                $errorMsg[] = $e->getMessage() . '\n';
                            }
                        }
                    } catch (Exceptions_SeotoasterException $e) {
                        $errorMsg[] = $e->getMessage() . '\n';
                    }
                }
            }

            $errorText = '';
            if(!empty($errorMsg)) {
                foreach ($errorMsg as $error) {
                    $errorText .= $error .'\n';
                }
            }

            return $errorText;
        }

        return '';
    }

    /**
     * @param $data
     * @return array|void
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Exception
     */
    public static function deleteProduct($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        $productMapper = Models_Mapper_ProductMapper::getInstance();
        $productId = filter_var(trim($data['productId']), FILTER_SANITIZE_NUMBER_INT);

        if(!empty($productId)) {
            $existedProduct = $productMapper->find($productId);

            if(!$existedProduct instanceof Models_Model_Product) {
                return array('error' => '1', 'message' => $translator->translate('Product is not exist.'));
            }

            $productLocationsMapper = Models_Mapper_ProductLocationsMapper::getInstance();
            $seosambaposActiveSessionMapper = Seosambapos_Models_Mappers_SeosambaposActiveSessionMapper::getInstance();
            $seosambaposActiveSession = $seosambaposActiveSessionMapper->findSession($data['posUserId']);
            if(!empty($seosambaposActiveSession)) {
                $locationId = $seosambaposActiveSession['location_id'];

                $productLocations = $productLocationsMapper->findLocationsByProductId($productId);

                $belongsToTheLocation = false;
                $countLocations = 0;
                $existedProductLocationId = 0;
                if(!empty($productLocations)) {
                    foreach ($productLocations as $pKey => $pLocation){
                        $countLocations += 1;
                        if($pLocation['location_id'] == $locationId) {
                            $belongsToTheLocation = true;
                            $existedProductLocationId = $pLocation['id'];
                        }
                    }
                }
            }

            $responceData = array();

            if(!empty($data['forceDelete'])) {
                if (!$belongsToTheLocation) {
                    return array('error' => '1', 'message' => $translator->translate('You can not delete this product, the product does not belong to this location.'));
                }

                if($countLocations > 1) {
                    //set inventory to 0
                    if(!empty($existedProductLocationId)) {
                        $productLocationsModel = $productLocationsMapper->find($existedProductLocationId);
                        if($productLocationsModel instanceof Models_Model_ProductLocationsModel) {
                            $productLocationsModel->setInventory(0);
                            $productLocationsMapper->save($productLocationsModel);

                            // log action
                            $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
                            $additionalContent = json_encode($data);
                            Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_DELETE_LOCATION_INVENTORY_PRODUCT,
                                $data['posUserId'], $createdAt, $additionalContent);

                            $responceData['productStatus'] = 'active';
                            $responceData['needConfirm'] = false;
                            $responceData['confirmMessage'] = '';

                            return $responceData;
                        }
                    }

                    return array('error' => '1', 'message' => $translator->translate('You can not delete this product, the product does not belong to this location.'));
                } else {
                    //remove product
                    $productMapper->delete($existedProduct);

                    // log action
                    $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
                    $additionalContent = json_encode($data);
                    Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_DELETE_PRODUCT,
                        $data['posUserId'], $createdAt, $additionalContent);

                    $responceData['productStatus'] = 'deleted';
                    $responceData['needConfirm'] = false;
                    $responceData['confirmMessage'] = '';

                    return $responceData;
                }
            } else {
                $confirmMessage = $translator->translate('You are attempting to delete this product. This action is performed at your own risk and may result in the loss of important historical data, including past purchases and reporting records. Proceed only if you fully understand the consequences.');

                $salesCount = $productMapper->fetchProductSalesCount($productId);
                $hasSales = false;

                $statuses = array(Models_Model_CartSession::CART_STATUS_COMPLETED, Models_Model_CartSession::CART_STATUS_SHIPPED, Models_Model_CartSession::CART_STATUS_DELIVERED, Models_Model_CartSession::CART_STATUS_PARTIAL);
                if(!empty($salesCount)) {
                    foreach ($salesCount as $key => $sale) {
                        if(in_array($sale['status'], $statuses)) {
                            $hasSales = true;
                        }
                    }
                }

                if($belongsToTheLocation) {
                    if($countLocations == 1) {
                        if(!$hasSales) {
                            //remove product
                            $productMapper->delete($existedProduct);

                            // log action
                            $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
                            $additionalContent = json_encode($data);
                            Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_DELETE_PRODUCT,
                                $data['posUserId'], $createdAt, $additionalContent);

                            $responceData['productStatus'] = 'deleted';
                            $responceData['needConfirm'] = false;
                            $responceData['confirmMessage'] = '';

                            return $responceData;
                        } else {
                            //show confirm message
                            $responceData['productStatus'] = 'active';
                            $responceData['needConfirm'] = true;
                            $responceData['confirmMessage'] = $confirmMessage;

                            return $responceData;
                        }
                    } elseif ($countLocations > 1) {
                        if(!$hasSales) {
                            //set inventory to 0
                            if(!empty($existedProductLocationId)) {
                                $productLocationsModel = $productLocationsMapper->find($existedProductLocationId);
                                if($productLocationsModel instanceof Models_Model_ProductLocationsModel) {
                                    $productLocationsModel->setInventory(0);
                                    $productLocationsMapper->save($productLocationsModel);

                                    // log action
                                    $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
                                    $additionalContent = json_encode($data);
                                    Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_DELETE_LOCATION_INVENTORY_PRODUCT,
                                        $data['posUserId'], $createdAt, $additionalContent);

                                    $responceData['productStatus'] = 'active';
                                    $responceData['needConfirm'] = false;
                                    $responceData['confirmMessage'] = '';

                                    return $responceData;
                                }
                            }

                            return array('error' => '1', 'message' => $translator->translate('You can not delete this product, the product does not belong to this location.'));
                        } else {
                            //show confirm message
                            $responceData['productStatus'] = 'active';
                            $responceData['needConfirm'] = true;
                            $responceData['confirmMessage'] = $confirmMessage;

                            return $responceData;
                        }
                    }
                } else {
                    return array('error' => '1', 'message' => $translator->translate('You can not delete this product, the product does not belong to this location.'));
                }
            }

        } else {
            return array('error' => '1', 'message' => $translator->translate('Product is not exist. Missing query mandatory productId'));
        }
    }

}

