<?php

class Tools_LocationsTools
{

    /**
     * Get location list
     *
     * @return void
     */
    public static function getLocations($locationId = '')
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $seosambaposTerminalLocationsMapper = Seosambapos_Models_Mappers_SeosambaposTerminalLocationsMapper::getInstance();
        $pickupLocations = Tools_Misc::getLocationsData($locationId);

        $resultLocations = array('error' => '1', 'message' => $translator->translate('Nothing to found'));
        if(!empty($pickupLocations)) {
            if(!empty($locationId)) {
                $pickupLocations = array($pickupLocations);
            }

            $seosambaposActiveSessionMapper = Seosambapos_Models_Mappers_SeosambaposActiveSessionMapper::getInstance();
            $countryListNames = Tools_Geo::countryListNames();
            $activeSesionData = $seosambaposActiveSessionMapper->findAllActiveSession();
            $cashRegisterList = Tools_LocationsTools::getCashRegisterList(true);

            $seosambaposLoggedUserLogMapper = Seosambapos_Models_Mappers_SeosambaposLoggedUserLogMapper::getInstance();

            foreach ($pickupLocations as $lKey => $pLocation) {
                if(empty($pLocation['cash_register_id'])) {
                    unset($pickupLocations[$lKey]);
                    continue;
                }

                $tLocationParams = array();
                $tLocationParams[] = $pLocation['name'];
                $tLocationParams[] = $pLocation['address1'];
                //$tLocationParams[] = $pLocation['address2'];
                $tLocationParams[] = $pLocation['city'];
                $tLocationParams[] = $pLocation['zip'];

                $country = array_search($pLocation['country'], $countryListNames);
                $tLocationParams[] = $country;
                $pLocation['countryAbbr'] = $country;

                $tLocationParams[] = $pLocation['state'];

                $locationParamsToHash = implode('', $tLocationParams);
                $localHash = md5($locationParamsToHash);

                $locationState = $pLocation['state'];
                $state = Tools_Geo::getStateByCode($pLocation['state']);
                if(!is_null($state) && !empty($state)) {
                    $pLocation['state'] = $state['id'];
                }

                $zoneId = Tools_Tax_Tax::getZone($pLocation, false);

                $pickupLocations[$lKey]['defaultTaxList'] = Tools_ProductTools::getDefaultTaxList('', $zoneId);

                $pLocation['state'] = $locationState;
                $terminalLocation = $seosambaposTerminalLocationsMapper->findByLocationId($pLocation['id']);

                $terminalId = '';
                $terminalLocationData = array();
                if(!empty($terminalLocation)) {
                    $locationAddressHash = $terminalLocation['location_address_hash'];

                    if($localHash != $locationAddressHash) {
                        $terminalId = $terminalLocation['terminal_id'];

                        if(!empty($terminalId)) {
                            //$terminalLocationData = array();
                            $terminalLocationData = Tools_StripeTools::updateStripeTerminalLocation($terminalId, $pLocation);
                        }
                    } else {
                        //$terminalId = $terminalLocation['terminal_id'];
                        //retreive location
                        $terminalLocationMojoDataId = '';
                        $terminalLocationMojo = Tools_StripeOAuthTools::getStripeTerminalLocationMojo(array('location_id' => $terminalLocation['terminal_id']));

                        if(!empty($terminalLocationMojo)) {
                            $terminalLocationMojoData = json_decode($terminalLocationMojo, true);
                            if(!empty($terminalLocationMojoData)) {
                                $terminalLocationMojoData = (object) $terminalLocationMojoData;

                                if(!empty($terminalLocationMojoData)) {
                                    $terminalLocationMojoDataId = $terminalLocationMojoData->id;
                                }
                            }
                        }

                        if(!empty($terminalLocationMojoDataId)) {
                            $terminalId = $terminalLocationMojoDataId;
                        } else {
                            $seosambaposTerminalLocationsMapper->deleteByTerminalId($terminalLocation['terminal_id']);

                            $terminalLocationData = Tools_StripeTools::createStripeTerminalLocation($pLocation);
                        }
                    }
                } else {
                    //$terminalLocationData = array();
                    $terminalLocationData = Tools_StripeTools::createStripeTerminalLocation($pLocation);
                }

                if(!empty($terminalLocationData) && empty($terminalLocationData['error'])) {
                    $terminalId = $terminalLocationData['id'];

                    $terminalLocationModel = new Seosambapos_Models_Models_SeosambaposTerminalLocationsModel();

                    if(!empty($terminalLocation['id'])) {
                        $terminalLocationModel->setId($terminalLocation['id']);
                    }

                    $terminalLocationModel->setPickupLocationId($pLocation['id']);
                    $terminalLocationModel->setLocationAddressHash($localHash);
                    $terminalLocationModel->setTerminalId($terminalId);

                    $seosambaposTerminalLocationsMapper->save($terminalLocationModel);
                }

                $pickupLocations[$lKey]['terminalLocationId'] = $terminalId;

                $pickupLocations[$lKey]['cashRegisters'] = array();
                if(!empty($pLocation['cash_register_id'])) {
                    $locationRegisterIds = explode(',', $pLocation['cash_register_id']);

                    if(!empty($locationRegisterIds)) {
                        $cashRegisters = array();
                        foreach ($locationRegisterIds as $key => $registerId) {
                            $statusSession = false;
                            foreach ($activeSesionData as $aSession) {
                                if($pLocation['id'] == $aSession['location_id'] && $registerId == $aSession['cash_register_id']) {
                                    $statusSession = true;
                                }
                            }

                            $cashRegisters[] = array(
                                'id' => $registerId,
                                'label' => $cashRegisterList[$registerId],
                                'status' => $statusSession,
                            );
                        }

                        $pickupLocations[$lKey]['cashRegisters'] = $cashRegisters;
                    }
                }

                $lastConnected = $seosambaposLoggedUserLogMapper->getLastConnectedLocation($pLocation['id']);

                if(!empty($lastConnected)) {
                    $lastConnected = date("d/m/Y", strtotime($lastConnected));
                }
                $pickupLocations[$lKey]['lastConnected'] = $lastConnected;
            }

            $resultLocations = $pickupLocations;
        }

        return $resultLocations;

    }

    /**
     * return CashRegisterList
     *
     * @return array
     */
    public static function getCashRegisterList($getPairs = false)
    {
        $seosambaposCashRegistersConfigMapper = Seosambapos_Models_Mappers_SeosambaposCashRegistersConfigMapper::getInstance();

        if($getPairs) {
            $seosambaposCashRegistersPairsData = $seosambaposCashRegistersConfigMapper->getPairsData();
        } else {
            $seosambaposCashRegistersPairsData = $seosambaposCashRegistersConfigMapper->getAllData();
        }

        $cashRegisterList = array();

        if(!empty($seosambaposCashRegistersPairsData)) {
            $cashRegisterList = $seosambaposCashRegistersPairsData;
        }

        return $cashRegisterList;
    }

}