<?php

class Tools_CustomerTools
{

    /**
     * Serch customer by email
     *
     * @return void
     */
    public static function searchCustomer($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $customerMapper = Models_Mapper_CustomerMapper::getInstance();
        $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();
        $defaultCustomerId = $seosambaposSettingsMapper->getConfigParam('defaultCustomerId');

        if(!empty($data['query'])) {
            $where = '(' . $customerMapper->getDbTable()->getAdapter()->quoteInto('email LIKE ?', $data['query']. '%');
            $where .= ' OR ' . $customerMapper->getDbTable()->getAdapter()->quoteInto('full_name LIKE ?', '%' . $data['query']. '%');
            $where .= ' OR ' . $customerMapper->getDbTable()->getAdapter()->quoteInto(new Zend_Db_Expr('CONCAT(mobile_country_code_value, "", mobile_phone) LIKE ?'), '%' . $data['query'] . '%');
            $where .= ' OR ' . $customerMapper->getDbTable()->getAdapter()->quoteInto(new Zend_Db_Expr('CONCAT(desktop_country_code_value, "", desktop_phone) LIKE ?'), '%' . $data['query'] . '%');

            $where .= ') AND ' . $customerMapper->getDbTable()->getAdapter()->quoteInto('role_id IN (?)', array(Shopping::ROLE_CUSTOMER, Tools_Security_Acl::ROLE_MEMBER));

            $customers = $customerMapper->listAll($where);
            if(!empty($customers)) {
                $customerData = array();
                foreach ($customers as $key => $customer) {
                    if(!empty($defaultCustomerId) && $defaultCustomerId == $customer['id']) {
                        continue;
                    }

                    $mobileCountryPhoneCode = Zend_Locale::getTranslation($customer['mobile_country_code'], 'phoneToTerritory');
                    $mobileCountryCodeValue = '+'.$mobileCountryPhoneCode;

                    $desktopCountryPhoneCode = Zend_Locale::getTranslation($customer['desktop_country_code'], 'phoneToTerritory');
                    $desktopCountryCodeValue = '+'.$desktopCountryPhoneCode;

                    $phoneMobile = $mobileCountryCodeValue . $customer['mobile_phone'];
                    $phoneDesktop = $desktopCountryCodeValue . $customer['desktop_phone'];

                    $foundMobile = strpos($phoneMobile, $data['query']);
                    $foundDesktop = strpos($phoneDesktop, $data['query']);

                    $phone = $phoneMobile;
                    $foundByPhone = false;
                    if($foundDesktop !== false) {
                        $foundByPhone = true;
                        $phone = $phoneDesktop;
                    }
                    if($foundMobile !== false) {
                        $foundByPhone = true;
                        $phone = $phoneMobile;
                    }

                    if(!$foundByPhone) {
                        $phone = '';

                        if(!empty($desktopCountryPhoneCode) && !empty($customer['desktop_phone'])) {
                            $phone = $phoneDesktop;
                        }

                        if(!empty($mobileCountryPhoneCode) && !empty($customer['mobile_phone'])) {
                            $phone = $phoneMobile;
                        }
                    }

                    $customerData[$key]['id']                = $customer['id'];
                    $customerData[$key]['fullName']          = $customer['full_name'];
                    $customerData[$key]['email']             = $customer['email'];
                    $customerData[$key]['phone']             = $phone;
                    $customerData[$key]['mobileCountryCode'] = $customer['mobile_country_code'];
                    $customerData[$key]['isSubscribe']       = !empty($customer['subscribed']) ? true : false;
                }

                if(!empty($customerData)) {
                    return array_values($customerData);
                }
            }
        }

        return array(
            'error' => '1',
            'message' => $translator->translate('Customer not found')
        );
    }

    /**
     * Get default customer from seosambapos general config
     *
     * @return void
     */
    public static function getDefaultCustomer()
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();
        $customerMapper = Models_Mapper_CustomerMapper::getInstance();

        $defaultCustomerId = $seosambaposSettingsMapper->getConfigParam('defaultCustomerId');

        if(!empty($defaultCustomerId)) {
            $where = $customerMapper->getDbTable()->getAdapter()->quoteInto('user.id = ?', $defaultCustomerId);
            $customers = $customerMapper->listAll($where);

            if(!empty($customers)) {
                $customerData = array();
                foreach ($customers as $key => $customer) {
                    $mobileCountryPhoneCode = Zend_Locale::getTranslation($customer['mobile_country_code'], 'phoneToTerritory');
                    $mobileCountryCodeValue = '+'.$mobileCountryPhoneCode;

                    $customerData['id']                = $customer['id'];
                    $customerData['fullName']          = $customer['full_name'];
                    $customerData['email']             = $customer['email'];
                    $customerData['phone']             = $mobileCountryCodeValue . $customer['mobile_phone'];
                    $customerData['mobileCountryCode'] = $customer['mobile_country_code'];
                    $customerData['isSubscribe']       = !empty($customer['subscribed']) ? true : false;
                }
                return $customerData;
            } else {
                return array('error' => '1', 'message' => $translator->translate('Default customer was deleted, please reassign the customer in config.'));
            }
        }

        return array('error' => '1', 'message' => $translator->translate('Default customer not assigned in the config'));
    }

    /**
     * Add new customer or return existed customer by email
     *
     * @return void
     */
    public static function addCustomer($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $userMapper = Application_Model_Mappers_UserMapper::getInstance();
        $customerEmail = $data['email'];
        $existedCustomer = $userMapper->findByEmail($customerEmail);
        if(!$existedCustomer instanceof Application_Model_Models_User) {
            $data['mobilePhone'] = Tools_System_Tools::cleanNumber($data['phone']);
            $data['desktopPhone'] = Tools_System_Tools::cleanNumber($data['desktopPhone']);
            if (!empty($data['mobileCountryCode'])) {
                $mobileCountryPhoneCode = Zend_Locale::getTranslation($data['mobileCountryCode'], 'phoneToTerritory');
                $data['mobile_country_code_value'] = '+'.$mobileCountryPhoneCode;
            } else {
                $data['mobile_country_code_value'] = null;
            }
            if (!empty($data['desktopCountryCode'])) {
                $mobileCountryPhoneCode = Zend_Locale::getTranslation($data['desktopCountryCode'], 'phoneToTerritory');
                $data['desktop_country_code_value'] = '+'.$mobileCountryPhoneCode;
            } else {
                $data['desktop_country_code_value'] = null;
            }

            $data['roleId'] = Shopping::ROLE_CUSTOMER;
            $data['fullName'] = $data['firstName'] . ' ' . $data['lastName'];

            $user = new Application_Model_Models_User($data);


            if($data['isSubscribe'] == true) {
                $user->setSubscribed('1');
            }

            $userMapper->save($user);

            unset($data['password']);
            // log action
            $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
            $additionalContent = json_encode($data);
            Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_ADD_CUSTOMER,
                $data['posUserId'], $createdAt, $additionalContent);
        }

        if(!empty($customerEmail)) {
            $customerData = self::searchCustomer(array('query' => $customerEmail));

            if(!empty($customerData['error'])) {
                if($existedCustomer instanceof Application_Model_Models_User) {
                    if($existedCustomer->getRoleId() != Shopping::ROLE_CUSTOMER || $existedCustomer->getRoleId() != Tools_Security_Acl::ROLE_MEMBER) {
                        return array(
                            'error' => '1',
                            'message' => $translator->translate('The customer already exists and has another role in the system')
                        );
                    }
                }
                return $customerData;
            }

            return array_shift($customerData);
        }

        return array(
            'error' => '1',
            'message' => $translator->translate('Can not create a customer')
        );
    }

    public static function getShippingCustomerAddresses($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['customerId'])) {
            return array('error' => '1', 'message' => $translator->translate('Can not found a customer'));
        }

        $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();
        $customerMapper = Models_Mapper_CustomerMapper::getInstance();
        $defaultCustomerId = $seosambaposSettingsMapper->getConfigParam('defaultCustomerId');

//        if(!empty($defaultCustomerId) && $data['customerId'] == $defaultCustomerId) {
//            return array('error' => '1', 'message' => $translator->translate('Can not get addresses list for default customer'));
//        }

        $customer = $customerMapper->find($data['customerId']);

        if(!empty($customer)) {
            $shippingAddressListData = array();
            $shippingAddressList = array();
            $pickupLocationAddresses = Store_Mapper_PickupLocationConfigMapper::getInstance()->getUserAddressByUserId($data['customerId']);
            $countryList = Tools_Geo::getCountries(true);

            $addressList = $customer->getAddresses();

            if(!empty($addressList)) {
                $customerAddressId = '';
                $defaultCustomerAddressData = $seosambaposSettingsMapper->findCustomerAddressByCustomerId($data['customerId']);
                if(!empty($defaultCustomerAddressData)) {
                    $customerAddressId = $defaultCustomerAddressData['customer_address_id'];
                }

                $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();

                foreach ($addressList as $key => $shippingAddress) {
                    $shippingAddressListPrepare = array();
                    $state = Tools_Geo::getStateById($shippingAddress['state']);
                    if($shippingAddress['address_type'] === Models_Model_Customer::ADDRESS_TYPE_SHIPPING && !in_array($shippingAddress['id'], $pickupLocationAddresses)) {
                        $cartAddresses = $cartSessionMapper->findAllAddressesByCustomerIdAndAddressId($data['customerId'], $shippingAddress['id'], 'shipping');

                        $isPickup = false;
                        if(!empty($cartAddresses)) {
                            foreach ($cartAddresses as $cartAddress) {
                                if($cartAddress['shipping_service'] == 'pickup' /* && $cartAddress['status'] == Models_Model_CartSession::CART_STATUS_COMPLETED */) {
                                    $isPickup = true;
                                }
                            }
                        }

                        if($isPickup) {
                            continue;
                        }

                        $shippingAddressListPrepare['id'] = $shippingAddress['id'];

                        //@todo if default customer address has in config
                        $defaultCustomerAddress = false;
                        if(!empty($customerAddressId) && $customerAddressId == $shippingAddress['id']) {
                            $defaultCustomerAddress = true;
                        }

                        $shippingAddressListPrepare['isDefaultCustomerAddress'] = $defaultCustomerAddress;

                        $shippingAddressListPrepare['streetAddress'] = $shippingAddress['address1'].' '. $shippingAddress['address2'];
                        $shippingAddressListPrepare['locality'] = Tools_ShippingTools::prepareLocality($shippingAddress);
                        $shippingAddressListPrepare['region'] = $state['state'];
                        $shippingAddressListPrepare['postalCode'] = $shippingAddress['zip'];

                        $shippingAddressListPrepare['country'] = '';
                        if(!empty($shippingAddress['country'])) {
                            if(in_array($shippingAddress['country'], $countryList)){
                                $shippingAddressListPrepare['country'] = array_search($shippingAddress['country'], $countryList);
                            }
                            if(array_key_exists($shippingAddress['country'], $countryList)){
                                $shippingAddressListPrepare['country'] = $shippingAddress['country'];
                            }
                        }

                        $shippingAddressListPrepare['email'] = $shippingAddress['email'];

                        $shippingAddressListPrepare['company'] = '';
                        if (!empty($shippingAddress['company'])) {
                            $shippingAddressListPrepare['company'] = $shippingAddress['company'];
                        }

                        $shippingAddressListPrepare['phone'] = '';
                        if (!empty($shippingAddress['phone'])) {
                            $shippingAddressListPrepare['phone'] = $shippingAddress['phone_country_code_value'] . $shippingAddress['phone'];
                        }

                        $shippingAddressListPrepare['mobile'] = '';
                        if (!empty($shippingAddress['mobile'])) {
                            $shippingAddressListPrepare['mobile'] = $shippingAddress['mobile_country_code_value'] . $shippingAddress['mobile'];
                        }
                    }

                    if(!empty($shippingAddressListPrepare)) {
                        $shippingAddressList[] = $shippingAddressListPrepare;
                    }
                }
            }

            $shippingAddressListData['addresses'] = $shippingAddressList;

            return $shippingAddressListData;
        }

        return array('error' => '1', 'message' => $translator->translate('Customer not found'));

    }

    public static function subscribeCustomer($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        $userMapper = Application_Model_Mappers_UserMapper::getInstance();
        $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();
        $customerId = $data['customerId'];
        $defaultCustomerId = $seosambaposSettingsMapper->getConfigParam('defaultCustomerId');

        if(!empty($defaultCustomerId) && $customerId == $defaultCustomerId) {
            return array('error' => '1', 'message' => $translator->translate('You can not subscribe default customer'));
        }

        $userModel = $userMapper->find($customerId);
        if ($userModel instanceof Application_Model_Models_User) {
            $userRole = $userModel->getRoleId();

            if($userRole != Tools_Security_Acl::ROLE_ADMIN && $userRole != Tools_Security_Acl::ROLE_SUPERADMIN) {
                $userModel->setSubscribed('1');
                $userModel->setPassword(null);
                $userMapper->save($userModel);

                // log action
//                $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
//                $additionalContent = json_encode($data);
//                Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_SUBSCRIBE_CUSTOMER,
//                    $data['posUserId'], $createdAt, $additionalContent);

                return array('message' => $translator->translate('Subscribed'));
            }

            return array('error' => '1', 'message' => $translator->translate('Can not subscribe customer who has admin or superadmin role.'));
        }

        return array('error' => '1', 'message' => $translator->translate('Can not subscribe customer. The customer is not found in the system'));
    }


}

