<?php
class Tools_ConfigTools
{

    /*
    * Get General config default customer
    */
    public static function getDefaultCustomerConfig()
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();
        $defaultCustomerId = $seosambaposSettingsMapper->getConfigParam('defaultCustomerId');

        $customerMapper = Models_Mapper_CustomerMapper::getInstance();
        $where = $customerMapper->getDbTable()->getAdapter()->quoteInto('role_id = ?', Shopping::ROLE_CUSTOMER);
        $defaultCustomers = $customerMapper->listAll($where);

        if(!empty($defaultCustomers)) {
            $clientsData = array(
                'defaultCustomerId' => '',
                'customersList' => array()
            );

            foreach ($defaultCustomers as $customer) {
                if($customer['id'] == $defaultCustomerId) {
                    $clientsData['defaultCustomerId'] = $defaultCustomerId;
                }
                $clientsData['customersList'][] = array(
                    'id' => $customer['id'],
                    'fullName' => $customer['full_name'],
                    'email' => $customer['email'],
                );
            }

            return $clientsData;
        }

        return array('error' => '1', 'message' => $translator->translate('No clients were found in the system'));
    }

    /*
     * Get General config default salesperson
     */
    public static function getDefaultSalespersonConfig()
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();
        $defaultSalespersonId = $seosambaposSettingsMapper->getConfigParam('defaultSalespersonId');

        $customerMapper = Models_Mapper_CustomerMapper::getInstance();
        $where = $customerMapper->getDbTable()->getAdapter()->quoteInto('role_id = ?', Shopping::ROLE_SALESPERSON);
        $defaultSalespersons = $customerMapper->listAll($where);

        if(!empty($defaultSalespersons)) {
            $clientsData = array(
                'defaultSalespersonId' => '',
                'salespersonsList' => array()
            );

            foreach ($defaultSalespersons as $salesperson) {
                if($salesperson['id'] == $defaultSalespersonId) {
                    $clientsData['defaultSalespersonId'] = $defaultSalespersonId;
                }
                $clientsData['salespersonsList'][] = array(
                    'id' => $salesperson['id'],
                    'fullName' => $salesperson['full_name'],
                    'email' => $salesperson['email'],
                );
            }

            return $clientsData;
        }

        return array('error' => '1', 'message' => $translator->translate('No salespersons were found in the system'));
    }

    /*
     * Get General config receipt template
     */
    public static function getReceiptTemplateConfig()
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();
        $receiptTemplate = $seosambaposSettingsMapper->getConfigParam('receiptTemplate');

        $templateList = Application_Model_Mappers_TemplateMapper::getInstance()->findByType(Seosambapos::RECEIPT_TEMPLATE_TYPE);

        if(!empty($templateList)) {
            $receiptTemplatesData = array(
                'receiptTemplate' => '',
                'receiptTemplateList' => array()
            );

            foreach ($templateList as $template) {
                if($template->getName() == $receiptTemplate) {
                    $receiptTemplatesData['receiptTemplate'] = $receiptTemplate;
                }
                $receiptTemplatesData['receiptTemplateList'][] = $template->getName();
            }

            return $receiptTemplatesData;
        }

        return array('error' => '1', 'message' => $translator->translate('No receipt templates were found in the system'));
    }

    /*
     * Get Default product config brand
     */
    public static function getDefaultProductBrandConfig()
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $defaultProductSettingsMapper = Seosambapos_Models_Mappers_SeosambaposDefaultproductSettingMapper::getInstance();
        $defaultBrandId = $defaultProductSettingsMapper->getConfigParam('defaultBrandId');

        $brandMapper = Models_Mapper_Brand::getInstance();
        $brands = $brandMapper->getAllBrands();

        if(!empty($brands)) {
            $brandsData = array(
                'brandId' => '',
                'brandsList' => array()
            );
            foreach ($brands as $brandId => $brand) {
                if($brandId == $defaultBrandId) {
                    $brandsData['brandId'] = $brandId;
                }
                $brandsData['brandsList'][] = array(
                    'id' => $brandId,
                    'name' => $brand,
                );
            }

            return $brandsData;
        }

        return array('error' => '1', 'message' => $translator->translate('No brands were found in the system'));
    }

    /*
     * Get Default product config tax
     */
    public static function getDefaultProductTaxConfig()
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $defaultProductSettingsMapper = Seosambapos_Models_Mappers_SeosambaposDefaultproductSettingMapper::getInstance();
        $defaultTaxId = $defaultProductSettingsMapper->getConfigParam('defaultTaxId');

        $defaultTaxes = Models_Mapper_Tax::getInstance()->getDefaultRule();
        $defaultTaxesData = array(
            '0' => $translator->translate('Non taxable'),
            '1' => $translator->translate('Default'),
            '2' => $translator->translate('Alternative'),
            '3' => $translator->translate('Alternative 2')
        );

        if(!empty($defaultTaxes)) {
            $defaultTaxesData[1] .= ' '.(($defaultTaxes->getRate1() === '0.00') ? 0 : $defaultTaxes->getRate1()).' %';
            $defaultTaxesData[2] .= ' '.(($defaultTaxes->getRate2() === '0.00') ? 0 : $defaultTaxes->getRate2()).' %';
            $defaultTaxesData[3] .= ' '.(($defaultTaxes->getRate3() === '0.00') ? 0 : $defaultTaxes->getRate3()).' %';
        }

        if(!empty($defaultTaxes)) {
            $taxesData = array(
                'taxId' => '',
                'taxList' => array()
            );

            foreach ($defaultTaxesData as $taxId => $tax) {
                if($taxId == $defaultTaxId) {
                    $taxesData['taxId'] = $defaultTaxId;
                }
                $taxesData['taxList'][] = array(
                    'id' => $taxId,
                    'name' => $tax
                );
            }

            return $taxesData;
        }

        return array('error' => '1', 'message' => $translator->translate('No taxes were found in the system'));
    }

    /*
    * Get Default product config brand
    */
    public static function getDefaultProductTemplateConfig()
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $defaultProductSettingsMapper = Seosambapos_Models_Mappers_SeosambaposDefaultproductSettingMapper::getInstance();
        $defaultTemplate = $defaultProductSettingsMapper->getConfigParam('defaultTemplate');

        $templateList = Application_Model_Mappers_TemplateMapper::getInstance()->findByType(Application_Model_Models_Template::TYPE_PRODUCT);

        if(!empty($templateList)) {
            $productTemplatesData = array(
                'defaultProductTemplate' => '',
                'defaultProductTemplateList' => array()
            );

            foreach ($templateList as $template) {
                if($template->getName() == $defaultTemplate) {
                    $productTemplatesData['defaultProductTemplate'] = $defaultTemplate;
                }
                $productTemplatesData['defaultProductTemplateList'][] = $template->getName();
            }

            return $productTemplatesData;
        }

        return array('error' => '1', 'message' => $translator->translate('No product templates were found in the system'));
    }

}