<?php

class Tools_CartTools
{

    /**
     * Get cart or create new.
     *
     * @param $data
     * @return array
     * @throws Exceptions_SeotoasterException
     * @throws Exceptions_SeotoasterPluginException
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     */
    public static function getCart($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        $activeSessionData = Tools_SeosambaPosTools::sessionStatus($data);

        $cashierId = null;
        $cashierLabel = null;
        $locationId = null;
        $posUserId = $data['posUserId'];

        if(!empty($activeSessionData)) {
            if(!empty($activeSessionData['cashRegister'])) {
                $cashierId = $activeSessionData['cashRegister']['id'];
                $cashierLabel = $activeSessionData['cashRegister']['label'];
            }

            if(!empty($activeSessionData['location'])) {
                foreach ($activeSessionData['location'] as $location) {
                    $locationId = $location['id'];
                }
            }

            $data['cashierId'] = $cashierId;
            $data['cashierLabel'] = $cashierLabel;
            $data['locationId'] = $locationId;
        }

//        error_log('GET CART');
//        error_log(print_r($data, true));

        if(!empty($locationId) && !empty($cashierId)) {
            $cart = Tools_ShoppingCart::getInstance();
            $customerMapper = Models_Mapper_CustomerMapper::getInstance();
            $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
            $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();
            $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
            $сouponMapper = Store_Mapper_CouponMapper::getInstance();

            $reservedCart = $seosambaposReservedCartsMapper->findCartByLocationIdAndCashierId($locationId, $cashierId);

            $defaultCustomerId = $seosambaposSettingsMapper->getConfigParam('defaultCustomerId');

            if(empty($defaultCustomerId)) {
                return array('error' => '1', 'message' => $translator->translate('Default customer not assigned in the config'));
            }

            $existingCustomer = $customerMapper->find($defaultCustomerId);

            if($reservedCart instanceof Seosambapos_Models_Models_SeosambaposReservedCartsModel) {
                $cartId = $reservedCart->getCartId();
//                error_log('GET CART ID');
//                error_log($cartId);

                $cartSession = $cartSessionMapper->find($cartId);

                if($cartSession instanceof Models_Model_CartSession) {
                    if($cartSession->getStatus() == Models_Model_CartSession::CART_STATUS_NEW && $cartSession->getUserId() == $defaultCustomerId) {
                        if($existingCustomer instanceof Models_Model_Customer) {
                            $cart->restoreCartSession($cartId);
                            $cart->setCartId($cartId);
                            $cart = self::getAppliedCouponsInCart($cart, $cartId);

                            $service = array('price' => 0);

                            $ss = $cartSession->getShippingService();
                            $sp = $cartSession->getShippingPrice();
                            if(!empty($ss) && !empty($sp)) {
                                $service['service'] = $cartSession->getShippingService();
                                $service['type'] = $cartSession->getShippingType();
                                $service['price'] = $cartSession->getShippingPrice();
                            }

                            $cart->setShippingData($service);

                            $cart->setCustomerId($existingCustomer->getId());
                            $cart->setShippingAddressKey($cartSession->getShippingAddressId());
                            $cart->setBillingAddressKey($cartSession->getBillingAddressId());
                            $cart->calculate(true);
                            $cartObj = $cart->save()->saveCartSession($existingCustomer);

                            if($cartObj instanceof Tools_ShoppingCart) {
                                $cartId = $cartObj->getCartId();

                                $msgCoupons = array();
                                $coupons = $сouponMapper->findSalesCouponsByCartId($cartId);
                                if(!empty($coupons)) {
                                    $appliedCoupons = array();
                                    foreach ($coupons as $coupon) {
                                        $appliedCoupons[] = $coupon['coupon_code'];
                                    }
                                    $msgCoupons['couponCodes'] = implode(',', $appliedCoupons);
                                }

                                $productsInCart = self::getProductsInCart($cartSession);

                                $shippingType = $cartSession->getShippingType();
                                $shippingService = $cartSession->getShippingService();
                                $shippingAddressId = $cartSession->getShippingAddressId();
                                $shippingAddress = array();

                                if(!empty($shippingAddressId)) {
                                    $shippingAddress = $cart->getAddressById($shippingAddressId);

                                    if(!empty($shippingAddress)) {
                                        $customerId =  $cartSession->getUserId();
                                        $shippingAddress = self::getCartShippingAddress($shippingAddress, $customerId);
                                    }
                                }

                                $cartStorageData = $cart;

                                return array(
                                    'cartId'          => $cartId,
                                    'products'        => !empty($productsInCart) ? $productsInCart : array(),
                                    'subTotal'        => round($cartStorageData->getSubTotal(), 2),
                                    'discount'        => round($cartStorageData->getDiscount(), 2),
                                    'discountTax'     => round($cartStorageData->getDiscountTax(), 2),
                                    'shippingPrice'   => is_null($cartSession->getShippingPrice()) ? 0.00 : round($cartSession->getShippingPrice(), 2),
                                    'shippingType'    => !empty($shippingType) ? $cartSession->getShippingType() : '',
                                    'shippingService' => !empty($shippingService) ? $cartSession->getShippingService() : '',
                                    'shippingAddress' => !empty($shippingAddress) ? $shippingAddress : null,
                                    'totalTax'        => round($cartStorageData->getTotalTax(), 2),
                                    'total'           => round($cartStorageData->getTotal(), 2),
                                    'shippingTax'     => round($cartStorageData->getShippingTax(), 2),
                                    'subTotalTax'     => round($cartStorageData->getSubTotalTax(), 2),
                                    'couponCodes'     => !empty($msgCoupons['couponCodes']) ? $msgCoupons['couponCodes'] : '',
                                );
                            }

                            return array('error' => '1', 'message' => $translator->translate('Can not save cart.'));
                        }

                        return array('error' => '1', 'message' => $translator->translate('Existed customer not found in system.'));
                    } else {
                        //@ todo clear cart into reserved cart table
                        $seosambaposReservedCartsMapper->removeReservedCartByCartId($cartId);

                        if($existingCustomer instanceof Models_Model_Customer) {
                            $cart->setCartId(null);
                            $cart->setContent(array());
                            $cart->setCustomerId($existingCustomer->getId())->calculate(true);
                            $cartObj = $cart->save()->saveCartSession($existingCustomer);

                            if($cartObj instanceof Tools_ShoppingCart) {
                                return self::_createCart($cartObj, $cart, $cashierId, $cashierLabel, $locationId, $posUserId);
                            }

                            return array('error' => '1', 'message' => $translator->translate('Can not save new cart.'));
                        }

                        return array('error' => '1', 'message' => $translator->translate('Existed customer not found in system.'));
                    }
                }

                return array('error' => '1', 'message' => $translator->translate('Can not get reserved cart.'));
            } else {
                if($existingCustomer instanceof Models_Model_Customer) {
                    $cart->setCartId(null);
                    $cart->setCustomerId($existingCustomer->getId())->calculate(true);
                    $cartObj = $cart->save()->saveCartSession($existingCustomer);

                    if($cartObj instanceof Tools_ShoppingCart) {
                       return self::_createCart($cartObj, $cart, $cashierId, $cashierLabel, $locationId, $posUserId);
                    }

                    return array('error' => '1', 'message' => $translator->translate('Can not save new cart.'));
                }

                return array('error' => '1', 'message' => $translator->translate('Existed customer not found in system.'));
            }
        }

        return array('error' => '1', 'message' => $translator->translate('Not found location_id or cashier_id'));
    }

    /**
     * Add product to cart
     *
     * @param $data
     * @return array|string[]|void
     * @throws Exceptions_SeotoasterException
     * @throws Exceptions_SeotoasterPluginException
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     */
    public static function addProductToCart($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data)) {
            return array('error' => '1', 'message' => $translator->translate('Requested params are empty.'));
        }

        if(empty($data['cartId'])) {
            return array('error' => '1', 'message' => $translator->translate('cartId is empty.'));
        }

        $cartStorage = Tools_ShoppingCart::getInstance();
        $сouponMapper = Store_Mapper_CouponMapper::getInstance();

        $isAlreadyPaid = self::verifyIfAlreadyPaid($data['cartId']);
        if ($isAlreadyPaid === true) {
            $cartStorage->clean();
            //@ todo clear cart into reserved cart table
            $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
            $seosambaposReservedCartsMapper->removeReservedCartByCartId($data['cartId']);
            return array('error' => '1', 'message' => $translator->translate('This cart is already paid.'));
        }

        $productMapper = Models_Mapper_ProductMapper::getInstance();
        $shoppingConfig = Models_Mapper_ShoppingConfig::getInstance()->getConfigParams();

        if(!empty($data['productId'])) {
            $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
            $cart        = $cartSessionMapper->find($data['cartId']);

            if(empty($data['quickSaleProduct'])) {
                $seosambaposActiveSessionMapper = Seosambapos_Models_Mappers_SeosambaposActiveSessionMapper::getInstance();
                $seosambaposActiveSession = $seosambaposActiveSessionMapper->findSession($data['posUserId']);

                $locationId = '';
                if(!empty($seosambaposActiveSession)) {
                    $locationId = $seosambaposActiveSession['location_id'];
                }

                if(!empty($locationId)) {
                    $pickupLocationMapper = Store_Mapper_PickupLocationMapper::getInstance();
                    $pickupLocation = $pickupLocationMapper->find($data['locationId']);

                    if($pickupLocation instanceof Store_Model_PickupLocation) {
                        $stateName = '';
                        $st = $pickupLocation->getState();
                        if(!empty($st)) {
                            $state = Tools_Geo::getStateByCode($st);
                            if(!empty($state)) {
                                $stateName = $state['name'];
                            }
                        }

                        $addressData = array(
                            'customerId' => $cart->getUserId(),
                            'address' => array(
                                'isDefaultCustomerAddress' => false,//true
                                'address1' => $pickupLocation->getAddress1(),
                                'address2' => $pickupLocation->getAddress2(),
                                'city' => $pickupLocation->getCity(),
                                'zip' => $pickupLocation->getZip(),
                                'country' => $pickupLocation->getCountry(),
                                'state' => $stateName,
                            ),
                        );

                        $result = self::addShippingAddress($addressData, 'pickup');
                        if(!empty($result['error'])) {
                            return $result;
                        }

                        $shippingAddressId = $result['id'];
                        $cart->setShippingAddressId($shippingAddressId);
                        $cart->setBillingAddressId($result['billingAddressId']);

                        $cart->setShippingService('pickup');

                        $cartSessionMapper->save($cart);
                    }
                }
            }

            $cartStorage->restoreCartSession($data['cartId']);
            $cartStorage->setCustomerId($cart->getUserId());
            $cartStorage->setShippingAddressKey($cart->getShippingAddressId());
            $cartStorage->setBillingAddressKey($cart->getBillingAddressId());

            $productId = $data['productId'];
            $options = array();

            if(!empty($data['selectedOptions'])) {
                $options = $data['selectedOptions'];
            }

            $addCount = isset($data['productQty']) ? abs(intval($data['productQty'])) : 1;

            if (!$productId) {
                return array('error' => '1', 'message' => $translator->translate('Can\'t add to cart: product not defined'));
            }

            $product = $productMapper->find($productId);

            if($product instanceof Models_Model_Product) {
                $product->setCurrentPrice(floatval($product->getPrice()));

                $inStockCount = $product->getInventory();

                //$productDisabled = $product->getEnabled();
                $productNegativeStock = $product->getNegativeStock();

//                if (!$productDisabled) {
//                    return array('error' => '1', 'message' => $translator->translate('This product is disabled'));
//                }

                if(!empty($shoppingConfig['minimumOrder'])) {
                    $minimumOrder = $product->getMinimumOrder();

                    if($addCount < $minimumOrder) {
                        return array('error' => '1', 'message' => $translator->translate('You can add minimum') . ' ' . $minimumOrder . ' ' . $translator->translate('products'));
                    }

                    if($inStockCount !== null && $addCount > $inStockCount) {
                        if(empty($productNegativeStock)) {
                            return array('error' => '1', 'message' => $translator->translate('You can\'t buy this product. Products left less than minimum quantity.'));
                        }
                    }
                }

                if(!empty($options)) {
                    $preparedOptions = array();
                    foreach ($options as $option) {
                        $preparedOptions[$option['optionId']] = $option['optionValue'];
                    }

                    if(!empty($preparedOptions)) {
                        $options = $preparedOptions;
                    }
                } else {
                    $options = Tools_ProductTools::getDefaultProductOptions($product);
                }

                $sid = Tools_ProductTools::generateStorageKey($product, $options);
                if (null !== ($cartItem = $cartStorage->findBySid($sid))) {
                    $inCartCount = $cartItem['qty'];
                } else {
                    $inCartCount = 0;
                }

                $customInventory = Tools_Misc::applyInventory($productId, $options, $addCount + $inCartCount, Tools_InventoryObserver::INVENTORY_IN_STOCK_METHOD);

                $errMessageOutOfStock = $translator->translate('The requested product is out of stock');
                $errMessageLimitQty = $translator->translate('The requested quantity is not available');

                if ($customInventory['error'] === true) {
                    if (!empty($customInventory['stock'])) {
                        return array('error' => '1', 'message' => $errMessageLimitQty);
                    }
                    return array('error' => '1', 'message' => $errMessageOutOfStock);
                }

                if (!is_null($inStockCount)) {
                    $inStockCount = intval($inStockCount);
                    if (null !== ($cartItem = $cartStorage->find($productId))) {
                        $inCartCount = $cartItem['qty'];
                    } else {
                        $inCartCount = 0;
                    }

                    if(empty($productNegativeStock)) {
                        if ($inStockCount <= 0) {
                            return array('error' => '1', 'message' => $errMessageOutOfStock);
                        }
                        if ($inStockCount - ($addCount + $inCartCount) < 0) {
                            return array('error' => '1', 'message' => $errMessageLimitQty);
                        }
                    }
                }

                if (isset($shoppingConfig['throttleTransactions']) && $shoppingConfig['throttleTransactions'] === 'true' && Tools_Misc::checkThrottleTransactionsLimit() === false) {
                    $throttleTransactionsLimitMessage = $shoppingConfig['throttleTransactionsLimitMessage'];
                    $throttleTransactionsLimitMessage = !empty($throttleTransactionsLimitMessage) ? $throttleTransactionsLimitMessage : Tools_Misc::THROTTLE_TRANSACTIONS_DEFAULT_MESSAGE;

                    return array('error' => '1', 'message' => $throttleTransactionsLimitMessage);
                }

                $productFreebiesSettings = Models_Mapper_ProductFreebiesSettingsMapper::getInstance()->getFreebies($productId);
                $freebiesProducts = array();
                if(!empty($productFreebiesSettings)){
                    if($productFreebiesSettings[0]['quantity'] == 0 && $productFreebiesSettings[0]['price_value'] != 0){
                        if($productFreebiesSettings[0]['price_value'] <= $cartStorage->getTotal()){
                            $freebiesProducts = Tools_ProductTools::prepareFreebies($productFreebiesSettings);
                        }
                    }elseif($productFreebiesSettings[0]['price_value'] == 0 && $productFreebiesSettings[0]['quantity'] != 0){
                        if($productFreebiesSettings[0]['quantity'] <= $addCount){
                            $freebiesProducts = Tools_ProductTools::prepareFreebies($productFreebiesSettings);
                        }
                    }elseif($productFreebiesSettings[0]['quantity'] <= $addCount && $productFreebiesSettings[0]['price_value'] <= $cartStorage->getTotal()){
                        $freebiesProducts = Tools_ProductTools::prepareFreebies($productFreebiesSettings);
                    }
                }

                if(!empty($freebiesProducts)){
                    if(!empty($freebiesProducts['error'])) {
                        return array('error' => '1', 'message' => $freebiesProducts['message']);
                    }

                    if(!empty($freebiesProducts['freebiesProducts'])) {
                        foreach($freebiesProducts['freebiesProducts'] as $prodId =>$freebiesProduct){
                            $itemKey = Tools_ProductTools::generateStorageKey($freebiesProduct, array(0 => 'freebies_'.$productId));
                            if(!$cartStorage->findBySid($itemKey)){
                                $freebiesProduct->setFreebies(1);
                                $cartStorage->add($freebiesProduct, array(0 => 'freebies_'.$productId), $freebiesProducts['freebiesQuantity'][$prodId]);
                            }
                        }
                    }
                }

                $cartContent = $cartStorage->getContent();
                $cartContentData = array();

                foreach($cartContent as $key => $item) {
                    if(!empty($item['product_id'])) {
                        $productIdCheck = $item['product_id'];
                    } else {
                        $productIdCheck = $item['id'];
                    }


                    $productCheck = Models_Mapper_ProductMapper::getInstance()->find($productIdCheck);

                    $optionsSelected = array();
                    foreach ($item['options'] as $opt) {
                        if(!empty($opt['id'])) {
                            $optionsSelected[$opt['option_id']] = $opt['id'];
                        } else if(!empty($opt['title'])){
                            $optionsSelected[$opt['option_id']] = $opt['title'];
                        }
                    }

                    if(!empty($optionsSelected)) {
                        $item['options'] = $optionsSelected;
                    }

                    $optionsCheck = ($item['options']) ? $item['options'] : Tools_ProductTools::getDefaultProductOptions($productCheck);
                    $sidCheck = Tools_ProductTools::generateStorageKey($productCheck, $optionsCheck);

                    if($item['product_id'] != $productId || $sidCheck != $sid) {
                        $cartContentData[$sidCheck] = $cartContent[$key];
                        continue;
                    }

                    if($sidCheck == $sid) {
                        $addCount += $item['qty'];
                    }
                    unset($cartContent[$key]);
                }

                $cartContent = $cartContentData;
                $cartStorage->setContent($cartContent);

                if(empty($data['idDefaultProduct'])) {
                    $productQty = isset($data['productQty']) ? abs(intval($data['productQty'])) : 1;

                    $cartLocationInventoryStatus = self::processCartLocationInventory($data['cartId'], $data['productId'], $data['locationId'], $productQty, $data['posUserId'], 'addToCart');

                    if(!empty($cartLocationInventoryStatus['error'])) {
                        return array('error' => '1', 'message' => $cartLocationInventoryStatus['message']);
                    }
                }

                $cartStorage->add($product, $options, $addCount, true);

                $cartStorage = self::getAppliedCouponsInCart($cartStorage, $data['cartId']);

                $service = array('price' => 0);

                $ss = $cart->getShippingService();
                $sp = $cart->getShippingPrice();
                if(!empty($ss) && !empty($sp)) {
                    $service['service'] = $cart->getShippingService();
                    $service['type'] = $cart->getShippingType();
                    $service['price'] = $cart->getShippingPrice();
                }

                $cartStorage->setShippingData($service);

                $cartStorage->calculate(true);
                $cartStorageData = $cartStorage->saveCartSession();
            } else {
                return array('error' => '1', 'message' => $translator->translate('Can\'t add to cart: product not found'));
            }

            if($cartStorageData instanceof Tools_ShoppingCart) {
                // log action
                $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
                $additionalContent = json_encode($data);
                Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_ADD_PRODUCT_TO_CART,
                    $data['posUserId'], $createdAt, $additionalContent);

                $msgCoupons = array();
                $coupons = $сouponMapper->findSalesCouponsByCartId($data['cartId']);
                if(!empty($coupons)) {
                    $appliedCoupons = array();
                    foreach ($coupons as $coupon) {
                        $appliedCoupons[] = $coupon['coupon_code'];
                    }
                    $msgCoupons['couponCodes'] = implode(',', $appliedCoupons);
                }

                $cart = $cartSessionMapper->find($data['cartId']);

                $productsInCart = self::getProductsInCart($cart);

                $shippingType = $cart->getShippingType();
                $shippingService = $cart->getShippingService();
                $shippingAddressId = $cart->getShippingAddressId();
                $shippingAddress = array();

                if(!empty($shippingAddressId)) {
                    $shippingAddress = $cartStorage->getAddressById($shippingAddressId);

                    if(!empty($shippingAddress)) {
                        $customerId =  $cart->getUserId();
                        $shippingAddress = self::getCartShippingAddress($shippingAddress, $customerId);
                    }
                }

                return array(
                    'cartId'          => $data['cartId'],
                    'products'        => !empty($productsInCart) ? $productsInCart : array(),
                    'subTotal'        => round($cartStorageData->getSubTotal(), 2),
                    'discount'        => round($cartStorageData->getDiscount(), 2),
                    'discountTax'     => round($cartStorageData->getDiscountTax(), 2),
                    'shippingPrice'   => is_null($cart->getShippingPrice()) ? 0.00 : round($cart->getShippingPrice(), 2),
                    'shippingType'    => !empty($shippingType) ? $cart->getShippingType() : '',
                    'shippingService' => !empty($shippingService) ? $cart->getShippingService() : '',
                    'shippingAddress' => !empty($shippingAddress) ? $shippingAddress : null,
                    'totalTax'        => round($cartStorageData->getTotalTax(), 2),
                    'total'           => round($cartStorageData->getTotal(), 2),
                    'shippingTax'     => round($cartStorageData->getShippingTax(), 2),
                    'subTotalTax'     => round($cartStorageData->getSubTotalTax(), 2),
                    'couponCodes'     => !empty($msgCoupons['couponCodes']) ? $msgCoupons['couponCodes'] : '',
                );
            }

            return array(
                'cartId'          => '0',
                'products'        => array(),
                'subTotal'        => 0.00,
                'discount'        => 0.00,
                'discountTax'     => 0.00,
                'shippingPrice'   => 0.00,
                'shippingType'    => '',
                'shippingService' => '',
                'shippingAddress' => null,
                'totalTax'        => 0.00,
                'total'           => 0.00,
                'shippingTax'     => 0.00,
                'subTotalTax'     => 0.00,
                'couponCodes'     => '',
            );
        }

        return array('error' => '1', 'message' => $translator->translate('The requested products are empty.'));
    }

    /**
     * Delete products from cart
     *
     * @param $data
     * @return array
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     */
    public static function deleteProductsFromCart($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['cartId'])) {
            return array('error' => '1', 'message' => $translator->translate('cartId is empty.'));
        }

        $cartStorage = Tools_ShoppingCart::getInstance();
        $сouponMapper = Store_Mapper_CouponMapper::getInstance();

        $isAlreadyPaid = self::verifyIfAlreadyPaid($data['cartId']);
        if ($isAlreadyPaid === true) {
            $cartStorage->clean();
            //@ todo clear cart into reserved cart table
            $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
            $seosambaposReservedCartsMapper->removeReservedCartByCartId($data['cartId']);
            return array('error' => '1', 'message' => $translator->translate('This cart is already paid.'));
        }

        $productMapper = Models_Mapper_ProductMapper::getInstance();

        if(!empty($data['productId'])) {
            $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
            $cartLocationInventoryMapper = Models_Mapper_CartLocationInventoryMapper::getInstance();

            $cart        = $cartSessionMapper->find($data['cartId']);
            $cartStorage->restoreCartSession($data['cartId']);
            $cartStorage->setCustomerId($cart->getUserId());
            $cartStorage->setShippingAddressKey($cart->getShippingAddressId());
            $cartStorage->setBillingAddressKey($cart->getBillingAddressId());

            $productId = $data['productId'];
            if (!$productId) {
                return array('error' => '1', 'message' => $translator->translate('Can\'t remove from cart: product not defined'));
            }

            $product = $productMapper->find($productId);

            if($product instanceof Models_Model_Product) {
                $sid = Tools_ProductTools::generateStorageKey($product, Tools_ProductTools::getDefaultProductOptions($product));
                $cartContent = $cartStorage->getContent();

                $cartContentData = array();
                $cartContentSidsToRemove = array();
                foreach($cartContent as $key => $item) {
                    $productIdCheck = $item['product_id'];
                    $productCheck = $productMapper->find($productIdCheck);

                    $sidCheck = Tools_ProductTools::generateStorageKey($productCheck, Tools_ProductTools::getDefaultProductOptions($productCheck));

                    if($item['product_id'] != $productId || $sidCheck != $sid) {
                        $cartContentData[$sidCheck] = $cartContent[$key];
                    } else {
                        $cartContentSidsToRemove[] = $sidCheck;
                        $cartContentData[$sidCheck] = $cartContent[$key];
                    }
                }

                $cartContent = $cartContentData;
                $cartStorage->setContent($cartContent);

                if(!empty($cartContentSidsToRemove)) {
                    foreach ($cartContentSidsToRemove as $itemSid) {
                        $cartStorage->remove($itemSid, true);
                    }

                    $cartStorage = self::getAppliedCouponsInCart($cartStorage, $data['cartId']);

                    $cartStorageContent = $cartStorage->getContent();
                    if(empty($cartStorageContent)) {
                        $coupons = $cartStorage->getCoupons();

                        if(!empty($coupons)) {
                            self::resetCoupons($data['cartId'], $coupons);
                            $cartStorage->setCoupons(null);
                            $cartStorage->setDiscount(0);
                            $cartStorage->setDiscountTax(0);
                            $cartStorage->setDiscountTaxRate(0);
                        }
                    }

                    $service = array('price' => 0);
                    if(!empty($cartStorageContent)) {
                        $ss = $cart->getShippingService();
                        $sp = $cart->getShippingPrice();
                        if(!empty($ss) && !empty($sp)) {
                            $service['service'] = $cart->getShippingService();
                            $service['type'] = $cart->getShippingType();
                            $service['price'] = $cart->getShippingPrice();
                        }
                    }

                    $cartStorage->setShippingData($service);
                    $cartStorage->calculate(true);
                    $cartStorageData = $cartStorage->saveCartSession();

                    // log action
//                        $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
//                        $additionalContent = json_encode($data);
//                        Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_DELETE_PRODUCT_FROM_CART,
//                            $data['posUserId'], $createdAt, $additionalContent);

                    $msgCoupons = array();
                    $coupons = $сouponMapper->findSalesCouponsByCartId($data['cartId']);
                    if(!empty($coupons)) {
                        $appliedCoupons = array();
                        foreach ($coupons as $coupon) {
                            $appliedCoupons[] = $coupon['coupon_code'];
                        }
                        $msgCoupons['couponCodes'] = implode(',', $appliedCoupons);
                    }

                    $cart = $cartSessionMapper->find($data['cartId']);

                    $productsInCart = self::getProductsInCart($cart);

                    $shippingType = $cart->getShippingType();
                    $shippingService = $cart->getShippingService();

                    $shippingAddressId = $cart->getShippingAddressId();
                    $shippingAddress = array();

                    if(!empty($shippingAddressId)) {
                        $shippingAddress = $cartStorage->getAddressById($shippingAddressId);

                        if(!empty($shippingAddress)) {
                            $customerId =  $cart->getUserId();
                            $shippingAddress = self::getCartShippingAddress($shippingAddress, $customerId);
                        }
                    }

                    $cartLocationInventoryMapper->deleteByCartIdAndProductId($data['cartId'], $data['productId']);

                    if($cartStorageData instanceof Tools_ShoppingCart) {
                        return array(
                            'cartId'          => $data['cartId'],
                            'products'        => !empty($productsInCart) ? $productsInCart : array(),
                            'subTotal'        => round($cartStorageData->getSubTotal(), 2),
                            'discount'        => round($cartStorageData->getDiscount(), 2),
                            'discountTax'     => round($cartStorageData->getDiscountTax(), 2),
                            'shippingPrice'   => is_null($cart->getShippingPrice()) ? 0.00 : round($cart->getShippingPrice(), 2),
                            'shippingType'    => !empty($shippingType) ? $cart->getShippingType() : '',
                            'shippingService' => !empty($shippingService) ? $cart->getShippingService() : '',
                            'shippingAddress' => !empty($shippingAddress) ? $shippingAddress : null,
                            'totalTax'        => round($cartStorageData->getTotalTax(), 2),
                            'total'           => round($cartStorageData->getTotal(), 2),
                            'shippingTax'     => round($cartStorageData->getShippingTax(), 2),
                            'subTotalTax'     => round($cartStorageData->getSubTotalTax(), 2),
                            'couponCodes'     => !empty($msgCoupons['couponCodes']) ? $msgCoupons['couponCodes'] : '',
                        );
                    }

                    return array(
                        'cartId'          => '0',
                        'products'        => array(),
                        'subTotal'        => 0.00,
                        'discount'        => 0.00,
                        'discountTax'     => 0.00,
                        'shippingPrice'   => 0.00,
                        'shippingType'    => '',
                        'shippingService' => '',
                        'shippingAddress' => null,
                        'totalTax'        => 0.00,
                        'total'           => 0.00,
                        'shippingTax'     => 0.00,
                        'subTotalTax'     => 0.00,
                        'couponCodes'     => '',
                    );
                } else {
                    return array('error' => '1', 'message' => $translator->translate('Nothing to remove'));
                }
            }

            return array('error' => '1', 'message' => $translator->translate('Product not found in system'));
        }

        return array('error' => '1', 'message' => $translator->translate('The requested products are empty.'));
    }

    /**
     * Change product qty in cart
     *
     * @param $data
     * @return array|int[]|string[]
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     */
    public static function changeProductQtyInCart($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['cartId'])) {
            return array('error' => '1', 'message' => $translator->translate('cartId is empty.'));
        }

        $cartStorage = Tools_ShoppingCart::getInstance();
        $сouponMapper = Store_Mapper_CouponMapper::getInstance();

        $isAlreadyPaid = self::verifyIfAlreadyPaid($data['cartId']);
        if ($isAlreadyPaid === true) {
            $cartStorage->clean();
            //@ todo clear cart into reserved cart table
            $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
            $seosambaposReservedCartsMapper->removeReservedCartByCartId($data['cartId']);
            return array('error' => '1', 'message' => $translator->translate('This cart is already paid.'));
        }

        $productMapper = Models_Mapper_ProductMapper::getInstance();
        $shoppingConfig = Models_Mapper_ShoppingConfig::getInstance()->getConfigParams();

        if(!empty($data['productId'])) {
            $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
            $cart        = $cartSessionMapper->find($data['cartId']);
            $cartStorage->restoreCartSession($data['cartId']);
            $cartStorage->setCustomerId($cart->getUserId());
            $cartStorage->setShippingAddressKey($cart->getShippingAddressId());
            $cartStorage->setBillingAddressKey($cart->getBillingAddressId());

            $productId = $data['productId'];

            $changeProductQty = isset($data['productQty']) ? abs(intval($data['productQty'])) : 0;

            if (!$productId) {
                return array('error' => '1', 'message' => $translator->translate('Can\'t change product qty in cart: productId not defined'));
            }

            //@todo remove product in cart if qty = 0
            if(empty($changeProductQty)) {
                $dataToRemove = array(
                    'cartId' => $data['cartId'],
                    'productId' => $productId
                );

                return self::deleteProductsFromCart($dataToRemove);
            }

            $product = $productMapper->find($productId);

            if($product instanceof Models_Model_Product) {
                $product->setCurrentPrice(floatval($product->getPrice()));

                $inStockCount = $product->getInventory();
                //$productDisabled = $product->getEnabled();
                $productNegativeStock = $product->getNegativeStock();

//                if (!$productDisabled) {
//                    return array('error' => '1', 'message' => $translator->translate('This product is disabled'));
//                }

                if(!empty($shoppingConfig['minimumOrder'])) {
                    $minimumOrder = $product->getMinimumOrder();

                    if($changeProductQty < $minimumOrder) {
                        return array('error' => '1', 'message' => $translator->translate('You can add minimum') . ' ' . $minimumOrder . ' ' . $translator->translate('products'));
                    }

                    if($inStockCount !== null && $changeProductQty > $inStockCount) {
                        if(empty($productNegativeStock)) {
                            return array('error' => '1', 'message' => $translator->translate('You can\'t buy this product. Products left less than minimum quantity.'));
                        }
                    }
                }

                $options = Tools_ProductTools::getDefaultProductOptions($product);
                $sid = Tools_ProductTools::generateStorageKey($product, $options);

                $customInventory = Tools_Misc::applyInventory($productId, $options, $changeProductQty, Tools_InventoryObserver::INVENTORY_IN_STOCK_METHOD);

                $errMessageOutOfStock = $translator->translate('The requested product is out of stock');
                $errMessageLimitQty = $translator->translate('The requested quantity is not available');

                if ($customInventory['error'] === true) {
                    if (!empty($customInventory['stock'])) {
                        return array('error' => '1', 'message' => $errMessageLimitQty);
                    }
                    return array('error' => '1', 'message' => $errMessageOutOfStock);
                }

                if (!is_null($inStockCount)) {
                    $inStockCount = intval($inStockCount);

                    if(empty($productNegativeStock)) {
                        if ($inStockCount <= 0) {
                            return array('error' => '1', 'message' => $errMessageOutOfStock);
                        }
                        if ($inStockCount - $changeProductQty < 0) {
                            return array('error' => '1', 'message' => $errMessageLimitQty);
                        }
                    }
                }

                if (isset($shoppingConfig['throttleTransactions']) && $shoppingConfig['throttleTransactions'] === 'true' && Tools_Misc::checkThrottleTransactionsLimit() === false) {
                    $throttleTransactionsLimitMessage = $shoppingConfig['throttleTransactionsLimitMessage'];
                    $throttleTransactionsLimitMessage = !empty($throttleTransactionsLimitMessage) ? $throttleTransactionsLimitMessage : Tools_Misc::THROTTLE_TRANSACTIONS_DEFAULT_MESSAGE;

                    return array('error' => '1', 'message' => $throttleTransactionsLimitMessage);
                }

                $defaultproductId = Seosambapos_Models_Mappers_SeosambaposDefaultproductSettingMapper::getInstance()->getConfigParam('defaultProductId');

                if($defaultproductId != $data['productId']) {
                    $cartLocationInventoryStatus = self::processCartLocationInventory($data['cartId'], $data['productId'], '', $changeProductQty, $data['posUserId'], 'changeProductQtyInCart');

                    if(!empty($cartLocationInventoryStatus['error'])) {
                        return array('error' => '1', 'message' => $cartLocationInventoryStatus['message']);
                    }
                }

                $cartContent = $cartStorage->getContent();

                foreach($cartContent as $key => $item) {
                    if($productId == $item['product_id']) {
                        $item['qty'] = $changeProductQty;
                        $item['taxClass'] = $product->getTaxClass();
                        $cartContent[$sid] = $item;
                        unset($cartContent[$key]);
                    }
                }

                $cartStorage = self::getAppliedCouponsInCart($cartStorage, $data['cartId']);

                $service = array('price' => 0);

                $ss = $cart->getShippingService();
                $sp = $cart->getShippingPrice();
                if(!empty($ss) && !empty($sp)) {
                    $service['service'] = $cart->getShippingService();
                    $service['type'] = $cart->getShippingType();
                    $service['price'] = $cart->getShippingPrice();
                }

                $cartStorage->setShippingData($service);

                $cartStorage->setContent($cartContent);
                $cartStorage->calculate(true);
                $cartStorageData = $cartStorage->saveCartSession();

                // log action
//                $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
//                $additionalContent = json_encode($data);
//                Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_CHANGE_PRODUCT_QTY_IN_CART,
//                    $data['posUserId'], $createdAt, $additionalContent);

                $msgCoupons = array();
                $coupons = $сouponMapper->findSalesCouponsByCartId($data['cartId']);
                if(!empty($coupons)) {
                    $appliedCoupons = array();
                    foreach ($coupons as $coupon) {
                        $appliedCoupons[] = $coupon['coupon_code'];
                    }
                    $msgCoupons['couponCodes'] = implode(',', $appliedCoupons);
                }

                $cart = $cartSessionMapper->find($data['cartId']);

                $productsInCart = self::getProductsInCart($cart);

                $shippingType = $cart->getShippingType();
                $shippingService = $cart->getShippingService();

                $shippingAddressId = $cart->getShippingAddressId();
                $shippingAddress = array();

                if(!empty($shippingAddressId)) {
                    $shippingAddress = $cartStorage->getAddressById($shippingAddressId);

                    if(!empty($shippingAddress)) {
                        $customerId =  $cart->getUserId();
                        $shippingAddress = self::getCartShippingAddress($shippingAddress, $customerId);
                    }
                }

                if($cartStorageData instanceof Tools_ShoppingCart) {
                    return array(
                        'cartId'          => $data['cartId'],
                        'products'        => !empty($productsInCart) ? $productsInCart : array(),
                        'subTotal'        => round($cartStorageData->getSubTotal(), 2),
                        'discount'        => round($cartStorageData->getDiscount(), 2),
                        'discountTax'     => round($cartStorageData->getDiscountTax(), 2),
                        'shippingPrice'   => is_null($cart->getShippingPrice()) ? 0.00 : round($cart->getShippingPrice(), 2),
                        'shippingType'    => !empty($shippingType) ? $cart->getShippingType() : '',
                        'shippingService' => !empty($shippingService) ? $cart->getShippingService() : '',
                        'shippingAddress' => !empty($shippingAddress) ? $shippingAddress : null,
                        'totalTax'        => round($cartStorageData->getTotalTax(), 2),
                        'total'           => round($cartStorageData->getTotal(), 2),
                        'shippingTax'     => round($cartStorageData->getShippingTax(), 2),
                        'couponCodes'     => !empty($msgCoupons['couponCodes']) ? $msgCoupons['couponCodes'] : '',
                    );
                }

                return array(
                    'cartId'          => '0',
                    'products'        => array(),
                    'subTotal'        => 0.00,
                    'discount'        => 0.00,
                    'discountTax'     => 0.00,
                    'shippingPrice'   => 0.00,
                    'shippingType'    => '',
                    'shippingService' => '',
                    'shippingAddress' => null,
                    'totalTax'        => 0.00,
                    'total'           => 0.00,
                    'shippingTax'     => 0.00,
                    'subTotalTax'     => 0.00,
                    'couponCodes'     => '',
                );
            }

            return array('error' => '1', 'message' => $translator->translate('Can\'t add to cart: product not found'));
        }

        return array('error' => '1', 'message' => $translator->translate('The requested productId is empty.'));
    }

    /*
    * Verify if payment already paid
    *
    * @return bool
    */
    public static function verifyIfAlreadyPaid($cartId)
    {
        $isPaid = false;
        if (!empty($cartId)) {
            $cartSession = Models_Mapper_CartSessionMapper::getInstance()->find($cartId);
            if ($cartSession instanceof Models_Model_CartSession) {
                $statuses = array(Models_Model_CartSession::CART_STATUS_COMPLETED, Models_Model_CartSession::CART_STATUS_SHIPPED, Models_Model_CartSession::CART_STATUS_DELIVERED, Models_Model_CartSession::CART_STATUS_PARTIAL);
                $status = $cartSession->getStatus();
                if (in_array($status, $statuses)) {
                    $isPaid = true;
                }
            }
        }

        return $isPaid;
    }

    public static function addShippingAddressToCart($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['cartId'])) {
            return array('error' => '1', 'message' => $translator->translate('cartId is empty.'));
        }

        $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
        $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();
        $сouponMapper = Store_Mapper_CouponMapper::getInstance();
        $cartSession = $cartSessionMapper->find($data['cartId']);
        $cartStorage = Tools_ShoppingCart::getInstance();
        $cartStorage->restoreCartSession($data['cartId']);
        $cartStorage->setCustomerId($cartSession->getUserId());
        $cartStorage->setShippingAddressKey($cartSession->getShippingAddressId());
        $cartStorage->setBillingAddressKey($cartSession->getBillingAddressId());

        $isAlreadyPaid = self::verifyIfAlreadyPaid($data['cartId']);
        if ($isAlreadyPaid === true) {
            $cartStorage->clean();
            //@ todo clear cart into reserved cart table
            $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
            $seosambaposReservedCartsMapper->removeReservedCartByCartId($data['cartId']);
            return array('error' => '1', 'message' => $translator->translate('This cart is already paid.'));
        }

        $defaultCustomerId = $seosambaposSettingsMapper->getConfigParam('defaultCustomerId');
        if($cartSession instanceof Models_Model_CartSession) {
            $customerId =  $cartSession->getUserId();

            $defaultCustomerAddressId = '';
            if(empty($data['shippingAddressId'])) {
//                if(!empty($defaultCustomerId) && $customerId == $defaultCustomerId) {
//                    return array('error' => '1', 'message' => $translator->translate('You can not set shipping address to default customer'));
//                }

                $defaultCustomerAddressData = $seosambaposSettingsMapper->findCustomerAddressByCustomerId($customerId);
                if(!empty($defaultCustomerAddressData)) {
                    $defaultCustomerAddressId = $defaultCustomerAddressData['customer_address_id'];
                }
            }

            $countryList = Tools_Geo::getCountries(true);

            if(!empty($defaultCustomerAddressId)) {
                $shippingAddress = $cartStorage->getAddressById($defaultCustomerAddressId);

                if(!empty($shippingAddress)) {
                    $billingAddressArray = array();
                    $billingAddressArray['firstname']                 = $shippingAddress['firstname'];
                    $billingAddressArray['lastname']                  = $shippingAddress['lastname'];
                    $billingAddressArray['company']                   = $shippingAddress['company'];
                    $billingAddressArray['email']                     = $shippingAddress['email'];
                    $billingAddressArray['address1']                  = $shippingAddress['address1'];
                    $billingAddressArray['address2']                  = $shippingAddress['address2'];
                    $billingAddressArray['country']                   = $shippingAddress['country'];
                    $billingAddressArray['city']                      = $shippingAddress['city'];
                    $billingAddressArray['state']                     = $shippingAddress['state'];
                    $billingAddressArray['zip']                       = $shippingAddress['zip'];
                    $billingAddressArray['phone']                     = $shippingAddress['phone'];
                    $billingAddressArray['phone_country_code_value']  = $shippingAddress['phone_country_code_value'];
                    $billingAddressArray['phonecountrycode']          = $shippingAddress['phonecountrycode'];
                    $billingAddressArray['mobile']                    = $shippingAddress['mobile'];
                    $billingAddressArray['mobile_country_code_value'] = $shippingAddress['mobile_country_code_value'];
                    $billingAddressArray['mobilecountrycode']         = $shippingAddress['mobilecountrycode'];

                    $addressBillingId = self::_addAddress($shippingAddress['user_id'], $billingAddressArray, Models_Model_Customer::ADDRESS_TYPE_BILLING);

                    $cartSession->setShippingAddressId($defaultCustomerAddressId);
                    $cartSession->setBillingAddressId($addressBillingId);
                    $cartSessionMapper->save($cartSession);

                    $state = Tools_Geo::getStateById($shippingAddress['state']);

                    $country = '';
                    if(!empty($shippingAddress['country'])) {
                        if(in_array($shippingAddress['country'], $countryList)){
                            $country = array_search($shippingAddress['country'], $countryList);
                        }
                        if(array_key_exists($shippingAddress['country'], $countryList)){
                            $country = $shippingAddress['country'];
                        }
                    }

                    // log action
//                    $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
//                    $additionalContent = json_encode($data);
//                    Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_ADD_SHIPPING_ADDRESS_TO_CART,
//                        $data['posUserId'], $createdAt, $additionalContent);

                    $cartStorage = self::getAppliedCouponsInCart($cartStorage, $data['cartId']);

                    $service = array('price' => 0);

                    $ss = $cartSession->getShippingService();
                    $sp = $cartSession->getShippingPrice();
                    if(!empty($ss) && !empty($sp)) {
                        $service['service'] = $cartSession->getShippingService();
                        $service['type'] = $cartSession->getShippingType();
                        $service['price'] = $cartSession->getShippingPrice();
                    }

                    $cartStorage->setShippingData($service);
                    $cartStorage->setShippingAddressKey($defaultCustomerAddressId);
                    $cartStorage->setBillingAddressKey($addressBillingId);
                    $cartStorage->calculate(true);
                    $cartStorageData = $cartStorage->saveCartSession();

                    $msgCoupons = array();
                    $coupons = $сouponMapper->findSalesCouponsByCartId($data['cartId']);
                    if(!empty($coupons)) {
                        $appliedCoupons = array();
                        foreach ($coupons as $coupon) {
                            $appliedCoupons[] = $coupon['coupon_code'];
                        }
                        $msgCoupons['couponCodes'] = implode(',', $appliedCoupons);
                    }

                    $cart = $cartSessionMapper->find($data['cartId']);

                    $productsInCart = self::getProductsInCart($cart);

                    $shippingType = $cart->getShippingType();
                    $shippingService = $cart->getShippingService();

                    if($cartStorageData instanceof Tools_ShoppingCart) {
                        return array(
                            'cartId'          => $data['cartId'],
                            'products'        => !empty($productsInCart) ? $productsInCart : array(),
                            'subTotal'        => round($cartStorageData->getSubTotal(), 2),
                            'discount'        => round($cartStorageData->getDiscount(), 2),
                            'discountTax'     => round($cartStorageData->getDiscountTax(), 2),
                            'shippingPrice'   => is_null($cart->getShippingPrice()) ? 0.00 : round($cart->getShippingPrice(), 2),
                            'shippingType'    => !empty($shippingType) ? $cart->getShippingType() : '',
                            'shippingService' => !empty($shippingService) ? $cart->getShippingService() : '',
                            'shippingAddress' => array(
                                'id' => $shippingAddress['id'],
                                'isDefaultCustomerAddress' => true,
                                'streetAddress' => $shippingAddress['address1'].' '. $shippingAddress['address2'],
                                'locality' => Tools_ShippingTools::prepareLocality($shippingAddress),
                                'region' => $state['state'],
                                'postalCode' => $shippingAddress['zip'],
                                'country' => $country,
                                'email' => $shippingAddress['email'],
                                'company' => $shippingAddress['company'],
                                'phone' => $shippingAddress['phone_country_code_value'] . $shippingAddress['phone'],
                                'mobile' => $shippingAddress['mobile_country_code_value'] . $shippingAddress['mobile'],
                            ),
                            'totalTax'        => round($cartStorageData->getTotalTax(), 2),
                            'total'           => round($cartStorageData->getTotal(), 2),
                            'shippingTax'     => round($cartStorageData->getShippingTax(), 2),
                            'couponCodes'     => !empty($msgCoupons['couponCodes']) ? $msgCoupons['couponCodes'] : '',
                        );
                    }

                    return array(
                        'cartId'          => '0',
                        'products'        => array(),
                        'subTotal'        => 0.00,
                        'discount'        => 0.00,
                        'discountTax'     => 0.00,
                        'shippingPrice'   => 0.00,
                        'shippingType'    => '',
                        'shippingService' => '',
                        'shippingAddress' => null,
                        'totalTax'        => 0.00,
                        'total'           => 0.00,
                        'shippingTax'     => 0.00,
                        'subTotalTax'     => 0.00,
                        'couponCodes'     => '',
                    );
                }

                return array('error' => '1', 'message' => $translator->translate('You can not set default shipping address. Address not found'));
            }


            if(!empty($data['shippingAddressId'])) {
//                if(!empty($defaultCustomerId) && $customerId == $defaultCustomerId) {
//                    return array('error' => '1', 'message' => $translator->translate('You can not set shipping address to default customer'));
//                }

                $shippingAddress = $cartStorage->getAddressById($data['shippingAddressId']);

                if(!empty($shippingAddress)) {
                    $billingAddressArray = array();
                    $billingAddressArray['firstname']                 = $shippingAddress['firstname'];
                    $billingAddressArray['lastname']                  = $shippingAddress['lastname'];
                    $billingAddressArray['company']                   = $shippingAddress['company'];
                    $billingAddressArray['email']                     = $shippingAddress['email'];
                    $billingAddressArray['address1']                  = $shippingAddress['address1'];
                    $billingAddressArray['address2']                  = $shippingAddress['address2'];
                    $billingAddressArray['country']                   = $shippingAddress['country'];
                    $billingAddressArray['city']                      = $shippingAddress['city'];
                    $billingAddressArray['state']                     = $shippingAddress['state'];
                    $billingAddressArray['zip']                       = $shippingAddress['zip'];
                    $billingAddressArray['phone']                     = $shippingAddress['phone'];
                    $billingAddressArray['phone_country_code_value']  = $shippingAddress['phone_country_code_value'];
                    $billingAddressArray['phonecountrycode']          = $shippingAddress['phonecountrycode'];
                    $billingAddressArray['mobile']                    = $shippingAddress['mobile'];
                    $billingAddressArray['mobile_country_code_value'] = $shippingAddress['mobile_country_code_value'];
                    $billingAddressArray['mobilecountrycode']         = $shippingAddress['mobilecountrycode'];

                    $addressBillingId = self::_addAddress($shippingAddress['user_id'], $billingAddressArray, Models_Model_Customer::ADDRESS_TYPE_BILLING);

                    $cartSession->setShippingAddressId($data['shippingAddressId']);
                    $cartSession->setBillingAddressId($addressBillingId);
                    $cartSessionMapper->save($cartSession);

                    $state = Tools_Geo::getStateById($shippingAddress['state']);

                    $country = '';
                    if(!empty($shippingAddress['country'])) {
                        if(in_array($shippingAddress['country'], $countryList)){
                            $country = array_search($shippingAddress['country'], $countryList);
                        }
                        if(array_key_exists($shippingAddress['country'], $countryList)){
                            $country = $shippingAddress['country'];
                        }
                    }

                    $customerAddressId = '';
                    $defaultCustomerAddressData = $seosambaposSettingsMapper->findCustomerAddressByCustomerId($customerId);
                    if(!empty($defaultCustomerAddressData)) {
                        $customerAddressId = $defaultCustomerAddressData['customer_address_id'];
                    }

                    $defaultCustomerAddress = false;
                    if(!empty($customerAddressId) && $customerAddressId == $data['shippingAddressId']) {
                        $defaultCustomerAddress = true;
                    }

                    // log action
//                    $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
//                    $additionalContent = json_encode($data);
//                    Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_ADD_SHIPPING_ADDRESS_TO_CART,
//                        $data['posUserId'], $createdAt, $additionalContent);

                    $cartStorage = self::getAppliedCouponsInCart($cartStorage, $data['cartId']);

                    $service = array('price' => 0);

                    $ss = $cartSession->getShippingService();
                    $sp = $cartSession->getShippingPrice();
                    if(!empty($ss) && !empty($sp)) {
                        $service['service'] = $cartSession->getShippingService();
                        $service['type'] = $cartSession->getShippingType();
                        $service['price'] = $cartSession->getShippingPrice();
                    }

                    $cartStorage->setShippingData($service);
                    $cartStorage->setShippingAddressKey($data['shippingAddressId']);
                    $cartStorage->setBillingAddressKey($addressBillingId);
                    $cartStorage->calculate(true);
                    $cartStorageData = $cartStorage->saveCartSession();

                    $msgCoupons = array();
                    $coupons = $сouponMapper->findSalesCouponsByCartId($data['cartId']);

                    if(!empty($coupons)) {
                        $appliedCoupons = array();
                        foreach ($coupons as $coupon) {
                            $appliedCoupons[] = $coupon['coupon_code'];
                        }
                        $msgCoupons['couponCodes'] = implode(',', $appliedCoupons);
                    }

                    $cart = $cartSessionMapper->find($data['cartId']);

                    $productsInCart = self::getProductsInCart($cart);

                    $shippingType = $cart->getShippingType();
                    $shippingService = $cart->getShippingService();

                    if($cartStorageData instanceof Tools_ShoppingCart) {
                        return array(
                            'cartId'          => $data['cartId'],
                            'products'        => !empty($productsInCart) ? $productsInCart : array(),
                            'subTotal'        => round($cartStorageData->getSubTotal(), 2),
                            'discount'        => round($cartStorageData->getDiscount(), 2),
                            'discountTax'     => round($cartStorageData->getDiscountTax(), 2),
                            'shippingPrice'   => is_null($cart->getShippingPrice()) ? 0.00 : round($cart->getShippingPrice(), 2),
                            'shippingType'    => !empty($shippingType) ? $cart->getShippingType() : '',
                            'shippingService' => !empty($shippingService) ? $cart->getShippingService() : '',
                            'shippingAddress' => array(
                                'id' => $shippingAddress['id'],
                                'isDefaultCustomerAddress' => $defaultCustomerAddress,
                                'streetAddress' => $shippingAddress['address1'].' '. $shippingAddress['address2'],
                                'locality' => Tools_ShippingTools::prepareLocality($shippingAddress),
                                'region' => $state['state'],
                                'postalCode' => $shippingAddress['zip'],
                                'country' => $country,
                                'email' => $shippingAddress['email'],
                                'company' => $shippingAddress['company'],
                                'phone' => $shippingAddress['phone_country_code_value'] . $shippingAddress['phone'],
                                'mobile' => $shippingAddress['mobile_country_code_value'] . $shippingAddress['mobile'],
                            ),
                            'totalTax'        => round($cartStorageData->getTotalTax(), 2),
                            'total'           => round($cartStorageData->getTotal(), 2),
                            'shippingTax'     => round($cartStorageData->getShippingTax(), 2),
                            'couponCodes'     => !empty($msgCoupons['couponCodes']) ? $msgCoupons['couponCodes'] : '',
                        );
                    }

                    return array(
                        'cartId'          => '0',
                        'products'        => array(),
                        'subTotal'        => 0.00,
                        'discount'        => 0.00,
                        'discountTax'     => 0.00,
                        'shippingPrice'   => 0.00,
                        'shippingType'    => '',
                        'shippingService' => '',
                        'shippingAddress' => null,
                        'totalTax'        => 0.00,
                        'total'           => 0.00,
                        'shippingTax'     => 0.00,
                        'subTotalTax'     => 0.00,
                        'couponCodes'     => '',
                    );
                }

                return array('error' => '1', 'message' => $translator->translate('You can not set this shipping address. Address not found'));
            }
        }

        return array('error' => '1', 'message' => $translator->translate('Cart not found!'));
    }

    /**
     * @param $data
     * @return array
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Currency_Exception
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     */
    public static function resetShipping($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['cartId'])) {
            return array('error' => '1', 'message' => $translator->translate('cartId is empty.'));
        }

        $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
        $cartSession = $cartSessionMapper->find($data['cartId']);

        if($cartSession instanceof Models_Model_CartSession) {
            $cartStorage = Tools_ShoppingCart::getInstance();
            $сouponMapper = Store_Mapper_CouponMapper::getInstance();

            $isAlreadyPaid = self::verifyIfAlreadyPaid($data['cartId']);
            if ($isAlreadyPaid === true) {
                $cartStorage->clean();
                //@ todo clear cart into reserved cart table
                $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
                $seosambaposReservedCartsMapper->removeReservedCartByCartId($data['cartId']);
                return array('error' => '1', 'message' => $translator->translate('This cart is already paid.'));
            }

            $cartStorage->restoreCartSession($data['cartId']);
            $cartStorage->setCustomerId($cartSession->getUserId());
            $cartStorage->setShippingAddressKey('');
            $cartStorage->setBillingAddressKey('');

            $cartStorage = self::getAppliedCouponsInCart($cartStorage, $data['cartId']);

            $service = array(
                'price' => 0,
                'type' => '',
                'service' => '',
            );

            $cartStorage->setShippingData($service)->calculate(true);
            $cartStorageData = $cartStorage->saveCartSession();

            $msgCoupons = array();
            $coupons = $сouponMapper->findSalesCouponsByCartId($data['cartId']);

            if(!empty($coupons)) {
                $appliedCoupons = array();
                foreach ($coupons as $coupon) {
                    $appliedCoupons[] = $coupon['coupon_code'];
                }
                $msgCoupons['couponCodes'] = implode(',', $appliedCoupons);
            }

            $cart = $cartSessionMapper->find($data['cartId']);

            $productsInCart = self::getProductsInCart($cart);

            $shippingType = $cart->getShippingType();
            $shippingService = $cart->getShippingService();

            $shippingAddressId = $cart->getShippingAddressId();
            $shippingAddress = array();

            if(!empty($shippingAddressId)) {
                $shippingAddress = $cartStorage->getAddressById($shippingAddressId);

                if(!empty($shippingAddress)) {
                    $customerId =  $cart->getUserId();
                    $shippingAddress = self::getCartShippingAddress($shippingAddress, $customerId);
                }
            }

            if($cartStorageData instanceof Tools_ShoppingCart) {
                return array(
                    'cartId'          => $data['cartId'],
                    'products'        => !empty($productsInCart) ? $productsInCart : array(),
                    'subTotal'        => round($cartStorageData->getSubTotal(), 2),
                    'discount'        => round($cartStorageData->getDiscount(), 2),
                    'discountTax'     => round($cartStorageData->getDiscountTax(), 2),
                    'shippingPrice'   => is_null($cart->getShippingPrice()) ? 0.00 : round($cart->getShippingPrice(), 2),
                    'shippingType'    => !empty($shippingType) ? $cart->getShippingType() : '',
                    'shippingService' => !empty($shippingService) ? $cart->getShippingService() : '',
                    'shippingAddress' => !empty($shippingAddress) ? $shippingAddress : null,
                    'totalTax'        => round($cartStorageData->getTotalTax(), 2),
                    'total'           => round($cartStorageData->getTotal(), 2),
                    'shippingTax'     => round($cartStorageData->getShippingTax(), 2),
                    'subTotalTax'     => round($cartStorageData->getSubTotalTax(), 2),
                    'couponCodes'     => !empty($msgCoupons['couponCodes']) ? $msgCoupons['couponCodes'] : '',
                );
            }

            return array(
                'cartId'          => '0',
                'products'        => array(),
                'subTotal'        => 0.00,
                'discount'        => 0.00,
                'discountTax'     => 0.00,
                'shippingPrice'   => 0.00,
                'shippingType'    => '',
                'shippingService' => '',
                'shippingAddress' => null,
                'totalTax'        => 0.00,
                'total'           => 0.00,
                'shippingTax'     => 0.00,
                'subTotalTax'     => 0.00,
                'couponCodes'     => '',
            );

        }

        return array('error' => '1', 'message' => $translator->translate('Cart not found!'));

    }

    /**
     * Add shipping price to cart
     *
     * @param $data
     * @return array|string[]
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     */
    public static function addShippingPriceToCart($data)
    {

        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['cartId'])) {
            return array('error' => '1', 'message' => $translator->translate('cartId is empty.'));
        }

        $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
        $cartSession = $cartSessionMapper->find($data['cartId']);

        if($cartSession instanceof Models_Model_CartSession) {
            $cartStorage = Tools_ShoppingCart::getInstance();
            $сouponMapper = Store_Mapper_CouponMapper::getInstance();

            $isAlreadyPaid = self::verifyIfAlreadyPaid($data['cartId']);
            if ($isAlreadyPaid === true) {
                $cartStorage->clean();
                //@ todo clear cart into reserved cart table
                $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
                $seosambaposReservedCartsMapper->removeReservedCartByCartId($data['cartId']);
                return array('error' => '1', 'message' => $translator->translate('This cart is already paid.'));
            }

            $cartStorage->restoreCartSession($data['cartId']);
            $cartStorage->setCustomerId($cartSession->getUserId());
            $cartStorage->setShippingAddressKey($cartSession->getShippingAddressId());
            $cartStorage->setBillingAddressKey($cartSession->getBillingAddressId());

            $cartStorage = self::getAppliedCouponsInCart($cartStorage, $data['cartId']);

            $service = array('price' => 0);
            if(!empty($data['serviceName']) && !empty($data['priceToCart'])) {
                $service['service'] = $data['serviceName'];
                $service['type'] = $data['typeToCart'];
                $service['price'] = $data['priceToCart'];
            }

            $cartStorage->setShippingData($service)->calculate(true);
            $cartStorageData = $cartStorage->saveCartSession();

            // log action
//            $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
//            $additionalContent = json_encode($data);
//            Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_ADD_SHIPPING_PRICE_TO_CART,
//                $data['posUserId'], $createdAt, $additionalContent);

            $msgCoupons = array();
            $coupons = $сouponMapper->findSalesCouponsByCartId($data['cartId']);

            if(!empty($coupons)) {
                $appliedCoupons = array();
                foreach ($coupons as $coupon) {
                    $appliedCoupons[] = $coupon['coupon_code'];
                }
                $msgCoupons['couponCodes'] = implode(',', $appliedCoupons);
            }

            $cart = $cartSessionMapper->find($data['cartId']);

            $productsInCart = self::getProductsInCart($cart);

            $shippingType = $cart->getShippingType();
            $shippingService = $cart->getShippingService();

            $shippingAddressId = $cart->getShippingAddressId();
            $shippingAddress = array();

            if(!empty($shippingAddressId)) {
                $shippingAddress = $cartStorage->getAddressById($shippingAddressId);

                if(!empty($shippingAddress)) {
                    $customerId =  $cart->getUserId();
                    $shippingAddress = self::getCartShippingAddress($shippingAddress, $customerId);
                }
            }

            if($cartStorageData instanceof Tools_ShoppingCart) {
                return array(
                    'cartId'          => $data['cartId'],
                    'products'        => !empty($productsInCart) ? $productsInCart : array(),
                    'subTotal'        => round($cartStorageData->getSubTotal(), 2),
                    'discount'        => round($cartStorageData->getDiscount(), 2),
                    'discountTax'     => round($cartStorageData->getDiscountTax(), 2),
                    'shippingPrice'   => is_null($cart->getShippingPrice()) ? 0.00 : round($cart->getShippingPrice(), 2),
                    'shippingType'    => !empty($shippingType) ? $cart->getShippingType() : '',
                    'shippingService' => !empty($shippingService) ? $cart->getShippingService() : '',
                    'shippingAddress' => !empty($shippingAddress) ? $shippingAddress : null,
                    'totalTax'        => round($cartStorageData->getTotalTax(), 2),
                    'total'           => round($cartStorageData->getTotal(), 2),
                    'shippingTax'     => round($cartStorageData->getShippingTax(), 2),
                    'subTotalTax'     => round($cartStorageData->getSubTotalTax(), 2),
                    'couponCodes'     => !empty($msgCoupons['couponCodes']) ? $msgCoupons['couponCodes'] : '',
                );
            }

            return array(
                'cartId'          => '0',
                'products'        => array(),
                'subTotal'        => 0.00,
                'discount'        => 0.00,
                'discountTax'     => 0.00,
                'shippingPrice'   => 0.00,
                'shippingType'    => '',
                'shippingService' => '',
                'shippingAddress' => null,
                'totalTax'        => 0.00,
                'total'           => 0.00,
                'shippingTax'     => 0.00,
                'subTotalTax'     => 0.00,
                'couponCodes'     => '',
            );
        }

        return array('error' => '1', 'message' => $translator->translate('Cart not found!'));
    }

    public static function completePurchaseByCash($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['cartId'])) {
            return array('error' => '1', 'message' => $translator->translate('cartId is empty.'));
        }

        $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
        $cartSession = $cartSessionMapper->find($data['cartId']);

        if($cartSession instanceof Models_Model_CartSession) {
            $isAlreadyPaid = self::verifyIfAlreadyPaid($data['cartId']);
            if ($isAlreadyPaid === true) {
                //@ todo clear cart into reserved cart table
                $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
                $seosambaposReservedCartsMapper->removeReservedCartByCartId($data['cartId']);
                return array('error' => '1', 'message' => $translator->translate('This cart is already paid.'));
            }

            $cartContent = $cartSession->getCartContent();

            if(empty($cartContent)) {
                return array('error' => '1', 'message' => $translator->translate('Empty product(s) in cart. Can not complete purchase.'));
            }

//            if($data['total'] != $cartSession->getTotal()) {
//                return array('error' => '1', 'message' => $translator->translate('Total in the cart does not match. Please update your cart.'));
//            }

            $cartSession->setAdditionalInfo('Paid by cash');

            //Set Seller ID
            $cartSession->setSalesId($data['posUserId']);

            $locationId = $cartSession->getLocationId();

            $shippingAddressId = $cartSession->getShippingAddressId();
            $billingAddressId = $cartSession->getBillingAddressId();

            if(empty($shippingAddressId) && empty($billingAddressId)) {
                $pickupLocationMapper = Store_Mapper_PickupLocationMapper::getInstance();
                $pickupLocation = $pickupLocationMapper->find($locationId);

                if($pickupLocation instanceof Store_Model_PickupLocation) {
                    $stateName = '';
                    $st = $pickupLocation->getState();
                    if(!empty($st)) {
                        $state = Tools_Geo::getStateByCode($st);
                        if(!empty($state)) {
                            $stateName = $state['name'];
                        }
                    }

                    $addressData = array(
                        'customerId' => $cartSession->getUserId(),
                        'address' => array(
                            'isDefaultCustomerAddress' => false,//true
                            'address1' => $pickupLocation->getAddress1(),
                            'address2' => $pickupLocation->getAddress2(),
                            'city' => $pickupLocation->getCity(),
                            'zip' => $pickupLocation->getZip(),
                            'country' => $pickupLocation->getCountry(),
                            'state' => $stateName,
                        ),
                    );

                    $result = self::addShippingAddress($addressData, 'pickup');
                    if(!empty($result['error'])) {
                        return $result;
                    }

                    $shippingAddressId = $result['id'];
                    $cartSession->setShippingAddressId($shippingAddressId);
                    $cartSession->setBillingAddressId($result['billingAddressId']);

                    $cartSession->setShippingService('pickup');
                }
            }

            $cartSessionMapper->save($cartSession);

            $cart = self::_updateCartStatus($data['cartId'], Models_Model_CartSession::CART_STATUS_COMPLETED, true);

            //@ todo clear cart into reserved cart table
            if($cart->getStatus() == Models_Model_CartSession::CART_STATUS_COMPLETED) {
                $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
                $seosambaposReservedCartsMapper->removeReservedCartByCartId($cart->getId());
            }

            $data['status'] = $cart->getStatus();
            // log action
            $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
            $additionalContent = json_encode($data);
            Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_COMPLETE_PURCHASE_BY_CASH,
                $data['posUserId'], $createdAt, $additionalContent);

            $seosambaposTransactionsMapper = Seosambapos_Models_Mappers_SeosambaposTransactionsMapper::getInstance();
            $seosambaposTransactionsModel = new Seosambapos_Models_Models_SeosambaposTransactionsModel();

            $seosambaposTransactionsModel->setPaymentType('Paid by cash');
            $seosambaposTransactionsModel->setCartId($data['cartId']);
            $seosambaposTransactionsModel->setStatus(Models_Model_CartSession::CART_STATUS_COMPLETED);
            $seosambaposTransactionsModel->setAmount(Tools_CartTools::cleanAmount($cartSession->getTotal()));
            $seosambaposTransactionsModel->setChargeId('');
            $seosambaposTransactionsModel->setTransactionId('');
            $seosambaposTransactionsModel->setDate($createdAt);
            $seosambaposTransactionsModel->setReason('');

            $seosambaposTransactionsMapper->save($seosambaposTransactionsModel);

            return array(
                'error'   => '0',
                'cartId'  => $cart->getId(),
                'total'   => (float)$cart->getTotal(),
                'message' => $cart->getStatus()
            );
        }

        return array('error' => '1', 'message' => $translator->translate('Cart not found!'));
    }

    /**
     * @param $data
     * @return array|void
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     */
    public static function addShippingAddress($data, $service = '')
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['customerId'])) {
            return array('error' => '1', 'message' => $translator->translate('customerId is empty.'));
        }

        if(!empty($data['address'])) {
            $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();
            $userMapper = Application_Model_Mappers_UserMapper::getInstance();
            $userModel = $userMapper->find($data['customerId']);

            if($userModel instanceof Application_Model_Models_User) {
                if($userModel->getRoleId() != Shopping::ROLE_CUSTOMER && $userModel->getRoleId() != Tools_Security_Acl::ROLE_MEMBER) {
                    return array('error' => '1', 'message' => $translator->translate('User is not customer or member.'));
                }

                $userFullName = $userModel->getFullName();
                $prepareUserName = explode(' ', $userFullName);
                $firstName = array_shift($prepareUserName);
                $lastName = implode(' ', $prepareUserName);
                $countryResult = '';
                $stateResult = '';
                $phone = $userModel->getDesktopPhone();
                $phoneCountryCodeValue = $userModel->getDesktopCountryCodeValue();
                $phoneCountryCode = $userModel->getDesktopCountryCode();
                $mobile = $userModel->getMobilePhone();
                $mobileCountryCodeValue = $userModel->getMobileCountryCodeValue();
                $mobileCountryCode = $userModel->getMobileCountryCode();

                $phoneFull = $phoneCountryCodeValue.$phone;
                $mobileFull = $mobileCountryCodeValue.$mobile;

                $countryList = Tools_Geo::getCountries(true);

                if(!empty($data['address']['country'])){
                    if(in_array($data['address']['country'], $countryList)){
                        $countryResult = array_search($data['address']['country'], $countryList);
                    }
                    if(array_key_exists($data['address']['country'], $countryList)){
                        $countryResult = $data['address']['country'];
                    }
                }

                $states = Tools_Geo::getState(null, true);
                $state = '';
                if(isset($data['address']['state']) && in_array($data['address']['state'], $states)){
                    $stateResult = array_search($data['address']['state'], $states);
                    if(!empty($stateResult)) {
                        $stateData = Tools_Geo::getStateById($stateResult);
                        $state = $stateData['state'];
                    }
                }

                $shippingAddressArray = array();
                $shippingAddressArray['firstname']                 = isset($firstName)?$firstName:'';
                $shippingAddressArray['lastname']                  = isset($lastName)?$lastName:'';
                $shippingAddressArray['company']                   = '';
                $shippingAddressArray['email']                     = $userModel->getEmail();
                $shippingAddressArray['address1']                  = isset($data['address']['address1'])?$data['address']['address1']:'';
                $shippingAddressArray['address2']                  = isset($data['address']['address2'])?$data['address']['address2']:'';
                $shippingAddressArray['country']                   = $countryResult;
                $shippingAddressArray['city']                      = isset($data['address']['city'])?$data['address']['city']:'';
                $shippingAddressArray['state']                     = $stateResult;
                $shippingAddressArray['zip']                       = isset($data['address']['zip'])?$data['address']['zip']:'';
                $shippingAddressArray['phone']                     = isset($phone)?$phone:'';
                $shippingAddressArray['phone_country_code_value']  = isset($phoneCountryCodeValue)?$phoneCountryCodeValue:'';
                $shippingAddressArray['phonecountrycode']          = isset($phoneCountryCode)?$phoneCountryCode:'';
                $shippingAddressArray['mobile']                    = isset($mobile)?$mobile:'';
                $shippingAddressArray['mobile_country_code_value'] = isset($mobileCountryCodeValue)?$mobileCountryCodeValue:'';
                $shippingAddressArray['mobilecountrycode']         = isset($mobileCountryCode)?$mobileCountryCode:'';

                $addressShippingId = self::_addAddress($data['customerId'], $shippingAddressArray, Models_Model_Customer::ADDRESS_TYPE_SHIPPING);

                $billingAddressArray = $shippingAddressArray;
                if(!empty($service) && $service == 'pickup') {
                    $shoppingConfig = Models_Mapper_ShoppingConfig::getInstance()->getConfigParams();

                    $billingEmptyAddress['firstname']                 = $shippingAddressArray['firstname'];
                    $billingEmptyAddress['lastname']                  = $shippingAddressArray['lastname'];
                    $billingEmptyAddress['email']                     = $shippingAddressArray['email'];
                    $billingEmptyAddress['phone']                     = $shippingAddressArray['phone'];
                    $billingEmptyAddress['phone_country_code_value']  = $shippingAddressArray['phone_country_code_value'];
                    $billingEmptyAddress['phonecountrycode']          = $shippingAddressArray['phonecountrycode'];
                    $billingEmptyAddress['mobile']                    = $shippingAddressArray['mobile'];
                    $billingEmptyAddress['mobile_country_code_value'] = $shippingAddressArray['mobile_country_code_value'];
                    $billingEmptyAddress['mobilecountrycode']         = $shippingAddressArray['mobilecountrycode'];
                    $billingEmptyAddress['country']                   = $shoppingConfig['country'];
                    $billingEmptyAddress['state']                     = $shoppingConfig['state'];

                    $billingAddressArray = $billingEmptyAddress;
                }

                $addressBillingId = self::_addAddress($data['customerId'], $billingAddressArray, Models_Model_Customer::ADDRESS_TYPE_BILLING);

                $defaultCustomerId = $seosambaposSettingsMapper->getConfigParam('defaultCustomerId');

                //@todo allow add shipping address to default customer, but deny yse this address as default
                $allowSetToDefault = true;
                if($data['address']['isDefaultCustomerAddress'] == true) {
                    if(!empty($defaultCustomerId) && $data['customerId'] == $defaultCustomerId) {
                        $allowSetToDefault = false;
                    }

                    if($allowSetToDefault) {
                        $seosambaposSettingsMapper->processDefaultCustomerAddress($data['customerId'], $addressShippingId);
                    }
                }

                return array(
                    'id' => $addressShippingId,
                    'billingAddressId' => $addressBillingId,
                    'isDefaultCustomerAddress' => $allowSetToDefault,
                    'streetAddress' => $data['address']['address1'].' '. $data['address']['address2'],
                    'locality' => Tools_ShippingTools::prepareLocality($data['address']),
                    'region' => $state,
                    'postalCode' => $data['address']['zip'],
                    'country' => $countryResult,
                    'email' => $shippingAddressArray['email'],
                    'company' => $shippingAddressArray['company'],
                    'phone' => $phoneFull,
                    'mobile' => $mobileFull,
                );

            }

            return array('error' => '1', 'message' => $translator->translate('You can not set this shipping address. User not found'));
        }
    }

    /**
     * Reset cart only for default customer
     *
     * @param $data
     * @return array
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     */
    public static function resetCart($data, $cronScript = false)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['cartId'])) {
            return array('error' => '1', 'message' => $translator->translate('cartId is empty.'));
        }

        $customerMapper = Models_Mapper_CustomerMapper::getInstance();
        $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
        $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();
        $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
        $cartSession = $cartSessionMapper->find($data['cartId']);

        $defaultCustomerId = $seosambaposSettingsMapper->getConfigParam('defaultCustomerId');

        if(empty($defaultCustomerId)) {
            return array('error' => '1', 'message' => $translator->translate('Default customer not assigned in the config'));
        }

        $existingCustomer = $customerMapper->find($defaultCustomerId);

        if(!$existingCustomer instanceof Models_Model_Customer) {
            return array('error' => '1', 'message' => $translator->translate('Default customer not exists'));
        }

        if($cartSession instanceof Models_Model_CartSession) {
            if($cartSession->getStatus() == Models_Model_CartSession::CART_STATUS_NEW && $cartSession->getUserId() == $defaultCustomerId) {
                $cartStorage = Tools_ShoppingCart::getInstance();

                $isAlreadyPaid = self::verifyIfAlreadyPaid($data['cartId']);
                if ($isAlreadyPaid === true) {
                    $cartStorage->clean();
                    //@ todo clear cart into reserved cart table
                    $seosambaposReservedCartsMapper->removeReservedCartByCartId($data['cartId']);
                    return array('error' => '1', 'message' => $translator->translate('This cart is already paid.'));
                }

                $cartStorage->restoreCartSession($data['cartId']);
                $cartStorage->setCustomerId($cartSession->getUserId());
                $cartStorage->setShippingAddressKey(null);
                $cartStorage->setBillingAddressKey(null);
                $cartStorage->setContent(array());

                $cartStorage = self::getAppliedCouponsInCart($cartStorage, $data['cartId']);

                $coupons = $cartStorage->getCoupons();

                if(!empty($coupons)) {
                    self::resetCoupons($data['cartId'], $coupons);
                    $cartStorage->setCoupons(null);
                    $cartStorage->setDiscount(0);
                    $cartStorage->setDiscountTax(0);
                    $cartStorage->setDiscountTaxRate(0);
                }

                $cartStorage->setShippingData(array('price' => 0));
                $cartStorage->calculate(true);
                $cartStorageData = $cartStorage->saveCartSession();

              // log action
//            $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
//            $additionalContent = json_encode($data);
//            Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_RESET_CART,
//                $data['posUserId'], $createdAt, $additionalContent);

                $cartLocationInventoryMapper = Models_Mapper_CartLocationInventoryMapper::getInstance();
                $cartLocationInventoryMapper->deleteByCartId($data['cartId']);

                if($cronScript) {
                    return array('error' => '0', 'message' => $translator->translate($data['cartId'] .' cleared.'));
                }

                if($cartStorageData instanceof Tools_ShoppingCart) {
                    return array(
                        'cartId'          => $data['cartId'],
                        'products'        => array(),
                        'subTotal'        => round($cartStorageData->getSubTotal(), 2),
                        'discount'        => round($cartStorageData->getDiscount(), 2),
                        'discountTax'     => round($cartStorageData->getDiscountTax(), 2),
                        'shippingPrice'   => 0.00,
                        'shippingType'    => '',
                        'shippingService' => '',
                        'shippingAddress' => null,
                        'totalTax'        => round($cartStorageData->getTotalTax(), 2),
                        'total'           => round($cartStorageData->getTotal(), 2),
                        'shippingTax'     => round($cartStorageData->getShippingTax(), 2),
                        'subTotalTax'     => round($cartStorageData->getSubTotalTax(), 2),
                        'couponCodes'     => '',
                    );
                }

                return array(
                    'cartId'          => '0',
                    'products'        => array(),
                    'subTotal'        => 0.00,
                    'discount'        => 0.00,
                    'discountTax'     => 0.00,
                    'shippingPrice'   => 0.00,
                    'shippingType'    => '',
                    'shippingService' => '',
                    'shippingAddress' => null,
                    'totalTax'        => 0.00,
                    'total'           => 0.00,
                    'shippingTax'     => 0.00,
                    'subTotalTax'     => 0.00,
                    'couponCodes'     => '',
                );
            }

            if($cartSession->getStatus() != Models_Model_CartSession::CART_STATUS_NEW || $cartSession->getUserId() != $defaultCustomerId) {
                //@ todo clear cart into reserved cart table
                $seosambaposReservedCartsMapper->removeReservedCartByCartId($data['cartId']);

                return array('message' => $translator->translate('Removed reserved cart(s)'));
            }

            return array('error' => '1', 'message' => $translator->translate('Nothing to reset'));
        }

        return array('error' => '1', 'message' => $translator->translate('Cart not found!'));
    }

    /**
     * Internal method
     *
     * @param $cartId
     * @param $status
     * @param $skipSupplierNotification
     * @param $message
     * @param $gateway
     * @return false|mixed
     * @throws Exceptions_SeotoasterException
     * @throws Exceptions_SeotoasterPluginException
     * @throws Zend_Db_Table_Exception
     */
    private static function _updateCartStatus($cartId, $status, $skipSupplierNotification = false, $message = '', $gateway = 'seosambapos')
    {
        $cart = Models_Mapper_CartSessionMapper::getInstance()->find($cartId);
        if ($cart instanceof Models_Model_CartSession) {
            $cart->registerObserver(
                new Tools_InventoryObserver($cart->getStatus())
            );

            if ($skipSupplierNotification === false) {
                $cart->registerObserver(
                    new Tools_SupplierObserver($cart->getStatus())
                );
            }

            if ($status === Models_Model_CartSession::CART_STATUS_COMPLETED) {
                $currentStatus = $cart->getStatus();
                if (!empty($cart->getIsPartial())) {
                    $cart->setSecondPaymentGateway($gateway);
                    $cart->setSecondPartialPaidAmount(round($cart->getTotal() - $cart->getFirstPartialPaidAmount(), 2));
                    if ($gateway === Models_Model_CartSession::MANUALLY_PAYED_GATEWAY_QUOTE || $gateway === Models_Model_CartSession::MANUALLY_PAYED_GATEWAY_MANUALL) {
                        $cart->setIsSecondPaymentManuallyPaid('1');
                        $isFirstPaymentManuallyPaid = $cart->getIsFirstPaymentManuallyPaid();
                        $isSecondPaymentManuallyPaid = $cart->getIsSecondPaymentManuallyPaid();
                        if (!empty($isFirstPaymentManuallyPaid) && !empty($isSecondPaymentManuallyPaid)) {
                            $cart->setIsFullOrderManuallyPaid('1');
                        }
                    } else {
                        $cart->setIsSecondPaymentManuallyPaid('0');
                    }
                }

            }

            $cart->setStatus($status);
            $cart->setGateway($gateway);

            if ($status === Models_Model_CartSession::CART_STATUS_COMPLETED) {
                $cart->setPurchasedOn(date(Tools_System_Tools::DATE_MYSQL));
                if (Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('throttleTransactions') === 'true') {
                    Tools_Misc::addThrottleTransaction();
                }
            }

            if ($status === Models_Model_CartSession::CART_STATUS_NOT_VERIFIED) {
                $cart->setPurchasedOn(null);
            }

            if ($status === Models_Model_CartSession::CART_STATUS_PARTIAL) {
                $cart->setPurchasedOn(date(Tools_System_Tools::DATE_MYSQL));
                $cart->setPartialPurchasedOn(date(Tools_System_Tools::DATE_MYSQL));
                $cart->setFirstPaymentGateway($gateway);
                if ($gateway === Models_Model_CartSession::MANUALLY_PAYED_GATEWAY_QUOTE || $gateway === Models_Model_CartSession::MANUALLY_PAYED_GATEWAY_MANUALL) {
                    $cart->setIsFirstPaymentManuallyPaid('1');
                } else {
                    $cart->setIsFirstPaymentManuallyPaid('0');
                }

                $partialPercentage = $cart->getPartialPercentage();
                $partialPaymentType = $cart->getPartialType();

                if ($partialPaymentType === Models_Model_CartSession::CART_PARTIAL_PAYMENT_TYPE_AMOUNT) {
                    $amountToPayPartial = round($partialPercentage, 2);
                } else {
                    $amountToPayPartial = round(($cart->getTotal() * $cart->getPartialPercentage()) / 100, 2);
                }

                $cart->setFirstPartialPaidAmount($amountToPayPartial);
            }

            if ($status === Models_Model_CartSession::CART_STATUS_ERROR) {
                $cart->setPurchaseErrorMessage($message);
            }


           return Models_Mapper_CartSessionMapper::getInstance()->save($cart);
        }

        return false;
    }

    /**
     * Internal method
     *
     * @param $customerId
     * @param $address
     * @param $type
     * @return array|mixed|null
     * @throws Zend_Db_Table_Exception
     */
    private static function _addAddress($customerId, $address, $type = null){
        $addressTable = new Models_DbTable_CustomerAddress();
        if (!empty($address)){
            if ($type !== null) {
                $address['address_type'] = $type;
            }
            $address = Tools_Misc::clenupAddress($address);
            $address['id'] = Tools_Misc::getAddressUniqKey($address);
            $address['user_id'] = $customerId;
            if (null === ($row = $addressTable->find($address['id'])->current())) {
                $row = $addressTable->createRow();
            }
            $row->setFromArray($address);

            return $row->save();
        }
        return null;
    }

    /**
     * Internal method
     *
     * @param $cart
     * @return array
     * @throws Zend_Currency_Exception
     * @throws Zend_Exception
     */
    public static function getProductsInCart($cart)
    {
        $productMapper = Models_Mapper_ProductMapper::getInstance();
        $websiteUrl = Zend_Controller_Action_HelperBroker::getExistingHelper('website')->getUrl();
        $inCart = array();
        $cartContent = $cart->getCartContent();

        if(!empty($cartContent)) {
            foreach ($cartContent as $sid => $item) {
                $productPrice = $item['price'];
                if(!empty($item['tax_price'])) {
                    $productPrice = $item['tax_price'];
                }

                $priceToShow = $productPrice * $cartContent[$sid]['qty'];

                $price = round($priceToShow, 2);

                if(isset($item['freebies']) && $item['freebies'] == 1){
                    $price = 'free';
                }

                $product = $productMapper->findByProductId($item['product_id']);
                $photo = $websiteUrl.Tools_Page_Tools::PLACEHOLDER_NOIMAGE;
                if(!empty($product)){
                    $photo = Tools_ProductTools::prepareProductImage($product['photo'], 'small');
                }

                $inCart[] = array(
                    'productId' => (string) $item['product_id'],
                    'productSku' => $item['sku'],
                    'productName' => $item['name'],
                    'productQty' => (int)$item['qty'],
                    'productPrice' => $price,
                    'imageUrl' => $photo
                );
            }
        }

        return $inCart;
    }

    /**
     * Internal method
     *
     * @param $shippingAddress
     * @param $customerId
     * @return array
     */
    public static function getCartShippingAddress($shippingAddress, $customerId)
    {
        $countryList = Tools_Geo::getCountries(true);

        $country = '';
        if(!empty($shippingAddress['country'])) {
            if(in_array($shippingAddress['country'], $countryList)){
                $country = array_search($shippingAddress['country'], $countryList);
            }
            if(array_key_exists($shippingAddress['country'], $countryList)){
                $country = $shippingAddress['country'];
            }
        }

        $state = Tools_Geo::getStateById($shippingAddress['state']);

        $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();

        $customerAddressId = '';
        if(!empty($customerId)) {
            $defaultCustomerAddressData = $seosambaposSettingsMapper->findCustomerAddressByCustomerId($customerId);
            if(!empty($defaultCustomerAddressData)) {
                $customerAddressId = $defaultCustomerAddressData['customer_address_id'];
            }
        }

        $defaultCustomerAddress = false;
        if(!empty($customerAddressId) && $customerAddressId == $shippingAddress['shippingAddressId']) {
            $defaultCustomerAddress = true;
        }

        $shippingAddress = array(
            'id' => $shippingAddress['id'],
            'isDefaultCustomerAddress' => $defaultCustomerAddress,
            'streetAddress' => $shippingAddress['address1'].' '. $shippingAddress['address2'],
            'locality' => Tools_ShippingTools::prepareLocality($shippingAddress),
            'region' => $state['state'],
            'postalCode' => $shippingAddress['zip'],
            'country' => $country,
            'email' => $shippingAddress['email'],
            'company' => $shippingAddress['company'],
            'phone' => $shippingAddress['phone_country_code_value'] . $shippingAddress['phone'],
            'mobile' => $shippingAddress['mobile_country_code_value'] . $shippingAddress['mobile'],
        );

        return $shippingAddress;
    }

    /**
     * Internal method
     *
     * @param $cartStorage
     * @param $cartId
     * @return mixed
     */
    public static function getAppliedCouponsInCart($cartStorage, $cartId)
    {
        $сouponMapper = Store_Mapper_CouponMapper::getInstance();
        $appliedCouponsData = $сouponMapper->findSalesCouponsByCartId($cartId);

        if(!empty($appliedCouponsData)) {
            $usedCoupons = array();
            foreach ($appliedCouponsData as $cData) {
                $currentCoupons = $сouponMapper->findByCode($cData['coupon_code']);

                foreach ($currentCoupons as $currentCoupon) {
                    if($currentCoupon instanceof Store_Model_Coupon) {
                        $usedCoupons[] = $currentCoupon;
                    }
                }
            }

            if(!empty($usedCoupons)) {
                $cartStorage->setCoupons($usedCoupons);
            }
        }

        return $cartStorage;
    }

    /**
     * Internal method
     *
     * @param $cartObj
     * @param $cart
     * @param $cashierId
     * @param $cashierLabel
     * @param $locationId
     * @param $posUserId
     * @return array
     * @throws Exceptions_SeotoasterException
     * @throws Exceptions_SeotoasterPluginException
     * @throws Zend_Db_Table_Exception
     */
    private static function _createCart($cartObj, $cart, $cashierId, $cashierLabel, $locationId, $posUserId)
    {
        $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
        $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();

        $cartId = $cartObj->getCartId();
        $cartSession = $cartSessionMapper->find($cartId);

        if($cartSession instanceof Models_Model_CartSession) {
            $cartSession->setShippingPrice(0);
            $cartSession->setCashierId($cashierId);
            $cartSession->setCashierLabel($cashierLabel);
            $cartSession->setLocationId($locationId);

            $cartSessionMapper->save($cartSession);
        }

        $data['cartId'] = $cartId;
        $data['locationId'] = $locationId;
        $data['cashRegisterId'] = $cashierId;

        $reservedCart = new Seosambapos_Models_Models_SeosambaposReservedCartsModel();
        $reservedCart->setCartId($cartId);
        $reservedCart->setLocationId($locationId);
        $reservedCart->setCashierId($cashierId);

        $seosambaposReservedCartsMapper->save($reservedCart);

        // log action
        $createdAt = Tools_System_Tools::convertDateFromTimezone('now');
        $additionalContent = json_encode($data);
        Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_CART_CREATE,
            $posUserId, $createdAt, $additionalContent);

        $cartStorageData = $cart;

        return array(
            'cartId'          => $cartId,
            'products'        => array(),
            'subTotal'        => round($cartStorageData->getSubTotal(), 2),
            'discount'        => round($cartStorageData->getDiscount(), 2),
            'discountTax'     => round($cartStorageData->getDiscountTax(), 2),
            'shippingPrice'   => 0.00,
            'shippingType'    => '',
            'shippingService' => '',
            'shippingAddress' => null,
            'totalTax'        => round($cartStorageData->getTotalTax(), 2),
            'total'           => round($cartStorageData->getTotal(), 2),
            'shippingTax'     => round($cartStorageData->getShippingTax(), 2),
            'subTotalTax'     => round($cartStorageData->getSubTotalTax(), 2),
            'couponCodes'     => '',
        );
    }

    /**
     * complete purchase by stripe hook
     *
     * @param $session
     * @return array
     * @throws Exceptions_SeotoasterException
     * @throws Exceptions_SeotoasterPluginException
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     */
    public static function completePurchase($session) {
        $translator = Zend_Registry::get('Zend_Translate');

        if (!empty($session) && isset($session->id)) {
            $cartId = $session->metadata['cartId'];
            $paymentType = $session->metadata['type'];
            $metadataWebsiteId = $session->metadata['websiteId'];
            $paymentStatus = $session->status;

            if(!empty($cartId) && !empty($paymentType)) {
                $configData = Application_Model_Mappers_ConfigMapper::getInstance()->getConfig();
                $websiteId = $configData['websiteId'];

                if(empty($websiteId) || $websiteId != $metadataWebsiteId) {
                    return array('error' => '0', 'accepted' => '1', 'message' => $translator->translate('Accepted'));
                }

                $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
                $cartSession = $cartSessionMapper->find($cartId);
                $seosambaposTransactionsMapper = Seosambapos_Models_Mappers_SeosambaposTransactionsMapper::getInstance();

                $hasError = false;
                $reason = '';
                if($cartSession instanceof Models_Model_CartSession) {
                    $isAlreadyPaid = self::verifyIfAlreadyPaid($cartId);
                    if ($isAlreadyPaid === true) {
                        //@ todo clear cart into reserved cart table
                        $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
                        $seosambaposReservedCartsMapper->removeReservedCartByCartId($cartId);
                        $reason = $translator->translate('This cart is already paid.');
                        $hasError = true;
                    }

                    $cartContent = $cartSession->getCartContent();

                    if(empty($cartContent)) {
                        $reason = $translator->translate('Empty product(s) in cart. Can not complete purchase.');
                        $hasError = true;
                    }

                    if(Tools_CartTools::cleanAmount($cartSession->getTotal()) != $session->amount) {
                        $reason = $translator->translate('Total in the cart does not match. Please update your cart.');
                        $hasError = true;
                    }

                    $cartSession->setAdditionalInfo($paymentType);

                    $locationId = $cartSession->getLocationId();
                    $cashRegisterId = $cartSession->getCashierId();

                    if(empty($locationId) || empty($cashRegisterId)) {
                        return array('error' => '1', 'message' => $translator->translate('locationId or cashRegisterId is empty.'));
                    }

                    $shippingAddressId = $cartSession->getShippingAddressId();
                    $billingAddressId = $cartSession->getBillingAddressId();

                    if(empty($shippingAddressId) && empty($billingAddressId)) {
                        $pickupLocationMapper = Store_Mapper_PickupLocationMapper::getInstance();
                        $pickupLocation = $pickupLocationMapper->find($locationId);

                        if($pickupLocation instanceof Store_Model_PickupLocation) {
                            $stateName = '';
                            $st = $pickupLocation->getState();
                            if(!empty($st)) {
                                $state = Tools_Geo::getStateByCode($st);
                                if(!empty($state)) {
                                    $stateName = $state['name'];
                                }
                            }

                            $addressData = array(
                                'customerId' => $cartSession->getUserId(),
                                'address' => array(
                                    'isDefaultCustomerAddress' => false,//true
                                    'address1' => $pickupLocation->getAddress1(),
                                    'address2' => $pickupLocation->getAddress2(),
                                    'city' => $pickupLocation->getCity(),
                                    'zip' => $pickupLocation->getZip(),
                                    'country' => $pickupLocation->getCountry(),
                                    'state' => $stateName,
                                ),
                            );

                            $result = self::addShippingAddress($addressData, 'pickup');
                            if(!empty($result['error'])) {
                                return $result;
                            }

                            $shippingAddressId = $result['id'];
                            $cartSession->setShippingAddressId($shippingAddressId);
                            $cartSession->setBillingAddressId($result['billingAddressId']);

                            $cartSession->setShippingService('pickup');
                        }
                    }

                    $seosambaposActiveSessionMapper = Seosambapos_Models_Mappers_SeosambaposActiveSessionMapper::getInstance();
                    $activeSessionData = $seosambaposActiveSessionMapper->findSessionByLocationIdAndCashRegisterId($locationId, $cashRegisterId);

                    $posUserId = '';
                    if(!empty($activeSessionData['user_id'])) {
                        $posUserId = $activeSessionData['user_id'];
                    }

                    if($paymentStatus == 'succeeded' && !$hasError) {
                        //Set Seller ID
                        $cartSession->setSalesId($posUserId);
                    }

                    $cartSessionMapper->save($cartSession);
                    $createdAt = Tools_System_Tools::convertDateFromTimezone('now');

                    $seosambaposTransactionsModel = new Seosambapos_Models_Models_SeosambaposTransactionsModel();
                    if($paymentStatus == 'succeeded' && !$hasError) {
                        $cart = self::_updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_COMPLETED, true);

                        //@ todo clear cart into reserved cart table
                        if($cart->getStatus() == Models_Model_CartSession::CART_STATUS_COMPLETED) {
                            $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
                            $seosambaposReservedCartsMapper->removeReservedCartByCartId($cart->getId());
                        }

                        $data['status'] = $paymentStatus;
                        $data['reason'] = $reason;
                        $data['cartId'] = $cartId;
                        if(!empty($posUserId)) {
                            $data['posUserId'] = $posUserId;

                            // log action
                            $additionalContent = json_encode($data);
                            Tools_SeosambaPosTools::logAction(Seosambapos_Models_Models_SeosambaposActionLogModel::ACTION_COMPLETE_PURCHASE,
                                $data['posUserId'], $createdAt, $additionalContent);
                        }

                        $seosambaposTransactionsModel->setStatus(Models_Model_CartSession::CART_STATUS_COMPLETED);
                    } else {
                        $paymentStatus = 'notcompleted';
                        $seosambaposTransactionsModel->setStatus($paymentStatus);
                    }

                    $seosambaposTransactionsModel->setPaymentType($paymentType);
                    $seosambaposTransactionsModel->setCartId($cartId);
                    $seosambaposTransactionsModel->setAmount($session->amount);
                    $seosambaposTransactionsModel->setChargeId($session->id);
                    $seosambaposTransactionsModel->setTransactionId($session->balance_transaction);
                    $seosambaposTransactionsModel->setDate($createdAt);
                    $seosambaposTransactionsModel->setReason($reason);

                    $seosambaposTransactionsMapper->save($seosambaposTransactionsModel);

                    return array('error' => '0', 'message' => $translator->translate('Success'));
                }
            } else {
                return array('error' => '0', 'accepted' => '1', 'message' => $translator->translate('Accepted'));
            }
        }

        return array('error' => '1', 'message' => $translator->translate('Stripe session or cartId is empty.'));
    }

    /**
     * Get cart info
     *
     * @param $data
     * @return array
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     */
    public static function getStripeCartData($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if(!empty($data['cartId'])) {
            $isAlreadyPaid = self::verifyIfAlreadyPaid($data['cartId']);
            if ($isAlreadyPaid === true) {
                return array('error' => '1', 'message' => $translator->translate('This cart is already paid.'));
            }

            $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
            $cartSession = $cartSessionMapper->find($data['cartId']);

            if (!$cartSession instanceof Models_Model_CartSession) {
                return array('error' => '1', 'message' => $translator->translate('Cart not found in store.'));
            }

            return array('error' => '0', 'cartSession' => $cartSession);

        }

        return array('error' => '1', 'message' => $translator->translate('cartId not found in store.'));
    }

    /**
     * Create quick sale
     *
     * @param $data
     * @return array
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Controller_Action_Exception
     * @throws Zend_Exception
     */
    public static function createQuickSale($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $websiteUrl = $websiteHelper->getUrl();

        $productMapper = Models_Mapper_ProductMapper::getInstance();
        $brandMapper = Models_Mapper_Brand::getInstance();
        $templateMapper = Application_Model_Mappers_TemplateMapper::getInstance();
        $seosambaposDefaultproductSettingMapper = Seosambapos_Models_Mappers_SeosambaposDefaultproductSettingMapper::getInstance();
        $seosambaposDefaultproductSetting = $seosambaposDefaultproductSettingMapper->getConfigParams();
        $seosambaposActiveSessionMapper = Seosambapos_Models_Mappers_SeosambaposActiveSessionMapper::getInstance();
        $productLocationsMapper = Models_Mapper_ProductLocationsMapper::getInstance();

        $addProductFlag = false;
        if(!empty($data['product']['name']) || !empty($data['product']['image'])) {
            $addProductFlag = true;
        }

        $defaultProductId = $seosambaposDefaultproductSetting['defaultProductId'];

        if(empty($defaultProductId)) {
            return array('error' => '1', 'message' => $translator->translate('Default product not assigned in the config'));
        }

        $defaultProduct = $productMapper->find($defaultProductId);

        if(!$defaultProduct instanceof Models_Model_Product) {
            return array('error' => '1', 'message' => $translator->translate('Default product was deleted, please reassign the product in config.'));
        }

        $price = $data['product']['price'];
        if(empty($price)) {
            return array('error' => '1', 'message' => $translator->translate('Product price is empty'));
        }

        $addProductToCartData = array();

        if($addProductFlag) {
            $uniqueHash = (string) time();
            $sku = $uniqueHash;

            $existedProduct = $productMapper->findBySku($sku);
            if($existedProduct instanceof Models_Model_Product) {
                return array('error' => '1', 'message' => $translator->translate('You already have a product with this SKU'));
            }

            $brand = '';
            if(!empty($seosambaposDefaultproductSetting['defaultBrandId'])) {
                $brandObj = $brandMapper->find($seosambaposDefaultproductSetting['defaultBrandId']);

                if($brandObj instanceof Models_Model_Brand) {
                    $brand = $brandObj->getName();
                }
            }

            if(empty($brand)) {
                return array('error' => '1', 'message' => $translator->translate('Default brand not assigned in the config'));
            }

            $mpn = $uniqueHash;
            $productName = filter_var(trim($data['product']['name']), FILTER_SANITIZE_STRING);

            if(empty($productName)) {
                $productName = 'quick-product'.$uniqueHash;
            }

            $weight = null;

            $taxC = '0';
            if(!empty($seosambaposDefaultproductSetting['defaultTaxId'])) {
                $taxC = $seosambaposDefaultproductSetting['defaultTaxId'];
            }

            if(empty($taxC)) {
                $taxC = '0';
            }

            $tags = array();
            $inventory = '1';
            $shortDescription = 'quick-product'.$uniqueHash;
            $dimensionW = '';
            $dimensionL = '';
            $dimensionD = '';
            $gtin = '';

            $image = $websiteUrl.Tools_Page_Tools::PLACEHOLDER_NOIMAGE;
            if(!empty($data['product']['image']) && is_array($data['product']['image'])) {
                $imageExtension = '';
                if(!empty($data['product']['image']['name'])) {
                    $imageExtension = pathinfo($data['product']['image']['name'], PATHINFO_EXTENSION);
                }
//            $pattern = '/data:image\/(.+);base64,(.*)/';
//            preg_match($pattern, $data['image'], $matches);
//            $imageExtension = $matches[1];

                if(in_array($imageExtension, Tools_ProductTools::$_acceptedFileTypesArray, true)) {
                    $encodedImageData = $data['product']['image']['data'];
                    $decodedImageData = base64_decode($encodedImageData);

                    $mediaFolder = Tools_ProductTools::DEFAULT_MEDIA_FOLDER;
                    if(!empty($data['product']['photoFolder'])) {
                        $mediaFolder = $data['product']['photoFolder'];
                    }

                    $imageName = strtolower(preg_replace("/[^a-zA-Z0-9\-_\s]/", '', $sku)) . '.' . $imageExtension;
                    $savePath = Tools_ProductTools::getProductsFilePath($imageName, $mediaFolder, 'original');

                    if(file_exists($savePath)){
                        unlink($savePath);
                    }

                    $fp = fopen($savePath,'x');
                    fwrite($fp, $decodedImageData);
                    fclose($fp);
                    if (file_exists($savePath)) {
                        $image = $mediaFolder . DIRECTORY_SEPARATOR . $imageName;

                        $localPath = $websiteHelper->getPath() . 'media' . DIRECTORY_SEPARATOR . Tools_ProductTools::DEFAULT_MEDIA_FOLDER . DIRECTORY_SEPARATOR;
                        $originalDir = $localPath . 'original' . DIRECTORY_SEPARATOR;

                        //$productDirs = array('large', 'medium', 'product', 'small');

                        $configTable   = new Application_Model_DbTable_Config();
                        $dbConfig = $configTable->selectConfig();
                        $iniConfig = Zend_Registry::get('misc');


                        $productDirs = array(
                            'small'	 => intval($dbConfig['imgSmall']),
                            'medium' => intval($dbConfig['imgMedium']),
                            'large'	 => intval($dbConfig['imgLarge']),
                            'product' => intval($iniConfig['imgProduct'])
                        );

                        foreach ($productDirs as $type => $size) {
                            $savePath = Tools_ProductTools::getProductsFilePath($imageName, $mediaFolder, $type);

                            if(file_exists($savePath)){
                                unlink($savePath);
                            }

                            $result = Tools_Image_Tools::resizeByParameters(
                                $originalDir . $imageName,
                                $size,
                                'auto',
                                true,
                                $localPath . $type . DIRECTORY_SEPARATOR
                            );

//                        $fp = fopen($savePath,'x');
//                        fwrite($fp, $decodedImageData);
//                        fclose($fp);
                        }
                    }
                }
            } elseif(empty($data['product']['image'])){
                $image = $defaultProduct->getPhoto();
            }

            $template = '';
            if(!empty($seosambaposDefaultproductSetting['defaultTemplate'])) {
                $existedTemplate = $templateMapper->find($seosambaposDefaultproductSetting['defaultTemplate']);

                if(!empty($existedTemplate)) {
                    $template = $seosambaposDefaultproductSetting['defaultTemplate'];
                }
            }

            if(empty($template)) {
                return array('error' => '1', 'message' => $translator->translate('Default template not assigned in the config or not set in request or not found in system'));
            }

            $productModel = new Models_Model_Product();
            $productModel->setSku($sku);
            $productModel->setMpn($mpn);
            $productModel->setBrand($brand);
            $productModel->setName($productName);
            $productModel->setPrice($price);
            $productModel->setWeight($weight);
            $productModel->setTaxClass($taxC);
            $productModel->setTags($tags);
            $productModel->setInventory($inventory);
            $productModel->setShortDescription($shortDescription);
            $productModel->setFullDescription('');
            $productModel->setProdWidth($dimensionW);
            $productModel->setProdLength($dimensionL);
            $productModel->setProdDepth($dimensionD);
            $productModel->setGtin($gtin);
            $productModel->setPhoto($image);
            $productModel->setPageTemplate($template);

            if(!empty($data['product']['defaultOptions'])) {
                $optionsInLibrary = Tools_ProductTools::getLibraryOptionsList(array('withoutSelections' => true));

                if(!empty($optionsInLibrary)) {
                    foreach ($data['product']['defaultOptions'] as $key => $option) {
                        if(!array_key_exists($option['parentId'], $optionsInLibrary)) {
                            unset($data['product']['defaultOptions'][$key]);
                        }
                    }

                    $productModel->setDefaultOptions($data['product']['defaultOptions']);
                }
            }
            $productModel->setEnabled(0);

            $product = $productMapper->save($productModel);

            if($product instanceof Models_Model_Product) {
                $seosambaposActiveSession = $seosambaposActiveSessionMapper->findSession($data['posUserId']);

                $locationId = '';
                if(!empty($seosambaposActiveSession)) {
                    $locationId = $seosambaposActiveSession['location_id'];
                    $existedProductLocation = $productLocationsMapper->findLocationByProductIdAndLocationId($product->getId(), $locationId);
                    if(empty($existedProductLocation)) {
                        $productLocationsModel = new Models_Model_ProductLocationsModel();
                        $productLocationsModel->setProductId($product->getId());
                        $productLocationsModel->setLocationId($locationId);
                        $productLocationsModel->setInventory($inventory);
                        $productLocationsModel->setIsDefaultLocation(1);
                        $productLocationsModel->setIsQuickProduct(1);

                        $productLocationsMapper->save($productLocationsModel);
                    }
                }

                $addProductToCartData = array(
                    'posUserId' => $data['posUserId'],
                    'cartId' => $data['cartId'],
                    'productId' => $product->getId(),
                    'locationId' => $locationId,
                    'quickSaleProduct' => true,
                );

            } else {
                return array('error' => '1', 'message' => $translator->translate('Can not create a product. Something went wrong!'));
            }
        } else {
            $productOptions = $defaultProduct->getDefaultOptions();

            if(!empty($productOptions)) {
                $optionAdditionalPriceFieldExists = false;
                $selectedOptions = array();
                foreach ($productOptions as $key => $option) {
                    if($option['type'] == 'additionalpricefield') {
                        $optionAdditionalPriceFieldExists = true;
                        $option['optionValue'] = $price;
                        $totalOptionValue = 0;

                        if($option['optionValue'] >= $defaultProduct->getPrice()) {
                            $totalOptionValue = $option['optionValue'] - $defaultProduct->getPrice();
                        } else if ($defaultProduct->getPrice() >= $option['optionValue']) {
                            $totalOptionValue = $defaultProduct->getPrice() - $option['optionValue'];
                        }

                        if(empty($totalOptionValue) || $totalOptionValue < 1) {
                            return array('error' => '1', 'message' => $translator->translate('Total product price should be greater than 1'));
                        }

                        $selectedOptions[] = array(
                            'optionId' => $option['id'],
                            'optionValue' => $totalOptionValue
                        );
                    }
                }

                if($optionAdditionalPriceFieldExists) {
                    $addProductToCartData = array(
                        'posUserId' => $data['posUserId'],
                        'cartId' => $data['cartId'],
                        'productId' => $defaultProduct->getId(),
                        'selectedOptions' => $selectedOptions,
                        'idDefaultProduct' => '1',
                        'quickSaleProduct' => true,
                    );
                } else {
                    return array('error' => '1', 'message' => $translator->translate('Not found option with type \"additionalpricefield\"'));
                }

            } else {
                return array('error' => '1', 'message' => $translator->translate('Not found option with type \"additionalpricefield\"'));
            }

        }

        return self::addProductToCart($addProductToCartData);
    }

    /**
     * Clear the card from product and remove product
     *
     * @param $data
     * @return array
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     */
    public static function deleteQuickSale($data) {
        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['cartId'])) {
            return array('error' => '1', 'message' => $translator->translate('cartId is empty.'));
        }

        $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
        $cartSession = $cartSessionMapper->find($data['cartId']);

        if($cartSession instanceof Models_Model_CartSession) {
            $seosambaposDefaultproductSettingMapper = Seosambapos_Models_Mappers_SeosambaposDefaultproductSettingMapper::getInstance();
            $seosambaposDefaultproductSetting = $seosambaposDefaultproductSettingMapper->getConfigParams();

            $defaultProductId = $seosambaposDefaultproductSetting['defaultProductId'];
            $cartContent = $cartSession->getCartContent();

            if(!empty($cartContent)) {
                foreach ($cartContent as $cartItem) {
                    $productId = $cartItem['product_id'];

                    $cartStorageData = self::deleteProductsFromCart(array('cartId' => $data['cartId'], 'productId' => $productId));

                    if($productId != $defaultProductId) {
                        $productMapper = Models_Mapper_ProductMapper::getInstance();
                        $product = $productMapper->find($productId);

                        if($product instanceof Models_Model_Product) {
                            $productMapper->delete($product);
                        }
                    }
                }

                return $cartStorageData;
            }

            return array('error' => '1', 'message' => $translator->translate('Nothing to delete. Cart is empty.'));
        }

        return array('error' => '1', 'message' => $translator->translate('Cart not found.'));
    }

    /**
     * Delete applied coupons in cart
     *
     * @param $cartId
     * @param $coupons
     * @return void
     */
    public static function resetCoupons($cartId, $coupons)
    {
        $couponMapper = Store_Mapper_CouponMapper::getInstance();

        if(!empty($coupons)) {
            $couponSalesDbTable = new Zend_Db_Table('shopping_coupon_sales');
            $couponUsageDbTable = new Zend_Db_Table('shopping_coupon_usage');

            foreach ($coupons as $coupon) {
                //delete shopping_coupon_sales coupon
                $where = $couponSalesDbTable->getAdapter()->quoteInto('coupon_code = ?', $coupon->getCode());
                $where .= ' AND ' . $couponSalesDbTable->getAdapter()->quoteInto('cart_id = ?', $cartId);
                $select =  $couponSalesDbTable->getAdapter()->select()->from('shopping_coupon_sales', array('coupon_code', 'cart_id'))->where($where);

                $couponRow = $couponSalesDbTable->getAdapter()->fetchRow($select);

                if(!empty($couponRow)) {
                    $where = $couponSalesDbTable->getAdapter()->quoteInto('coupon_code = ?', $coupon->getCode());
                    $where .= ' AND ' . $couponSalesDbTable->getAdapter()->quoteInto('cart_id = ?', $cartId);

                    $couponSalesDbTable->getAdapter()->delete('shopping_coupon_sales', $where);
                }

                //delete shopping_coupon_usage coupon
                $existedCouponUsage = $couponMapper->findCouponUsageByCouponId($coupon->getId());

                if(!empty($existedCouponUsage)) {
                    $where = $couponUsageDbTable->getAdapter()->quoteInto('coupon_id = ?', $coupon->getId());
                    $where .= ' AND ' . $couponUsageDbTable->getAdapter()->quoteInto('cart_id = ?', $cartId);
                    $couponUsageDbTable->delete($where);
                }
            }
        }
    }

    /**
     * @param $cartId
     * @param $productId
     * @param $requestedLocationId
     * @param $locationInventoryToProcess
     * @param $posUserId
     * @param $type
     * @return array
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Exception
     */
    public static function processCartLocationInventory($cartId, $productId, $requestedLocationId, $locationInventoryToProcess, $posUserId, $type = '')
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $productLocationsMapper = Models_Mapper_ProductLocationsMapper::getInstance();
        $cartLocationInventoryMapper = Models_Mapper_CartLocationInventoryMapper::getInstance();

        $priorityLocationsToCalculate = array();

        $cartLocationInventories = $cartLocationInventoryMapper->findByCartProductId($cartId, $productId);

        if(empty($requestedLocationId) && !empty($cartLocationInventories)) {
            $startCartLocationInventoryEl = $cartLocationInventories[0];
            $requestedLocationId = $startCartLocationInventoryEl['location_id'];
        }

        //requested location
        if(!in_array($requestedLocationId, $priorityLocationsToCalculate)) {
            $priorityLocationsToCalculate[] = $requestedLocationId;
        }

        $loggedLocationId = '';
        $loggedLocationData = Tools_SeosambaPosTools::sessionStatus(array('posUserId' => $posUserId), true);

        if(empty($loggedLocationData['error'])) {
            $loggedLocationId = $loggedLocationData['location']['id'];
        } else {
            return array('error' => '1', 'message' => $translator->translate('Can not get locationId for logged user.'));
        }

        //logged user location
        if(!in_array($loggedLocationId, $priorityLocationsToCalculate)) {
            $priorityLocationsToCalculate[] = $loggedLocationId;
        }

        $productLocation = $productLocationsMapper->findLocationByProductIdAndLocationId($productId, $requestedLocationId);

        if(!empty($productLocation)) {
            //if(!empty($cartLocationInventories)) {
                $productLocationsAll = $productLocationsMapper->findLocationsByProductId($productId);

                $defaultLocation = '';
                $maxAllowedInventories = 0;
                $locationsInventoryLimit = array();

                foreach ($productLocationsAll as $key => $loc) {
                    $locationsInventoryLimit[$loc['location_id']] = $loc['inventory'];
                    if(!empty($loc['is_default_location'])) {
                        $defaultLocation = $loc['location_id'];
                    }
                    $maxAllowedInventories += $loc['inventory'];
                }

                arsort($locationsInventoryLimit);

                if(empty($defaultLocation)) {
                    $defaultLocation = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('defaultLocationId');
                }

                //default location
                if(!in_array($defaultLocation, $priorityLocationsToCalculate)) {
                    $priorityLocationsToCalculate[] = $defaultLocation;
                }

                $inventoriesAddedToCart = $locationInventoryToProcess;
                if($type == 'addToCart') {
                    foreach ($cartLocationInventories as $cartLocInventory) {
                        $inventoriesAddedToCart += $cartLocInventory['location_inventory'];
                    }
                }

                if($inventoriesAddedToCart > $maxAllowedInventories) {
                    return array('error' => '1', 'message' => $translator->translate('You can not add more items to your cart than are available in all locations warehouses.'));
                }

                foreach ($locationsInventoryLimit as $id => $inventory) {
                    if(!in_array($id, $priorityLocationsToCalculate)) {
                        $priorityLocationsToCalculate[] = $id;
                    }
                }

                $cartLocationInventoryMapper->deleteByCartIdAndProductId($cartId, $productId);

                foreach ($priorityLocationsToCalculate as $locationId) {
                    $remainderOfValue = $locationsInventoryLimit[$locationId] - $inventoriesAddedToCart;

                    $cartLocationInventory = new Models_Model_CartLocationInventoryModel();
                    $cartLocationInventory->setCartId($cartId);
                    $cartLocationInventory->setProductId($productId);
                    $cartLocationInventory->setLocationId($locationId);
                    $cartLocationInventory->setProductStatus('new');

                    if($remainderOfValue >= 0) {
                        //save $inventoriesAddedToCart
                        $cartLocationInventory->setLocationInventory($inventoriesAddedToCart);

                        if(!empty($inventoriesAddedToCart)) {
                            $cartLocationInventoryMapper->save($cartLocationInventory);
                        }

                        break;
                    } elseif ($remainderOfValue < 0) {
                        //save $locationsInventoryLimit[$locationId]
                        $cartLocationInventory->setLocationInventory($locationsInventoryLimit[$locationId]);

                        if(!empty($locationsInventoryLimit[$locationId])) {
                            $cartLocationInventoryMapper->save($cartLocationInventory);
                        }

                        $inventoriesAddedToCart = abs($remainderOfValue);
                    }
                }

//            } else {
//
//
//                $cartLocationInventory = new Models_Model_CartLocationInventoryModel();
//                $cartLocationInventory->setCartId($cartId);
//                $cartLocationInventory->setProductId($productId);
//                $cartLocationInventory->setLocationId($requestedLocationId);
//                $cartLocationInventory->setLocationInventory($locationInventoryToProcess);
//                $cartLocationInventory->setProductStatus('new');
//
//                if(!empty($locationInventoryToProcess)) {
//                    $cartLocationInventoryMapper->save($cartLocationInventory);
//                }
//            }

            return array('error' => '0', 'message' => $translator->translate('Done'));
        }

        return array('error' => '1', 'message' => $translator->translate('Product not found with this location.'));
    }

    /**
     * Check if product location inventories available in stock
     *
     * @param $data
     * @return array|string[]
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     */
    public static function validateCart($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['cartId'])) {
            return array('error' => '1', 'message' => $translator->translate('cartId is empty.'));
        }

        $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
        $cartSession = $cartSessionMapper->find($data['cartId']);

        if($cartSession instanceof Models_Model_CartSession) {
            $isAlreadyPaid = self::verifyIfAlreadyPaid($data['cartId']);
            if ($isAlreadyPaid === true) {
                //@ todo clear cart into reserved cart table
                $seosambaposReservedCartsMapper = Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper::getInstance();
                $seosambaposReservedCartsMapper->removeReservedCartByCartId($data['cartId']);
                return array('error' => '1', 'message' => $translator->translate('This cart is already paid.'));
            }

            $cartLocationInventoryMapper = Models_Mapper_CartLocationInventoryMapper::getInstance();
            $productAndLocationInfo = $cartLocationInventoryMapper->getLocationInventoryInfo($data['cartId']);

            if(!empty($productAndLocationInfo)) {
                $productLocationsMapper = Models_Mapper_ProductLocationsMapper::getInstance();

                $errorInventories = array();
                foreach ($productAndLocationInfo as $productLocationInfoItem) {
                    $productLocation = $productLocationsMapper->findLocationByProductIdAndLocationId($productLocationInfoItem['product_id'], $productLocationInfoItem['location_id']);
                    if(!empty($productLocation) && $productLocation['inventory'] < $productLocationInfoItem['location_inventory']) {
                        $inventoryDiff = $productLocationInfoItem['location_inventory'] - $productLocation['inventory'];
                        $errorInventories[] = 'The requested product "' . $productLocationInfoItem['product_name'] . '" from "' . $productLocationInfoItem['location_name'] . '" available quantity is ' . $productLocation['inventory'] . '. Please, reduce the quantity by ' . $inventoryDiff . '.';
                    }
                }

                if(!empty($errorInventories)) {
                    $message = '';
                    foreach ($errorInventories as $errorInventory) {
                        $message .= $errorInventory . '\n\n';
                    }

                    return array('error' => '1', 'message' => $message);
                }

                return array('error' => '0', 'message' => $translator->translate('Checking successful.'));
            }

            $cartContent = $cartSession->getCartContent();

            $defaultproductId = Seosambapos_Models_Mappers_SeosambaposDefaultproductSettingMapper::getInstance()->getConfigParam('defaultProductId');

            $hasError = false;
            foreach ($cartContent as $cartItem) {
                $productId = $cartItem['product_id'];

                if($productId != $defaultproductId) {
                    $hasError = true;
                }
            }

            if($hasError) {
                return array('error' => '1', 'message' => $translator->translate('Something went wrong. Please remove your products from the cart and add them again.'));
            } else {
                return array('error' => '0', 'message' => $translator->translate('Checking successful.'));
            }

        }

        return array('error' => '1', 'message' => $translator->translate('Cart not found! Please relogin and add this product(s) again.'));
    }

    /**
     * Return order details info
     *
     * @param $data
     * @return array
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Currency_Exception
     * @throws Zend_Db_Table_Exception
     * @throws Zend_Exception
     */
    public static function getOrderInfo($data)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['cartId'])) {
            return array('error' => '1', 'message' => $translator->translate('cartId is empty.'));
        }

        $order = Models_Mapper_CartSessionMapper::getInstance()->find($data['cartId'], true);
        $shoppingCart = Tools_ShoppingCart::getInstance();

        if (!$order) {
            return array('error' => '1', 'message' => $translator->translate('Order not found!'));
        }

        $serviceLabelMapper = Models_Mapper_ShoppingShippingServiceLabelMapper::getInstance();
        $shippingServiceLabel = $serviceLabelMapper->findByName($order->getShippingService());
        $shippingServiceLabelInfo = '';
        if (!empty($shippingServiceLabel)) {
            $shippingServiceLabelInfo = $shippingServiceLabel;
        }

        $pickupLocationConfigMapper = Store_Mapper_PickupLocationConfigMapper::getInstance();
        $pickupLocations = $pickupLocationConfigMapper->getLocationNames();
        $pickupLocationsInfo = $pickupLocations[$order->getLocationId()];

        $salesInfo = array();
        $salesName = '';
        $salesId = $order->getSalesId();
        if(!empty($salesId)) {
            $userMapper = Application_Model_Mappers_UserMapper::getInstance();
            $salesUserModel = $userMapper->find($salesId);

            if($salesUserModel instanceof Application_Model_Models_User){
                $salesName = $salesUserModel->getFullName();
            }
        }

        $shippingType = $order->getShippingType();
        $shippingAddress = array();
        $shippingAddressId = $order->getShippingAddressId();

        if(!empty($shippingAddressId)) {
            $shippingAddress = $shoppingCart->getAddressById($shippingAddressId);

            if(!empty($shippingAddress)) {
                $customerId =  $order->getUserId();
                $shippingAddress = self::getCartShippingAddress($shippingAddress, $customerId);
            }
        }

        $billingAddress = array();
        $billingAddressId = $order->getBillingAddressId();

        if(!empty($billingAddressId)) {
            $billingAddress = $shoppingCart->getAddressById($billingAddressId);

            if(!empty($billingAddress)) {
                $customerId =  $order->getUserId();
                $billingAddress = self::getCartShippingAddress($billingAddress, $customerId);
            }
        }

        $productsInCart = self::getProductsInCart($order);

        $salesInfo['salesName'] = $salesName;
        $salesInfo['salesLocation'] = $pickupLocationsInfo;
        $salesInfo['salesCashier'] = $order->getCashierLabel();

        return array(
            'cartId'          => $data['cartId'],
            'cartStatus'      => $order->getStatus(),
            'purchasedOn'     => date('d M, Y', strtotime($order->getPurchasedOn())),
            'additionalInfo'  => nl2br($order->getAdditionalInfo()),
            'salesInfo'       => $salesInfo,
            'products'        => !empty($productsInCart) ? $productsInCart : array(),
            'subTotal'        => round($order->getSubTotal(), 2),
            'discount'        => round($order->getDiscount(), 2),
            'discountTax'     => round($order->getDiscountTax(), 2),
            'shippingPrice'   => is_null($order->getShippingPrice()) ? 0.00 : round($order->getShippingPrice(), 2),
            'shippingType'    => !empty($shippingType) ? $order->getShippingType() : '',
            'shippingService' => !empty($shippingServiceLabelInfo) ? $shippingServiceLabelInfo : $order->getShippingService(),
            'shippingAddress' => !empty($shippingAddress) ? $shippingAddress : null,
            'billingAddress'  => !empty($billingAddress) ? $billingAddress : null,
            'totalTax'        => round($order->getTotalTax(), 2),
            'total'           => round($order->getTotal(), 2),
            'shippingTax'     => round($order->getShippingTax(), 2),
            'subTotalTax'     => round($order->getSubTotalTax(), 2),
        );
    }

    /**
     * Return clean amount ex: 9.95 = 995
     *
     * @param $amountToPay
     * @return int
     */
    public static function cleanAmount($amountToPay) {
       return intval(strval($amountToPay * 100));
    }

    /**
     * Check if store has successull purchase
     *
     * @return bool
     */
    public static function ifSuccessfulPurchaseExists()
    {
        $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
        $cartSuccessfulPurchase = $cartSessionMapper->ifSuccessfulPurchaseExists();

        return $cartSuccessfulPurchase;
    }

}

