<?php

/**
 * Class Seosambapos_Models_Mappers_SeosambaposTransactionsMapper
 *
 * @method Seosambapos_Models_Mappers_SeosambaposTransactionsMapper   getInstance()   getInstance()   Returns an instance of itself
 * @method Zend_Db_Table    getDbTable()    getDbTable()    Returns an instance of DbTable
 */
class Seosambapos_Models_Mappers_SeosambaposTransactionsMapper extends Application_Model_Mappers_Abstract
{

    protected $_dbTable = 'Seosambapos_Models_Dbtables_SeosambaposTransactionsDbtable';

    protected $_model = 'Seosambapos_Models_Models_SeosambaposTransactionsModel';

    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'payment_type'   => $model->getPaymentType(),
            'cart_id'        => $model->getCartId(),
            'status'         => $model->getStatus(),
            'amount'         => $model->getAmount(),
            'charge_id'      => $model->getChargeId(),
            'transaction_id' => $model->getTransactionId(),
            'date'           => $model->getDate(),
            'reason'         => $model->getReason(),
        );

        $id = $model->getId();
        if ($id) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            $this->getDbTable()->update($data, $where);
        } else {
            $id = $this->getDbTable()->insert($data);
            $model->setId($id);
        }
        return $model;
    }


}

