<?php

/**
 * Class Seosambapos_Models_Mappers_SeosambaposTerminalLocationsMapper
 *
 * @method Seosambapos_Models_Mappers_SeosambaposTerminalLocationsMapper   getInstance()   getInstance()   Returns an instance of itself
 * @method Zend_Db_Table    getDbTable()    getDbTable()    Returns an instance of DbTable
 */
class Seosambapos_Models_Mappers_SeosambaposTerminalLocationsMapper extends Application_Model_Mappers_Abstract
{

    protected $_dbTable = 'Seosambapos_Models_Dbtables_SeosambaposTerminalLocationsDbtable';

    protected $_model = 'Seosambapos_Models_Models_SeosambaposTerminalLocationsModel';

    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'pickup_location_id'    => $model->getPickupLocationId(),
            'location_address_hash' => $model->getLocationAddressHash(),
            'terminal_id'           => $model->getTerminalId(),
        );

        $id = $model->getId();
        if ($id) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            $this->getDbTable()->update($data, $where);
        } else {
            $id = $this->getDbTable()->insert($data);
            $model->setId($id);
        }
        return $model;
    }

    /**
     * @param $pickupLocationId
     * @return mixed|null
     */
    public function findByLocationId($pickupLocationId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('pickup_location_id = ?', $pickupLocationId);
        $select = $this->getDbTable()->getAdapter()->select()->from('plugin_seosambapos_terminal_locations');
        $select->where($where);

        return $this->getDbTable()->getAdapter()->fetchRow($select);
    }

    /**
     * Get locations data
     *
     * @param $locationId
     * @param $cashRegisterIds
     * @return array|mixed
     */
    public function getLocationsData($locationId = false)
    {
        $pickupLocation = new Store_DbTable_PickupLocation();

        $where = '';
        if ($locationId) {
            $where = $pickupLocation->getAdapter()->quoteInto('spl.id = ?', $locationId);
        }

        if(!empty($where)) {
            $where .= ' AND ';
        }

        $where .= $pickupLocation->getAdapter()->quoteInto('spl.cash_register_id <> ?', ' ');
        $where .= ' AND ' . new Zend_Db_Expr('spl.cash_register_id IS NOT NULL');

        $select = $pickupLocation->select()
            ->from(array('spl' => 'shopping_pickup_location'), array(
                'spl.*'
            ));

        $select->where($where);

        if ($locationId) {
            return $pickupLocation->getAdapter()->fetchRow($select);
        }
        return $pickupLocation->getAdapter()->fetchAll($select);

    }

    /**
     * @param $terminalId
     * @return mixed|null
     */
    public function deleteByTerminalId($terminalId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('terminal_id = ?', $terminalId);
        return $this->getDbTable()->getAdapter()->delete('plugin_seosambapos_terminal_locations', $where);
    }


}

