<?php


class Seosambapos_Models_Mappers_SeosambaposSettingMapper extends Application_Model_Mappers_Abstract
{

    protected $_dbTable = 'Seosambapos_Models_Dbtables_SeosambaposSettingDbtable';

    protected $_model = 'Seosambapos_Models_Models_SeosambaposSettingModel';

    public function save($config)
    {
        if (!is_array($config) || empty ($config)) {
            throw new Exceptions_SeotoasterPluginException('Given parameter should be non empty array');
        }

        array_walk($config, function ($value, $key, $dbTable) {
            $dbTable->updateParam($key, $value);
        }, $this->getDbTable());

    }

    /**
     * Get all config params
     *
     * @return mixed
     * @throws Exception
     */
    public function getConfigParams()
    {
        return $this->getDbTable()->selectConfig();
    }

    /**
     * Get by param name
     *
     * @param string $name param name
     * @return null
     * @throws Exception
     */
    public function getConfigParam($name)
    {
        if (!$name) {
            return null;
        }

        $row = $this->getDbTable()->find($name);
        if ($row = $row->current()) {
            return $row->value;
        }

        return null;
    }

    /**
     * find customer address id by customer ID
     *
     * @param $customerId
     * @return array|mixed
     */
    public function findCustomerAddressByCustomerId($customerId) {
        $data = array();

        if(!empty($customerId)) {
            $defaultCustomerAddressDbTable = new Seosambapos_Models_Dbtables_SeosambaposDefaultCustomerAddressDbtable();

            $where = $defaultCustomerAddressDbTable->getAdapter()->quoteInto('psdca.customer_id = ?', intval($customerId));
            $select = $defaultCustomerAddressDbTable->getAdapter()->select()->from(array('psdca' => 'plugin_seosambapos_default_customer_address'), array('psdca.customer_address_id'))
                ->where($where);

            $data = $defaultCustomerAddressDbTable->getAdapter()->fetchRow($select);

        }

        return $data;
    }

    /**
     * Delete/Save default customer address
     *
     * @param $customerId
     * @param $locationId
     * @return void
     * @throws Exception
     */
    public function processDefaultCustomerAddress($customerId, $customerAddressId = '')
    {
        $defaultCustomerAddressDbTable = new Seosambapos_Models_Dbtables_SeosambaposDefaultCustomerAddressDbtable();

        if(!empty($customerId)) {
            $where = $defaultCustomerAddressDbTable->getAdapter()->quoteInto('customer_id = ?', $customerId);
            $defaultCustomerAddressDbTable->getAdapter()->delete('plugin_seosambapos_default_customer_address', $where);

            if(!empty($customerAddressId)) {
                $data = array(
                    'customer_id' => $customerId,
                    'customer_address_id' => $customerAddressId
                );
                $this->getDbTable()->getAdapter()->insert('plugin_seosambapos_default_customer_address', $data);
            }
        }
    }
}

