<?php

/**
 * Class Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper
 *
 * @method Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper   getInstance()   getInstance()   Returns an instance of itself
 * @method Zend_Db_Table    getDbTable()    getDbTable()    Returns an instance of DbTable
 */
class Seosambapos_Models_Mappers_SeosambaposReservedCartsMapper extends Application_Model_Mappers_Abstract
{

    protected $_dbTable = 'Seosambapos_Models_Dbtables_SeosambaposReservedCartsDbtable';

    protected $_model = 'Seosambapos_Models_Models_SeosambaposReservedCartsModel';

    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'cart_id'     => $model->getCartId(),
            'location_id' => $model->getLocationId(),
            'cashier_id'  => $model->getCashierId(),
        );

        $id = $model->getId();
        if ($id) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            $this->getDbTable()->update($data, $where);
        } else {
            $id = $this->getDbTable()->insert($data);
            $model->setId($id);
        }
        return $model;
    }

    /**
     * @param $locationId
     * @param $cashierId
     * @return mixed|null
     */
    public function findCartByLocationIdAndCashierId($locationId, $cashierId) {
        $where = $this->getDbTable()->getAdapter()->quoteInto('location_id = ?', $locationId);
        $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto('cashier_id = ?', $cashierId);
        return $this->_findWhere($where);
    }

    /**
     * @param $cartId
     * @return int
     */
    public function removeReservedCartByCartId($cartId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('cart_id = ?', $cartId);
        return $this->getDbTable()->getAdapter()->delete('plugin_seosambapos_reserved_carts', $where);
    }

    /**
     * @return array
     */
    public function getReservedCards()
    {
        $select = $this->getDbTable()->getAdapter()->select()->from('plugin_seosambapos_reserved_carts');
        return $this->getDbTable()->getAdapter()->fetchAll($select);
    }


}

