<?php

/**
 * Class Seosambapos_Models_Mappers_SeosambaposReduceProductLocationsInventoryLogMapper
 *
 * @method Seosambapos_Models_Mappers_SeosambaposReduceProductLocationsInventoryLogMapper  getInstance()   Returns an instance of itself
 * @method Zend_Db_Table    getDbTable()    getDbTable()    Returns an instance of DbTable
 */
class Seosambapos_Models_Mappers_SeosambaposReduceProductLocationsInventoryLogMapper extends Application_Model_Mappers_Abstract
{

    protected $_dbTable = 'Seosambapos_Models_Dbtables_SeosambaposReduceProductLocationsInventoryLogDbtable';

    protected $_model = 'Seosambapos_Models_Models_SeosambaposReduceProductLocationsInventoryLogModel';

    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'type'               => $model->getType(),
            'cart_id'            => $model->getCartId(),
            'location_id'        => $model->getLocationId(),
            'created_at'         => $model->getCreatedAt(),
            'additional_content' => $model->getAdditionalContent(),
        );

        $id = $model->getId();
        if ($id) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            $this->getDbTable()->update($data, $where);
        } else {
            $id = $this->getDbTable()->insert($data);
            $model->setId($id);
        }
        return $model;
    }


}

