<?php

/**
 * Class Seosambapos_Models_Mappers_SeosambaposPurchasesDataMapper
 *
 * @method Seosambapos_Models_Mappers_SeosambaposPurchasesDataMapper   getInstance()   getInstance()   Returns an instance of itself
 * @method Zend_Db_Table    getDbTable()    getDbTable()    Returns an instance of DbTable
 */
class Seosambapos_Models_Mappers_SeosambaposPurchasesDataMapper extends Application_Model_Mappers_Abstract
{

    protected $_dbTable = 'Seosambapos_Models_Dbtables_SeosambaposPurchasesDataDbtable';

    protected $_model = 'Seosambapos_Models_Models_SeosambaposPurchasesDataModel';

    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'cart_id'     => $model->getCartId(),
            'location_id' => $model->getLocationId(),
            'status'      => $model->getStatus(),
            'type'        => $model->getType(),
            'gateway'     => $model->getGateway(),
            'receipt'     => $model->getReceipt(),
        );

        $id = $model->getId();
        if ($id) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            $this->getDbTable()->update($data, $where);
        } else {
            $id = $this->getDbTable()->insert($data);
            $model->setId($id);
        }
        return $model;
    }

    public function findByCartId($cartId)
    {
        if(!empty($cartId)) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('pspd.cart_id = ?', $cartId);
            $select = $this->getDbTable()->getAdapter()->select()->from(array('pspd' => 'plugin_seosambapos_purchases_data'))
                ->where($where);

            return $this->getDbTable()->getAdapter()->fetchRow($select);
        }

        return null;
    }


}

