<?php

/**
 * Class Seosambapos_Models_Mappers_SeosambaposLoggedUserLogMapper
 *
 * @method Seosambapos_Models_Mappers_SeosambaposLoggedUserLogMapper  getInstance()   Returns an instance of itself
 * @method Zend_Db_Table    getDbTable()    getDbTable()    Returns an instance of DbTable
 */
class Seosambapos_Models_Mappers_SeosambaposLoggedUserLogMapper extends Application_Model_Mappers_Abstract
{

    protected $_dbTable = 'Seosambapos_Models_Dbtables_SeosambaposLoggedUserLogDbtable';

    protected $_model = 'Seosambapos_Models_Models_SeosambaposLoggedUserLogModel';

    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'user_id'          => $model->getUserId(),
            'status'           => $model->getStatus(),
            'location_id'      => $model->getLocationId(),
            'cash_register_id' => $model->getCashRegisterId(),
            'date_created'     => $model->getDateCreated(),
        );

        $id = $model->getId();
        if ($id) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            $this->getDbTable()->update($data, $where);
        } else {
            $id = $this->getDbTable()->insert($data);
            $model->setId($id);
        }
        return $model;
    }

    public function getLastConnectedLocation($locationId)
    {
        $lastConnected = '';
        $where = $this->getDbTable()->getAdapter()->quoteInto('status = ?', 'login');
        $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto('location_id = ?', $locationId);
        $select = $this->getDbTable()->getAdapter()->select()->from('plugin_seosambapos_logged_user_log', array('date_created'))
            ->where($where)->order(array('id DESC'))->limit(1);

        $data = $this->getDbTable()->getAdapter()->fetchRow($select);

        if(!empty($data)){
            $lastConnected = $data['date_created'];
        }

        return $lastConnected;
    }


}

