<?php


class Seosambapos_Models_Mappers_SeosambaposDefaultproductSettingMapper extends Application_Model_Mappers_Abstract
{

    protected $_dbTable = 'Seosambapos_Models_Dbtables_SeosambaposDefaultproductSettingDbtable';

    protected $_model = 'Seosambapos_Models_Models_SeosambaposDefaultproductSettingModel';

    public function save($config)
    {
        if (!is_array($config) || empty ($config)) {
            throw new Exceptions_SeotoasterPluginException('Given parameter should be non empty array');
        }

        array_walk($config, function ($value, $key, $dbTable) {
            $dbTable->updateParam($key, $value);
        }, $this->getDbTable());

    }

    /**
     * Get all config params
     *
     * @return mixed
     * @throws Exception
     */
    public function getConfigParams()
    {
        return $this->getDbTable()->selectConfig();
    }

    /**
     * Get by param name
     *
     * @param string $name param name
     * @return null
     * @throws Exception
     */
    public function getConfigParam($name)
    {
        if (!$name) {
            return null;
        }

        $row = $this->getDbTable()->find($name);
        if ($row = $row->current()) {
            return $row->value;
        }

        return null;
    }

    /**
     * Get product options selection ID
     *
     * @param $productId
     * @param $optionParam
     * @return array|mixed
     */
    public function findDefaultSelectionOptionByProductId($productId, $optionParam) {
        $data = array();

        if(!empty($productId) && !empty($optionParam)) {
            $productOptionDbTable = new Models_DbTable_ProductOption();

            $where = $productOptionDbTable->getAdapter()->quoteInto('pho.product_id = ?', intval($productId));
            $where .= ' AND '.$productOptionDbTable->getAdapter()->quoteInto('pos.isDefault = ?', '1');
            $where .= ' AND '.$productOptionDbTable->getAdapter()->quoteInto('po.title = ?', $optionParam);

            $select = $productOptionDbTable->getAdapter()->select()->from(array('pho' => 'shopping_product_has_option'), array('pos.id', 'pos.option_id', 'pos.priceValue'))
                ->join(array('po' => 'shopping_product_option'), 'pho.option_id = po.id', array())
                ->join(array('pos' => 'shopping_product_option_selection'), 'pos.option_id = pho.option_id', array())
                ->where($where);

            $data = $productOptionDbTable->getAdapter()->fetchRow($select);
        }
        return $data;
    }

    /**
     * @param $where
     * @param $order
     * @param $limit
     * @param $offset
     * @param $withoutCount
     * @param $singleRecord
     * @param $having
     * @return array
     * @throws Exception
     */
    public function fetchAllData(
        $where = null,
        $order = null,
        $limit = null,
        $offset = null,
        $withoutCount = false,
        $singleRecord = false,
        $having = ''
    ) {
        $select = $this->getDbTable()->getAdapter()->select()
            ->from(array('sp' => 'shopping_product'),
                array(
                    'sp.*'
                )
            )->joinLeft(array('p' => 'page'), 'p.id = sp.page_id', array('p.url'))
            ->joinLeft(array('sb' => 'shopping_brands'), 'sb.id = sp.brand_id', array('brandName' => 'sb.name'))
            ->joinLeft(array('pho' => 'shopping_product_has_option'), 'pho.product_id = sp.id', array())
            ->joinLeft(array('spo' => 'shopping_product_option'), 'spo.id = pho.option_id', array());

        if (!empty($having)) {
            $select->having($having);
        }

        $select->group('sp.id');
        if (!empty($order)) {
            $select->order($order);
        }

        if (!empty($where)) {
            $select->where($where);
        }

        $select->limit($limit, $offset);

        if ($singleRecord) {
            $data = $this->getDbTable()->getAdapter()->fetchRow($select);
        } else {
            $data = $this->getDbTable()->getAdapter()->fetchAll($select);
        }

        if ($withoutCount === false) {
            $select->reset(Zend_Db_Select::COLUMNS);
            $select->reset(Zend_Db_Select::FROM);
            $select->reset(Zend_Db_Select::LIMIT_OFFSET);
            $select->reset(Zend_Db_Select::LIMIT_COUNT);

            $count = array('count' => new Zend_Db_Expr('COUNT(DISTINCT(sp.id))'));

            $select->from(array('sp' => 'shopping_product'), $count);

            $select =  $this->getDbTable()->getAdapter()->select()
                ->from(
                    array('subres' => $select),
                    array('count' => 'SUM(count)')
                );

            $count = $this->getDbTable()->getAdapter()->fetchRow($select);

            return array(
                'totalRecords' => $count['count'],
                'data' => $data,
                'offset' => $offset,
                'limit' => $limit
            );
        } else {
            return $data;
        }
    }


}

