<?php

/**
 * Class Seosambapos_Models_Mappers_SeosambaposCashRegistersConfigMapper
 *
 * @method Seosambapos_Models_Mappers_SeosambaposCashRegistersConfigMapper   getInstance()   getInstance()   Returns an instance of itself
 * @method Zend_Db_Table    getDbTable()    getDbTable()    Returns an instance of DbTable
 */
class Seosambapos_Models_Mappers_SeosambaposCashRegistersConfigMapper extends Application_Model_Mappers_Abstract
{

    protected $_dbTable = 'Seosambapos_Models_Dbtables_SeosambaposCashRegistersConfigDbtable';

    protected $_model = 'Seosambapos_Models_Models_SeosambaposCashRegistersConfigModel';

    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'cash_register_id'    => $model->getCashRegisterId(),
            'cash_register_label' => $model->getCashRegisterLabel(),
        );

        $id = $model->getId();
        if ($id) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            $this->getDbTable()->update($data, $where);
        } else {
            $id = $this->getDbTable()->insert($data);
            $model->setId($id);
        }
        return $model;
    }

    /**
     * @param $cashRegisterId
     * @return mixed|null
     * @throws Exception
     */
    public function findByCashRegisterId($cashRegisterId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('cash_register_id = ?', $cashRegisterId);
        return $this->_findWhere($where);
    }

    /**
     * @param $cashRegisterLabel
     * @return mixed|null
     */
    public function findByCashRegisterLabel($cashRegisterLabel)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('cash_register_label = ?', $cashRegisterLabel);
        return $this->_findWhere($where);
    }

    /**
     * @return array
     */
    public function getAllData()
    {
        $select = $this->getDbTable()->getAdapter()->select()->from('plugin_seosambapos_cash_registers_config');
        return $this->getDbTable()->getAdapter()->fetchAll($select);
    }

    public function getPairsData()
    {
        $select = $this->getDbTable()->getAdapter()->select()->from('plugin_seosambapos_cash_registers_config', array('cash_register_id', 'cash_register_label'));
        return  $this->getDbTable()->getAdapter()->fetchPairs($select);
    }

    /**
     * @param $id
     * @return mixed
     */
    public function delete($id)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
        return $this->getDbTable()->getAdapter()->delete('plugin_seosambapos_cash_registers_config', $where);
    }
}

