<?php

/**
 * Class Seosambapos_Models_Mappers_SeosambaposActiveSessionMapper
 *
 * @method Seosambapos_Models_Mappers_SeosambaposActiveSessionMapper   getInstance()   getInstance()   Returns an instance of itself
 * @method Zend_Db_Table    getDbTable()    getDbTable()    Returns an instance of DbTable
 */
class Seosambapos_Models_Mappers_SeosambaposActiveSessionMapper extends Application_Model_Mappers_Abstract
{

    protected $_dbTable = 'Seosambapos_Models_Dbtables_SeosambaposActiveSessionDbtable';

    protected $_model = 'Seosambapos_Models_Models_SeosambaposActiveSessionModel';

    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'user_id'          => $model->getUserId(),
            'cash_register_id' => $model->getCashRegisterId(),
            'location_id'      => $model->getLocationId(),
        );

        $id = $model->getId();
        if ($id) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            $this->getDbTable()->update($data, $where);
        } else {
            $id = $this->getDbTable()->insert($data);
            $model->setId($id);
        }
        return $model;
    }

    /**
     * @param $userId
     * @return mixed|null
     * @throws Exception
     */
    public function findSession($userId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('user_id = ?', $userId);
        $select = $this->getDbTable()->getAdapter()->select()->from('plugin_seosambapos_active_session')->where($where);
        return $this->getDbTable()->getAdapter()->fetchRow($select);
    }

    /**
     * @param $userId
     * @return mixed|null
     * @throws Exception
     */
    public function findSessionObj($userId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('user_id = ?', $userId);
        return $this->_findWhere($where);
    }

    /**
     * Return active cash register session
     *
     * @return array
     */
    public function findAllActiveSession()
    {
        $select = $this->getDbTable()->getAdapter()->select()->from('plugin_seosambapos_active_session');
        return $this->getDbTable()->getAdapter()->fetchAll($select);
    }

    /**
     * Return session by locationId and by cashRegisterId
     *
     * @return array
     */
    public function findSessionByLocationIdAndCashRegisterId($locationId, $cashRegisterId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('location_id = ?', $locationId);
        $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto('cash_register_id = ?', $cashRegisterId);
        $select = $this->getDbTable()->getAdapter()->select()->from('plugin_seosambapos_active_session')->where($where);
        return $this->getDbTable()->getAdapter()->fetchRow($select);
    }

    /**
     * @param $id
     * @return mixed
     */
    public function delete($id)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
        return $this->getDbTable()->getAdapter()->delete('plugin_seosambapos_active_session', $where);
    }
}

