<?php

require_once 'system/library/vendor/autoload.php';

use Stripe\Stripe;
use Stripe\Terminal;
use Stripe\PaymentIntent;
use Stripe\Webhook;
use Stripe\Exception;

class Seosambapos extends Tools_Plugins_Abstract
{

    const SEOSAMBAPOS_SECURE_TOKEN = 'SeosambaposToken';

    const PLUGIN_CLASS_NAME = 'Seosambapos';

    const RECEIPT_TEMPLATE_TYPE = 'typepos';

    const CLEAR_RESERVED_CARTS_CONTENT_PATH = 'plugins/seosambapos/system/cronscript/clearReservedCartsContent.php';

    const UNSET_ACTIVE_SESSION_ALL_SALES_PATH = 'plugins/seosambapos/system/cronscript/unsetActiveSessionAllSales.php';

    /**
     * Toaster layout
     *
     * @var
     */
    private $_layout = null;

    /**
     * Plugin api actions
     *
     * @return array
     */
    public static function pluginApiActions()
    {
        return array(
            'getStripeTerminalToken',
            'getLocations',
            'setSession',
            'unsetSession',
            'sessionStatus',
            'searchCustomer',
            'getDefaultCustomer',
            'addCustomer',
            'getDefaultProduct',
            'getProductList',
            'addProduct',
            'getShippingCustomerAddresses',
            'addCouponToCart',
            'getStoreInfo',
            'emailReceipt',
            'changeCartCustomerId',
            'getCart',
            'addProductToCart',
            'deleteProductsFromCart',
            'changeProductQtyInCart',
            'addShippingAddressToCart',
            'resetShipping',
            'getShippingPriceValues',
            'addShippingPriceToCart',
            'getProductTagsByLocation',
            'completePurchaseByCash',
            'addShippingAddress',
            'resetCart',
            'createQuickSale',
            'generateReceipt',
            'getStripeIntent',
            'getReviewLinks',
            'sendReviewLink',
            'deleteQuickSale',
            'updateProduct',
            'validateCart',
            'getOrderInfo',
            'getDefaultCustomerConfig',
            'setDefaultCustomerConfig',
            'getDefaultSalespersonConfig',
            'setDefaultSalespersonConfig',
            'getReceiptTemplateConfig',
            'setReceiptTemplateConfig',
            'getDefaultProductBrandConfig',
            'setDefaultProductBrandConfig',
            'getDefaultProductTaxConfig',
            'setDefaultProductTaxConfig',
            'getDefaultProductTemplateConfig',
            'setDefaultProductTemplateConfig',
            'isPosPluginExist',
            'addProductAdditionalPictures',
            'getProductAdditionalPictures',
            'deleteProductAdditionalPictures',
            'deleteProduct',

        );
    }

    public function __construct($options, $seotoasterData)
    {
        parent::__construct($options, $seotoasterData);
        $this->_layout = new Zend_Layout();
        $this->_layout->setLayoutPath(Zend_Layout::getMvcInstance()->getLayoutPath());

        if (($scriptPaths = Zend_Layout::getMvcInstance()->getView()->getScriptPaths()) !== false) {
            $this->_view->setScriptPath($scriptPaths);
        }
        $this->_view->addScriptPath(__DIR__ . '/system/views/');
    }

    public function beforeController()
    {
        //use this for debugging mojo actions getStripeTerminalToken/getLocations/getLocations/addProduct/updateProduct;
//        $websiteConfig = Zend_Controller_Action_HelperBroker::getStaticHelper('config');
//        $websiteConfig->init();
//        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
//        $websiteHelper->init();

        //self::getStripeTerminalToken();
        //self::getCashRegisterList();
        //self::getLocations();
        //self::setSession(array());
        //self::unsetSession(array());
        //self::sessionStatus(array());
        //self::searchCustomer(array());
        //self::getDefaultCustomer();
        //self::addCustomer(array());
        //self::getDefaultProduct();
        //self::getProductList(array());
        //self::addProduct(array());
        //self::updateProduct(array());
        //self::getDefaultTaxList();
        //self::getLibraryOptionsList(array());
        //self::getLibraryOptionById(array());
        //self::getOptionDropdownRadioNewSelection();
        //self::getShippingCustomerAddresses(array());
        //self::subscribeCustomer(array());
        //self::isStoreOpen();
        //self::isProductAvailable(array());
        //self::addCouponToCart(array());
        //self::getProductBrandsList();
        //self::getStoreInfo();
        //self::emailReceipt(array());
        //self::changeCartCustomerId(array());
        //self::getCart(array());
        //self::addProductToCart(array());
        //self::deleteProductsFromCart(array());
        //self::changeProductQtyInCart(array());
        //self::addShippingAddressToCart(array());
        //self::resetShipping(array());
        //self::getShippingPriceValues(array());
        //self::addShippingPriceToCart(array());
        //self::getProductTagsByLocation(array());
        //self::completePurchaseByCash(array());
        //self::addShippingAddress(array());
        //self::resetCart(array());
        //self::createQuickSale(array());
        //self::generateReceipt(array());
        //self::getStripeIntent(array());
        //self::getReviewLinks(array());
        //self::sendReviewLink(array());
        //self::deleteQuickSale(array());
        //self::validateCart(array());
        //self::getOrderInfo(array());
        //self::getDefaultCustomerConfig();
        //self::setDefaultCustomerConfig(array());
        //self::getDefaultSalespersonConfig();
        //self::setDefaultSalespersonConfig(array());
        //self::getReceiptTemplateConfig();
        //self::setReceiptTemplateConfig(array());
        //self::getDefaultProductBrandConfig();
        //self::setDefaultProductBrandConfig(array());
        //self::getDefaultProductTaxConfig();
        //self::setDefaultProductTaxConfig(array());
        //self::getDefaultProductTemplateConfig();
        //self::setDefaultProductTemplateConfig(array());
        //self::isPosPluginExist();
        //self::addProductAdditionalPictures(array());
        //self::getProductAdditionalPictures(array());
        //self::deleteProductAdditionalPictures(array());
        //self::deleteProduct(array());
    }

    public function configDataAction() {
        if (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)) {
            $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();
            if ($this->_request->isPost()) {
                $configParams = filter_var_array($this->_request->getParams(), FILTER_SANITIZE_STRING);

                $secureToken = $this->_request->getParam(Tools_System_Tools::CSRF_SECURE_TOKEN, false);
                $tokenValid = Tools_System_Tools::validateToken($secureToken, self::SEOSAMBAPOS_SECURE_TOKEN);
                if (!$tokenValid) {
                    $this->_responseHelper->fail(array('message' => $this->_translator->translate('Please re-login'), 'status' => 'error'));
                }

                $seosambaposSettings = $seosambaposSettingsMapper->getConfigParams();
                if(!empty($configParams['getConfig'])) {
                    $customerMapper = Models_Mapper_CustomerMapper::getInstance();
                    $where = $customerMapper->getDbTable()->getAdapter()->quoteInto('role_id = ?', Shopping::ROLE_CUSTOMER);
                    $defaultCustomers = $customerMapper->listAll($where);

                    $where = $customerMapper->getDbTable()->getAdapter()->quoteInto('role_id IN (?)',
                        array(Tools_Security_Acl::ROLE_SUPERADMIN,
                            Tools_Security_Acl::ROLE_ADMIN,
                            Shopping::ROLE_SALESPERSON
                        )
                    );
                    $defaultSalespersons = $customerMapper->listAll($where);

                    $defaultCustomersData = array();
                    $defaultSalespersonsData = array();

                    $existsDefaultCustomer = false;
                    if(!empty($defaultCustomers)) {
                        foreach ($defaultCustomers as $customer) {
                            if($customer['id'] == $seosambaposSettings['defaultCustomerId']) {
                                $existsDefaultCustomer = true;
                            }
                            $defaultCustomersData[] = array('label' => $customer['full_name'] . ' (' . $customer['email'] . ')', 'id' => $customer['id']);
                        }
                    }

                    $existsDefaultSalesperson = false;
                    if(!empty($defaultSalespersons)) {
                        foreach ($defaultSalespersons as $salesperson) {
                            if($salesperson['id'] == $seosambaposSettings['defaultSalespersonId']) {
                                $existsDefaultSalesperson = true;
                            }
                            $defaultSalespersonsData[] = array('label' => $salesperson['full_name'] . ' (' . $salesperson['email'] . ')', 'id' => $salesperson['id']);
                        }
                    }

                    $templateList = Application_Model_Mappers_TemplateMapper::getInstance()->findByType(self::RECEIPT_TEMPLATE_TYPE);
                    $receiptTemplates = array();

                    if(!empty($templateList)) {
                        foreach ($templateList as $template) {
                            $receiptTemplates[$template->getName()] = $template->getName();
                        }
                    }

                    if(!empty($seosambaposSettings)) {
                        if(!$existsDefaultCustomer) {
                            $seosambaposSettings['defaultCustomerId'] = '';
                            $seosambaposSettings['defaultCustomerLabel'] = '';
                        }

                        if(!$existsDefaultSalesperson) {
                            $seosambaposSettings['defaultSalespersonId'] = '';
                            $seosambaposSettings['defaultSalespersonLabel'] = '';
                        }

                        if(!$existsDefaultCustomer || !$existsDefaultSalesperson) {
                            $seosambaposSettingsMapper->save($seosambaposSettings);
                        }
                    }

                    $this->_responseHelper->success(array(
                        'generalConfig' => $seosambaposSettings,
                        'defaultCustomers' => $defaultCustomersData,
                        'defaultSalespersons' => $defaultSalespersonsData,
                        'templateList' => $receiptTemplates,
                        'cronPathClearReservedCardsContent' => Zend_Registry::get('website')['path'].self::CLEAR_RESERVED_CARTS_CONTENT_PATH,
                        'cronPathUnsetActiveSessionAllSales' => Zend_Registry::get('website')['path'].self::UNSET_ACTIVE_SESSION_ALL_SALES_PATH,
                        'status' => 'ok'
                    ));
                } else {
                    if(!empty($configParams['defaultCustomerId'])) {
                        $seosambaposSettings['defaultCustomerId'] = $configParams['defaultCustomerId'];
                    }
                    if(!empty($configParams['defaultCustomerLabel'])) {
                        $seosambaposSettings['defaultCustomerLabel'] = $configParams['defaultCustomerLabel'];
                    }
                    if(!empty($configParams['receiptTemplate'])) {
                        $seosambaposSettings['receiptTemplate'] = $configParams['receiptTemplate'];
                    }

                    if(!empty($configParams['defaultSalespersonId'])) {
                        $seosambaposSettings['defaultSalespersonId'] = $configParams['defaultSalespersonId'];
                    }
                    if(!empty($configParams['defaultSalespersonLabel'])) {
                        $seosambaposSettings['defaultSalespersonLabel'] = $configParams['defaultSalespersonLabel'];
                    }

                    $seosambaposSettingsMapper->save($seosambaposSettings);

                    $this->_responseHelper->success(array('generalConfig' => $seosambaposSettings, 'status' => 'ok'));
                }
            } else {
                $seosambaposSettings = $seosambaposSettingsMapper->getConfigParams();
                $this->_responseHelper->success(array('generalConfig' => $seosambaposSettings, 'status' => 'ok'));
            }
        } else {
            $this->_responseHelper->fail(array('message' => $this->_translator->translate('You have no access!'), 'status' => 'error'));
        }
    }

    public function defaultProductConfigDataAction() {
        if (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)) {
            $defaultProductSettingsMapper = Seosambapos_Models_Mappers_SeosambaposDefaultproductSettingMapper::getInstance();
            if ($this->_request->isPost()) {
                $configParams = filter_var_array($this->_request->getParams(), FILTER_SANITIZE_STRING);
                $defaultBrandId = $configParams['defaultBrandId'];
                $defaultTaxId = $configParams['defaultTaxId'];
                $defaultTemplate = $configParams['defaultTemplate'];
                $defaultProduct = $configParams['defaultProduct'];
                $defaultProductCondition = $configParams['defaultCondition'];

                $secureToken = $this->_request->getParam(Tools_System_Tools::CSRF_SECURE_TOKEN, false);
                $tokenValid = Tools_System_Tools::validateToken($secureToken, self::SEOSAMBAPOS_SECURE_TOKEN);
                if (!$tokenValid) {
                    $this->_responseHelper->fail(array('message' => $this->_translator->translate('Please re-login'), 'status' => 'error'));
                }

                if (empty($defaultBrandId)) {
                    $this->_responseHelper->fail(array('message' => $this->_translator->translate('Please select default product brand'), 'status' => 'error'));
                }

                if (empty($defaultTemplate)) {
                    $this->_responseHelper->fail(array('message' => $this->_translator->translate('Please select default product page template'), 'status' => 'error'));
                }

                if (empty($defaultProductCondition)) {
                    $this->_responseHelper->fail(array('message' => $this->_translator->translate('Please select default product condiition'), 'status' => 'error'));
                }

                if(!empty($defaultProduct)) {
                    unset($configParams['defaultProduct']);
                    $defaultProduct = array_shift($defaultProduct);
                    $configParams['defaultProductId'] = $defaultProduct['id'];
                    $configParams['defaultProductLabel'] = $defaultProduct['label'];
                }

                $defaultProductSettingsMapper->save($configParams);

                $this->_responseHelper->success(array('configData' => $configParams, 'message' => $this->_translator->translate('Saved'), 'status' => 'ok'));
            } else {
                $defaultProductSettings = $defaultProductSettingsMapper->getConfigParams();

                $existsDefaultProduct = true;
                if(!empty($defaultProductSettings['defaultProductId'])) {
                    $productMapper = Models_Mapper_ProductMapper::getInstance();
                    $product = $productMapper->findByProductId($defaultProductSettings['defaultProductId']);

                    if(empty($product)) {
                        $existsDefaultProduct = false;
                    }
                }

                $brandMapper = Models_Mapper_Brand::getInstance();
                $brands = $brandMapper->getAllBrands();

                $defaultTaxes = Models_Mapper_Tax::getInstance()->getDefaultRule();
                $defaultTaxesData = array(
                    '0' => $this->_translator->translate('Non taxable'),
                    '1' => $this->_translator->translate('Default'),
                    '2' => $this->_translator->translate('Alternative'),
                    '3' => $this->_translator->translate('Alternative 2')
                );

                if(!empty($defaultTaxes)) {
                    $defaultTaxesData[1] .= ' '.(($defaultTaxes->getRate1() === '0.00') ? 0 : $defaultTaxes->getRate1()).' %';
                    $defaultTaxesData[2] .= ' '.(($defaultTaxes->getRate2() === '0.00') ? 0 : $defaultTaxes->getRate2()).' %';
                    $defaultTaxesData[3] .= ' '.(($defaultTaxes->getRate3() === '0.00') ? 0 : $defaultTaxes->getRate3()).' %';
                }

                $templateList = Application_Model_Mappers_TemplateMapper::getInstance()->findByType(Application_Model_Models_Template::TYPE_PRODUCT);
                $productTemplates = array();

                if(!empty($templateList)) {
                    foreach ($templateList as $template) {
                        $productTemplates[$template->getName()] = $template->getName();
                    }
                }

                $seosambaposDefaultproductSettingMapper = Seosambapos_Models_Mappers_SeosambaposDefaultproductSettingMapper::getInstance();
                $where = $seosambaposDefaultproductSettingMapper->getDbTable()->getAdapter()->quoteInto('sp.enabled = ?', '0');
                $where .= ' AND '. new Zend_Db_Expr('sp.inventory IS NULL');
                $where .= ' AND ' . $seosambaposDefaultproductSettingMapper->getDbTable()->getAdapter()->quoteInto('spo.type = ?', 'additionalpricefield');

                $productData = $seosambaposDefaultproductSettingMapper->fetchAllData($where, null, null, null, true);

                $productList = array();
                if(!empty($productData)) {
                    foreach ($productData as $key => $product) {
                        $productList[] = array('id' => $product['id'], 'label' => $product['name'] . ' (' . $product['sku'] . ')');
                    }
                }

                $defaultConditionList = array(
                    'new' => $this->_translator->translate('condition_new'),
                    'refurbished' =>  $this->_translator->translate('condition_refurbished'),
                    'used' =>  $this->_translator->translate('condition_used')
                );

                if(!empty($defaultProductSettings)) {
                    if(!$existsDefaultProduct) {
                        $defaultProductSettings['defaultProductId'] = '';
                        $defaultProductSettings['defaultProductLabel'] = '';
                    }

                    $defaultProductSettingsMapper->save($defaultProductSettings);
                }

                //$tags = Models_Mapper_Tag::getInstance()->fetchAll();

                $this->_responseHelper->success(array(
                    'configData' => $defaultProductSettings,
                    'brands' => $brands,
                    'defaultTaxes' => $defaultTaxesData,
                    'templateList' => $productTemplates,
                    'productList' => $productList,
                    'defaultCondition' => $defaultConditionList,
                    'status' => 'ok'
                ));
            }
        } else {
            $this->_responseHelper->fail(array('message' => $this->_translator->translate('You have no access!'), 'status' => 'error'));
        }
    }

    /**
     * Configuration tab
     *
     * @throws Exceptions_SeotoasterPluginException
     */
    public function tabAction()
    {

        if (!Tools_Security_Acl::isAllowed(Shopping::RESOURCE_STORE_MANAGEMENT)) {
            throw new Exceptions_SeotoasterPluginException('Forbidden');
        }

        $pid = filter_var($this->_request->getParam('productId'), FILTER_SANITIZE_NUMBER_INT);
        $productId = '';
        if (!empty($pid)) {
            $productId = $pid;
        }

        $this->_view->productId = $productId;

        echo $this->_view->render('defaultProductConfigTab.phtml');
    }

    //@todo this method migrated to stripepay plugin buttonPaymentSuccessCallbackAction
    //@todo use if stripepayOAuth == 0 and stripepay config credentials
//    public function completePurchaseSuccessCallbackAction()
//    {
//        $stripepayOAuth = Tools_StripeOAuthTools::checkStripepayConfigOAuth();
//
//        if(empty($stripepayOAuth)) {
//            $stripeConfigMapper = Stripepay_Models_Mappers_StripepayConfigMapper::getInstance();
//            $stripeConfig = $stripeConfigMapper->getConfigParams();
//
//            $secretKey = $stripeConfig['privateKey'];
//            $endpoint_secret = $stripeConfig['endpointSecret'];
//
//            if(!empty($stripeConfig['useSandBox'])) {
//                $secretKey = $stripeConfig['privateKeyTest'];
//            }
//
//            Stripe::setApiKey($secretKey);
//            $payload = @file_get_contents('php://input');
//            $sig_header = $_SERVER['HTTP_STRIPE_SIGNATURE'];
//            $event = null;
//            try {
//                $event = Webhook::constructEvent(
//                    $payload, $sig_header, $endpoint_secret
//                );
//            } catch (UnexpectedValueException $e) {
//                // Invalid payload
//                http_response_code(400);
//                exit();
//            } catch (Exception\SignatureVerificationException $e) {
//                // Invalid signature
//                http_response_code(400);
//                exit();
//            }
//            // Handle the checkout.session.completed event
//            if ($event->type == 'charge.succeeded') {
//                $session = $event->data->object;
//                //error_log(print_r($session, true));
//
//                // Fulfill the purchase...
//                $result = Tools_CartTools::completePurchase($session);
//
//                if($result['error']) {
//                    http_response_code(400);
//                    exit();
//                } else {
//                    http_response_code(200);
//                    exit();
//                }
//            }
//        }
//
//        http_response_code(202);//Accepted
//        exit();
//    }

    public function posterminalsAction() {
        if (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)) {
            $this->_layout->content = $this->_view->render('posterminalsConfig.phtml');
            echo $this->_layout->render();
        }
    }

    public function saveCashRegistersConfigDataAction()
    {
        if (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)) {
            $secureToken = $this->_request->getParam(Tools_System_Tools::CSRF_SECURE_TOKEN, false);
            $tokenValid = Tools_System_Tools::validateToken($secureToken, self::SEOSAMBAPOS_SECURE_TOKEN);
            if (!$tokenValid) {
                $this->_responseHelper->fail(array('message' => $this->_translator->translate('Please re-login'), 'status' => 'error'));
            }

            $cashRegisterId = filter_var($this->_request->getParam('cashRegisterId'), FILTER_SANITIZE_NUMBER_INT);
            $cashRegisterLabel = filter_var($this->_request->getParam('cashRegisterLabel'), FILTER_SANITIZE_STRING);

            if(!empty($cashRegisterId) && !empty($cashRegisterLabel)) {
                $seosambaposCashRegistersConfigMapper = Seosambapos_Models_Mappers_SeosambaposCashRegistersConfigMapper::getInstance();

                $cashRegister = $seosambaposCashRegistersConfigMapper->findByCashRegisterId($cashRegisterId);

                if(!$cashRegister instanceof Seosambapos_Models_Models_SeosambaposCashRegistersConfigModel) {
                    $cashRegLabel = $seosambaposCashRegistersConfigMapper->findByCashRegisterLabel($cashRegisterLabel);

                    if($cashRegLabel instanceof Seosambapos_Models_Models_SeosambaposCashRegistersConfigModel) {
                        $this->_responseHelper->fail(array('message' => $this->_translator->translate('A cash register with this label is already exists. Please provide other label.'), 'status' => 'error'));
                    }

                    $cashRegister = new Seosambapos_Models_Models_SeosambaposCashRegistersConfigModel();

                    $cashRegister->setCashRegisterId($cashRegisterId);
                    $cashRegister->setCashRegisterLabel($cashRegisterLabel);

                    $seosambaposCashRegistersConfigMapper->save($cashRegister);

                    $this->_responseHelper->success(array('message' => $this->_translator->translate('Cash register created'), 'status' => 'ok'));
                } else {
                    $this->_responseHelper->fail(array('message' => $this->_translator->translate('A cash register with this Id is already exists'), 'status' => 'error'));
                }
            }

            $this->_responseHelper->fail(array('message' => $this->_translator->translate('You can not create new cash register'), 'status' => 'error'));
        }

        $this->_responseHelper->fail(array('message' => $this->_translator->translate('You have no access!'), 'status' => 'error'));
    }

    public function getCashRegistersSavedDataAction()
    {

        if (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)) {
            $secureToken = $this->_request->getParam(Tools_System_Tools::CSRF_SECURE_TOKEN, false);
            $tokenValid = Tools_System_Tools::validateToken($secureToken, self::SEOSAMBAPOS_SECURE_TOKEN);
            if (!$tokenValid) {
                $this->_responseHelper->fail(array('message' => $this->_translator->translate('Please re-login'), 'status' => 'error'));
            }

            $seosambaposCashRegistersConfigMapper = Seosambapos_Models_Mappers_SeosambaposCashRegistersConfigMapper::getInstance();
            $cashRegisters = $seosambaposCashRegistersConfigMapper->getAllData();

            $this->_responseHelper->success(array(
                'cashRegisters' => $cashRegisters,
                'status' => 'ok'
            ));
        }

        $this->_responseHelper->fail(array('message' => $this->_translator->translate('You have no access!'), 'status' => 'error'));
    }

    public function updateCashRegisterLabelAction()
    {
        if (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)) {
            $secureToken = $this->_request->getParam(Tools_System_Tools::CSRF_SECURE_TOKEN, false);
            $tokenValid = Tools_System_Tools::validateToken($secureToken, self::SEOSAMBAPOS_SECURE_TOKEN);
            if (!$tokenValid) {
                $this->_responseHelper->fail(array('message' => $this->_translator->translate('Please re-login'), 'status' => 'error'));
            }

            $id = filter_var($this->_request->getParam('id'), FILTER_SANITIZE_NUMBER_INT);
            $cashRegisterLabel = filter_var($this->_request->getParam('cashRegisterLabel'), FILTER_SANITIZE_STRING);

            if(!empty($id) && !empty($cashRegisterLabel)) {
                $seosambaposCashRegistersConfigMapper = Seosambapos_Models_Mappers_SeosambaposCashRegistersConfigMapper::getInstance();

                $cashRegister = $seosambaposCashRegistersConfigMapper->find($id);

                if($cashRegister instanceof Seosambapos_Models_Models_SeosambaposCashRegistersConfigModel) {
                    $cashRegLabel = $seosambaposCashRegistersConfigMapper->findByCashRegisterLabel($cashRegisterLabel);

                    if($cashRegLabel instanceof Seosambapos_Models_Models_SeosambaposCashRegistersConfigModel) {
                        $this->_responseHelper->fail(array('message' => $this->_translator->translate('A cash register with this label is already exists. Please provide other label.'), 'status' => 'error'));
                    }

                    $cashRegister->setCashRegisterLabel($cashRegisterLabel);

                    $seosambaposCashRegistersConfigMapper->save($cashRegister);

                    $this->_responseHelper->success(array('message' => $this->_translator->translate('Cash register label updated'), 'status' => 'ok'));
                }
            }

            $this->_responseHelper->fail(array('message' => $this->_translator->translate('You can not update label'), 'status' => 'error'));
        }

        $this->_responseHelper->fail(array('message' => $this->_translator->translate('You have no access!'), 'status' => 'error'));
    }

    public function deleteCashRegisterAction()
    {
        if (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)) {
            $secureToken = $this->_request->getParam(Tools_System_Tools::CSRF_SECURE_TOKEN, false);
            $tokenValid = Tools_System_Tools::validateToken($secureToken, self::SEOSAMBAPOS_SECURE_TOKEN);
            if (!$tokenValid) {
                $this->_responseHelper->fail(array('message' => $this->_translator->translate('Please re-login'), 'status' => 'error'));
            }

            $id = filter_var($this->_request->getParam('id'), FILTER_SANITIZE_NUMBER_INT);

            if(!empty($id)) {
                $seosambaposCashRegistersConfigMapper = Seosambapos_Models_Mappers_SeosambaposCashRegistersConfigMapper::getInstance();

                $cashRegister = $seosambaposCashRegistersConfigMapper->find($id);

                if($cashRegister instanceof Seosambapos_Models_Models_SeosambaposCashRegistersConfigModel) {
                    $seosambaposCashRegistersConfigMapper->delete($id);

                    $this->_responseHelper->success(array('message' => $this->_translator->translate('Cash register deleted'), 'status' => 'ok'));
                }
            }

            $this->_responseHelper->fail(array('message' => $this->_translator->translate('You can not delete label'), 'status' => 'error'));
        }

        $this->_responseHelper->fail(array('message' => $this->_translator->translate('You have no access!'), 'status' => 'error'));
    }

    public static function getStripeTerminalToken()
    {
        return Tools_StripeTools::getStripeTerminalToken();
    }

    public static function getCashRegisterList()
    {
        return Tools_LocationsTools::getCashRegisterList(true);
    }

    public static function getLocations()
    {
        return Tools_LocationsTools::getLocations();
    }

    public static function setSession($data)
    {
//        $data = array(
//           'posUserId' => '',//15
//           'posUserEmail' => '',
//           'locationId' => '2',
//           'cashRegisterId' => '3'
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId']) || empty($data['cashRegisterId']) || empty($data['locationId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId or cashRegisterId or locationId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId'], $data['cashRegisterId'], $data['locationId'], true);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_SeosambaPosTools::setSession($data);
    }

    public static function unsetSession($data)
    {
//        $data = array(
//           'posUserId' => '1',
//           'posUserEmail' => 'valentin@seosamba.com',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);
        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        return Tools_SeosambaPosTools::unsetSession($data);
    }

    public static function sessionStatus($data)
    {
//        $data = array(
//           'posUserId' => '1',
//           'posUserEmail' => 'valentin@seosamba.com',
//        );

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        return Tools_SeosambaPosTools::sessionStatus($data, true);
    }

    public static function searchCustomer($data)
    {
//        $data = array(
//            'query' => 'valentin@seosamba.com' //vorobyov,+38096410
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        if(empty($data['query'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing customer email or name or phone'));
        }

        return Tools_CustomerTools::searchCustomer($data);
    }

    public static function getDefaultCustomer()
    {
        return Tools_CustomerTools::getDefaultCustomer();
    }

    public static function addCustomer($data)
    {
//        $data = array(
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'prefix' => 'Mr',
//            'firstName' => 'John',
//            'lastName' => 'Doe',
//            'email' => 'johndoe111111@mail.com',
//            'password' => '',//not required
//            'timezone' => 'Europe/Kyiv',
//            'mobileCountryCode' => 'UA',
//            'phone' => '964444444',
//            'desktopCountryCode' => 'UA',
//            'desktopPhone' => '965555555',
//            'isSubscribe' => true,//false
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        if (empty($data['email']) || (empty($data['firstName']) && empty($data['lastName']))) {
            return array('error' => '1', 'message' => $translator->translate('Missing customer params. Required: email/firstName/lastName'));
        }

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }
        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']/*, $data['cashRegisterId'], $data['locationId']*/);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_CustomerTools::addCustomer($data);
    }

    public static function getDefaultProduct()
    {
        return Tools_ProductTools::getDefaultProduct();
    }

    public static function getProductList($data)
    {
//        $data = array(
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'limit' => 5,
//            'offset' => 0,
//            'locationId' => '1',
//            'includeOutOfStock' => false,//true
////            'productTags' => '1,2',
//            //'searchParam' => 'someProduct-sku',
//            'order' => 'name',//price
//            'orderType' => 'ASC',//DESC
//        );

        return Tools_ProductTools::getProductList($data);
    }

    public static function addProduct($data)
    {

//        $data = array (
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'product' => array(
//                'name' => 'someProduct-nameAImage',
//                'sku' => 'someproduct-nameAImage2',
//                'shortDescription' => 'shortDescription-nameAImage',
//                'mpn' => 'someProduct-nameAImage',
//                'gtin' => '',
//                'imageUrl' => 'http://gfgthriftstorecom.loc/media/products/small/someproduct-name2.jpeg',
//                'condition' => 'new',
//                'image' => array(
//                    'data' => "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",
//                    'name' => "someproduct-sku1.jpeg"
//                ),
//                'weight' => '1.400',
//                'taxClass' => '1',
//                'tags' => array(
//                    'tag1-product',
//                    'tag2-product',
//                    'Gift'
//                ),
//                'inventory' => '1',
//                'dimensions' => array(
//                    'width' => '5',
//                    'length' => '6',
//                    'depth' => '7',
//                ),
//                'brand' => '',//Amstar
//                'nonTaxablePrice' => '2',
//                'additionalImages' => array(
//                    array(
//                        'data' => "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",
//                        'name' => "additional-image1.jpeg"
//                    ),
//                    array(
//                        'data' => "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",
//                        'name' => "additional-image2.jpeg"
//                    ),
//                ),
//            )
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        if (empty($data)) {
            return array('error' => '1', 'message' => $translator->translate('Missing query field(s)'));
        }

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }
        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_ProductTools::addProduct($data);
    }

    public static function updateProduct($data)
    {
        //@todo one location
//        $data = array (
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'product' => array(
//                'id' => '124',
//                'name' => 'someProduct-nameAImage',
//                'sku' => 'someproduct-nameAImage2',
//                'shortDescription' => 'shortDescription-nameAImage',
//                'mpn' => 'someProduct-nameAImage',
//                'gtin' => '',
//                'condition' => 'new',
////                'image' => array(
////                    'data' => "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",
////                    'name' => "someproduct-sku.jpeg"
////                ),
//                'weight' => '1.400',
//                'taxClass' => '1',
//                'tags' => array(
//                    'tag1-product',
//                    'tag2-product',
//                    'Gift'
//                ),
//                'inventory' => '6',
//                'dimensions' => array(
//                    'width' => '5',
//                    'length' => '6',
//                    'depth' => '7',
//                ),
//                'brand' => 'postest',
//                'nonTaxablePrice' => '1.2',
//                //'photoFolder' => 'somefolder',
//                'deletedImagesIds' => array('16','17','18','4'),
//                'additionalImages' => array(
//                    array(
//                        'data' => "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",
//                        'name' => "additional-image11.jpeg"
//                    ),
//                    array(
//                        'data' => "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",
//                        'name' => "additional-image12.jpeg"
//                    ),
//                ),
//            )
//        );

        //@todo many locations
//        $data = array (
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'product' => array(
//                'id' => '5',
//                'name' => 'someProduct-nameA',
//                'sku' => 'someproduct-nameTAG',
//                'shortDescription' => 'shortDescription-productA',
//                'mpn' => 'someProduct-npmA',
//                'gtin' => '',
//                'condition' => 'new',
//                'image' => array(
//                    'data' => "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",
//                    'name' => "someproduct-sku.jpeg"
//                ),
//                'weight' => '1.400',
//                'taxClass' => '1',
//                'tags' => array(
//                    'tag1-product',
//                    'tag2-product',
//                    'Gift'
//                ),
//                'inventory' => '5',
//                'dimensions' => array(
//                    'width' => '5',
//                    'length' => '6',
//                    'depth' => '7',
//                ),
//                'brand' => 'pos',
//                'nonTaxablePrice' => '2',
//                'photoFolder' => 'somefolder',
//                'deletedImagesIds' => array(),
//                'additionalImages' => array(),
//            )
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }
        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_ProductTools::updateProduct($data);
    }

    public static function getDefaultTaxList()
    {
        return Tools_ProductTools::getDefaultTaxList();
    }

    public static function getLibraryOptionsList($data)
    {
//        $data = array(
//           'withoutSelections' => '1'
//        );

        return Tools_ProductTools::getLibraryOptionsList($data);
    }

    public static function getLibraryOptionById($data)
    {
//        $data = array(
//           'libraryOptionId' => '971'
//        );

        return Tools_ProductTools::getLibraryOptionById($data);
    }

    public static function getOptionDropdownRadioNewSelection()
    {
        return Tools_ProductTools::getOptionDropdownRadioNewSelection();
    }

    public static function getShippingCustomerAddresses($data)
    {
//        $data = array(
//           'customerId' => '1'//'586'
//        );

        return Tools_CustomerTools::getShippingCustomerAddresses($data);
    }

    public static function subscribeCustomer($data)
    {
//        $data = array(
//           'posUserId' => '1',
//           'posUserEmail' => 'valentin@seosamba.com',
//           'customerId' => '586'
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        if (empty($data['customerId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing customerId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_CustomerTools::subscribeCustomer($data);
    }

    /**
     * Check if store open
     *
     * @return array
     * @throws Zend_Exception
     */
    public static function isStoreOpen()
    {
        $translator = Zend_Registry::get('Zend_Translate');

        if (Tools_Misc::isStoreClosed() === true) {
            $storeIsClosedMessage = Tools_Misc::getStoreIsClosedMessage();
            return array('error' => '1', 'message' => $translator->translate($storeIsClosedMessage));
        }

        if (Tools_Misc::isStoreDisabled() === true) {
            $storeIsClosedMessage = Tools_Misc::getStoreIsDisabledMessage();
            return array('error' => '1', 'message' => $translator->translate($storeIsClosedMessage));
        }

        return array();
    }

    public static function isProductAvailable($data)
    {
//        $data = array(
//            array(
//                'produuctId' => '1',
//                'qty' => '100',
//            ),
//            array(
//                'produuctId' => '2',
//                'qty' => '1',
//            ),
//        );

        $isStoreOpen = self::isStoreOpen();
        if(!empty($isStoreOpen['error'])) {
            return $isStoreOpen;
        }

       return Tools_ProductTools::isProductAvailable($data);
    }

    public static function addCouponToCart($data)
    {
//        $data = array(
//            'posUserId' => '1',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '2033',
//            'code' => 'JPE4RBR3A2'
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $isStoreOpen = self::isStoreOpen();
        if(!empty($isStoreOpen['error'])) {
            return $isStoreOpen;
        }

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_ProductTools::addCouponToCart($data);
    }

    public static function emailReceipt($data)
    {
//       $data = array(
//          'posUserId' => '4',
//          'posUserEmail' => 'valentin@seosamba.com',
//          'cartId' => '2',//1922 - default customer,
//          'email' => 'test@mail.com',
//          'links' => ['https://mos.best/w3q5f', 'https://mos.best/9v1x6']
//      );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_ProductTools::emailReceipt($data);
    }

    public static function getProductBrandsList()
    {
        return Tools_ProductTools::getProductBrandsList();
    }

    public static function getStoreInfo()
    {
        return Tools_SeosambaPosTools::getStoreInfo();
    }

    public static function changeCartCustomerId($data)
    {
//        $data = array(
//            'posUserId' => '1',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '2027',
//            'customerId' => '25',//586
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_ProductTools::changeCartCustomerId($data);
    }

    public static function getCart($data)
    {
//        $data = array(
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $isStoreOpen = self::isStoreOpen();
        if(!empty($isStoreOpen['error'])) {
            return $isStoreOpen;
        }

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_CartTools::getCart($data);
    }

    public static function addProductToCart($data)
    {
//        $data = array(
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '443',
//            'productId' => '7',
//            'productQty' => '1',
//            'locationId' => '2',//Fisher/Shafer NONMEM Workshop (test)
//        );

        //other product
//        $data = array(
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '3',
//            'productId' => '5',
//            'productQty' => '2',
//            'locationId' => '1',//Boyd J Ball (test)
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $isStoreOpen = self::isStoreOpen();
        if(!empty($isStoreOpen['error'])) {
            return $isStoreOpen;
        }

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_CartTools::addProductToCart($data);
    }

    public static function deleteProductsFromCart($data)
    {
//        $data = array(
//            'posUserId' => '1',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '2033',
//            'productId' => '1',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $isStoreOpen = self::isStoreOpen();
        if(!empty($isStoreOpen['error'])) {
            return $isStoreOpen;
        }

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_CartTools::deleteProductsFromCart($data);
    }

    public static function changeProductQtyInCart($data)
    {
//        $data = array(
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '3',
//            'productId' => '5',
//            'productQty' => '2',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $isStoreOpen = self::isStoreOpen();
        if(!empty($isStoreOpen['error'])) {
            return $isStoreOpen;
        }

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_CartTools::changeProductQtyInCart($data);
    }

    public static function addShippingAddressToCart($data)
    {
//        $data = array(
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '1',
//            'shippingAddressId' => 'ffe6782367c652026e0e99c0198cdf9c',//'ab6ae98b03447b9375c3b6082ef6b03a',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $isStoreOpen = self::isStoreOpen();
        if(!empty($isStoreOpen['error'])) {
            return $isStoreOpen;
        }

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_CartTools::addShippingAddressToCart($data);
    }

    public static function resetShipping($data)
    {
//        $data = array(
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '428',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $isStoreOpen = self::isStoreOpen();
        if(!empty($isStoreOpen['error'])) {
            return $isStoreOpen;
        }

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_CartTools::resetShipping($data);
    }

    public static function getShippingPriceValues($data)
    {
//        $data = array(
//            'posUserId' => '1',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '2027',
//            'serviceName' => 'customshipping'//'usps,ups,customshipping,flatrateship,flatrateshipping',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_ShippingTools::getShippingPriceValues($data);
    }

    public static function addShippingPriceToCart($data)
    {
//        $data = array(
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '443',
//            'serviceName' => 'customshipping',
//            'priceToCart' => '2.00',
//            'typeToCart' => 'Type -1',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_CartTools::addShippingPriceToCart($data);
    }

    public static function getProductTagsByLocation($data)
    {
//        $data = array(
//            'locationId' => '1',
//        );

        return Tools_ProductTools::getProductTagsByLocation($data);
    }

    public static function completePurchaseByCash($data)
    {
//        $data = array(
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '443',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_CartTools::completePurchaseByCash($data);
    }

    public static function addShippingAddress($data)
    {
//        $data = array(
//            'posUserId' => '1',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'customerId' => '351',
//            'address' => array(
//                'isDefaultCustomerAddress' => true,//false
//                'address1' => '444 9th St',
//                'address2' => '',
//                'city' => 'Brooklyn',
//                'zip' => '22222',
//                'country' => 'US',
//                'state' => 'New York',
//            ),
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $isStoreOpen = self::isStoreOpen();
        if(!empty($isStoreOpen['error'])) {
            return $isStoreOpen;
        }

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_CartTools::addShippingAddress($data);
    }

    public static function resetCart($data)
    {
//        $data = array(
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '443',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $isStoreOpen = self::isStoreOpen();
        if(!empty($isStoreOpen['error'])) {
            return $isStoreOpen;
        }

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_CartTools::resetCart($data);
    }

    public static function createQuickSale($data)
    {
//        $data = array (
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '8',
//            'product' => array(
//                'name' => 'someProduct-quickQuick',
////                'image' => array(
////                    'data' => "/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAMCAgICAgMCAgIDAwMDBAYEBAQEBAgGBgUGCQgKCgkICQkKDA8MCgsOCwkJDRENDg8QEBEQCgwSExIQEw8QEBD/2wBDAQMDAwQDBAgEBAgQCwkLEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBD/wAARCABQAFADASIAAhEBAxEB/8QAHAAAAgMBAQEBAAAAAAAAAAAAAAgBBwkGAgQD/8QANxAAAQMDAgQDBQYGAwAAAAAAAQIDBAAFEQYHCBIhMRNBURQyQmGBCSJxgpGhFTNykrTDVHSi/8QAGgEAAgMBAQAAAAAAAAAAAAAABAUDBgcACP/EADQRAAAEAwUECAYDAAAAAAAAAAABAgQDERIFBhMxkSFhcfAUFRZRobHB0QcXMkFCUiIzgf/aAAwDAQACEQMRAD8AqKiiivRA8xAqPy1NFcOBUetMJw2cKEze62ydWX6+u2ewMPmM0WGgt+U4ACvk5uiUjIGSDk5GOhq4r39nLp1xgnTm5dzjvcvQTYTb6T/YW8Ugc3ms5pGOBEXtLPYZy0Fha3VtN5AJxBh/xPLaRT1MI1RVx7qcKO7u1jL1yl2pq92hrKlTrWS6GkerjZAWj5nBA9apsHIzTVq9bvkYkBRKLcFDxi5Yrw3CDSe8Hn9KPSpoooCgooq5+ErayPunu/Bj3OOHbRY0G6T0qGUuchAbbPqFLKcjzSlVCvXSGLdUdeSSmCmLRb9yhvDzUchdfDdwU2C96Zj613jhS31XJCXYVnS84wGmT1DjxQQvnV3CQRgd8k4TwPFlw66Q2tYY1Zt/7RHty5IiS4DzxeDRWCUuNqXleOmCCT3GK0Fvl0btNuU/nB5elZ1cWe9CNZXpzb+zKC4lslh2fIB6OSEAgND5Jycn16eXXN7FtS07TtQlko6fuX4kXDkxqVuWPZVkWOaFIKrIj/I1cfMspBruB4Y4drH/ANud/kuVd0u6RYawhxxKSTjqapLgfyeHaxAf8ud/kuVyPG7OksbV3TwJDjS25cNaFoWQpJElvBBHY0ket+l2uuBOVSzLUxYbPc9CsSG4lOmGRy4EGcW2zcGSRg5pLOK/hZhhiZuLt1bURpjAMi5W1hOG5CO6nWkjs4O5SPe79/fjhF4r7vJvcLa7c65LlicsMWm6vry6HT7rDx+Lm7IUfvZwDnIIcy/wUTIS1Y6gVIfTbrvSL7+Ci50EKVML3MDOXuk+dRjKFJUMpqatHiT27Z253TnRbfHDVsu6P4jEQkYS3zkhxsfgsHA8gU1V1a+ycoewEx0ZKKYxN8zWwcrbxM0nIFPP9nLZWWtO6y1DypLsmbGh83mEttqXj9Xf2pGKef7OW9MO6d1lp4FIejTY0zl8ylxtSc/q1+9I73VdUxJbvMg/uVR1xDq7lS0MXbxBalf0zom93qP79utsiS2D5rQ2SB+oFZUpW66VPPLLjjhKnFqOSonqSa1f340o9q3RF8scYDxbjbZEVsnyWtshJ/UisoS26ypTL7S23WyW3EKGCkjoQR60luJh0Rf2mWnMxYPiJiYkH9ZHrsn6DSvgcmxHOHq1NokIUqJNmtPAH+WvxlKwfopJ+tcNxuXSI9tjcmQ4Ap2XEbbB+M+MlWB9Ek/SlI2w3t3D2idlDR11bRFnEKkQZLfix3VAYCuXIIVjplJB9c18e427Gtt1JjMnVtwaUzHJWzEjN+Ew2s91YyST8yTUh3Xcdb9MqKiqrfnOUhEV7mxWL0Gk8SmndlKc+HiOTYeejOtyYzq2nmlhxtaDhSVg5BB9c1sBtrqRzWu2um9UyQPGu9oizHsDAC1tJUofqTWP7DD0l5uNGZU686sNtoQMlSycAAeua1/23045onbPTulpPL41otEaI8QehcQ0Eq/9A1HfzDogy+qZ6bJ+gk+HeJixpfTItZnL1CbcedqZDOnLwEAOMTJEXPqHGwr/AFfvSj02XHbemXUaes4WC47NflY+TbYT/tpTac3Rq6rRPvPzMIr609brp7inoQj81XPwlbqR9rN34Mi6Sg1aL4g2ucpRwlvxCC24fQJWE5PklSqpmoIzT161hvm6m68lFIV1i7WwcocQ80nMbR3CG3PjFtQByOlIzxR8J9/N5mbi7b2tc1MtReudrYRl3xPN5lPx57lI656jOTjpuE7i3gy7dC2w3QuaY82MlMe1XWQvCJKB0Sy6o9nB0AWeihgH7/vOCHockdVJrIUqe3Ye5bfBRc6DbTJhe5gW33SfP+GMXXWnWHlsSG1tOtkocbWOVSSO4IPY1LDL0l5uNGacdddWEtttgqUonsAB3Na/ak2u211g57TqnQ9huz+MB6ZAadcA/rUM/vU6b20210U57TpfRFgtD2MeLEgtNOY/qSM/vVo7dw8P+k6uOzy9BUfl3FxJYxU8Nuk/UKhwk8JV6g3mFulujbFw/Ylh+02mQjDvi/C+8n4OXulJ65wTjHVudY3tq125aAsc6x2zX6XnVcC2MKCHQpePWkf4neJpFwEvQ+iLiH5TuWZ89lWUx0di22R3cPYke7+ParGb2874jMtvgkudRb0pYXSYGU/dR86CluIPX7e4W5k2ZDkeLbrWPYIqwejnISXHB+KycHzAFVx+aoSkISEpGAK9VrzFollATARkkpDEn7xb9ytxEzUcwUUUUWBB5IyPvVb+2nFNu1tnHatca7IvVpaAS3CuYLvhI9G3AQtA9BkgelVFRQrpm3epojpJRbwUzfOWK8Rus0nuDlWv7QOAtgfxvQVxju46+yTW3kk/nCcV8l84+IjrKk2TQ9xecI6e1S22QP7AqlAopJ2RsuqdB6n7ixdtLXppxC4yL2FmbicRe524yHYUy5otVtd6LiW/LfiD0ccJKz8xkA+lVilKUjlCcD5V6op20ZQGSKICSSW4V54/cvl4jhZqPeCiiiigIP/Z",
////                    'name' => "someproduct-sku1111A.jpeg"
////                ),
//                'price' => '78999.99',
//            )
//        );

//        $data = array (
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '8',
//            'product' => array(
//                'price' => '10.00',
//            )
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        if (empty($data)) {
            return array('error' => '1', 'message' => $translator->translate('Missing query field(s)'));
        }

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }
        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_CartTools::createQuickSale($data);
    }

    public static function generateReceipt($data)
    {
//        $data = array (
//            'posUserId' => '1',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '2025',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        if (empty($data)) {
            return array('error' => '1', 'message' => $translator->translate('Missing query field(s)'));
        }

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }
        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_ProductTools::generateReceipt($data);
    }

    public static function getStripeIntent($data)
    {
//        $data = array (
//            'posUserId' => '1',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '2024',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        if (empty($data)) {
            return array('error' => '1', 'message' => $translator->translate('Missing query field(s)'));
        }

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }
        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        $cartData = Tools_CartTools::getStripeCartData($data);

        if(!empty($cartData['error'])) {
            return $cartData;
        }

        $storeInfo = Tools_SeosambaPosTools::getStoreInfo();

        if(empty($storeInfo['currency'])) {
            return array('error' => '1', 'message' => $translator->translate('Store currency is empty'));
        }

        $amountToPay = round($cartData['cartSession']->getTotal(), 2);
        if(empty($amountToPay)) {
            return array('error' => '1', 'message' => $translator->translate('Cart amount is empty'));
        }

        $amountToPay =  Tools_CartTools::cleanAmount($amountToPay);

        $stripepayOAuth = Tools_StripeOAuthTools::checkStripepayConfigOAuth();

        if(empty($stripepayOAuth)) {
            $stripeConfigMapper = Stripepay_Models_Mappers_StripepayConfigMapper::getInstance();
            $stripeSettings = $stripeConfigMapper->getConfigParams();

            $secretKey = $stripeSettings['privateKey'];
            if(!empty($stripeSettings['useSandBox'])) {
                $secretKey = $stripeSettings['privateKeyTest'];
            }

            if(empty($secretKey)) {
                return array('error' => '1', 'message' => $translator->translate('Stripe account is not configured/connected'));
            }

            Stripe::setApiKey($secretKey);
            $intent = PaymentIntent::create([
                'amount' => $amountToPay,
                'currency' => strtolower($storeInfo['currency']),//'usd',
                'payment_method_types' => ['card'],
                'metadata' => array(
                    'cartId' => $data['cartId'],
                    'type' => 'creditcart'
                ),
            ]);
        } else {
            $configData = Application_Model_Mappers_ConfigMapper::getInstance()->getConfig();
            $websiteId = $configData['websiteId'];

            $dataRequest = array(
                'amount' => $amountToPay,
                'currency' => strtolower($storeInfo['currency']),//'usd',
                'payment_method_types' => ['card'],
                'metadata' => array(
                    'cartId' => $data['cartId'],
                    'type' => 'creditcart',
                    'websiteId' => $websiteId
                )
            );

            $responceIntent = Tools_StripeOAuthTools::createPaymentIntentMojo($dataRequest);

            if (!empty($responceIntent['error'])) {
                return array('error' => '1', 'message' => $translator->translate('Stripe account can not get payment intent'));
            }

            if(!empty($responceIntent)) {
                $responcePaymentIntentData = json_decode($responceIntent, true);
                if(!empty($responcePaymentIntentData)) {
                    $intent = (object) $responcePaymentIntentData;
                }
            }
        }

        if(isset($intent->client_secret)) {
            $intentSecret = $intent->client_secret;

            return array(
                'intent' => $intentSecret
            );
        }

        return array('error' => '1', 'message' => $translator->translate('Can not get stripe intent.'));
    }

    public static function getReviewLinks($data)
    {
        //@todo retured data from mojo
    }

    public static function sendReviewLink($data)
    {
//        $data = array (
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '1',
//            'isEmail' => 'true',//false
//            'recipient' => 'test1@mail.com',//posuser@mail.com/+380964101035
//            'links' => array('https://mos.best/mpdb2','https://mos.best/ssf06')
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        if (empty($data)) {
            return array('error' => '1', 'message' => $translator->translate('Missing query field(s)'));
        }

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_SeosambaPosTools::sendReviewLink($data);
    }

    public static function deleteQuickSale($data)
    {
//        $data = array (
//            'posUserId' => '1',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '2033'
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        if (empty($data)) {
            return array('error' => '1', 'message' => $translator->translate('Missing query field(s)'));
        }

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }
        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_CartTools::deleteQuickSale($data);
    }

    public static function validateCart($data)
    {
//        $data = array (
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'cartId' => '3'
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_CartTools::validateCart($data);

//        if (!Zend_Registry::isRegistered('extConfig')) {
//            $configTable   = new Application_Model_DbTable_Config();
//            Zend_Registry::set('extConfig', $configTable->selectConfig());
//        }
//
//        Tools_PaymentGateway::updateCartStatus('2', Models_Model_CartSession::CART_STATUS_COMPLETED);
    }

    public static function getOrderInfo($data)
    {
//        $data = array (
//            'cartId' => '443'
//        );

        return Tools_CartTools::getOrderInfo($data);

    }

    public static function getDefaultCustomerConfig()
    {
        return Tools_ConfigTools::getDefaultCustomerConfig();
    }

    public static function setDefaultCustomerConfig($data)
    {
//        $data = array (
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'defaultCustomerId' => '9',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        if (empty($data['defaultCustomerId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing defaultCustomerId'));
        }
        $customerMapper = Models_Mapper_CustomerMapper::getInstance();
        $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();

        $where = $customerMapper->getDbTable()->getAdapter()->quoteInto('user.id = ?', $data['defaultCustomerId']);
        $customers = $customerMapper->listAll($where);

        if(!empty($customers)) {
            foreach ($customers as $key => $customer) {
                $defaultCustomerLabel = $customer['full_name'] . ' (' . $customer['email'] . ')';
            }

            $seosambaposSettings = $seosambaposSettingsMapper->getConfigParams();
            if(!empty($data['defaultCustomerId'])) {
                $seosambaposSettings['defaultCustomerId'] = $data['defaultCustomerId'];
            }
            if(!empty($defaultCustomerLabel)) {
                $seosambaposSettings['defaultCustomerLabel'] = $defaultCustomerLabel;
            }

            $seosambaposSettingsMapper->save($seosambaposSettings);

            return Tools_ConfigTools::getDefaultCustomerConfig();
        }

        return array('error' => '1', 'message' => $translator->translate('Customer with this ID not found in the system'));
    }

    public static function getDefaultSalespersonConfig()
    {
        return Tools_ConfigTools::getDefaultSalespersonConfig();
    }

    public static function setDefaultSalespersonConfig($data)
    {
//        $data = array (
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'defaultSalespersonId' => '2',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        if (empty($data['defaultSalespersonId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing defaultSalespersonId'));
        }
        $customerMapper = Models_Mapper_CustomerMapper::getInstance();
        $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();

        $where = $customerMapper->getDbTable()->getAdapter()->quoteInto('user.id = ?', $data['defaultSalespersonId']);
        $customers = $customerMapper->listAll($where);

        if(!empty($customers)) {
            foreach ($customers as $key => $customer) {
                $defaultSalespersonLabel = $customer['full_name'] . ' (' . $customer['email'] . ')';
            }

            $seosambaposSettings = $seosambaposSettingsMapper->getConfigParams();
            if(!empty($data['defaultSalespersonId'])) {
                $seosambaposSettings['defaultSalespersonId'] = $data['defaultSalespersonId'];
            }
            if(!empty($defaultSalespersonLabel)) {
                $seosambaposSettings['defaultSalespersonLabel'] = $defaultSalespersonLabel;
            }

            $seosambaposSettingsMapper->save($seosambaposSettings);

            return Tools_ConfigTools::getDefaultSalespersonConfig();
        }

        return array('error' => '1', 'message' => $translator->translate('Salesperson with this ID not found in the system'));
    }

    public static function getReceiptTemplateConfig()
    {
        return Tools_ConfigTools::getReceiptTemplateConfig();
    }

    public static function setReceiptTemplateConfig($data)
    {
//        $data = array (
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'receiptTemplate' => 'receipt',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        if (empty($data['receiptTemplate'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing receiptTemplate'));
        }
        $seosambaposSettingsMapper = Seosambapos_Models_Mappers_SeosambaposSettingMapper::getInstance();
        $templateList = Application_Model_Mappers_TemplateMapper::getInstance()->findByType(self::RECEIPT_TEMPLATE_TYPE);
        $receiptTemplates = array();

        if(!empty($templateList)) {
            foreach ($templateList as $template) {
                $receiptTemplates[] = $template->getName();
            }
        }

        if(!empty($templateList)) {
            if(!in_array($data['receiptTemplate'], $receiptTemplates)) {
                return array('error' => '1', 'message' => $translator->translate('Requested receipt template not found in the system'));
            }

            $seosambaposSettings = $seosambaposSettingsMapper->getConfigParams();
            if(!empty($data['receiptTemplate'])) {
                $seosambaposSettings['receiptTemplate'] = $data['receiptTemplate'];
            }

            $seosambaposSettingsMapper->save($seosambaposSettings);

            return Tools_ConfigTools::getReceiptTemplateConfig();
        }

        return array('error' => '1', 'message' => $translator->translate('No receipt templates were found in the system'));
    }

    public static function getDefaultProductBrandConfig()
    {
        return Tools_ConfigTools::getDefaultProductBrandConfig();
    }

    public static function setDefaultProductBrandConfig($data)
    {
//        $data = array (
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'brandId' => '12',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        if (empty($data['brandId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing brandId'));
        }
        $defaultProductSettingsMapper = Seosambapos_Models_Mappers_SeosambaposDefaultproductSettingMapper::getInstance();
        $brandMapper = Models_Mapper_Brand::getInstance();

        $existedBrand = $brandMapper->find($data['brandId']);
        if(!$existedBrand instanceof Models_Model_Brand) {
            return array('error' => '1', 'message' => $translator->translate('Requested brand not found in the system'));
        }

        $defaultProductSettings['defaultBrandId'] = $data['brandId'];
        $defaultProductSettingsMapper->save($defaultProductSettings);

        return Tools_ConfigTools::getDefaultProductBrandConfig();
    }

    public static function getDefaultProductTaxConfig()
    {
        return Tools_ConfigTools::getDefaultProductTaxConfig();
    }

    public static function setDefaultProductTaxConfig($data)
    {
//        $data = array (
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'taxId' => '1',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        $defaultProductSettingsMapper = Seosambapos_Models_Mappers_SeosambaposDefaultproductSettingMapper::getInstance();

        $defaultProductSettings['defaultTaxId'] = $data['taxId'];
        $defaultProductSettingsMapper->save($defaultProductSettings);

        return Tools_ConfigTools::getDefaultProductTaxConfig();
    }

    public static function getDefaultProductTemplateConfig()
    {
        return Tools_ConfigTools::getDefaultProductTemplateConfig();
    }

    public static function setDefaultProductTemplateConfig($data)
    {
//        $data = array (
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'productTemplate' => 'product',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        if (empty($data['productTemplate'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing productTemplate'));
        }
        $defaultProductSettingsMapper = Seosambapos_Models_Mappers_SeosambaposDefaultproductSettingMapper::getInstance();
        $templateMapper = Application_Model_Mappers_TemplateMapper::getInstance();

        $existedTemplate = $templateMapper->find($data['productTemplate']);
        if(!$existedTemplate instanceof Application_Model_Models_Template) {
            return array('error' => '1', 'message' => $translator->translate('Requested template not found in the system'));
        }

        $defaultProductSettings['defaultTemplate'] = $data['productTemplate'];
        $defaultProductSettingsMapper->save($defaultProductSettings);

        return Tools_ConfigTools::getDefaultProductTemplateConfig();
    }

    public static function isPosPluginExist()
    {
        $translator = Zend_Registry::get('Zend_Translate');
        return array('error' => '0', 'done' => true, 'message' => $translator->translate('The plugin exists in the system'));
    }

//@todo deprecated
    public static function addProductAdditionalPictures($data)
    {
//        $data = array (
//            'posUserId' => '4',
//            'posUserEmail' => 'valentin@seosamba.com',
//            'productId' => '11',
//            'additionalImages' => array(
//                0 => array(
//                    'data' => "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",
//                    'name' => "someproductimage.jpeg"
//                ),
////                1 => array(
////                    'data' => "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",
////                    'name' => "other-product-image.jpeg"
////                ),
//            ),
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId'));
        }
        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        //return Tools_ProductTools::addProductAdditionalPictures($data);
    }

//@todo deprecated
    public static function getProductAdditionalPictures($data)
    {
//        $data = array (
//            'productId' => '11',
//        );

        return Tools_ProductTools::getProductAdditionalPictures($data);
    }

//@todo deprecated
    public static function deleteProductAdditionalPictures($data)
    {
//        $data = array (
//            '6',
//            '7',
//        );

        //return Tools_ProductTools::deleteProductAdditionalPictures($data);
    }

    public static function deleteProduct($data)
    {
//        $data = array (
//            'productId' => '11',
//            'forceDelete' => '1',
//            'posUserId' => '4',
//        );

        $translator = Zend_Registry::get('Zend_Translate');

        $data['posUserId'] = Tools_SeosambaPosTools::getPosUserId($data);

        if (empty($data['posUserId'])) {
            return array('error' => '1', 'message' => $translator->translate('Missing posUserId or cashRegisterId or locationId'));
        }

        $statusValidate = Tools_SeosambaPosTools::checkExistUserAndCashRegister($data['posUserId']);
        if(!empty($statusValidate['error'])) {
            return $statusValidate;
        }

        return Tools_ProductTools::deleteProduct($data);
    }

    /**
     * Manage config action
     */
    public function configAction()
    {
        if (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)) {
            $this->_layout->content = $this->_view->render('seosambaPosConfig.phtml');
            echo $this->_layout->render();
        }
    }

    public function defaultProductAction()
    {
        if (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)) {
            echo $this->_view->render('defaultProductConfig.phtml');
        }
    }

    /**
     * Create receipt in pdf format
     */
    public function createPdfReceiptAction()
    {
        $data = $this->_request->getParams();
        $fileInfo = Tools_ProductTools::generateReceipt($data);
        if (!empty($fileInfo)) {
            if ($data['dwn'] == 1) {
                header("Content-Description: File Transfer");
                header("Content-Disposition: attachment; filename=$fileInfo[fileName]");
                header("Content-type: application/pdf");
                readfile($fileInfo['folder'] . $fileInfo['fileName']);
            }
            if ($data['dwn'] == 0) {
                $this->_redirector->gotoUrl($this->_websiteHelper->getUrl() . 'plugins/seosambapos/receipts/' . $fileInfo['fileName']);
            }
        }
    }

    //@todo debugging action
    public function sendResponse($data, $code = 200)
    {
        $response = new Zend_Controller_Response_Http();
        $response->setHttpResponseCode($code);
        $response->setHeader('Content-Type', 'application/json', true);
        $response->setBody(json_encode($data));
        $response->sendResponse();
        exit;
    }

    //@todo debugging action
    protected function _error($message = null, $statusCode = Api_Service_Abstract::REST_STATUS_BAD_REQUEST){
        if (is_numeric($statusCode)){
            $statusCode = intval($statusCode);
        }
        $response = new Zend_Controller_Response_Http();
        $response->clearAllHeaders()->clearBody();
        $response->setHttpResponseCode(intval($statusCode));
        $response->setHeader('Content-Type', 'application/json', true);
        if (!empty($message)){
            $response->setBody(json_encode($message));
        }

        $response->sendResponse();
        exit();
    }


    //@todo debugging action
    //plugin/seosambapos/run/getLocations/
    public function getLocationsAction() {
        $dataResult = self::getLocations();

        if(!empty($dataResult['error'])) {
            $this->_error($dataResult);
        }

        $this->sendResponse($dataResult);
    }

    //@todo debugging action
    //plugin/seosambapos/run/setSession/
    public function setSessionAction() {
        $data = $this->_request->getParams();
        $dataResult = self::setSession($data);

        if(!empty($dataResult['error'])) {
            $this->_error($dataResult);
        }

        $this->sendResponse($dataResult);
    }



}