define([
    'backbone',
    '../models/product-images.js',
    'i18n!../../../nls/config_'+$('#product-additional-images-language').val()+'_ln.js'
], function(Backbone, ProductImageModel, i18n){
    var ProductImagesUploadView = Backbone.View.extend({
        el: $('#product-additional-images-config-block'),
        events: {

        },
        templates: {

        },
        initialize: function(){
            this.$el = $('#product-additional-images-config-block');
            this.uploaderProdcutImagesFolder = $('#current-product-id-addition-image').val();

            if (typeof this.formSocialServiceUploader !== 'undefined') {
                this.formSocialServiceUploader.unbindAll();
            }
            var options = {
                runtimes: 'html5',
                browse_button: 'uploader-product-images-additional-button',
                //container: 'product-additional-images-config-block',
                max_file_size: '100mb',
                url: $('#website_url').val()+'api/productimages/productimages/',
                filters: [
                    {title : "Image files", extensions : "jpg,gif,png,jpeg,webp"}
                ],
                multipart_params: {
                    secureToken: '',
                    folder:'',
                    productId: ''
                }
            };


            this.formSocialServiceUploader = new plupload.Uploader(options);

            this.formSocialServiceUploader.init();

            this.formSocialServiceUploader.bind('BeforeUpload', _.bind(this.beforeUpload, this));
            this.formSocialServiceUploader.bind('FilesAdded', _.bind(this.filesAdded, this));
            this.formSocialServiceUploader.bind('UploadProgress', _.bind(this.uploadProgress, this));
            this.formSocialServiceUploader.bind('FileUploaded', _.bind(this.fileUploaded, this));
            this.formSocialServiceUploader.bind('Error', _.bind(this.handleUploadErrors, this));


        },
        render: function(){
            return this;
        },
        filesAdded: function(up, files)
        {
            this.formSocialServiceUploader.settings.multipart_params.secureToken = $('#product-images-additional-product-token').val();
            this.formSocialServiceUploader.settings.multipart_params.productId = $('#current-product-id-addition-image').val();
            this.formSocialServiceUploader.settings.multipart_params.folder = this.uploaderProdcutImagesFolder;
            this.formSocialServiceUploader.start();
        },
        uploadProgress: function(up, file)
        {
            $('#progressbar').progressbar({value: file.percent}).text(file.percent);
        },
        fileUploaded: function(up, file, result)
        {
            $('#progressbar').delay(800).fadeOut();
            var response = jQuery.parseJSON(result.response);
            if (response.error == 1) {
                showMessage(response.responseText, true, 5000);
            }  else {
                showMessage(response.responseText, false, 5000);
            }
            this.$el.trigger('ProductImage:created');
            this.formSocialServiceUploader.refresh();
        },
        handleUploadErrors: function(up, file)
        {
            var message = 'Unknown error';
            if (file.code == '-601') {
                message = 'Wrong extension. You can upload only jpg,gif,png,jpeg,webp';
            }

            showMessage(message, true, 5000);
        },
        beforeUpload: function(up, file){
            $('#progressbar').fadeIn().progressbar({value: 0});
        }
    });

    return ProductImagesUploadView;
});